/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    int scope = 0;
    int startPage = 1;
    int endPage = 1;
    boolean printToFile = false;
    int handle;
    int index;
    byte[] settingsData;
    static final String ADD_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk2.addIdleProc";
    static final String REMOVE_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk2.removeIdleProc";

    public PrintDialog(Shell shell) {
        this(shell, 32768);
    }

    public PrintDialog(Shell shell, int n) {
        super(shell, n);
        this.checkSubclass();
    }

    protected void checkSubclass() {
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int n) {
        this.scope = n;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int n) {
        this.startPage = n;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int n) {
        this.endPage = n;
    }

    public boolean getPrintToFile() {
        return this.printToFile;
    }

    public void setPrintToFile(boolean bl) {
        this.printToFile = bl;
    }

    public PrinterData open() {
        int n;
        Object object;
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 0)) {
            return Printer.getDefaultPrinterData();
        }
        byte[] byArray = Converter.wcsToMbcs(null, this.getText(), true);
        int n2 = this.getParent().handle;
        while (n2 != 0 && !OS.GTK_IS_WINDOW(n2)) {
            n2 = OS.gtk_widget_get_parent(n2);
        }
        this.handle = OS.gtk_print_unix_dialog_new(byArray, n2);
        OS.gtk_print_unix_dialog_set_current_page(this.handle, -1);
        OS.gtk_print_unix_dialog_set_manual_capabilities(this.handle, 7);
        int n3 = OS.gtk_print_settings_new();
        int n4 = OS.gtk_page_setup_new();
        Printer.setScope(n3, this.scope, this.startPage, this.endPage);
        if (this.printToFile) {
            object = Converter.wcsToMbcs(null, "Print to File", true);
            OS.gtk_print_settings_set_printer(n3, object);
        }
        OS.gtk_print_unix_dialog_set_settings(this.handle, n3);
        OS.gtk_print_unix_dialog_set_page_setup(this.handle, n4);
        OS.g_object_unref(n3);
        OS.g_object_unref(n4);
        object = null;
        Display display = this.getParent() != null ? this.getParent().getDisplay() : Display.getCurrent();
        display.setData(ADD_IDLE_PROC_KEY, null);
        if (OS.gtk_dialog_run(this.handle) == -5 && (n = OS.gtk_print_unix_dialog_get_selected_printer(this.handle)) != 0) {
            Object[] objectArray;
            int n5;
            Object object2;
            n3 = OS.gtk_print_unix_dialog_get_settings(this.handle);
            n4 = OS.gtk_print_unix_dialog_get_page_setup(this.handle);
            object = Printer.printerDataFromGtkPrinter(n);
            int n6 = OS.gtk_print_settings_get_print_pages(n3);
            switch (n6) {
                case 0: {
                    this.scope = 0;
                    break;
                }
                case 2: {
                    this.scope = 1;
                    object2 = new int[1];
                    n5 = OS.gtk_print_settings_get_page_ranges(n3, (int[])object2);
                    objectArray = new int[2];
                    int n7 = object2[0];
                    int n8 = Integer.MAX_VALUE;
                    int n9 = 0;
                    int n10 = 0;
                    while (n10 < n7) {
                        OS.memmove(objectArray, n5 + n10 * objectArray.length * 4, objectArray.length * 4);
                        n8 = Math.min(n8, objectArray[0] + 1);
                        n9 = Math.max(n9, objectArray[1] + 1);
                        ++n10;
                    }
                    OS.g_free(n5);
                    this.startPage = n8 == Integer.MAX_VALUE ? 1 : n8;
                    this.endPage = n9 == 0 ? 1 : n9;
                    break;
                }
                case 1: {
                    this.scope = 2;
                    this.startPage = this.endPage = OS.gtk_print_unix_dialog_get_current_page(this.handle);
                }
            }
            this.printToFile = object.name.equals("Print to File");
            if (this.printToFile) {
                int n11 = OS.gtk_print_settings_get(n3, OS.GTK_PRINT_SETTINGS_OUTPUT_URI);
                n5 = OS.strlen(n11);
                objectArray = new byte[n5];
                OS.memmove((byte[])objectArray, n11, n5);
                object.fileName = new String(Converter.mbcsToWcs(null, (byte[])objectArray));
            }
            object.scope = this.scope;
            object.startPage = this.startPage;
            object.endPage = this.endPage;
            object.printToFile = this.printToFile;
            object.copyCount = OS.gtk_print_settings_get_n_copies(n3);
            object.collate = OS.gtk_print_settings_get_collate(n3);
            object2 = new Callback(this, "GtkPrintSettingsFunc", 3);
            n5 = ((Callback)object2).getAddress();
            if (n5 == 0) {
                SWT.error(3);
            }
            this.index = 0;
            this.settingsData = new byte[1024];
            OS.gtk_print_settings_foreach(n3, n5, 0);
            ((Callback)object2).dispose();
            ++this.index;
            this.store("orientation", OS.gtk_page_setup_get_orientation(n4));
            this.store("top_margin", OS.gtk_page_setup_get_top_margin(n4, 3));
            this.store("bottom_margin", OS.gtk_page_setup_get_bottom_margin(n4, 3));
            this.store("left_margin", OS.gtk_page_setup_get_left_margin(n4, 3));
            this.store("right_margin", OS.gtk_page_setup_get_right_margin(n4, 3));
            int n12 = OS.gtk_page_setup_get_paper_size(n4);
            this.storeBytes("paper_size_name", OS.gtk_paper_size_get_name(n12));
            this.storeBytes("paper_size_display_name", OS.gtk_paper_size_get_display_name(n12));
            this.storeBytes("paper_size_ppd_name", OS.gtk_paper_size_get_ppd_name(n12));
            this.store("paper_size_width", OS.gtk_paper_size_get_width(n12, 3));
            this.store("paper_size_height", OS.gtk_paper_size_get_height(n12, 3));
            this.store("paper_size_is_custom", OS.gtk_paper_size_is_custom(n12));
            object.otherData = this.settingsData;
            OS.g_object_unref(n3);
        }
        display.setData(REMOVE_IDLE_PROC_KEY, null);
        OS.gtk_widget_destroy(this.handle);
        return object;
    }

    int GtkPrintSettingsFunc(int n, int n2, int n3) {
        int n4 = OS.strlen(n);
        byte[] byArray = new byte[n4];
        OS.memmove(byArray, n, n4);
        n4 = OS.strlen(n2);
        byte[] byArray2 = new byte[n4];
        OS.memmove(byArray2, n2, n4);
        this.store(byArray, byArray2);
        return 0;
    }

    void store(String string, int n) {
        this.store(string, String.valueOf(n));
    }

    void store(String string, double d) {
        this.store(string, String.valueOf(d));
    }

    void store(String string, boolean bl) {
        this.store(string, String.valueOf(bl));
    }

    void storeBytes(String string, int n) {
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        this.store(string.getBytes(), byArray);
    }

    void store(String string, String string2) {
        this.store(string.getBytes(), string2.getBytes());
    }

    void store(byte[] byArray, byte[] byArray2) {
        int n = byArray.length + 1 + byArray2.length + 1;
        if (this.index + n + 1 > this.settingsData.length) {
            byte[] byArray3 = new byte[this.settingsData.length + Math.max(n + 1, 1024)];
            System.arraycopy(this.settingsData, 0, byArray3, 0, this.settingsData.length);
            this.settingsData = byArray3;
        }
        System.arraycopy(byArray, 0, this.settingsData, this.index, byArray.length);
        this.index += byArray.length + 1;
        System.arraycopy(byArray2, 0, this.settingsData, this.index, byArray2.length);
        this.index += byArray2.length + 1;
    }
}

