/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;

public class HiveConf
extends Configuration {
    protected String hiveJar;
    protected Properties origProp;
    protected String auxJars;
    private static final Log l4j = LogFactory.getLog(HiveConf.class);
    public static final ConfVars[] metaVars = new ConfVars[]{ConfVars.METASTOREDIRECTORY, ConfVars.METASTOREWAREHOUSE, ConfVars.METASTOREURIS, ConfVars.METASTORETHRIFTRETRIES, ConfVars.METASTORE_CLIENT_CONNECT_RETRY_DELAY, ConfVars.METASTORE_CLIENT_SOCKET_TIMEOUT, ConfVars.METASTOREPWD, ConfVars.METASTORECONNECTURLHOOK, ConfVars.METASTORECONNECTURLKEY, ConfVars.METASTOREATTEMPTS, ConfVars.METASTOREINTERVAL, ConfVars.METASTOREFORCERELOADCONF, ConfVars.METASTORESERVERMINTHREADS, ConfVars.METASTORESERVERMAXTHREADS, ConfVars.METASTORE_TCP_KEEP_ALIVE, ConfVars.METASTORE_INT_ORIGINAL, ConfVars.METASTORE_INT_ARCHIVED, ConfVars.METASTORE_INT_EXTRACTED, ConfVars.METASTORE_KERBEROS_KEYTAB_FILE, ConfVars.METASTORE_KERBEROS_PRINCIPAL, ConfVars.METASTORE_USE_THRIFT_SASL, ConfVars.METASTORE_CACHE_PINOBJTYPES, ConfVars.METASTORE_CONNECTION_POOLING_TYPE, ConfVars.METASTORE_VALIDATE_TABLES, ConfVars.METASTORE_VALIDATE_COLUMNS, ConfVars.METASTORE_VALIDATE_CONSTRAINTS, ConfVars.METASTORE_STORE_MANAGER_TYPE, ConfVars.METASTORE_AUTO_CREATE_SCHEMA, ConfVars.METASTORE_AUTO_START_MECHANISM_MODE, ConfVars.METASTORE_TRANSACTION_ISOLATION, ConfVars.METASTORE_CACHE_LEVEL2, ConfVars.METASTORE_CACHE_LEVEL2_TYPE, ConfVars.METASTORE_IDENTIFIER_FACTORY, ConfVars.METASTORE_PLUGIN_REGISTRY_BUNDLE_CHECK};
    public static final ConfVars[] dbVars = new ConfVars[]{ConfVars.HADOOPBIN, ConfVars.HADOOPJT, ConfVars.METASTOREWAREHOUSE, ConfVars.SCRATCHDIR};

    public static int getIntVar(Configuration conf, ConfVars var) {
        assert (var.valClass == Integer.class);
        return conf.getInt(var.varname, var.defaultIntVal);
    }

    public static void setIntVar(Configuration conf, ConfVars var, int val) {
        assert (var.valClass == Integer.class);
        conf.setInt(var.varname, val);
    }

    public int getIntVar(ConfVars var) {
        return HiveConf.getIntVar(this, var);
    }

    public void setIntVar(ConfVars var, int val) {
        HiveConf.setIntVar(this, var, val);
    }

    public static long getLongVar(Configuration conf, ConfVars var) {
        assert (var.valClass == Long.class);
        return conf.getLong(var.varname, var.defaultLongVal);
    }

    public static void setLongVar(Configuration conf, ConfVars var, long val) {
        assert (var.valClass == Long.class);
        conf.setLong(var.varname, val);
    }

    public long getLongVar(ConfVars var) {
        return HiveConf.getLongVar(this, var);
    }

    public void setLongVar(ConfVars var, long val) {
        HiveConf.setLongVar(this, var, val);
    }

    public static float getFloatVar(Configuration conf, ConfVars var) {
        assert (var.valClass == Float.class);
        return conf.getFloat(var.varname, var.defaultFloatVal);
    }

    public static void setFloatVar(Configuration conf, ConfVars var, float val) {
        assert (var.valClass == Float.class);
        ShimLoader.getHadoopShims().setFloatConf(conf, var.varname, val);
    }

    public float getFloatVar(ConfVars var) {
        return HiveConf.getFloatVar(this, var);
    }

    public void setFloatVar(ConfVars var, float val) {
        HiveConf.setFloatVar(this, var, val);
    }

    public static boolean getBoolVar(Configuration conf, ConfVars var) {
        assert (var.valClass == Boolean.class);
        return conf.getBoolean(var.varname, var.defaultBoolVal);
    }

    public static void setBoolVar(Configuration conf, ConfVars var, boolean val) {
        assert (var.valClass == Boolean.class);
        conf.setBoolean(var.varname, val);
    }

    public boolean getBoolVar(ConfVars var) {
        return HiveConf.getBoolVar(this, var);
    }

    public void setBoolVar(ConfVars var, boolean val) {
        HiveConf.setBoolVar(this, var, val);
    }

    public static String getVar(Configuration conf, ConfVars var) {
        assert (var.valClass == String.class);
        return conf.get(var.varname, var.defaultVal);
    }

    public static void setVar(Configuration conf, ConfVars var, String val) {
        assert (var.valClass == String.class);
        conf.set(var.varname, val);
    }

    public String getVar(ConfVars var) {
        return HiveConf.getVar(this, var);
    }

    public void setVar(ConfVars var, String val) {
        HiveConf.setVar(this, var, val);
    }

    public void logVars(PrintStream ps) {
        for (ConfVars one : ConfVars.values()) {
            ps.println(one.varname + "=" + (this.get(one.varname) != null ? this.get(one.varname) : ""));
        }
    }

    public HiveConf() {
    }

    public HiveConf(Class<?> cls) {
        this.initialize(cls);
    }

    public HiveConf(Configuration other, Class<?> cls) {
        super(other);
        this.initialize(cls);
    }

    public HiveConf(HiveConf other) {
        super((Configuration)other);
        this.hiveJar = other.hiveJar;
        this.auxJars = other.auxJars;
        this.origProp = (Properties)other.origProp.clone();
    }

    private Properties getUnderlyingProps() {
        Iterator iter = this.iterator();
        Properties p = new Properties();
        while (iter.hasNext()) {
            Map.Entry e = (Map.Entry)iter.next();
            p.setProperty((String)e.getKey(), (String)e.getValue());
        }
        return p;
    }

    private void initialize(Class<?> cls) {
        this.hiveJar = new JobConf(cls).getJar();
        this.origProp = this.getUnderlyingProps();
        URL hconfurl = this.getClassLoader().getResource("hive-default.xml");
        if (hconfurl == null) {
            l4j.debug((Object)"hive-default.xml not found.");
        } else {
            this.addResource(hconfurl);
        }
        URL hsiteurl = this.getClassLoader().getResource("hive-site.xml");
        if (hsiteurl == null) {
            l4j.debug((Object)"hive-site.xml not found.");
        } else {
            this.addResource(hsiteurl);
        }
        URL hadoopconfurl = this.getClassLoader().getResource("hadoop-default.xml");
        if (hadoopconfurl == null) {
            hadoopconfurl = this.getClassLoader().getResource("hadoop-site.xml");
        }
        if (hadoopconfurl != null) {
            String conffile = hadoopconfurl.getPath();
            this.setVar(ConfVars.HADOOPCONF, conffile.substring(0, conffile.lastIndexOf(47)));
        }
        this.applySystemProperties();
        if (this.hiveJar == null) {
            this.hiveJar = this.get(ConfVars.HIVEJAR.varname);
        }
        if (this.auxJars == null) {
            this.auxJars = this.get(ConfVars.HIVEAUXJARS.varname);
        }
    }

    public void applySystemProperties() {
        for (ConfVars oneVar : ConfVars.values()) {
            if (System.getProperty(oneVar.varname) == null || System.getProperty(oneVar.varname).length() <= 0) continue;
            this.set(oneVar.varname, System.getProperty(oneVar.varname));
        }
    }

    public Properties getChangedProperties() {
        Properties ret = new Properties();
        Properties newProp = this.getUnderlyingProps();
        for (Object one : newProp.keySet()) {
            String oneProp = (String)one;
            String oldValue = this.origProp.getProperty(oneProp);
            if (StringUtils.equals(oldValue, newProp.getProperty(oneProp))) continue;
            ret.setProperty(oneProp, newProp.getProperty(oneProp));
        }
        return ret;
    }

    public Properties getAllProperties() {
        return this.getUnderlyingProps();
    }

    public String getJar() {
        return this.hiveJar;
    }

    public String getAuxJars() {
        return this.auxJars;
    }

    public void setAuxJars(String auxJars) {
        this.auxJars = auxJars;
        HiveConf.setVar(this, ConfVars.HIVEAUXJARS, auxJars);
    }

    public String getUser() throws IOException {
        try {
            UserGroupInformation ugi = ShimLoader.getHadoopShims().getUGIForConf(this);
            return ugi.getUserName();
        }
        catch (LoginException le) {
            throw new IOException(le);
        }
    }

    public static String getColumnInternalName(int pos) {
        return "_col" + pos;
    }

    public static enum ConfVars {
        SCRIPTWRAPPER("hive.exec.script.wrapper", null),
        PLAN("hive.exec.plan", null),
        SCRATCHDIR("hive.exec.scratchdir", "/tmp/" + System.getProperty("user.name") + "/hive"),
        SUBMITVIACHILD("hive.exec.submitviachild", false),
        SCRIPTERRORLIMIT("hive.exec.script.maxerrsize", 100000),
        ALLOWPARTIALCONSUMP("hive.exec.script.allow.partial.consumption", false),
        COMPRESSRESULT("hive.exec.compress.output", false),
        COMPRESSINTERMEDIATE("hive.exec.compress.intermediate", false),
        COMPRESSINTERMEDIATECODEC("hive.intermediate.compression.codec", ""),
        COMPRESSINTERMEDIATETYPE("hive.intermediate.compression.type", ""),
        BYTESPERREDUCER("hive.exec.reducers.bytes.per.reducer", 1000000000L),
        MAXREDUCERS("hive.exec.reducers.max", 999),
        PREEXECHOOKS("hive.exec.pre.hooks", ""),
        POSTEXECHOOKS("hive.exec.post.hooks", ""),
        EXECPARALLEL("hive.exec.parallel", false),
        EXECPARALLETHREADNUMBER("hive.exec.parallel.thread.number", 8),
        HIVESPECULATIVEEXECREDUCERS("hive.mapred.reduce.tasks.speculative.execution", true),
        HIVECOUNTERSPULLINTERVAL("hive.exec.counters.pull.interval", 1000L),
        DYNAMICPARTITIONING("hive.exec.dynamic.partition", false),
        DYNAMICPARTITIONINGMODE("hive.exec.dynamic.partition.mode", "strict"),
        DYNAMICPARTITIONMAXPARTS("hive.exec.max.dynamic.partitions", 1000),
        DYNAMICPARTITIONMAXPARTSPERNODE("hive.exec.max.dynamic.partitions.pernode", 100),
        MAXCREATEDFILES("hive.exec.max.created.files", 100000L),
        DOWNLOADED_RESOURCES_DIR("hive.downloaded.resources.dir", "/tmp/" + System.getProperty("user.name") + "/hive_resources"),
        DEFAULTPARTITIONNAME("hive.exec.default.partition.name", "__HIVE_DEFAULT_PARTITION__"),
        DEFAULT_ZOOKEEPER_PARTITION_NAME("hive.lockmgr.zookeeper.default.partition.name", "__HIVE_DEFAULT_ZOOKEEPER_PARTITION__"),
        SHOW_JOB_FAIL_DEBUG_INFO("hive.exec.show.job.failure.debug.info", true),
        OUTPUT_FILE_EXTENSION("hive.output.file.extension", null),
        LOCALMODEAUTO("hive.exec.mode.local.auto", false),
        LOCALMODEMAXBYTES("hive.exec.mode.local.auto.inputbytes.max", 0x8000000L),
        LOCALMODEMAXTASKS("hive.exec.mode.local.auto.tasks.max", 4),
        DROPIGNORESNONEXISTENT("hive.exec.drop.ignorenonexistent", true),
        HADOOPBIN("hadoop.bin.path", System.getenv("HADOOP_HOME") + "/bin/hadoop"),
        HADOOPCONF("hadoop.config.dir", System.getenv("HADOOP_HOME") + "/conf"),
        HADOOPFS("fs.default.name", "file:///"),
        HADOOPMAPFILENAME("map.input.file", null),
        HADOOPMAPREDINPUTDIR("mapred.input.dir", null),
        HADOOPMAPREDINPUTDIRRECURSIVE("mapred.input.dir.recursive", false),
        HADOOPJT("mapred.job.tracker", "local"),
        HADOOPNUMREDUCERS("mapred.reduce.tasks", 1),
        HADOOPJOBNAME("mapred.job.name", null),
        HADOOPSPECULATIVEEXECREDUCERS("mapred.reduce.tasks.speculative.execution", false),
        METASTOREDIRECTORY("hive.metastore.metadb.dir", ""),
        METASTOREWAREHOUSE("hive.metastore.warehouse.dir", ""),
        METASTOREURIS("hive.metastore.uris", ""),
        METASTORETHRIFTRETRIES("hive.metastore.connect.retries", 5),
        METASTORE_CLIENT_CONNECT_RETRY_DELAY("hive.metastore.client.connect.retry.delay", 1),
        METASTORE_CLIENT_SOCKET_TIMEOUT("hive.metastore.client.socket.timeout", 20),
        METASTOREPWD("javax.jdo.option.ConnectionPassword", ""),
        METASTORECONNECTURLHOOK("hive.metastore.ds.connection.url.hook", ""),
        METASTORECONNECTURLKEY("javax.jdo.option.ConnectionURL", ""),
        METASTOREATTEMPTS("hive.metastore.ds.retry.attempts", 1),
        METASTOREINTERVAL("hive.metastore.ds.retry.interval", 1000),
        METASTOREFORCERELOADCONF("hive.metastore.force.reload.conf", false),
        METASTORESERVERMINTHREADS("hive.metastore.server.min.threads", 200),
        METASTORESERVERMAXTHREADS("hive.metastore.server.max.threads", Integer.MAX_VALUE),
        METASTORE_TCP_KEEP_ALIVE("hive.metastore.server.tcp.keepalive", true),
        METASTORE_INT_ORIGINAL("hive.metastore.archive.intermediate.original", "_INTERMEDIATE_ORIGINAL"),
        METASTORE_INT_ARCHIVED("hive.metastore.archive.intermediate.archived", "_INTERMEDIATE_ARCHIVED"),
        METASTORE_INT_EXTRACTED("hive.metastore.archive.intermediate.extracted", "_INTERMEDIATE_EXTRACTED"),
        METASTORE_KERBEROS_KEYTAB_FILE("hive.metastore.kerberos.keytab.file", ""),
        METASTORE_KERBEROS_PRINCIPAL("hive.metastore.kerberos.principal", ""),
        METASTORE_USE_THRIFT_SASL("hive.metastore.sasl.enabled", false),
        METASTORE_CACHE_PINOBJTYPES("hive.metastore.cache.pinobjtypes", "Table,StorageDescriptor,SerDeInfo,Partition,Database,Type,FieldSchema,Order"),
        METASTORE_CONNECTION_POOLING_TYPE("datanucleus.connectionPoolingType", "DBCP"),
        METASTORE_VALIDATE_TABLES("datanucleus.validateTables", false),
        METASTORE_VALIDATE_COLUMNS("datanucleus.validateColumns", false),
        METASTORE_VALIDATE_CONSTRAINTS("datanucleus.validateConstraints", false),
        METASTORE_STORE_MANAGER_TYPE("datanucleus.storeManagerType", "rdbms"),
        METASTORE_AUTO_CREATE_SCHEMA("datanucleus.autoCreateSchema", true),
        METASTORE_AUTO_START_MECHANISM_MODE("datanucleus.autoStartMechanismMode", "checked"),
        METASTORE_TRANSACTION_ISOLATION("datanucleus.transactionIsolation", "read-committed"),
        METASTORE_CACHE_LEVEL2("datanucleus.cache.level2", false),
        METASTORE_CACHE_LEVEL2_TYPE("datanucleus.cache.level2.type", "SOFT"),
        METASTORE_IDENTIFIER_FACTORY("datanucleus.identifierFactory", "datanucleus"),
        METASTORE_PLUGIN_REGISTRY_BUNDLE_CHECK("datanucleus.plugin.pluginRegistryBundleCheck", "LOG"),
        NEWTABLEDEFAULTPARA("hive.table.parameters.default", ""),
        CLIIGNOREERRORS("hive.cli.errors.ignore", false),
        HIVE_METASTORE_FS_HANDLER_CLS("hive.metastore.fs.handler.class", "org.apache.hadoop.hive.metastore.HiveMetaStoreFsImpl"),
        HIVESESSIONID("hive.session.id", ""),
        HIVESESSIONSILENT("hive.session.silent", false),
        HIVEQUERYSTRING("hive.query.string", ""),
        HIVEQUERYID("hive.query.id", ""),
        HIVEPLANID("hive.query.planid", ""),
        HIVEJOBNAMELENGTH("hive.jobname.length", 50),
        HIVEJAR("hive.jar.path", ""),
        HIVEAUXJARS("hive.aux.jars.path", ""),
        HIVEADDEDFILES("hive.added.files.path", ""),
        HIVEADDEDJARS("hive.added.jars.path", ""),
        HIVEADDEDARCHIVES("hive.added.archives.path", ""),
        HIVES_AUTO_PROGRESS_TIMEOUT("hive.auto.progress.timeout", 0),
        HIVETABLENAME("hive.table.name", ""),
        HIVEPARTITIONNAME("hive.partition.name", ""),
        HIVESCRIPTAUTOPROGRESS("hive.script.auto.progress", false),
        HIVESCRIPTIDENVVAR("hive.script.operator.id.env.var", "HIVE_SCRIPT_OPERATOR_ID"),
        HIVEMAPREDMODE("hive.mapred.mode", "nonstrict"),
        HIVEALIAS("hive.alias", ""),
        HIVEMAPSIDEAGGREGATE("hive.map.aggr", "true"),
        HIVEGROUPBYSKEW("hive.groupby.skewindata", "false"),
        HIVEJOINEMITINTERVAL("hive.join.emit.interval", 1000),
        HIVEJOINCACHESIZE("hive.join.cache.size", 25000),
        HIVEMAPJOINBUCKETCACHESIZE("hive.mapjoin.bucket.cache.size", 100),
        HIVEMAPJOINROWSIZE("hive.mapjoin.size.key", 10000),
        HIVEMAPJOINCACHEROWS("hive.mapjoin.cache.numrows", 25000),
        HIVEGROUPBYMAPINTERVAL("hive.groupby.mapaggr.checkinterval", 100000),
        HIVEMAPAGGRHASHMEMORY("hive.map.aggr.hash.percentmemory", 0.5f),
        HIVEMAPJOINFOLLOWEDBYMAPAGGRHASHMEMORY("hive.mapjoin.followby.map.aggr.hash.percentmemory", 0.3f),
        HIVEMAPAGGRMEMORYTHRESHOLD("hive.map.aggr.hash.force.flush.memory.threshold", 0.9f),
        HIVEMAPAGGRHASHMINREDUCTION("hive.map.aggr.hash.min.reduction", 0.5f),
        HIVEUDTFAUTOPROGRESS("hive.udtf.auto.progress", false),
        HIVEDEFAULTFILEFORMAT("hive.default.fileformat", "TextFile"),
        HIVEQUERYRESULTFILEFORMAT("hive.query.result.fileformat", "TextFile"),
        HIVECHECKFILEFORMAT("hive.fileformat.check", true),
        HIVEHISTORYFILELOC("hive.querylog.location", "/tmp/" + System.getProperty("user.name")),
        HIVESCRIPTSERDE("hive.script.serde", "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe"),
        HIVESCRIPTRECORDREADER("hive.script.recordreader", "org.apache.hadoop.hive.ql.exec.TextRecordReader"),
        HIVESCRIPTRECORDWRITER("hive.script.recordwriter", "org.apache.hadoop.hive.ql.exec.TextRecordWriter"),
        HIVEHWILISTENHOST("hive.hwi.listen.host", "0.0.0.0"),
        HIVEHWILISTENPORT("hive.hwi.listen.port", "9999"),
        HIVEHWIWARFILE("hive.hwi.war.file", System.getenv("HWI_WAR_FILE")),
        HIVEHADOOPMAXMEM("hive.mapred.local.mem", 0),
        HIVESMALLTABLESFILESIZE("hive.smalltable.filesize", 25000000L),
        HIVETESTMODE("hive.test.mode", false),
        HIVETESTMODEPREFIX("hive.test.mode.prefix", "test_"),
        HIVETESTMODESAMPLEFREQ("hive.test.mode.samplefreq", 32),
        HIVETESTMODENOSAMPLE("hive.test.mode.nosamplelist", ""),
        HIVEMERGEMAPFILES("hive.merge.mapfiles", true),
        HIVEMERGEMAPREDFILES("hive.merge.mapredfiles", false),
        HIVEMERGEMAPFILESSIZE("hive.merge.size.per.task", 256000000L),
        HIVEMERGEMAPFILESAVGSIZE("hive.merge.smallfiles.avgsize", 16000000L),
        HIVESKEWJOIN("hive.optimize.skewjoin", false),
        HIVECONVERTJOIN("hive.auto.convert.join", false),
        HIVESKEWJOINKEY("hive.skewjoin.key", 1000000),
        HIVESKEWJOINMAPJOINNUMMAPTASK("hive.skewjoin.mapjoin.map.tasks", 10000),
        HIVESKEWJOINMAPJOINMINSPLIT("hive.skewjoin.mapjoin.min.split", 0x2000000L),
        MAPREDMAXSPLITSIZE("mapred.max.split.size", 256000000L),
        MAPREDMINSPLITSIZE("mapred.min.split.size", 1L),
        MAPREDMINSPLITSIZEPERNODE("mapred.min.split.size.per.rack", 1L),
        MAPREDMINSPLITSIZEPERRACK("mapred.min.split.size.per.node", 1L),
        HIVEMERGEMAPONLY("hive.mergejob.maponly", true),
        HIVESENDHEARTBEAT("hive.heartbeat.interval", 1000),
        HIVEMAXMAPJOINSIZE("hive.mapjoin.maxsize", 100000),
        HIVEHASHTABLETHRESHOLD("hive.hashtable.initialCapacity", 100000),
        HIVEHASHTABLELOADFACTOR("hive.hashtable.loadfactor", 0.75f),
        HIVEHASHTABLEFOLLOWBYGBYMAXMEMORYUSAGE("hive.mapjoin.followby.gby.localtask.max.memory.usage", 0.55f),
        HIVEHASHTABLEMAXMEMORYUSAGE("hive.mapjoin.localtask.max.memory.usage", 0.9f),
        HIVEHASHTABLESCALE("hive.mapjoin.check.memory.rows", 100000L),
        HIVEDEBUGLOCALTASK("hive.debug.localtask", false),
        HIVEJOBPROGRESS("hive.task.progress", false),
        HIVEINPUTFORMAT("hive.input.format", "org.apache.hadoop.hive.ql.io.CombineHiveInputFormat"),
        HIVEENFORCEBUCKETING("hive.enforce.bucketing", false),
        HIVEENFORCESORTING("hive.enforce.sorting", false),
        HIVEPARTITIONER("hive.mapred.partitioner", "org.apache.hadoop.hive.ql.io.DefaultHivePartitioner"),
        HIVESCRIPTOPERATORTRUST("hive.exec.script.trust", false),
        HIVE_COMBINE_INPUT_FORMAT_SUPPORTS_SPLITTABLE("hive.hadoop.supports.splittable.combineinputformat", false),
        HIVEOPTCP("hive.optimize.cp", true),
        HIVEOPTPPD("hive.optimize.ppd", true),
        HIVEOPTPPD_STORAGE("hive.optimize.ppd.storage", true),
        HIVEOPTGROUPBY("hive.optimize.groupby", true),
        HIVEOPTBUCKETMAPJOIN("hive.optimize.bucketmapjoin", false),
        HIVEOPTSORTMERGEBUCKETMAPJOIN("hive.optimize.bucketmapjoin.sortedmerge", false),
        HIVEOPTREDUCEDEDUPLICATION("hive.optimize.reducededuplication", true),
        HIVESTATSAUTOGATHER("hive.stats.autogather", true),
        HIVESTATSDBCLASS("hive.stats.dbclass", "jdbc:derby"),
        HIVESTATSJDBCDRIVER("hive.stats.jdbcdriver", "org.apache.derby.jdbc.EmbeddedDriver"),
        HIVESTATSDBCONNECTIONSTRING("hive.stats.dbconnectionstring", "jdbc:derby:;databaseName=TempStatsStore;create=true"),
        HIVE_STATS_DEFAULT_PUBLISHER("hive.stats.default.publisher", ""),
        HIVE_STATS_DEFAULT_AGGREGATOR("hive.stats.default.aggregator", ""),
        HIVE_STATS_JDBC_TIMEOUT("hive.stats.jdbc.timeout", 30),
        HIVE_STATS_ATOMIC("hive.stats.atomic", false),
        HIVE_SUPPORT_CONCURRENCY("hive.support.concurrency", false),
        HIVE_LOCK_MANAGER("hive.lock.manager", "org.apache.hadoop.hive.ql.lockmgr.zookeeper.ZooKeeperHiveLockManager"),
        HIVE_LOCK_NUMRETRIES("hive.lock.numretries", 100),
        HIVE_LOCK_SLEEP_BETWEEN_RETRIES("hive.lock.sleep.between.retries", 60),
        HIVE_ZOOKEEPER_QUORUM("hive.zookeeper.quorum", ""),
        HIVE_ZOOKEEPER_CLIENT_PORT("hive.zookeeper.client.port", ""),
        HIVE_ZOOKEEPER_SESSION_TIMEOUT("hive.zookeeper.session.timeout", 600000),
        HIVE_ZOOKEEPER_NAMESPACE("hive.zookeeper.namespace", "hive_zookeeper_namespace"),
        HIVE_ZOOKEEPER_CLEAN_EXTRA_NODES("hive.zookeeper.clean.extra.nodes", false),
        HIVE_HBASE_WAL_ENABLED("hive.hbase.wal.enabled", true),
        HIVEARCHIVEENABLED("hive.archive.enabled", false),
        HIVEHARPARENTDIRSETTABLE("hive.archive.har.parentdir.settable", false),
        HIVEOUTERJOINSUPPORTSFILTERS("hive.outerjoin.supports.filters", true),
        HIVEFETCHOUTPUTSERDE("hive.fetch.output.serde", "org.apache.hadoop.hive.serde2.DelimitedJSONSerDe"),
        HIVEVARIABLESUBSTITUTE("hive.variable.substitute", true),
        SEMANTIC_ANALYZER_HOOK("hive.semantic.analyzer.hook", null),
        HIVE_AUTHORIZATION_ENABLED("hive.security.authorization.enabled", false),
        HIVE_AUTHORIZATION_MANAGER("hive.security.authorization.manager", null),
        HIVE_AUTHENTICATOR_MANAGER("hive.security.authenticator.manager", null),
        HIVE_AUTHORIZATION_TABLE_USER_GRANTS("hive.security.authorization.createtable.user.grants", null),
        HIVE_AUTHORIZATION_TABLE_GROUP_GRANTS("hive.security.authorization.createtable.group.grants", null),
        HIVE_AUTHORIZATION_TABLE_ROLE_GRANTS("hive.security.authorization.createtable.role.grants", null),
        HIVE_AUTHORIZATION_TABLE_OWNER_GRANTS("hive.security.authorization.createtable.owner.grants", null),
        HIVE_CLI_PRINT_HEADER("hive.cli.print.header", false),
        HIVE_ERROR_ON_EMPTY_PARTITION("hive.error.on.empty.partition", false),
        HIVE_INDEX_IGNORE_HDFS_LOC("hive.index.compact.file.ignore.hdfs", false),
        HIVE_MAPPER_CANNOT_SPAN_MULTIPLE_PARTITIONS("hive.mapper.cannot.span.multiple.partitions", false),
        HIVE_REWORK_MAPREDWORK("hive.rework.mapredwork", false);

        public final String varname;
        public final String defaultVal;
        public final int defaultIntVal;
        public final long defaultLongVal;
        public final float defaultFloatVal;
        public final Class<?> valClass;
        public final boolean defaultBoolVal;

        private ConfVars(String varname, String defaultVal) {
            this.varname = varname;
            this.valClass = String.class;
            this.defaultVal = defaultVal;
            this.defaultIntVal = -1;
            this.defaultLongVal = -1L;
            this.defaultFloatVal = -1.0f;
            this.defaultBoolVal = false;
        }

        private ConfVars(String varname, int defaultIntVal) {
            this.varname = varname;
            this.valClass = Integer.class;
            this.defaultVal = null;
            this.defaultIntVal = defaultIntVal;
            this.defaultLongVal = -1L;
            this.defaultFloatVal = -1.0f;
            this.defaultBoolVal = false;
        }

        private ConfVars(String varname, long defaultLongVal) {
            this.varname = varname;
            this.valClass = Long.class;
            this.defaultVal = null;
            this.defaultIntVal = -1;
            this.defaultLongVal = defaultLongVal;
            this.defaultFloatVal = -1.0f;
            this.defaultBoolVal = false;
        }

        private ConfVars(String varname, float defaultFloatVal) {
            this.varname = varname;
            this.valClass = Float.class;
            this.defaultVal = null;
            this.defaultIntVal = -1;
            this.defaultLongVal = -1L;
            this.defaultFloatVal = defaultFloatVal;
            this.defaultBoolVal = false;
        }

        private ConfVars(String varname, boolean defaultBoolVal) {
            this.varname = varname;
            this.valClass = Boolean.class;
            this.defaultVal = null;
            this.defaultIntVal = -1;
            this.defaultLongVal = -1L;
            this.defaultFloatVal = -1.0f;
            this.defaultBoolVal = defaultBoolVal;
        }

        public String toString() {
            return this.varname;
        }
    }
}

