/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.BufferedWriter;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.metadata.CheckResult;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMetaStoreChecker;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.AlterDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.AlterIndexDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableSimpleDesc;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.CreateIndexDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableLikeDesc;
import org.apache.hadoop.hive.ql.plan.CreateViewDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DescFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DropIndexDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.GrantDesc;
import org.apache.hadoop.hive.ql.plan.GrantRevokeRoleDDL;
import org.apache.hadoop.hive.ql.plan.LockTableDesc;
import org.apache.hadoop.hive.ql.plan.MsckDesc;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.plan.RevokeDesc;
import org.apache.hadoop.hive.ql.plan.RoleDDLDesc;
import org.apache.hadoop.hive.ql.plan.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.plan.ShowFunctionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowGrantDesc;
import org.apache.hadoop.hive.ql.plan.ShowIndexesDesc;
import org.apache.hadoop.hive.ql.plan.ShowLocksDesc;
import org.apache.hadoop.hive.ql.plan.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.plan.ShowTablesDesc;
import org.apache.hadoop.hive.ql.plan.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.UnlockTableDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.dynamic_type.DynamicSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DDLTask
extends Task<DDLWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.exec.DDLTask");
    transient HiveConf conf;
    private static final int separator = 9;
    private static final int terminator = 10;
    private static String INTERMEDIATE_ARCHIVED_DIR_SUFFIX;
    private static String INTERMEDIATE_ORIGINAL_DIR_SUFFIX;
    private static String INTERMEDIATE_EXTRACTED_DIR_SUFFIX;

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext ctx) {
        super.initialize(conf, queryPlan, ctx);
        this.conf = conf;
        INTERMEDIATE_ARCHIVED_DIR_SUFFIX = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ARCHIVED);
        INTERMEDIATE_ORIGINAL_DIR_SUFFIX = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ORIGINAL);
        INTERMEDIATE_EXTRACTED_DIR_SUFFIX = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_EXTRACTED);
    }

    @Override
    public int execute(DriverContext driverContext) {
        try {
            MsckDesc msckDesc;
            Hive db = Hive.get(this.conf);
            CreateDatabaseDesc createDatabaseDesc = ((DDLWork)this.work).getCreateDatabaseDesc();
            if (null != createDatabaseDesc) {
                return this.createDatabase(db, createDatabaseDesc);
            }
            DropDatabaseDesc dropDatabaseDesc = ((DDLWork)this.work).getDropDatabaseDesc();
            if (dropDatabaseDesc != null) {
                return this.dropDatabase(db, dropDatabaseDesc);
            }
            SwitchDatabaseDesc switchDatabaseDesc = ((DDLWork)this.work).getSwitchDatabaseDesc();
            if (switchDatabaseDesc != null) {
                return this.switchDatabase(db, switchDatabaseDesc);
            }
            DescDatabaseDesc descDatabaseDesc = ((DDLWork)this.work).getDescDatabaseDesc();
            if (descDatabaseDesc != null) {
                return this.descDatabase(descDatabaseDesc);
            }
            AlterDatabaseDesc alterDatabaseDesc = ((DDLWork)this.work).getAlterDatabaseDesc();
            if (alterDatabaseDesc != null) {
                return this.alterDatabase(alterDatabaseDesc);
            }
            CreateTableDesc crtTbl = ((DDLWork)this.work).getCreateTblDesc();
            if (crtTbl != null) {
                return this.createTable(db, crtTbl);
            }
            CreateIndexDesc crtIndex = ((DDLWork)this.work).getCreateIndexDesc();
            if (crtIndex != null) {
                return this.createIndex(db, crtIndex);
            }
            AlterIndexDesc alterIndex = ((DDLWork)this.work).getAlterIndexDesc();
            if (alterIndex != null) {
                return this.alterIndex(db, alterIndex);
            }
            DropIndexDesc dropIdx = ((DDLWork)this.work).getDropIdxDesc();
            if (dropIdx != null) {
                return this.dropIndex(db, dropIdx);
            }
            CreateTableLikeDesc crtTblLike = ((DDLWork)this.work).getCreateTblLikeDesc();
            if (crtTblLike != null) {
                return this.createTableLike(db, crtTblLike);
            }
            DropTableDesc dropTbl = ((DDLWork)this.work).getDropTblDesc();
            if (dropTbl != null) {
                return this.dropTable(db, dropTbl);
            }
            AlterTableDesc alterTbl = ((DDLWork)this.work).getAlterTblDesc();
            if (alterTbl != null) {
                return this.alterTable(db, alterTbl);
            }
            CreateViewDesc crtView = ((DDLWork)this.work).getCreateViewDesc();
            if (crtView != null) {
                return this.createView(db, crtView);
            }
            AddPartitionDesc addPartitionDesc = ((DDLWork)this.work).getAddPartitionDesc();
            if (addPartitionDesc != null) {
                return this.addPartition(db, addPartitionDesc);
            }
            AlterTableSimpleDesc simpleDesc = ((DDLWork)this.work).getAlterTblSimpleDesc();
            if (simpleDesc != null) {
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.TOUCH) {
                    return this.touch(db, simpleDesc);
                }
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.ARCHIVE) {
                    return this.archive(db, simpleDesc, driverContext);
                }
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.UNARCHIVE) {
                    return this.unarchive(db, simpleDesc);
                }
            }
            if ((msckDesc = ((DDLWork)this.work).getMsckDesc()) != null) {
                return this.msck(db, msckDesc);
            }
            DescTableDesc descTbl = ((DDLWork)this.work).getDescTblDesc();
            if (descTbl != null) {
                return this.describeTable(db, descTbl);
            }
            DescFunctionDesc descFunc = ((DDLWork)this.work).getDescFunctionDesc();
            if (descFunc != null) {
                return this.describeFunction(descFunc);
            }
            ShowDatabasesDesc showDatabases = ((DDLWork)this.work).getShowDatabasesDesc();
            if (showDatabases != null) {
                return this.showDatabases(db, showDatabases);
            }
            ShowTablesDesc showTbls = ((DDLWork)this.work).getShowTblsDesc();
            if (showTbls != null) {
                return this.showTables(db, showTbls);
            }
            ShowTableStatusDesc showTblStatus = ((DDLWork)this.work).getShowTblStatusDesc();
            if (showTblStatus != null) {
                return this.showTableStatus(db, showTblStatus);
            }
            ShowFunctionsDesc showFuncs = ((DDLWork)this.work).getShowFuncsDesc();
            if (showFuncs != null) {
                return this.showFunctions(showFuncs);
            }
            ShowLocksDesc showLocks = ((DDLWork)this.work).getShowLocksDesc();
            if (showLocks != null) {
                return this.showLocks(showLocks);
            }
            LockTableDesc lockTbl = ((DDLWork)this.work).getLockTblDesc();
            if (lockTbl != null) {
                return this.lockTable(lockTbl);
            }
            UnlockTableDesc unlockTbl = ((DDLWork)this.work).getUnlockTblDesc();
            if (unlockTbl != null) {
                return this.unlockTable(unlockTbl);
            }
            ShowPartitionsDesc showParts = ((DDLWork)this.work).getShowPartsDesc();
            if (showParts != null) {
                return this.showPartitions(db, showParts);
            }
            RoleDDLDesc roleDDLDesc = ((DDLWork)this.work).getRoleDDLDesc();
            if (roleDDLDesc != null) {
                return this.roleDDL(roleDDLDesc);
            }
            GrantDesc grantDesc = ((DDLWork)this.work).getGrantDesc();
            if (grantDesc != null) {
                return this.grantOrRevokePrivileges(grantDesc.getPrincipals(), grantDesc.getPrivileges(), grantDesc.getPrivilegeSubjectDesc(), grantDesc.getGrantor(), grantDesc.getGrantorType(), grantDesc.isGrantOption(), true);
            }
            RevokeDesc revokeDesc = ((DDLWork)this.work).getRevokeDesc();
            if (revokeDesc != null) {
                return this.grantOrRevokePrivileges(revokeDesc.getPrincipals(), revokeDesc.getPrivileges(), revokeDesc.getPrivilegeSubjectDesc(), null, null, false, false);
            }
            ShowGrantDesc showGrantDesc = ((DDLWork)this.work).getShowGrantDesc();
            if (showGrantDesc != null) {
                return this.showGrants(showGrantDesc);
            }
            GrantRevokeRoleDDL grantOrRevokeRoleDDL = ((DDLWork)this.work).getGrantRevokeRoleDDL();
            if (grantOrRevokeRoleDDL != null) {
                return this.grantOrRevokeRole(grantOrRevokeRoleDDL);
            }
            ShowIndexesDesc showIndexes = ((DDLWork)this.work).getShowIndexesDesc();
            if (showIndexes != null) {
                return this.showIndexes(db, showIndexes);
            }
        }
        catch (InvalidTableException e) {
            this.console.printError("Table " + e.getTableName() + " does not exist");
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        catch (HiveException e) {
            this.console.printError("FAILED: Error in metadata: " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        catch (Exception e) {
            this.console.printError("Failed with exception " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        assert (false);
        return 0;
    }

    private int grantOrRevokeRole(GrantRevokeRoleDDL grantOrRevokeRoleDDL) throws HiveException {
        try {
            boolean grantRole = grantOrRevokeRoleDDL.getGrant();
            List<PrincipalDesc> principals = grantOrRevokeRoleDDL.getPrincipalDesc();
            List<String> roles = grantOrRevokeRoleDDL.getRoles();
            for (PrincipalDesc principal : principals) {
                String userName = principal.getName();
                for (String roleName : roles) {
                    if (grantRole) {
                        this.db.grantRole(roleName, userName, principal.getType(), grantOrRevokeRoleDDL.getGrantor(), grantOrRevokeRoleDDL.getGrantorType(), grantOrRevokeRoleDDL.isGrantOption());
                        continue;
                    }
                    this.db.revokeRole(roleName, userName, principal.getType());
                }
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return 0;
    }

    private int showGrants(ShowGrantDesc showGrantDesc) throws HiveException {
        try {
            Path resFile = new Path(showGrantDesc.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            PrincipalDesc principalDesc = showGrantDesc.getPrincipalDesc();
            PrivilegeObjectDesc hiveObjectDesc = showGrantDesc.getHiveObj();
            String principalName = principalDesc.getName();
            if (hiveObjectDesc == null) {
                List<HiveObjectPrivilege> users = this.db.showPrivilegeGrant(HiveObjectType.GLOBAL, principalName, principalDesc.getType(), null, null, null, null);
                if (users != null && users.size() > 0) {
                    boolean first = true;
                    for (HiveObjectPrivilege usr : users) {
                        if (!first) {
                            outStream.write(10);
                        } else {
                            first = false;
                        }
                        DDLTask.writeGrantInfo((DataOutput)outStream, principalDesc.getType(), principalName, null, null, null, null, usr.getGrantInfo());
                    }
                }
            } else {
                String obj = hiveObjectDesc.getObject();
                boolean notFound = true;
                String dbName = null;
                String tableName = null;
                Table tableObj = null;
                Database dbObj = null;
                if (hiveObjectDesc.getTable()) {
                    String[] dbTab = obj.split("\\.");
                    if (dbTab.length == 2) {
                        dbName = dbTab[0];
                        tableName = dbTab[1];
                    } else {
                        dbName = this.db.getCurrentDatabase();
                        tableName = obj;
                    }
                    dbObj = this.db.getDatabase(dbName);
                    tableObj = this.db.getTable(dbName, tableName);
                    notFound = dbObj == null || tableObj == null;
                } else {
                    dbName = hiveObjectDesc.getObject();
                    dbObj = this.db.getDatabase(dbName);
                    boolean bl = notFound = dbObj == null;
                }
                if (notFound) {
                    throw new HiveException(obj + " can not be found");
                }
                String partName = null;
                List partValues = null;
                if (hiveObjectDesc.getPartSpec() != null) {
                    partName = Warehouse.makePartName(hiveObjectDesc.getPartSpec(), (boolean)false);
                    partValues = Warehouse.getPartValuesFromPartName((String)partName);
                }
                if (!hiveObjectDesc.getTable()) {
                    List<HiveObjectPrivilege> dbs = this.db.showPrivilegeGrant(HiveObjectType.DATABASE, principalName, principalDesc.getType(), dbName, null, null, null);
                    if (dbs != null && dbs.size() > 0) {
                        boolean first = true;
                        for (HiveObjectPrivilege db : dbs) {
                            if (!first) {
                                outStream.write(10);
                            } else {
                                first = false;
                            }
                            DDLTask.writeGrantInfo((DataOutput)outStream, principalDesc.getType(), principalName, dbName, null, null, null, db.getGrantInfo());
                        }
                    }
                } else if (showGrantDesc.getColumns() != null) {
                    for (String columnName : showGrantDesc.getColumns()) {
                        List<HiveObjectPrivilege> columnss = this.db.showPrivilegeGrant(HiveObjectType.COLUMN, principalName, principalDesc.getType(), dbName, tableName, partValues, columnName);
                        if (columnss == null || columnss.size() <= 0) continue;
                        boolean first = true;
                        for (HiveObjectPrivilege col : columnss) {
                            if (!first) {
                                outStream.write(10);
                            } else {
                                first = false;
                            }
                            DDLTask.writeGrantInfo((DataOutput)outStream, principalDesc.getType(), principalName, dbName, tableName, partName, columnName, col.getGrantInfo());
                        }
                    }
                } else if (hiveObjectDesc.getPartSpec() != null) {
                    List<HiveObjectPrivilege> parts = this.db.showPrivilegeGrant(HiveObjectType.PARTITION, principalName, principalDesc.getType(), dbName, tableName, partValues, null);
                    if (parts != null && parts.size() > 0) {
                        boolean first = true;
                        for (HiveObjectPrivilege part : parts) {
                            if (!first) {
                                outStream.write(10);
                            } else {
                                first = false;
                            }
                            DDLTask.writeGrantInfo((DataOutput)outStream, principalDesc.getType(), principalName, dbName, tableName, partName, null, part.getGrantInfo());
                        }
                    }
                } else {
                    List<HiveObjectPrivilege> tbls = this.db.showPrivilegeGrant(HiveObjectType.TABLE, principalName, principalDesc.getType(), dbName, tableName, null, null);
                    if (tbls != null && tbls.size() > 0) {
                        boolean first = true;
                        for (HiveObjectPrivilege tbl : tbls) {
                            if (!first) {
                                outStream.write(10);
                            } else {
                                first = false;
                            }
                            DDLTask.writeGrantInfo((DataOutput)outStream, principalDesc.getType(), principalName, dbName, tableName, null, null, tbl.getGrantInfo());
                        }
                    }
                }
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("show table status: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.info((Object)("show table status: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
        return 0;
    }

    private int grantOrRevokePrivileges(List<PrincipalDesc> principals, List<PrivilegeDesc> privileges, PrivilegeObjectDesc privSubjectDesc, String grantor, PrincipalType grantorType, boolean grantOption, boolean isGrant) {
        if (privileges == null || privileges.size() == 0) {
            this.console.printError("No privilege found.");
            return 1;
        }
        String dbName = null;
        String tableName = null;
        Table tableObj = null;
        Database dbObj = null;
        try {
            if (privSubjectDesc != null) {
                if (privSubjectDesc.getPartSpec() != null && isGrant) {
                    throw new HiveException("Grant does not support partition level.");
                }
                String obj = privSubjectDesc.getObject();
                boolean notFound = true;
                if (privSubjectDesc.getTable()) {
                    String[] dbTab = obj.split("\\.");
                    if (dbTab.length == 2) {
                        dbName = dbTab[0];
                        tableName = dbTab[1];
                    } else {
                        dbName = this.db.getCurrentDatabase();
                        tableName = obj;
                    }
                    dbObj = this.db.getDatabase(dbName);
                    tableObj = this.db.getTable(dbName, tableName);
                    notFound = dbObj == null || tableObj == null;
                } else {
                    dbName = privSubjectDesc.getObject();
                    dbObj = this.db.getDatabase(dbName);
                    boolean bl = notFound = dbObj == null;
                }
                if (notFound) {
                    throw new HiveException(obj + " can not be found");
                }
            }
            PrivilegeBag privBag = new PrivilegeBag();
            if (privSubjectDesc == null) {
                for (int idx = 0; idx < privileges.size(); ++idx) {
                    Privilege priv = privileges.get(idx).getPrivilege();
                    if (privileges.get(idx).getColumns() != null && privileges.get(idx).getColumns().size() > 0) {
                        throw new HiveException("For user-level privileges, column sets should be null. columns=" + privileges.get(idx).getColumns().toString());
                    }
                    privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.GLOBAL, null, null, null, null), null, null, new PrivilegeGrantInfo(priv.toString(), 0, grantor, grantorType, grantOption)));
                }
            } else {
                org.apache.hadoop.hive.metastore.api.Partition partObj = null;
                List partValues = null;
                if (tableObj != null) {
                    if (!tableObj.isPartitioned() && privSubjectDesc.getPartSpec() != null) {
                        throw new HiveException("Table is not partitioned, but partition name is present: partSpec=" + privSubjectDesc.getPartSpec().toString());
                    }
                    if (privSubjectDesc.getPartSpec() != null) {
                        partObj = this.db.getPartition(tableObj, privSubjectDesc.getPartSpec(), false).getTPartition();
                        partValues = partObj.getValues();
                    }
                }
                for (PrivilegeDesc privDesc : privileges) {
                    List<String> columns = privDesc.getColumns();
                    Privilege priv = privDesc.getPrivilege();
                    if (columns != null && columns.size() > 0) {
                        if (!priv.supportColumnLevel()) {
                            throw new HiveException(priv.toString() + " does not support column level.");
                        }
                        if (privSubjectDesc == null || tableName == null) {
                            throw new HiveException("For user-level/database-level privileges, column sets should be null. columns=" + columns);
                        }
                        for (int i = 0; i < columns.size(); ++i) {
                            privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.COLUMN, dbName, tableName, partValues, columns.get(i)), null, null, new PrivilegeGrantInfo(priv.toString(), 0, grantor, grantorType, grantOption)));
                        }
                        continue;
                    }
                    if (privSubjectDesc.getTable()) {
                        if (privSubjectDesc.getPartSpec() != null) {
                            privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.PARTITION, dbName, tableName, partValues, null), null, null, new PrivilegeGrantInfo(priv.toString(), 0, grantor, grantorType, grantOption)));
                            continue;
                        }
                        privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.TABLE, dbName, tableName, null, null), null, null, new PrivilegeGrantInfo(priv.toString(), 0, grantor, grantorType, grantOption)));
                        continue;
                    }
                    privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.DATABASE, dbName, null, null, null), null, null, new PrivilegeGrantInfo(priv.toString(), 0, grantor, grantorType, grantOption)));
                }
            }
            for (PrincipalDesc principal : principals) {
                for (int i = 0; i < privBag.getPrivileges().size(); ++i) {
                    HiveObjectPrivilege objPrivs = (HiveObjectPrivilege)privBag.getPrivileges().get(i);
                    objPrivs.setPrincipalName(principal.getName());
                    objPrivs.setPrincipalType(principal.getType());
                }
                if (isGrant) {
                    this.db.grantPrivileges(privBag);
                    continue;
                }
                this.db.revokePrivileges(privBag);
            }
        }
        catch (Exception e) {
            this.console.printError("Error: " + e.getMessage());
            return 1;
        }
        return 0;
    }

    private int roleDDL(RoleDDLDesc roleDDLDesc) {
        block8: {
            RoleDDLDesc.RoleOperation operation = roleDDLDesc.getOperation();
            try {
                if (operation.equals((Object)RoleDDLDesc.RoleOperation.CREATE_ROLE)) {
                    this.db.createRole(roleDDLDesc.getName(), roleDDLDesc.getRoleOwnerName());
                    break block8;
                }
                if (operation.equals((Object)RoleDDLDesc.RoleOperation.DROP_ROLE)) {
                    this.db.dropRole(roleDDLDesc.getName());
                    break block8;
                }
                if (operation.equals((Object)RoleDDLDesc.RoleOperation.SHOW_ROLE_GRANT)) {
                    List<Role> roles = this.db.showRoleGrant(roleDDLDesc.getName(), roleDDLDesc.getPrincipalType());
                    if (roles != null && roles.size() > 0) {
                        Path resFile = new Path(roleDDLDesc.getResFile());
                        FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
                        FSDataOutputStream outStream = fs.create(resFile);
                        for (Role role : roles) {
                            outStream.writeBytes("role name:" + role.getRoleName());
                            outStream.write(10);
                        }
                        outStream.close();
                    }
                    break block8;
                }
                throw new HiveException("Unkown role operation " + operation.getOperationName());
            }
            catch (HiveException e) {
                this.console.printError("Error in role operation " + operation.getOperationName() + " on role name " + roleDDLDesc.getName() + ", error message " + e.getMessage());
                return 1;
            }
            catch (IOException e) {
                LOG.info((Object)("role ddl exception: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
                return 1;
            }
        }
        return 0;
    }

    private int alterDatabase(AlterDatabaseDesc alterDbDesc) throws HiveException {
        String dbName = alterDbDesc.getDatabaseName();
        Database database = this.db.getDatabase(dbName);
        Map<String, String> newParams = alterDbDesc.getDatabaseProperties();
        if (database != null) {
            Map params = database.getParameters();
            if (params != null && newParams != null) {
                params.putAll(newParams);
                database.setParameters(params);
            } else {
                database.setParameters(newParams);
            }
        } else {
            throw new HiveException("ERROR: The database " + dbName + " does not exist.");
        }
        this.db.alterDatabase(database.getName(), database);
        return 0;
    }

    private int dropIndex(Hive db, DropIndexDesc dropIdx) throws HiveException {
        db.dropIndex(db.getCurrentDatabase(), dropIdx.getTableName(), dropIdx.getIndexName(), true);
        return 0;
    }

    private int createIndex(Hive db, CreateIndexDesc crtIndex) throws HiveException {
        if (crtIndex.getSerde() != null) {
            this.validateSerDe(crtIndex.getSerde());
        }
        db.createIndex(crtIndex.getTableName(), crtIndex.getIndexName(), crtIndex.getIndexTypeHandlerClass(), crtIndex.getIndexedCols(), crtIndex.getIndexTableName(), crtIndex.getDeferredRebuild(), crtIndex.getInputFormat(), crtIndex.getOutputFormat(), crtIndex.getSerde(), crtIndex.getStorageHandler(), crtIndex.getLocation(), crtIndex.getIdxProps(), crtIndex.getTblProps(), crtIndex.getSerdeProps(), crtIndex.getCollItemDelim(), crtIndex.getFieldDelim(), crtIndex.getFieldEscape(), crtIndex.getLineDelim(), crtIndex.getMapKeyDelim(), crtIndex.getIndexComment());
        return 0;
    }

    private int alterIndex(Hive db, AlterIndexDesc alterIndex) throws HiveException {
        String dbName = alterIndex.getDbName();
        String baseTableName = alterIndex.getBaseTableName();
        String indexName = alterIndex.getIndexName();
        Index idx = db.getIndex(dbName, baseTableName, indexName);
        if (alterIndex.getOp() != AlterIndexDesc.AlterIndexTypes.ADDPROPS) {
            this.console.printError("Unsupported Alter commnad");
            return 1;
        }
        idx.getParameters().putAll(alterIndex.getProps());
        if (!this.updateModifiedParameters(idx.getParameters(), this.conf)) {
            return 1;
        }
        try {
            db.alterIndex(dbName, baseTableName, indexName, idx);
        }
        catch (InvalidOperationException e) {
            this.console.printError("Invalid alter operation: " + e.getMessage());
            LOG.info((Object)("alter index: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (HiveException e) {
            this.console.printError("Invalid alter operation: " + e.getMessage());
            return 1;
        }
        return 0;
    }

    private int addPartition(Hive db, AddPartitionDesc addPartitionDesc) throws HiveException {
        Table tbl = db.getTable(addPartitionDesc.getDbName(), addPartitionDesc.getTableName());
        this.validateAlterTableType(tbl, AlterTableDesc.AlterTableTypes.ADDPARTITION, addPartitionDesc.getExpectView());
        Partition checkPart = db.getPartition(tbl, addPartitionDesc.getPartSpec(), false);
        if (checkPart != null && addPartitionDesc.getIfNotExists()) {
            return 0;
        }
        if (addPartitionDesc.getLocation() == null) {
            db.createPartition(tbl, addPartitionDesc.getPartSpec());
        } else {
            if (tbl.isView()) {
                throw new HiveException("LOCATION clause illegal for view partition");
            }
            db.createPartition(tbl, addPartitionDesc.getPartSpec(), new Path(tbl.getPath(), addPartitionDesc.getLocation()));
        }
        Partition part = db.getPartition(tbl, addPartitionDesc.getPartSpec(), false);
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(part));
        return 0;
    }

    private int touch(Hive db, AlterTableSimpleDesc touchDesc) throws HiveException {
        String dbName = touchDesc.getDbName();
        String tblName = touchDesc.getTableName();
        Table tbl = db.getTable(dbName, tblName);
        this.validateAlterTableType(tbl, AlterTableDesc.AlterTableTypes.TOUCH);
        if (touchDesc.getPartSpec() == null) {
            try {
                db.alterTable(tblName, tbl);
            }
            catch (InvalidOperationException e) {
                throw new HiveException("Uable to update table");
            }
            ((DDLWork)this.work).getInputs().add(new ReadEntity(tbl));
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        } else {
            Partition part = db.getPartition(tbl, touchDesc.getPartSpec(), false);
            if (part == null) {
                throw new HiveException("Specified partition does not exist");
            }
            try {
                db.alterPartition(tblName, part);
            }
            catch (InvalidOperationException e) {
                throw new HiveException(e);
            }
            ((DDLWork)this.work).getInputs().add(new ReadEntity(part));
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(part));
        }
        return 0;
    }

    private boolean isArchived(Partition p) {
        Map<String, String> params = p.getParameters();
        return "true".equalsIgnoreCase(params.get("is_archived"));
    }

    private void setIsArchived(Partition p, boolean state) {
        Map<String, String> params = p.getParameters();
        if (state) {
            params.put("is_archived", "true");
        } else {
            params.remove("is_archived");
        }
    }

    private String getOriginalLocation(Partition p) {
        Map<String, String> params = p.getParameters();
        return params.get("original_location");
    }

    private void setOriginalLocation(Partition p, String loc) {
        Map<String, String> params = p.getParameters();
        if (loc == null) {
            params.remove("original_location");
        } else {
            params.put("original_location", loc);
        }
    }

    private String getArchiveDirOnly(Path parentDir, String archiveName) {
        URI parentUri = parentDir.toUri();
        Path harDir = new Path(parentUri.getPath(), archiveName);
        return harDir.toString();
    }

    private void setArchived(Partition p, Path parentDir, String dirInArchive, String archiveName) throws URISyntaxException {
        assert (!this.isArchived(p));
        Map<String, String> params = p.getParameters();
        URI parentUri = parentDir.toUri();
        String parentHost = parentUri.getHost();
        String harHost = null;
        harHost = parentHost == null ? "" : parentUri.getScheme() + "-" + parentHost;
        URI harUri = null;
        harUri = dirInArchive.length() == 0 ? new URI("har", parentUri.getUserInfo(), harHost, parentUri.getPort(), this.getArchiveDirOnly(parentDir, archiveName), parentUri.getQuery(), parentUri.getFragment()) : new URI("har", parentUri.getUserInfo(), harHost, parentUri.getPort(), new Path(this.getArchiveDirOnly(parentDir, archiveName), dirInArchive).toUri().getPath(), parentUri.getQuery(), parentUri.getFragment());
        this.setIsArchived(p, true);
        this.setOriginalLocation(p, parentDir.toString());
        p.setLocation(harUri.toString());
    }

    private void setUnArchived(Partition p) {
        assert (this.isArchived(p));
        String parentDir = this.getOriginalLocation(p);
        this.setIsArchived(p, false);
        this.setOriginalLocation(p, null);
        assert (parentDir != null);
        p.setLocation(parentDir);
    }

    private boolean pathExists(Path p) throws HiveException {
        try {
            FileSystem fs = p.getFileSystem((Configuration)this.conf);
            return fs.exists(p);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private void moveDir(FileSystem fs, Path from, Path to) throws HiveException {
        try {
            if (!fs.rename(from, to)) {
                throw new HiveException("Moving " + from + " to " + to + " failed!");
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private void deleteDir(Path dir) throws HiveException {
        try {
            Warehouse wh = new Warehouse((Configuration)this.conf);
            wh.deleteDir(dir, true);
        }
        catch (MetaException e) {
            throw new HiveException(e);
        }
    }

    private int archive(Hive db, AlterTableSimpleDesc simpleDesc, DriverContext driverContext) throws HiveException {
        String dbName = simpleDesc.getDbName();
        String tblName = simpleDesc.getTableName();
        Table tbl = db.getTable(dbName, tblName);
        this.validateAlterTableType(tbl, AlterTableDesc.AlterTableTypes.ARCHIVE);
        LinkedHashMap<String, String> partSpec = simpleDesc.getPartSpec();
        Partition p = db.getPartition(tbl, partSpec, false);
        if (tbl.getTableType() != TableType.MANAGED_TABLE) {
            throw new HiveException("ARCHIVE can only be performed on managed tables");
        }
        if (p == null) {
            throw new HiveException("Specified partition does not exist");
        }
        if (this.isArchived(p)) {
            Path originalDir = new Path(this.getOriginalLocation(p));
            Path leftOverIntermediateOriginal = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ORIGINAL_DIR_SUFFIX);
            if (this.pathExists(leftOverIntermediateOriginal)) {
                this.console.printInfo("Deleting " + leftOverIntermediateOriginal + " left over from a previous archiving operation");
                this.deleteDir(leftOverIntermediateOriginal);
            }
            throw new HiveException("Specified partition is already archived");
        }
        Path originalDir = p.getPartitionPath();
        Path intermediateArchivedDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ARCHIVED_DIR_SUFFIX);
        Path intermediateOriginalDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ORIGINAL_DIR_SUFFIX);
        String archiveName = "data.har";
        FileSystem fs = null;
        try {
            fs = originalDir.getFileSystem((Configuration)this.conf);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        if (!this.pathExists(intermediateArchivedDir) && !this.pathExists(intermediateOriginalDir)) {
            Path tmpDir = new Path(driverContext.getCtx().getExternalTmpFileURI(originalDir.toUri()), "partlevel");
            this.console.printInfo("Creating " + archiveName + " for " + originalDir.toString());
            this.console.printInfo("in " + tmpDir);
            this.console.printInfo("Please wait... (this may take a while)");
            HadoopShims shim = ShimLoader.getHadoopShims();
            int ret = 0;
            try {
                ret = shim.createHadoopArchive(this.conf, originalDir, tmpDir, archiveName);
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
            if (ret != 0) {
                throw new HiveException("Error while creating HAR");
            }
            try {
                this.console.printInfo("Moving " + tmpDir + " to " + intermediateArchivedDir);
                if (this.pathExists(intermediateArchivedDir)) {
                    throw new HiveException("The intermediate archive directory already exists.");
                }
                fs.rename(tmpDir, intermediateArchivedDir);
            }
            catch (IOException e) {
                throw new HiveException("Error while moving tmp directory");
            }
        }
        if (this.pathExists(intermediateArchivedDir)) {
            this.console.printInfo("Intermediate archive directory " + intermediateArchivedDir + " already exists. Assuming it contains an archived version of the partition");
        }
        if (!this.pathExists(intermediateOriginalDir)) {
            this.console.printInfo("Moving " + originalDir + " to " + intermediateOriginalDir);
            this.moveDir(fs, originalDir, intermediateOriginalDir);
        } else {
            this.console.printInfo(intermediateOriginalDir + " already exists. " + "Assuming it contains the original files in the partition");
        }
        if (!this.pathExists(originalDir)) {
            this.console.printInfo("Moving " + intermediateArchivedDir + " to " + originalDir);
            this.moveDir(fs, intermediateArchivedDir, originalDir);
        } else {
            this.console.printInfo(originalDir + " already exists. " + "Assuming it contains the archived version of the partition");
        }
        try {
            boolean parentSettable = this.conf.getBoolVar(HiveConf.ConfVars.HIVEHARPARENTDIRSETTABLE);
            String dirInArchive = "";
            if (!parentSettable && (dirInArchive = originalDir.toUri().getPath()).length() > 1 && dirInArchive.charAt(0) == '/') {
                dirInArchive = dirInArchive.substring(1);
            }
            this.setArchived(p, originalDir, dirInArchive, archiveName);
            db.alterPartition(tblName, p);
        }
        catch (Exception e) {
            throw new HiveException("Unable to change the partition info for HAR", e);
        }
        this.deleteDir(intermediateOriginalDir);
        return 0;
    }

    private int unarchive(Hive db, AlterTableSimpleDesc simpleDesc) throws HiveException {
        String dbName = simpleDesc.getDbName();
        String tblName = simpleDesc.getTableName();
        Table tbl = db.getTable(dbName, tblName);
        this.validateAlterTableType(tbl, AlterTableDesc.AlterTableTypes.UNARCHIVE);
        if (simpleDesc.getPartSpec() == null) {
            throw new HiveException("ARCHIVE is for partitions only");
        }
        LinkedHashMap<String, String> partSpec = simpleDesc.getPartSpec();
        Partition p = db.getPartition(tbl, partSpec, false);
        if (tbl.getTableType() != TableType.MANAGED_TABLE) {
            throw new HiveException("UNARCHIVE can only be performed on managed tables");
        }
        if (p == null) {
            throw new HiveException("Specified partition does not exist");
        }
        if (!this.isArchived(p)) {
            Path location = new Path(p.getLocation());
            Path leftOverArchiveDir = new Path(location.getParent(), location.getName() + INTERMEDIATE_ARCHIVED_DIR_SUFFIX);
            if (this.pathExists(leftOverArchiveDir)) {
                this.console.printInfo("Deleting " + leftOverArchiveDir + " left over " + "from a previous unarchiving operation");
                this.deleteDir(leftOverArchiveDir);
            }
            throw new HiveException("Specified partition is not archived");
        }
        Path originalLocation = new Path(this.getOriginalLocation(p));
        Path sourceDir = new Path(p.getLocation());
        Path intermediateArchiveDir = new Path(originalLocation.getParent(), originalLocation.getName() + INTERMEDIATE_ARCHIVED_DIR_SUFFIX);
        Path intermediateExtractedDir = new Path(originalLocation.getParent(), originalLocation.getName() + INTERMEDIATE_EXTRACTED_DIR_SUFFIX);
        Path tmpDir = new Path(this.driverContext.getCtx().getExternalTmpFileURI(originalLocation.toUri()));
        FileSystem fs = null;
        try {
            fs = tmpDir.getFileSystem((Configuration)this.conf);
            FileStatus[] filesInTmpDir = fs.listStatus(tmpDir);
            if (filesInTmpDir != null && filesInTmpDir.length != 0) {
                for (FileStatus file : filesInTmpDir) {
                    this.console.printInfo(file.getPath().toString());
                }
                throw new HiveException("Temporary directory " + tmpDir + " is not empty");
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        if (originalLocation == null) {
            throw new HiveException("Missing archive data in the partition");
        }
        if (!"har".equals(sourceDir.toUri().getScheme())) {
            throw new HiveException("Location should refer to a HAR");
        }
        if (!this.pathExists(intermediateExtractedDir) && !this.pathExists(intermediateArchiveDir)) {
            try {
                String copySource = new Path(sourceDir, "*").toString();
                String copyDest = tmpDir.toString();
                ArrayList<String> args = new ArrayList<String>();
                args.add("-cp");
                args.add(copySource);
                args.add(copyDest);
                this.console.printInfo("Copying " + copySource + " to " + copyDest);
                FsShell fss = new FsShell((Configuration)this.conf);
                int ret = 0;
                try {
                    ret = ToolRunner.run((Tool)fss, (String[])args.toArray(new String[0]));
                }
                catch (Exception e) {
                    throw new HiveException(e);
                }
                if (ret != 0) {
                    throw new HiveException("Error while copying files from archive");
                }
                this.console.printInfo("Moving " + tmpDir + " to " + intermediateExtractedDir);
                if (fs.exists(intermediateExtractedDir)) {
                    throw new HiveException("Invalid state: the intermediate extracted directory already exists.");
                }
                fs.rename(tmpDir, intermediateExtractedDir);
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
        if (!this.pathExists(intermediateArchiveDir)) {
            try {
                this.console.printInfo("Moving " + originalLocation + " to " + intermediateArchiveDir);
                fs.rename(originalLocation, intermediateArchiveDir);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        } else {
            this.console.printInfo(intermediateArchiveDir + " already exists. " + "Assuming it contains the archived version of the partition");
        }
        if (!this.pathExists(originalLocation)) {
            try {
                this.console.printInfo("Moving " + intermediateExtractedDir + " to " + originalLocation);
                fs.rename(intermediateExtractedDir, originalLocation);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        } else {
            this.console.printInfo(originalLocation + " already exists. " + "Assuming it contains the extracted files in the partition");
        }
        this.setUnArchived(p);
        try {
            db.alterPartition(tblName, p);
        }
        catch (InvalidOperationException e) {
            throw new HiveException(e);
        }
        this.deleteDir(intermediateArchiveDir);
        return 0;
    }

    private void validateAlterTableType(Table tbl, AlterTableDesc.AlterTableTypes alterType) throws HiveException {
        this.validateAlterTableType(tbl, alterType, false);
    }

    private void validateAlterTableType(Table tbl, AlterTableDesc.AlterTableTypes alterType, boolean expectView) throws HiveException {
        block7: {
            block6: {
                if (!tbl.isView()) break block6;
                if (!expectView) {
                    throw new HiveException("Cannot alter a view with ALTER TABLE");
                }
                switch (alterType) {
                    case ADDPARTITION: 
                    case DROPPARTITION: 
                    case ADDPROPS: {
                        break block7;
                    }
                    default: {
                        throw new HiveException("Cannot use this form of ALTER on a view");
                    }
                }
            }
            if (expectView) {
                throw new HiveException("Cannot alter a base table with ALTER VIEW");
            }
        }
        if (tbl.isNonNative()) {
            throw new HiveException("Cannot use ALTER TABLE on a non-native table");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int msck(Hive db, MsckDesc msckDesc) {
        CheckResult result = new CheckResult();
        ArrayList<String> repairOutput = new ArrayList<String>();
        try {
            HiveMetaStoreChecker checker = new HiveMetaStoreChecker(db);
            Table t = db.newTable(msckDesc.getTableName());
            checker.checkMetastore(t.getDbName(), t.getTableName(), msckDesc.getPartSpecs(), result);
            if (!msckDesc.isRepairPartitions()) return 0;
            Table table = db.getTable(msckDesc.getTableName());
            Iterator<CheckResult.PartitionResult> i$ = result.getPartitionsNotInMs().iterator();
            while (i$.hasNext()) {
                CheckResult.PartitionResult part = i$.next();
                try {
                    db.createPartition(table, Warehouse.makeSpecFromName((String)part.getPartitionName()));
                    repairOutput.add("Repair: Added partition to metastore " + msckDesc.getTableName() + ':' + part.getPartitionName());
                }
                catch (Exception e) {
                    LOG.warn((Object)"Repair error, could not add partition to metastore: ", (Throwable)e);
                }
            }
            return 0;
        }
        catch (HiveException e) {
            LOG.warn((Object)"Failed to run metacheck: ", (Throwable)e);
            int n = 1;
            return n;
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to run metacheck: ", (Throwable)e);
            int n = 1;
            return n;
        }
        finally {
            BufferedWriter resultOut = null;
            try {
                Path resFile = new Path(msckDesc.getResFile());
                FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
                resultOut = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(resFile)));
                boolean firstWritten = false;
                firstWritten |= this.writeMsckResult(result.getTablesNotInMs(), "Tables not in metastore:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getTablesNotOnFs(), "Tables missing on filesystem:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getPartitionsNotInMs(), "Partitions not in metastore:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getPartitionsNotOnFs(), "Partitions missing from filesystem:", resultOut, firstWritten);
                for (String rout : repairOutput) {
                    if (firstWritten) {
                        resultOut.write(10);
                    } else {
                        firstWritten = true;
                    }
                    resultOut.write(rout);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Failed to save metacheck output: ", (Throwable)e);
                int fs = 1;
                return fs;
            }
            finally {
                if (resultOut != null) {
                    try {
                        resultOut.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"Failed to close output file: ", (Throwable)e);
                        return 1;
                    }
                }
            }
        }
    }

    private boolean writeMsckResult(List<? extends Object> result, String msg, Writer out, boolean wrote) throws IOException {
        if (!result.isEmpty()) {
            if (wrote) {
                out.write(10);
            }
            out.write(msg);
            for (Object object : result) {
                out.write(9);
                out.write(object.toString());
            }
            return true;
        }
        return false;
    }

    private int showPartitions(Hive db, ShowPartitionsDesc showParts) throws HiveException {
        String tabName = showParts.getTabName();
        Table tbl = null;
        List<String> parts = null;
        tbl = db.getTable(tabName);
        if (!tbl.isPartitioned()) {
            this.console.printError("Table " + tabName + " is not a partitioned table");
            return 1;
        }
        parts = showParts.getPartSpec() != null ? db.getPartitionNames(tbl.getDbName(), tbl.getTableName(), showParts.getPartSpec(), (short)-1) : db.getPartitionNames(tbl.getDbName(), tbl.getTableName(), (short)-1);
        try {
            Path resFile = new Path(showParts.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            Iterator<String> iterParts = parts.iterator();
            while (iterParts.hasNext()) {
                outStream.writeBytes(iterParts.next());
                outStream.write(10);
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("show partitions: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            throw new HiveException(e.toString());
        }
        catch (IOException e) {
            LOG.info((Object)("show partitions: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            throw new HiveException(e.toString());
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int showIndexes(Hive db, ShowIndexesDesc showIndexes) throws HiveException {
        String tableName = showIndexes.getTableName();
        Table tbl = null;
        List<Index> indexes = null;
        tbl = db.getTable(tableName);
        indexes = db.getIndexes(tbl.getDbName(), tbl.getTableName(), (short)-1);
        try {
            Path resFile = new Path(showIndexes.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            if (showIndexes.isFormatted()) {
                outStream.writeBytes(MetaDataFormatUtils.getIndexColumnsHeader());
                outStream.write(10);
                outStream.write(10);
            }
            for (Index index : indexes) {
                outStream.writeBytes(MetaDataFormatUtils.getAllColumnsInformation(index));
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("show indexes: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            throw new HiveException(e.toString());
        }
        catch (IOException e) {
            LOG.info((Object)("show indexes: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            throw new HiveException(e.toString());
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int showDatabases(Hive db, ShowDatabasesDesc showDatabasesDesc) throws HiveException {
        List<String> databases = null;
        if (showDatabasesDesc.getPattern() != null) {
            LOG.info((Object)("pattern: " + showDatabasesDesc.getPattern()));
            databases = db.getDatabasesByPattern(showDatabasesDesc.getPattern());
        } else {
            databases = db.getAllDatabases();
        }
        LOG.info((Object)("results : " + databases.size()));
        try {
            Path resFile = new Path(showDatabasesDesc.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            for (String database : databases) {
                outStream.writeBytes(database);
                outStream.write(10);
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)("show databases: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.warn((Object)("show databases: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int showTables(Hive db, ShowTablesDesc showTbls) throws HiveException {
        List<String> tbls = null;
        String dbName = showTbls.getDbName();
        if (!db.databaseExists(dbName)) {
            throw new HiveException("ERROR: The database " + dbName + " does not exist.");
        }
        if (showTbls.getPattern() != null) {
            LOG.info((Object)("pattern: " + showTbls.getPattern()));
            tbls = db.getTablesByPattern(dbName, showTbls.getPattern());
            LOG.info((Object)("results : " + tbls.size()));
        } else {
            tbls = db.getAllTables(dbName);
        }
        try {
            Path resFile = new Path(showTbls.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            TreeSet<String> sortedTbls = new TreeSet<String>(tbls);
            Iterator iterTbls = sortedTbls.iterator();
            while (iterTbls.hasNext()) {
                outStream.writeBytes((String)iterTbls.next());
                outStream.write(10);
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)("show table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.warn((Object)("show table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int showFunctions(ShowFunctionsDesc showFuncs) throws HiveException {
        Set<String> funcs = null;
        if (showFuncs.getPattern() != null) {
            LOG.info((Object)("pattern: " + showFuncs.getPattern()));
            funcs = FunctionRegistry.getFunctionNames(showFuncs.getPattern());
            LOG.info((Object)("results : " + funcs.size()));
        } else {
            funcs = FunctionRegistry.getFunctionNames();
        }
        try {
            Path resFile = new Path(showFuncs.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            TreeSet<String> sortedFuncs = new TreeSet<String>(funcs);
            Iterator iterFuncs = sortedFuncs.iterator();
            while (iterFuncs.hasNext()) {
                outStream.writeBytes((String)iterFuncs.next());
                outStream.write(10);
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)("show function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.warn((Object)("show function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int showLocks(ShowLocksDesc showLocks) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveLockManager lockMgr = ctx.getHiveLockMgr();
        boolean isExt = showLocks.isExt();
        if (lockMgr == null) {
            throw new HiveException("show Locks LockManager not specified");
        }
        try {
            Path resFile = new Path(showLocks.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            List<HiveLock> locks = null;
            locks = showLocks.getTableName() == null ? lockMgr.getLocks(false, isExt) : lockMgr.getLocks(this.getHiveObject(showLocks.getTableName(), showLocks.getPartSpec()), true, isExt);
            Collections.sort(locks, new Comparator<HiveLock>(){

                @Override
                public int compare(HiveLock o1, HiveLock o2) {
                    int cmp = o1.getHiveLockObject().getName().compareTo(o2.getHiveLockObject().getName());
                    if (cmp == 0) {
                        if (o1.getHiveLockMode() == o2.getHiveLockMode()) {
                            return cmp;
                        }
                        if (o1.getHiveLockMode() == HiveLockMode.EXCLUSIVE) {
                            return -1;
                        }
                        return 1;
                    }
                    return cmp;
                }
            });
            for (HiveLock lock : locks) {
                outStream.writeBytes(lock.getHiveLockObject().getDisplayName());
                outStream.write(9);
                outStream.writeBytes(lock.getHiveLockMode().toString());
                if (isExt) {
                    outStream.write(10);
                    HiveLockObject.HiveLockObjectData lockData = lock.getHiveLockObject().getData();
                    if (lockData != null) {
                        outStream.writeBytes("LOCK_QUERYID:" + lockData.getQueryId() + " ");
                        outStream.writeBytes("LOCK_TIME:" + lockData.getLockTime() + " ");
                        outStream.writeBytes("LOCK_MODE:" + lockData.getLockMode() + " ");
                    }
                }
                outStream.write(10);
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)("show function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.warn((Object)("show function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int lockTable(LockTableDesc lockTbl) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveLockManager lockMgr = ctx.getHiveLockMgr();
        if (lockMgr == null) {
            throw new HiveException("lock Table LockManager not specified");
        }
        HiveLockMode mode = HiveLockMode.valueOf(lockTbl.getMode());
        String tabName = lockTbl.getTableName();
        Table tbl = this.db.getTable("default", tabName);
        if (tbl == null) {
            throw new HiveException("Table " + tabName + " does not exist ");
        }
        Map<String, String> partSpec = lockTbl.getPartSpec();
        HiveLockObject.HiveLockObjectData lockData = new HiveLockObject.HiveLockObjectData(lockTbl.getQueryId(), String.valueOf(System.currentTimeMillis()), "EXPLICIT");
        if (partSpec == null) {
            HiveLock lck = lockMgr.lock(new HiveLockObject(tbl, lockData), mode, true, 0, 0);
            if (lck == null) {
                return 1;
            }
            return 0;
        }
        Partition par = this.db.getPartition(tbl, partSpec, false);
        if (par == null) {
            throw new HiveException("Partition " + partSpec + " for table " + tabName + " does not exist");
        }
        HiveLock lck = lockMgr.lock(new HiveLockObject(par, lockData), mode, true, 0, 0);
        if (lck == null) {
            return 1;
        }
        return 0;
    }

    private HiveLockObject getHiveObject(String tabName, Map<String, String> partSpec) throws HiveException {
        Table tbl = this.db.getTable(tabName);
        if (tbl == null) {
            throw new HiveException("Table " + tabName + " does not exist ");
        }
        HiveLockObject obj = null;
        if (partSpec == null) {
            obj = new HiveLockObject(tbl, null);
        } else {
            Partition par = this.db.getPartition(tbl, partSpec, false);
            if (par == null) {
                throw new HiveException("Partition " + partSpec + " for table " + tabName + " does not exist");
            }
            obj = new HiveLockObject(par, null);
        }
        return obj;
    }

    private int unlockTable(UnlockTableDesc unlockTbl) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveLockManager lockMgr = ctx.getHiveLockMgr();
        if (lockMgr == null) {
            throw new HiveException("unlock Table LockManager not specified");
        }
        String tabName = unlockTbl.getTableName();
        HiveLockObject obj = this.getHiveObject(tabName, unlockTbl.getPartSpec());
        List<HiveLock> locks = lockMgr.getLocks(obj, false, false);
        if (locks == null || locks.isEmpty()) {
            throw new HiveException("Table " + tabName + " is not locked ");
        }
        for (HiveLock lock : locks) {
            lockMgr.unlock(lock);
        }
        return 0;
    }

    private int describeFunction(DescFunctionDesc descFunc) throws HiveException {
        String funcName = descFunc.getName();
        try {
            Path resFile = new Path(descFunc.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            Description desc = null;
            Class<?> funcClass = null;
            FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo(funcName);
            if (functionInfo != null) {
                funcClass = functionInfo.getFunctionClass();
            }
            if (funcClass != null) {
                desc = funcClass.getAnnotation(Description.class);
            }
            if (desc != null) {
                outStream.writeBytes(desc.value().replace("_FUNC_", funcName));
                if (descFunc.isExtended()) {
                    Set<String> synonyms = FunctionRegistry.getFunctionSynonyms(funcName);
                    if (synonyms.size() > 0) {
                        outStream.writeBytes("\nSynonyms: " + StringUtils.join(synonyms, ", "));
                    }
                    if (desc.extended().length() > 0) {
                        outStream.writeBytes("\n" + desc.extended().replace("_FUNC_", funcName));
                    }
                }
            } else if (funcClass != null) {
                outStream.writeBytes("There is no documentation for function '" + funcName + "'");
            } else {
                outStream.writeBytes("Function '" + funcName + "' does not exist.");
            }
            outStream.write(10);
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)("describe function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.warn((Object)("describe function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int descDatabase(DescDatabaseDesc descDatabase) throws HiveException {
        try {
            Path resFile = new Path(descDatabase.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            Database database = this.db.getDatabase(descDatabase.getDatabaseName());
            if (database != null) {
                outStream.writeBytes(database.getName());
                outStream.write(9);
                if (database.getDescription() != null) {
                    outStream.writeBytes(database.getDescription());
                }
                outStream.write(9);
                if (database.getLocationUri() != null) {
                    outStream.writeBytes(database.getLocationUri());
                }
                outStream.write(9);
                if (descDatabase.isExt() && database.getParametersSize() > 0) {
                    Map params = database.getParameters();
                    outStream.writeBytes(params.toString());
                }
            } else {
                outStream.writeBytes("No such database: " + descDatabase.getDatabaseName());
            }
            outStream.write(10);
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)("describe database: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.warn((Object)("describe database: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int showTableStatus(Hive db, ShowTableStatusDesc showTblStatus) throws HiveException {
        ArrayList<Table> tbls = new ArrayList<Table>();
        HashMap<String, String> part = showTblStatus.getPartSpec();
        Partition par = null;
        if (part != null) {
            Table tbl = db.getTable(showTblStatus.getDbName(), showTblStatus.getPattern());
            par = db.getPartition(tbl, part, false);
            if (par == null) {
                throw new HiveException("Partition " + part + " for table " + showTblStatus.getPattern() + " does not exist.");
            }
            tbls.add(tbl);
        } else {
            LOG.info((Object)("pattern: " + showTblStatus.getPattern()));
            List<String> tblStr = db.getTablesForDb(showTblStatus.getDbName(), showTblStatus.getPattern());
            TreeSet<String> sortedTbls = new TreeSet<String>(tblStr);
            for (String tblName : sortedTbls) {
                Table tbl = db.getTable(showTblStatus.getDbName(), tblName);
                tbls.add(tbl);
            }
            LOG.info((Object)("results : " + tblStr.size()));
        }
        try {
            Path resFile = new Path(showTblStatus.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            for (Table tbl : tbls) {
                String tableName = tbl.getTableName();
                String tblLoc = null;
                String inputFormattCls = null;
                String outputFormattCls = null;
                if (part != null) {
                    if (par != null) {
                        if (par.getLocation() != null) {
                            tblLoc = par.getDataLocation().toString();
                        }
                        inputFormattCls = par.getInputFormatClass().getName();
                        outputFormattCls = par.getOutputFormatClass().getName();
                    }
                } else {
                    if (tbl.getPath() != null) {
                        tblLoc = tbl.getDataLocation().toString();
                    }
                    inputFormattCls = tbl.getInputFormatClass().getName();
                    outputFormattCls = tbl.getOutputFormatClass().getName();
                }
                String owner = tbl.getOwner();
                List<FieldSchema> cols = tbl.getCols();
                String ddlCols = MetaStoreUtils.getDDLFromFieldSchema((String)"columns", cols);
                boolean isPartitioned = tbl.isPartitioned();
                String partitionCols = "";
                if (isPartitioned) {
                    partitionCols = MetaStoreUtils.getDDLFromFieldSchema((String)"partition_columns", tbl.getPartCols());
                }
                outStream.writeBytes("tableName:" + tableName);
                outStream.write(10);
                outStream.writeBytes("owner:" + owner);
                outStream.write(10);
                outStream.writeBytes("location:" + tblLoc);
                outStream.write(10);
                outStream.writeBytes("inputformat:" + inputFormattCls);
                outStream.write(10);
                outStream.writeBytes("outputformat:" + outputFormattCls);
                outStream.write(10);
                outStream.writeBytes("columns:" + ddlCols);
                outStream.write(10);
                outStream.writeBytes("partitioned:" + isPartitioned);
                outStream.write(10);
                outStream.writeBytes("partitionColumns:" + partitionCols);
                outStream.write(10);
                Path tablLoc = tbl.getPath();
                ArrayList<Path> locations = new ArrayList<Path>();
                if (isPartitioned) {
                    if (par == null) {
                        for (Partition curPart : db.getPartitions(tbl)) {
                            if (curPart.getLocation() == null) continue;
                            locations.add(new Path(curPart.getLocation()));
                        }
                    } else if (par.getLocation() != null) {
                        locations.add(new Path(par.getLocation()));
                    }
                } else if (tablLoc != null) {
                    locations.add(tablLoc);
                }
                if (!locations.isEmpty()) {
                    this.writeFileSystemStats((DataOutput)outStream, locations, tablLoc, false, 0);
                }
                outStream.write(10);
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("show table status: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.info((Object)("show table status: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return 0;
    }

    private int describeTable(Hive db, DescTableDesc descTbl) throws HiveException {
        Path resFile;
        String colPath;
        String tableName = colPath.substring(0, (colPath = descTbl.getTableName()).indexOf(46) == -1 ? colPath.length() : colPath.indexOf(46));
        Table tbl = db.getTable(tableName, false);
        Partition part = null;
        try {
            resFile = new Path(descTbl.getResFile());
            if (tbl == null) {
                FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
                DataOutput outStream = (DataOutput)fs.open(resFile);
                String errMsg = "Table " + tableName + " does not exist";
                outStream.write(errMsg.getBytes("UTF-8"));
                ((FSDataOutputStream)outStream).close();
                return 0;
            }
            if (descTbl.getPartSpec() != null) {
                part = db.getPartition(tbl, descTbl.getPartSpec(), false);
                if (part == null) {
                    FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
                    DataOutput outStream = (DataOutput)fs.open(resFile);
                    String errMsg = "Partition " + descTbl.getPartSpec() + " for table " + tableName + " does not exist";
                    outStream.write(errMsg.getBytes("UTF-8"));
                    ((FSDataOutputStream)outStream).close();
                    return 0;
                }
                tbl = part.getTable();
            }
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("describe table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.info((Object)("describe table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        try {
            LOG.info((Object)("DDLTask: got data for " + tbl.getTableName()));
            resFile = new Path(descTbl.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            if (colPath.equals(tableName)) {
                if (!descTbl.isFormatted()) {
                    List<FieldSchema> cols = tbl.getCols();
                    if (tableName.equals(colPath)) {
                        cols.addAll(tbl.getPartCols());
                    }
                    outStream.writeBytes(MetaDataFormatUtils.displayColsUnformatted(cols));
                } else {
                    outStream.writeBytes(MetaDataFormatUtils.getAllColumnsInformation(tbl));
                }
            } else {
                List<FieldSchema> cols = Hive.getFieldsFromDeserializer(colPath, tbl.getDeserializer());
                if (descTbl.isFormatted()) {
                    outStream.writeBytes(MetaDataFormatUtils.getAllColumnsInformation(cols));
                } else {
                    outStream.writeBytes(MetaDataFormatUtils.displayColsUnformatted(cols));
                }
            }
            if (tableName.equals(colPath)) {
                if (descTbl.isFormatted()) {
                    if (part != null) {
                        outStream.writeBytes(MetaDataFormatUtils.getPartitionInformation(part));
                    } else {
                        outStream.writeBytes(MetaDataFormatUtils.getTableInformation(tbl));
                    }
                }
                if (descTbl.isExt()) {
                    outStream.write(10);
                    if (part != null) {
                        outStream.writeBytes("Detailed Partition Information");
                        outStream.write(9);
                        outStream.writeBytes(part.getTPartition().toString());
                        outStream.write(9);
                        outStream.write(10);
                    } else {
                        outStream.writeBytes("Detailed Table Information");
                        outStream.write(9);
                        outStream.writeBytes(tbl.getTTable().toString());
                        outStream.write(9);
                        outStream.write(10);
                    }
                }
            }
            LOG.info((Object)("DDLTask: written data for " + tbl.getTableName()));
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("describe table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.info((Object)("describe table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return 0;
    }

    public static void writeGrantInfo(DataOutput outStream, PrincipalType principalType, String principalName, String dbName, String tableName, String partName, String columnName, PrivilegeGrantInfo grantInfo) throws IOException {
        String privilege = grantInfo.getPrivilege();
        int createTime = grantInfo.getCreateTime();
        String grantor = grantInfo.getGrantor();
        if (dbName != null) {
            DDLTask.writeKeyValuePair(outStream, "database", dbName);
        }
        if (tableName != null) {
            DDLTask.writeKeyValuePair(outStream, "table", tableName);
        }
        if (partName != null) {
            DDLTask.writeKeyValuePair(outStream, "partition", partName);
        }
        if (columnName != null) {
            DDLTask.writeKeyValuePair(outStream, "columnName", columnName);
        }
        DDLTask.writeKeyValuePair(outStream, "principalName", principalName);
        DDLTask.writeKeyValuePair(outStream, "principalType", "" + principalType);
        DDLTask.writeKeyValuePair(outStream, "privilege", privilege);
        DDLTask.writeKeyValuePair(outStream, "grantTime", "" + createTime);
        if (grantor != null) {
            DDLTask.writeKeyValuePair(outStream, "grantor", grantor);
        }
    }

    private static void writeKeyValuePair(DataOutput outStream, String key, String value) throws IOException {
        outStream.write(10);
        outStream.writeBytes(key);
        outStream.write(9);
        outStream.writeBytes(value);
        outStream.write(9);
    }

    private void writeFileSystemStats(DataOutput outStream, List<Path> locations, Path tabLoc, boolean partSpecified, int indent) throws IOException {
        int k;
        long totalFileSize = 0L;
        long maxFileSize = 0L;
        long minFileSize = Long.MAX_VALUE;
        long lastAccessTime = 0L;
        long lastUpdateTime = 0L;
        int numOfFiles = 0;
        boolean unknown = false;
        FileSystem fs = tabLoc.getFileSystem((Configuration)this.conf);
        try {
            FileStatus tmpStatus = fs.getFileStatus(tabLoc);
            lastAccessTime = ShimLoader.getHadoopShims().getAccessTime(tmpStatus);
            lastUpdateTime = tmpStatus.getModificationTime();
            if (partSpecified) {
                tmpStatus = fs.getFileStatus(locations.get(0));
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Cannot access File System. File System status will be unknown: ", (Throwable)e);
            unknown = true;
        }
        if (!unknown) {
            for (Path loc : locations) {
                try {
                    FileStatus status = fs.getFileStatus(tabLoc);
                    FileStatus[] files = fs.listStatus(loc);
                    long accessTime = ShimLoader.getHadoopShims().getAccessTime(status);
                    long updateTime = status.getModificationTime();
                    if (!status.isDir()) continue;
                    if (accessTime > lastAccessTime) {
                        lastAccessTime = accessTime;
                    }
                    if (updateTime > lastUpdateTime) {
                        lastUpdateTime = updateTime;
                    }
                    for (FileStatus currentStatus : files) {
                        if (currentStatus.isDir()) continue;
                        ++numOfFiles;
                        long fileLen = currentStatus.getLen();
                        totalFileSize += fileLen;
                        if (fileLen > maxFileSize) {
                            maxFileSize = fileLen;
                        }
                        if (fileLen < minFileSize) {
                            minFileSize = fileLen;
                        }
                        accessTime = ShimLoader.getHadoopShims().getAccessTime(currentStatus);
                        updateTime = currentStatus.getModificationTime();
                        if (accessTime > lastAccessTime) {
                            lastAccessTime = accessTime;
                        }
                        if (updateTime <= lastUpdateTime) continue;
                        lastUpdateTime = updateTime;
                    }
                }
                catch (IOException e) {
                }
            }
        }
        String unknownString = "unknown";
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("totalNumberFiles:");
        outStream.writeBytes(unknown ? unknownString : "" + numOfFiles);
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("totalFileSize:");
        outStream.writeBytes(unknown ? unknownString : "" + totalFileSize);
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("maxFileSize:");
        outStream.writeBytes(unknown ? unknownString : "" + maxFileSize);
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("minFileSize:");
        if (numOfFiles > 0) {
            outStream.writeBytes(unknown ? unknownString : "" + minFileSize);
        } else {
            outStream.writeBytes(unknown ? unknownString : "0");
        }
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("lastAccessTime:");
        outStream.writeBytes(unknown || lastAccessTime < 0L ? unknownString : "" + lastAccessTime);
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("lastUpdateTime:");
        outStream.writeBytes(unknown ? unknownString : "" + lastUpdateTime);
        outStream.write(10);
    }

    private int alterTable(Hive db, AlterTableDesc alterTbl) throws HiveException {
        Table tbl = db.getTable(alterTbl.getOldName());
        Partition part = null;
        if (alterTbl.getPartSpec() != null && (part = db.getPartition(tbl, alterTbl.getPartSpec(), false)) == null) {
            this.console.printError("Partition : " + alterTbl.getPartSpec().toString() + " does not exist.");
            return 1;
        }
        this.validateAlterTableType(tbl, alterTbl.getOp(), alterTbl.getExpectView());
        Table oldTbl = tbl.copy();
        if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.RENAME) {
            tbl.setTableName(alterTbl.getNewName());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDCOLS) {
            ArrayList<FieldSchema> newCols = alterTbl.getNewCols();
            List<FieldSchema> oldCols = tbl.getCols();
            if (tbl.getSerializationLib().equals("org.apache.hadoop.hive.serde.thrift.columnsetSerDe")) {
                this.console.printInfo("Replacing columns for columnsetSerDe and changing to LazySimpleSerDe");
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
                tbl.getTTable().getSd().setCols(newCols);
            } else {
                for (FieldSchema newCol : newCols) {
                    String newColName = newCol.getName();
                    Iterator<FieldSchema> iterOldCols = oldCols.iterator();
                    while (iterOldCols.hasNext()) {
                        String oldColName = iterOldCols.next().getName();
                        if (!oldColName.equalsIgnoreCase(newColName)) continue;
                        this.console.printError("Column '" + newColName + "' exists");
                        return 1;
                    }
                    oldCols.add(newCol);
                }
                tbl.getTTable().getSd().setCols(oldCols);
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.RENAMECOLUMN) {
            List<FieldSchema> oldCols = tbl.getCols();
            ArrayList<FieldSchema> newCols = new ArrayList<FieldSchema>();
            Iterator<FieldSchema> iterOldCols = oldCols.iterator();
            String oldName = alterTbl.getOldColName();
            String newName = alterTbl.getNewColName();
            String type = alterTbl.getNewColType();
            String comment = alterTbl.getNewColComment();
            boolean first = alterTbl.getFirst();
            String afterCol = alterTbl.getAfterCol();
            FieldSchema column = null;
            boolean found = false;
            int position = -1;
            if (first) {
                position = 0;
            }
            int i = 1;
            while (iterOldCols.hasNext()) {
                FieldSchema col = iterOldCols.next();
                String oldColName = col.getName();
                if (oldColName.equalsIgnoreCase(newName) && !oldColName.equalsIgnoreCase(oldName)) {
                    this.console.printError("Column '" + newName + "' exists");
                    return 1;
                }
                if (oldColName.equalsIgnoreCase(oldName)) {
                    col.setName(newName);
                    if (type != null && !type.trim().equals("")) {
                        col.setType(type);
                    }
                    if (comment != null) {
                        col.setComment(comment);
                    }
                    found = true;
                    if (first || afterCol != null && !afterCol.trim().equals("")) {
                        column = col;
                        continue;
                    }
                }
                if (afterCol != null && !afterCol.trim().equals("") && oldColName.equalsIgnoreCase(afterCol)) {
                    position = i;
                }
                ++i;
                newCols.add(col);
            }
            if (!found) {
                this.console.printError("Column '" + oldName + "' does not exist");
                return 1;
            }
            if (afterCol != null && !afterCol.trim().equals("") && position < 0) {
                this.console.printError("Column '" + afterCol + "' does not exist");
                return 1;
            }
            if (position >= 0) {
                newCols.add(position, column);
            }
            tbl.getTTable().getSd().setCols(newCols);
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.REPLACECOLS) {
            if (tbl.getSerializationLib().equals("org.apache.hadoop.hive.serde.thrift.columnsetSerDe")) {
                this.console.printInfo("Replacing columns for columnsetSerDe and changing to LazySimpleSerDe");
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
            } else if (!(tbl.getSerializationLib().equals(MetadataTypedColumnsetSerDe.class.getName()) || tbl.getSerializationLib().equals(LazySimpleSerDe.class.getName()) || tbl.getSerializationLib().equals(ColumnarSerDe.class.getName()) || tbl.getSerializationLib().equals(DynamicSerDe.class.getName()))) {
                this.console.printError("Replace columns is not supported for this table. SerDe may be incompatible.");
                return 1;
            }
            tbl.getTTable().getSd().setCols(alterTbl.getNewCols());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDPROPS) {
            tbl.getTTable().getParameters().putAll(alterTbl.getProps());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDSERDEPROPS) {
            tbl.getTTable().getSd().getSerdeInfo().getParameters().putAll(alterTbl.getProps());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDSERDE) {
            tbl.setSerializationLib(alterTbl.getSerdeName());
            if (alterTbl.getProps() != null && alterTbl.getProps().size() > 0) {
                tbl.getTTable().getSd().getSerdeInfo().getParameters().putAll(alterTbl.getProps());
            }
            tbl.setFields(Hive.getFieldsFromDeserializer(tbl.getTableName(), tbl.getDeserializer()));
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDFILEFORMAT) {
            if (part != null) {
                part.getTPartition().getSd().setInputFormat(alterTbl.getInputFormat());
                part.getTPartition().getSd().setOutputFormat(alterTbl.getOutputFormat());
                if (alterTbl.getSerdeName() != null) {
                    part.getTPartition().getSd().getSerdeInfo().setSerializationLib(alterTbl.getSerdeName());
                }
            } else {
                tbl.getTTable().getSd().setInputFormat(alterTbl.getInputFormat());
                tbl.getTTable().getSd().setOutputFormat(alterTbl.getOutputFormat());
                if (alterTbl.getSerdeName() != null) {
                    tbl.setSerializationLib(alterTbl.getSerdeName());
                }
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ALTERPROTECTMODE) {
            boolean protectModeEnable = alterTbl.isProtectModeEnable();
            AlterTableDesc.ProtectModeType protectMode = alterTbl.getProtectModeType();
            ProtectMode mode = null;
            mode = part != null ? part.getProtectMode() : tbl.getProtectMode();
            if (protectModeEnable && protectMode == AlterTableDesc.ProtectModeType.OFFLINE) {
                mode.offline = true;
            } else if (protectModeEnable && protectMode == AlterTableDesc.ProtectModeType.NO_DROP) {
                mode.noDrop = true;
            } else if (!protectModeEnable && protectMode == AlterTableDesc.ProtectModeType.OFFLINE) {
                mode.offline = false;
            } else if (!protectModeEnable && protectMode == AlterTableDesc.ProtectModeType.NO_DROP) {
                mode.noDrop = false;
            }
            if (part != null) {
                part.setProtectMode(mode);
            } else {
                tbl.setProtectMode(mode);
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDCLUSTERSORTCOLUMN) {
            List<String> columns = Utilities.getColumnNamesFromFieldSchema(tbl.getCols());
            Utilities.validateColumnNames(columns, alterTbl.getBucketColumns());
            if (alterTbl.getSortColumns() != null) {
                Utilities.validateColumnNames(columns, Utilities.getColumnNamesFromSortCols(alterTbl.getSortColumns()));
            }
            int numBuckets = -1;
            ArrayList<String> bucketCols = null;
            ArrayList<Object> sortCols = null;
            if (alterTbl.getNumberBuckets() == -1) {
                bucketCols = new ArrayList();
                sortCols = new ArrayList();
                numBuckets = -1;
            } else {
                bucketCols = alterTbl.getBucketColumns();
                sortCols = alterTbl.getSortColumns();
                numBuckets = alterTbl.getNumberBuckets();
            }
            tbl.getTTable().getSd().setBucketCols(bucketCols);
            tbl.getTTable().getSd().setNumBuckets(numBuckets);
            tbl.getTTable().getSd().setSortCols(sortCols);
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ALTERLOCATION) {
            String newLocation = alterTbl.getNewLocation();
            try {
                URI locURI = new URI(newLocation);
                if (!locURI.isAbsolute() || locURI.getScheme() == null || locURI.getScheme().trim().equals("")) {
                    throw new HiveException(newLocation + " is not absolute or has no scheme information. " + "Please specify a complete absolute uri with scheme information.");
                }
                if (part != null) {
                    part.setLocation(newLocation);
                }
                tbl.setDataLocation(locURI);
            }
            catch (URISyntaxException e) {
                throw new HiveException(e);
            }
        } else {
            this.console.printError("Unsupported Alter commnad");
            return 1;
        }
        if (part == null) {
            if (!this.updateModifiedParameters(tbl.getTTable().getParameters(), this.conf)) {
                return 1;
            }
            try {
                tbl.checkValidity();
            }
            catch (HiveException e) {
                this.console.printError("Invalid table columns : " + e.getMessage(), org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                return 1;
            }
        } else if (!this.updateModifiedParameters(part.getParameters(), this.conf)) {
            return 1;
        }
        try {
            if (part == null) {
                db.alterTable(alterTbl.getOldName(), tbl);
            } else {
                db.alterPartition(tbl.getTableName(), part);
            }
        }
        catch (InvalidOperationException e) {
            this.console.printError("Invalid alter operation: " + e.getMessage());
            LOG.info((Object)("alter table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (HiveException e) {
            return 1;
        }
        if (part != null) {
            ((DDLWork)this.work).getInputs().add(new ReadEntity(part));
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(part));
        } else {
            ((DDLWork)this.work).getInputs().add(new ReadEntity(oldTbl));
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        }
        return 0;
    }

    private int dropTable(Hive db, DropTableDesc dropTbl) throws HiveException {
        Table tbl = null;
        try {
            tbl = db.getTable(dropTbl.getTableName());
        }
        catch (InvalidTableException e) {
            // empty catch block
        }
        if (dropTbl.getPartSpecs() == null) {
            if (tbl != null) {
                if (tbl.isView()) {
                    if (!dropTbl.getExpectView()) {
                        throw new HiveException("Cannot drop a view with DROP TABLE");
                    }
                } else if (dropTbl.getExpectView()) {
                    throw new HiveException("Cannot drop a base table with DROP VIEW");
                }
            }
            if (tbl != null && !tbl.canDrop()) {
                throw new HiveException("Table " + tbl.getTableName() + " is protected from being dropped");
            }
            if (tbl != null && tbl.isPartitioned()) {
                List<Partition> listPartitions = db.getPartitions(tbl);
                for (Partition p : listPartitions) {
                    if (p.canDrop()) continue;
                    throw new HiveException("Table " + tbl.getTableName() + " Partition" + p.getName() + " is protected from being dropped");
                }
            }
            db.dropTable(dropTbl.getTableName());
            if (tbl != null) {
                ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
            }
        } else {
            if (tbl != null) {
                this.validateAlterTableType(tbl, AlterTableDesc.AlterTableTypes.DROPPARTITION, dropTbl.getExpectView());
            }
            List<String> partitionNames = db.getPartitionNames(dropTbl.getTableName(), (short)-1);
            HashSet<LinkedHashMap> partitions = new HashSet<LinkedHashMap>();
            for (String partitionName : partitionNames) {
                try {
                    partitions.add(Warehouse.makeSpecFromName((String)partitionName));
                }
                catch (MetaException e) {
                    LOG.warn((Object)("Unrecognized partition name from metastore: " + partitionName));
                }
            }
            ArrayList<Partition> partsToDelete = new ArrayList<Partition>();
            for (LinkedHashMap<String, String> partSpec : dropTbl.getPartSpecs()) {
                Iterator it = partitions.iterator();
                while (it.hasNext()) {
                    Map part = (Map)it.next();
                    boolean match = true;
                    for (Map.Entry item : partSpec.entrySet()) {
                        if (((String)item.getValue()).equals(part.get(item.getKey()))) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    Partition p = db.getPartition(tbl, part, false);
                    if (!p.canDrop()) {
                        throw new HiveException("Table " + tbl.getTableName() + " Partition " + p.getName() + " is protected from being dropped");
                    }
                    partsToDelete.add(p);
                    it.remove();
                }
            }
            for (Partition partition : partsToDelete) {
                this.console.printInfo("Dropping the partition " + partition.getName());
                db.dropPartition(dropTbl.getTableName(), partition.getValues(), true);
                ((DDLWork)this.work).getOutputs().add(new WriteEntity(partition));
            }
        }
        return 0;
    }

    private boolean updateModifiedParameters(Map<String, String> params, HiveConf conf) {
        String user = null;
        try {
            user = conf.getUser();
        }
        catch (IOException e) {
            this.console.printError("Unable to get current user: " + e.getMessage(), org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return false;
        }
        params.put("last_modified_by", user);
        params.put("last_modified_time", Long.toString(System.currentTimeMillis() / 1000L));
        return true;
    }

    private void validateSerDe(String serdeName) throws HiveException {
        try {
            Deserializer d = SerDeUtils.lookupDeserializer(serdeName);
            if (d != null) {
                LOG.debug((Object)("Found class for " + serdeName));
            }
        }
        catch (SerDeException e) {
            throw new HiveException("Cannot validate serde: " + serdeName, e);
        }
    }

    private int createDatabase(Hive db, CreateDatabaseDesc crtDb) throws HiveException, AlreadyExistsException {
        Database database = new Database();
        database.setName(crtDb.getName());
        database.setDescription(crtDb.getComment());
        database.setLocationUri(crtDb.getLocationUri());
        database.setParameters(crtDb.getDatabaseProperties());
        db.createDatabase(database, crtDb.getIfNotExists());
        return 0;
    }

    private int dropDatabase(Hive db, DropDatabaseDesc dropDb) throws HiveException, NoSuchObjectException {
        db.dropDatabase(dropDb.getDatabaseName(), true, dropDb.getIfExists());
        return 0;
    }

    private int switchDatabase(Hive db, SwitchDatabaseDesc switchDb) throws HiveException {
        String dbName = switchDb.getDatabaseName();
        if (!db.databaseExists(dbName)) {
            throw new HiveException("ERROR: The database " + dbName + " does not exist.");
        }
        db.setCurrentDatabase(dbName);
        Database database = db.getDatabase(dbName);
        assert (database != null);
        Map dbParams = database.getParameters();
        if (dbParams != null) {
            for (HiveConf.ConfVars var : HiveConf.dbVars) {
                String newValue = (String)dbParams.get(var.varname);
                if (newValue == null) continue;
                LOG.info((Object)("Changing " + var.varname + " from " + this.conf.getVar(var) + " to " + newValue));
                this.conf.setVar(var, newValue);
            }
        }
        return 0;
    }

    private int createTable(Hive db, CreateTableDesc crtTbl) throws HiveException {
        int rc;
        Table tbl = db.newTable(crtTbl.getTableName());
        if (crtTbl.getTblProps() != null) {
            tbl.getTTable().getParameters().putAll(crtTbl.getTblProps());
        }
        if (crtTbl.getPartCols() != null) {
            tbl.setPartCols(crtTbl.getPartCols());
        }
        if (crtTbl.getNumBuckets() != -1) {
            tbl.setNumBuckets(crtTbl.getNumBuckets());
        }
        if (crtTbl.getStorageHandler() != null) {
            tbl.setProperty("storage_handler", crtTbl.getStorageHandler());
        }
        HiveStorageHandler storageHandler = tbl.getStorageHandler();
        if (crtTbl.getSerName() == null) {
            if (storageHandler == null) {
                LOG.info((Object)("Default to LazySimpleSerDe for table " + crtTbl.getTableName()));
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
            } else {
                String serDeClassName = storageHandler.getSerDeClass().getName();
                LOG.info((Object)("Use StorageHandler-supplied " + serDeClassName + " for table " + crtTbl.getTableName()));
                tbl.setSerializationLib(serDeClassName);
            }
        } else {
            this.validateSerDe(crtTbl.getSerName());
            tbl.setSerializationLib(crtTbl.getSerName());
        }
        if (crtTbl.getFieldDelim() != null) {
            tbl.setSerdeParam("field.delim", crtTbl.getFieldDelim());
            tbl.setSerdeParam("serialization.format", crtTbl.getFieldDelim());
        }
        if (crtTbl.getFieldEscape() != null) {
            tbl.setSerdeParam("escape.delim", crtTbl.getFieldEscape());
        }
        if (crtTbl.getCollItemDelim() != null) {
            tbl.setSerdeParam("colelction.delim", crtTbl.getCollItemDelim());
        }
        if (crtTbl.getMapKeyDelim() != null) {
            tbl.setSerdeParam("mapkey.delim", crtTbl.getMapKeyDelim());
        }
        if (crtTbl.getLineDelim() != null) {
            tbl.setSerdeParam("line.delim", crtTbl.getLineDelim());
        }
        if (crtTbl.getSerdeProps() != null) {
            for (Map.Entry<String, String> m : crtTbl.getSerdeProps().entrySet()) {
                tbl.setSerdeParam(m.getKey(), m.getValue());
            }
        }
        if (crtTbl.getCols() != null) {
            tbl.setFields(crtTbl.getCols());
        }
        if (crtTbl.getBucketCols() != null) {
            tbl.setBucketCols(crtTbl.getBucketCols());
        }
        if (crtTbl.getSortCols() != null) {
            tbl.setSortCols(crtTbl.getSortCols());
        }
        if (crtTbl.getComment() != null) {
            tbl.setProperty("comment", crtTbl.getComment());
        }
        if (crtTbl.getLocation() != null) {
            tbl.setDataLocation(new Path(crtTbl.getLocation()).toUri());
        }
        tbl.setInputFormatClass(crtTbl.getInputFormat());
        tbl.setOutputFormatClass(crtTbl.getOutputFormat());
        tbl.getTTable().getSd().setInputFormat(tbl.getInputFormatClass().getName());
        tbl.getTTable().getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
        if (crtTbl.isExternal()) {
            tbl.setProperty("EXTERNAL", "TRUE");
            tbl.setTableType(TableType.EXTERNAL_TABLE);
        }
        if (tbl.getBucketCols() != null && tbl.getSortCols() != null) {
            List<String> bucketCols = tbl.getBucketCols();
            List<Order> sortCols = tbl.getSortCols();
            if (sortCols.size() > 0 && sortCols.size() >= bucketCols.size()) {
                boolean found = true;
                for (String bucketCol : bucketCols) {
                    boolean colFound = false;
                    for (int i = 0; i < bucketCols.size(); ++i) {
                        if (!bucketCol.equals(sortCols.get(i).getCol())) continue;
                        colFound = true;
                        break;
                    }
                    if (colFound) continue;
                    found = false;
                    break;
                }
                if (found) {
                    tbl.setProperty("SORTBUCKETCOLSPREFIX", "TRUE");
                }
            }
        }
        if ((rc = this.setGenericTableAttributes(tbl)) != 0) {
            return rc;
        }
        db.createTable(tbl, crtTbl.getIfNotExists());
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        return 0;
    }

    private int createTableLike(Hive db, CreateTableLikeDesc crtTbl) throws HiveException {
        Table tbl = db.getTable(crtTbl.getLikeTableName());
        String targetTableName = crtTbl.getTableName();
        Table newTable = db.newTable(targetTableName);
        tbl.setDbName(newTable.getDbName());
        tbl.setTableName(newTable.getTableName());
        if (crtTbl.isExternal()) {
            tbl.setProperty("EXTERNAL", "TRUE");
        } else {
            tbl.setProperty("EXTERNAL", "FALSE");
        }
        if (crtTbl.getLocation() != null) {
            tbl.setDataLocation(new Path(crtTbl.getLocation()).toUri());
        } else {
            tbl.unsetDataLocation();
        }
        Map<String, String> params = tbl.getParameters();
        params.clear();
        db.createTable(tbl, crtTbl.getIfNotExists());
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        return 0;
    }

    private int createView(Hive db, CreateViewDesc crtView) throws HiveException {
        int rc;
        Table tbl = db.newTable(crtView.getViewName());
        tbl.setTableType(TableType.VIRTUAL_VIEW);
        tbl.setSerializationLib(null);
        tbl.clearSerDeInfo();
        tbl.setViewOriginalText(crtView.getViewOriginalText());
        tbl.setViewExpandedText(crtView.getViewExpandedText());
        tbl.setFields(crtView.getSchema());
        if (crtView.getComment() != null) {
            tbl.setProperty("comment", crtView.getComment());
        }
        if (crtView.getTblProps() != null) {
            tbl.getTTable().getParameters().putAll(crtView.getTblProps());
        }
        if (crtView.getPartCols() != null) {
            tbl.setPartCols(crtView.getPartCols());
        }
        if ((rc = this.setGenericTableAttributes(tbl)) != 0) {
            return rc;
        }
        db.createTable(tbl, crtView.getIfNotExists());
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        return 0;
    }

    private int setGenericTableAttributes(Table tbl) {
        try {
            tbl.setOwner(this.conf.getUser());
        }
        catch (IOException e) {
            this.console.printError("Unable to get current user: " + e.getMessage(), org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        tbl.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        return 0;
    }

    @Override
    public StageType getType() {
        return StageType.DDL;
    }

    @Override
    public String getName() {
        return "DDL";
    }

    @Override
    protected void localizeMRTmpFilesImpl(Context ctx) {
    }
}

