/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.serde2.DelimitedJSONSerDe;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public class FetchTask
extends Task<FetchWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int maxRows = 100;
    private FetchOperator ftOp;
    private SerDe mSerde;
    private int totalRows;

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext ctx) {
        super.initialize(conf, queryPlan, ctx);
        try {
            JobConf job = new JobConf((Configuration)conf, ExecDriver.class);
            String serdeName = HiveConf.getVar(conf, HiveConf.ConfVars.HIVEFETCHOUTPUTSERDE);
            Class<SerDe> serdeClass = Class.forName(serdeName, true, JavaUtils.getClassLoader()).asSubclass(SerDe.class);
            this.mSerde = (SerDe)ReflectionUtils.newInstance(serdeClass, null);
            Properties serdeProp = new Properties();
            if (this.mSerde instanceof DelimitedJSONSerDe) {
                serdeProp.put("serialization.format", "9");
                serdeProp.put("serialization.null.format", ((FetchWork)this.work).getSerializationNullFormat());
            }
            this.mSerde.initialize((Configuration)job, serdeProp);
            this.ftOp = new FetchOperator((FetchWork)this.work, job);
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    @Override
    public int execute(DriverContext driverContext) {
        assert (false);
        return 0;
    }

    public TableDesc getTblDesc() {
        return ((FetchWork)this.work).getTblDesc();
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public boolean fetch(ArrayList<String> res) throws IOException {
        try {
            int numRows = 0;
            int rowsRet = this.maxRows;
            if (((FetchWork)this.work).getLimit() >= 0 && ((FetchWork)this.work).getLimit() - this.totalRows < rowsRet) {
                rowsRet = ((FetchWork)this.work).getLimit() - this.totalRows;
            }
            if (rowsRet <= 0) {
                this.ftOp.clearFetchContext();
                return false;
            }
            while (numRows < rowsRet) {
                InspectableObject io = this.ftOp.getNextRow();
                if (io == null) {
                    if (numRows == 0) {
                        return false;
                    }
                    this.totalRows += numRows;
                    return true;
                }
                res.add(((Text)this.mSerde.serialize(io.o, io.oi)).toString());
                ++numRows;
            }
            this.totalRows += numRows;
            return true;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public StageType getType() {
        return StageType.FETCH;
    }

    @Override
    public String getName() {
        return "FETCH";
    }

    @Override
    protected void localizeMRTmpFilesImpl(Context ctx) {
        ArrayList<String> ls;
        String s = ((FetchWork)this.work).getTblDir();
        if (s != null && ctx.isMRTmpFileURI(s)) {
            ((FetchWork)this.work).setTblDir(ctx.localizeMRTmpFileURI(s));
        }
        if ((ls = ((FetchWork)this.work).getPartDir()) != null) {
            ctx.localizePaths(ls);
        }
    }

    public void clearFetch() throws HiveException {
        if (null != this.ftOp) {
            this.ftOp.clearFetchContext();
        }
    }
}

