/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Drop Table")
public class DropTableDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    String tableName;
    ArrayList<LinkedHashMap<String, String>> partSpecs;
    boolean expectView;

    public DropTableDesc() {
    }

    public DropTableDesc(String tableName, boolean expectView) {
        this.tableName = tableName;
        this.partSpecs = null;
        this.expectView = expectView;
    }

    public DropTableDesc(String tableName, List<? extends Map<String, String>> partSpecs, boolean expectView) {
        this.tableName = tableName;
        this.partSpecs = new ArrayList(partSpecs.size());
        for (int i = 0; i < partSpecs.size(); ++i) {
            this.partSpecs.add(new LinkedHashMap<String, String>(partSpecs.get(i)));
        }
        this.expectView = expectView;
    }

    @Explain(displayName="table")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ArrayList<LinkedHashMap<String, String>> getPartSpecs() {
        return this.partSpecs;
    }

    public void setPartSpecs(ArrayList<LinkedHashMap<String, String>> partSpecs) {
        this.partSpecs = partSpecs;
    }

    public boolean getExpectView() {
        return this.expectView;
    }

    public void setExpectView(boolean expectView) {
        this.expectView = expectView;
    }
}

