/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.QBJoinTree;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

@Explain(displayName="Map Reduce")
public class MapredWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String command;
    private LinkedHashMap<String, ArrayList<String>> pathToAliases;
    private LinkedHashMap<String, PartitionDesc> pathToPartitionInfo;
    private LinkedHashMap<String, Operator<? extends Serializable>> aliasToWork;
    private LinkedHashMap<String, PartitionDesc> aliasToPartnInfo;
    private TableDesc keyDesc;
    private List<TableDesc> tagToValueDesc;
    private Operator<?> reducer;
    private Integer numReduceTasks;
    private Integer numMapTasks;
    private Long maxSplitSize;
    private Long minSplitSize;
    private Long minSplitSizePerNode;
    private Long minSplitSizePerRack;
    private boolean needsTagging;
    private boolean hadoopSupportsSplittable;
    private MapredLocalWork mapLocalWork;
    private String inputformat;
    private boolean gatheringStats;
    private String tmpHDFSFileURI;
    private LinkedHashMap<Operator<? extends Serializable>, OpParseContext> opParseCtxMap;
    private QBJoinTree joinTree;
    private boolean mapperCannotSpanPartns;

    public MapredWork() {
        this.aliasToPartnInfo = new LinkedHashMap();
    }

    public MapredWork(String command, LinkedHashMap<String, ArrayList<String>> pathToAliases, LinkedHashMap<String, PartitionDesc> pathToPartitionInfo, LinkedHashMap<String, Operator<? extends Serializable>> aliasToWork, TableDesc keyDesc, List<TableDesc> tagToValueDesc, Operator<?> reducer, Integer numReduceTasks, MapredLocalWork mapLocalWork, boolean hadoopSupportsSplittable) {
        this.command = command;
        this.pathToAliases = pathToAliases;
        this.pathToPartitionInfo = pathToPartitionInfo;
        this.aliasToWork = aliasToWork;
        this.keyDesc = keyDesc;
        this.tagToValueDesc = tagToValueDesc;
        this.reducer = reducer;
        this.numReduceTasks = numReduceTasks;
        this.mapLocalWork = mapLocalWork;
        this.aliasToPartnInfo = new LinkedHashMap();
        this.hadoopSupportsSplittable = hadoopSupportsSplittable;
        this.maxSplitSize = null;
        this.minSplitSize = null;
        this.minSplitSizePerNode = null;
        this.minSplitSizePerRack = null;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    @Explain(displayName="Path -> Alias", normalExplain=false)
    public LinkedHashMap<String, ArrayList<String>> getPathToAliases() {
        return this.pathToAliases;
    }

    public void setPathToAliases(LinkedHashMap<String, ArrayList<String>> pathToAliases) {
        this.pathToAliases = pathToAliases;
    }

    @Explain(displayName="Path -> Partition", normalExplain=false)
    public LinkedHashMap<String, PartitionDesc> getPathToPartitionInfo() {
        return this.pathToPartitionInfo;
    }

    public void setPathToPartitionInfo(LinkedHashMap<String, PartitionDesc> pathToPartitionInfo) {
        this.pathToPartitionInfo = pathToPartitionInfo;
    }

    public LinkedHashMap<String, PartitionDesc> getAliasToPartnInfo() {
        return this.aliasToPartnInfo;
    }

    public void setAliasToPartnInfo(LinkedHashMap<String, PartitionDesc> aliasToPartnInfo) {
        this.aliasToPartnInfo = aliasToPartnInfo;
    }

    @Explain(displayName="Alias -> Map Operator Tree")
    public LinkedHashMap<String, Operator<? extends Serializable>> getAliasToWork() {
        return this.aliasToWork;
    }

    public void setAliasToWork(LinkedHashMap<String, Operator<? extends Serializable>> aliasToWork) {
        this.aliasToWork = aliasToWork;
    }

    @Explain(displayName="Local Work")
    public MapredLocalWork getMapLocalWork() {
        return this.mapLocalWork;
    }

    public void setMapLocalWork(MapredLocalWork mapLocalWork) {
        this.mapLocalWork = mapLocalWork;
    }

    public TableDesc getKeyDesc() {
        return this.keyDesc;
    }

    public void setKeyDesc(TableDesc keyDesc) {
        this.keyDesc = keyDesc;
    }

    public List<TableDesc> getTagToValueDesc() {
        return this.tagToValueDesc;
    }

    public void setTagToValueDesc(List<TableDesc> tagToValueDesc) {
        this.tagToValueDesc = tagToValueDesc;
    }

    @Explain(displayName="Reduce Operator Tree")
    public Operator<?> getReducer() {
        return this.reducer;
    }

    public void setReducer(Operator<?> reducer) {
        this.reducer = reducer;
    }

    public Integer getNumMapTasks() {
        return this.numMapTasks;
    }

    public void setNumMapTasks(Integer numMapTasks) {
        this.numMapTasks = numMapTasks;
    }

    public Integer getNumReduceTasks() {
        return this.numReduceTasks;
    }

    public void setNumReduceTasks(Integer numReduceTasks) {
        this.numReduceTasks = numReduceTasks;
    }

    public void addMapWork(String path, String alias, Operator<?> work, PartitionDesc pd) {
        ArrayList<String> curAliases = this.pathToAliases.get(path);
        if (curAliases == null) {
            assert (this.pathToPartitionInfo.get(path) == null);
            curAliases = new ArrayList();
            this.pathToAliases.put(path, curAliases);
            this.pathToPartitionInfo.put(path, pd);
        } else assert (this.pathToPartitionInfo.get(path) != null);
        for (String oneAlias : curAliases) {
            if (!oneAlias.equals(alias)) continue;
            throw new RuntimeException("Multiple aliases named: " + alias + " for path: " + path);
        }
        curAliases.add(alias);
        if (this.aliasToWork.get(alias) != null) {
            throw new RuntimeException("Existing work for alias: " + alias);
        }
        this.aliasToWork.put(alias, work);
    }

    public String isInvalid() {
        if (this.getNumReduceTasks() >= 1 && this.getReducer() == null) {
            return "Reducers > 0 but no reduce operator";
        }
        if (this.getNumReduceTasks() == 0 && this.getReducer() != null) {
            return "Reducers == 0 but reduce operator specified";
        }
        return null;
    }

    public String toXML() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Utilities.serializeMapRedWork(this, baos);
        return baos.toString();
    }

    private void setAliases() {
        for (String oneAlias : this.aliasToWork.keySet()) {
            this.aliasToWork.get(oneAlias).setAlias(oneAlias);
        }
    }

    public void deriveExplainAttributes() {
        if (this.pathToPartitionInfo != null) {
            for (Map.Entry<String, PartitionDesc> entry : this.pathToPartitionInfo.entrySet()) {
                entry.getValue().deriveBaseFileName(entry.getKey());
            }
        }
        if (this.mapLocalWork != null) {
            this.mapLocalWork.deriveExplainAttributes();
        }
    }

    public void initialize() {
        this.setAliases();
    }

    @Explain(displayName="Needs Tagging", normalExplain=false)
    public boolean getNeedsTagging() {
        return this.needsTagging;
    }

    public void setNeedsTagging(boolean needsTagging) {
        this.needsTagging = needsTagging;
    }

    public boolean getHadoopSupportsSplittable() {
        return this.hadoopSupportsSplittable;
    }

    public void setHadoopSupportsSplittable(boolean hadoopSupportsSplittable) {
        this.hadoopSupportsSplittable = hadoopSupportsSplittable;
    }

    public Long getMaxSplitSize() {
        return this.maxSplitSize;
    }

    public void setMaxSplitSize(Long maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
    }

    public Long getMinSplitSize() {
        return this.minSplitSize;
    }

    public void setMinSplitSize(Long minSplitSize) {
        this.minSplitSize = minSplitSize;
    }

    public Long getMinSplitSizePerNode() {
        return this.minSplitSizePerNode;
    }

    public void setMinSplitSizePerNode(Long minSplitSizePerNode) {
        this.minSplitSizePerNode = minSplitSizePerNode;
    }

    public Long getMinSplitSizePerRack() {
        return this.minSplitSizePerRack;
    }

    public void setMinSplitSizePerRack(Long minSplitSizePerRack) {
        this.minSplitSizePerRack = minSplitSizePerRack;
    }

    public String getInputformat() {
        return this.inputformat;
    }

    public void setInputformat(String inputformat) {
        this.inputformat = inputformat;
    }

    public void setGatheringStats(boolean gatherStats) {
        this.gatheringStats = gatherStats;
    }

    public boolean isGatheringStats() {
        return this.gatheringStats;
    }

    public void setMapperCannotSpanPartns(boolean mapperCannotSpanPartns) {
        this.mapperCannotSpanPartns = mapperCannotSpanPartns;
    }

    public boolean isMapperCannotSpanPartns() {
        return this.mapperCannotSpanPartns;
    }

    public String getTmpHDFSFileURI() {
        return this.tmpHDFSFileURI;
    }

    public void setTmpHDFSFileURI(String tmpHDFSFileURI) {
        this.tmpHDFSFileURI = tmpHDFSFileURI;
    }

    public QBJoinTree getJoinTree() {
        return this.joinTree;
    }

    public void setJoinTree(QBJoinTree joinTree) {
        this.joinTree = joinTree;
    }

    public LinkedHashMap<Operator<? extends Serializable>, OpParseContext> getOpParseCtxMap() {
        return this.opParseCtxMap;
    }

    public void setOpParseCtxMap(LinkedHashMap<Operator<? extends Serializable>, OpParseContext> opParseCtxMap) {
        this.opParseCtxMap = opParseCtxMap;
    }
}

