/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.Job;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigException;
import org.apache.pig.SortInfo;
import org.apache.pig.backend.datastorage.ContainerDescriptor;
import org.apache.pig.backend.datastorage.DataStorage;
import org.apache.pig.backend.datastorage.ElementDescriptor;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.executionengine.ExecJob;
import org.apache.pig.backend.hadoop.executionengine.HJob;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.io.InterStorage;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LODefine;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LOUserFunc;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlanBuilder;
import org.apache.pig.impl.logicalLayer.PlanSetter;
import org.apache.pig.impl.logicalLayer.ScalarFinder;
import org.apache.pig.impl.logicalLayer.UnionOnSchemaSetter;
import org.apache.pig.impl.logicalLayer.optimizer.LogicalOptimizer;
import org.apache.pig.impl.logicalLayer.parser.QueryParser;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.validators.LogicalPlanValidationExecutor;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.streaming.StreamingCommand;
import org.apache.pig.impl.util.LogUtils;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.impl.util.PropertiesUtil;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.LogicalPlanMigrationVistor;
import org.apache.pig.newplan.logical.optimizer.LogicalPlanOptimizer;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.pen.ExampleGenerator;
import org.apache.pig.scripting.ScriptEngine;
import org.apache.pig.tools.grunt.GruntParser;
import org.apache.pig.tools.parameters.ParameterSubstitutionPreprocessor;
import org.apache.pig.tools.pigscript.parser.ParseException;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.PigStatsUtil;
import org.apache.pig.tools.pigstats.ScriptState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.Public
@InterfaceStability.Stable
public class PigServer {
    private final Log log = LogFactory.getLog(this.getClass());
    private Stack<Graph> graphs = new Stack();
    private Graph currDAG;
    private PigContext pigContext;
    private static int scopeCounter = 0;
    private String scope = this.constructScope();
    private boolean aggregateWarning = true;
    private boolean isMultiQuery = true;

    public static ExecType parseExecType(String str) throws IOException {
        String normStr = str.toLowerCase();
        if (normStr.equals("local")) {
            return ExecType.LOCAL;
        }
        if (normStr.equals("mapreduce")) {
            return ExecType.MAPREDUCE;
        }
        if (normStr.equals("mapred")) {
            return ExecType.MAPREDUCE;
        }
        if (normStr.equals("pig")) {
            return ExecType.PIG;
        }
        if (normStr.equals("pigbody")) {
            return ExecType.PIG;
        }
        int errCode = 2040;
        String msg = "Unknown exec type: " + str;
        throw new PigException(msg, errCode, 4);
    }

    private String constructScope() {
        return "" + ++scopeCounter;
    }

    public PigServer(String execTypeString) throws ExecException, IOException {
        this(PigServer.parseExecType(execTypeString));
    }

    public PigServer(ExecType execType) throws ExecException {
        this(execType, PropertiesUtil.loadDefaultProperties());
    }

    public PigServer(ExecType execType, Properties properties) throws ExecException {
        this(new PigContext(execType, properties));
    }

    public PigServer(PigContext context) throws ExecException {
        this(context, true);
    }

    public PigServer(PigContext context, boolean connect) throws ExecException {
        this.pigContext = context;
        this.currDAG = new Graph(false);
        this.aggregateWarning = "true".equalsIgnoreCase(this.pigContext.getProperties().getProperty("aggregate.warning"));
        this.isMultiQuery = "true".equalsIgnoreCase(this.pigContext.getProperties().getProperty("opt.multiquery", "true"));
        if (connect) {
            this.pigContext.connect();
        }
        if ("true".equals(this.pigContext.getProperties().getProperty("mapred.output.compress"))) {
            this.pigContext.getProperties().setProperty("output.compression.enabled", "true");
            String codec = this.pigContext.getProperties().getProperty("mapred.output.compression.codec");
            if (codec == null) {
                throw new RuntimeException("'mapred.output.compress' is set but no value is specified for 'mapred.output.compression.codec'.");
            }
            this.pigContext.getProperties().setProperty("output.compression.codec", codec);
        }
        this.addJarsFromProperties();
    }

    private void addJarsFromProperties() throws ExecException {
        String jar_str = this.pigContext.getProperties().getProperty("pig.additional.jars");
        if (jar_str != null) {
            for (String jar : jar_str.split(":")) {
                try {
                    this.registerJar(jar);
                }
                catch (IOException e) {
                    int errCode = 4010;
                    String msg = "Failed to register jar :" + jar + ". Caught exception.";
                    throw new ExecException(msg, errCode, 8, e);
                }
            }
        }
    }

    public PigContext getPigContext() {
        return this.pigContext;
    }

    public void debugOn() {
        Logger.getLogger((String)"org.apache.pig").setLevel(Level.DEBUG);
        this.pigContext.getLog4jProperties().setProperty("log4j.logger.org.apache.pig", Level.DEBUG.toString());
    }

    public void debugOff() {
        Logger.getLogger((String)"org.apache.pig").setLevel(this.pigContext.getDefaultLogLevel());
        this.pigContext.getLog4jProperties().setProperty("log4j.logger.org.apache.pig", this.pigContext.getDefaultLogLevel().toString());
    }

    public void setDefaultParallel(int p) {
        this.pigContext.defaultParallel = p;
    }

    public void setBatchOn() {
        this.log.debug((Object)"Create a new graph.");
        if (this.currDAG != null) {
            this.graphs.push(this.currDAG);
        }
        this.currDAG = new Graph(this.isMultiQuery);
    }

    public boolean isBatchOn() {
        return this.graphs.size() > 0;
    }

    public boolean isBatchEmpty() throws FrontendException {
        if (this.currDAG == null) {
            int errCode = 1083;
            String msg = "setBatchOn() must be called first.";
            throw new FrontendException(msg, errCode, 2);
        }
        return this.currDAG.isBatchEmpty();
    }

    public List<ExecJob> executeBatch() throws FrontendException, ExecException {
        PigStats stats = this.executeBatchEx();
        LinkedList<ExecJob> jobs = new LinkedList<ExecJob>();
        PigStats.JobGraph jGraph = stats.getJobGraph();
        for (JobStats js : jGraph) {
            for (OutputStats output : js.getOutputs()) {
                if (js.isSuccessful()) {
                    jobs.add(new HJob(ExecJob.JOB_STATUS.COMPLETED, this.pigContext, output.getPOStore(), output.getAlias(), stats));
                    continue;
                }
                HJob hjob = new HJob(ExecJob.JOB_STATUS.FAILED, this.pigContext, output.getPOStore(), output.getAlias(), stats);
                hjob.setException(js.getException());
                jobs.add(hjob);
            }
        }
        return jobs;
    }

    private PigStats executeBatchEx() throws FrontendException, ExecException {
        if (!this.isMultiQuery) {
            return PigStats.get();
        }
        if (this.currDAG == null || !this.isBatchOn()) {
            int errCode = 1083;
            String msg = "setBatchOn() must be called first.";
            throw new FrontendException(msg, errCode, 2);
        }
        return this.currDAG.execute();
    }

    public void discardBatch() throws FrontendException {
        if (this.currDAG == null || !this.isBatchOn()) {
            int errCode = 1083;
            String msg = "setBatchOn() must be called first.";
            throw new FrontendException(msg, errCode, 2);
        }
        this.currDAG = this.graphs.pop();
    }

    public void addPathToSkip(String path) {
        this.pigContext.addPathToSkip(path);
    }

    public void registerFunction(String function, String functionSpec) {
        this.registerFunction(function, new FuncSpec(functionSpec));
    }

    public void registerFunction(String function, FuncSpec funcSpec) {
        this.pigContext.registerFunction(function, funcSpec);
    }

    public void registerStreamingCommand(String commandAlias, StreamingCommand command) {
        this.pigContext.registerStreamCmd(commandAlias, command);
    }

    private URL locateJarFromResources(String jarName) throws IOException {
        Enumeration<URL> urls = ClassLoader.getSystemResources(jarName);
        URL resourceLocation = null;
        if (urls.hasMoreElements()) {
            resourceLocation = urls.nextElement();
        }
        if (urls.hasMoreElements()) {
            StringBuffer sb = new StringBuffer("Found multiple resources that match ");
            sb.append(jarName);
            sb.append(": ");
            sb.append(resourceLocation);
            while (urls.hasMoreElements()) {
                sb.append(urls.nextElement());
                sb.append("; ");
            }
            this.log.debug((Object)sb.toString());
        }
        return resourceLocation;
    }

    public void registerJar(String name) throws IOException {
        if (name != null) {
            URL resource = this.locateJarFromResources(name);
            if (resource == null) {
                File f = FileLocalizer.fetchFile((Properties)this.pigContext.getProperties(), (String)name).file;
                if (!f.canRead()) {
                    int errCode = 4002;
                    String msg = "Can't read jar file: " + name;
                    throw new FrontendException(msg, errCode, 8);
                }
                resource = f.toURI().toURL();
            }
            this.pigContext.addJar(resource);
        }
    }

    public void registerCode(String path, String scriptingLang, String namespace) throws IOException {
        File f = new File(path);
        if (!f.canRead()) {
            int errCode = 4002;
            String msg = "Can't read file: " + path;
            throw new FrontendException(msg, errCode, 8);
        }
        if (scriptingLang != null) {
            ScriptEngine se = ScriptEngine.getInstance(scriptingLang);
            se.registerFunctions(path, namespace, this.pigContext);
        }
        this.pigContext.addScriptFile(path);
    }

    public void registerQuery(String query, int startLine) throws IOException {
        this.currDAG.registerQuery(query, startLine);
    }

    public Graph getClonedGraph() throws IOException {
        Graph graph = this.currDAG.clone();
        if (graph == null) {
            int errCode = 2127;
            String msg = "Cloning of plan failed.";
            throw new FrontendException(msg, errCode, 4);
        }
        return graph;
    }

    public void registerQuery(String query) throws IOException {
        this.registerQuery(query, 1);
    }

    public void registerScript(String fileName) throws IOException {
        this.registerScript(fileName, null, null);
    }

    public void registerScript(String fileName, Map<String, String> params) throws IOException {
        this.registerScript(fileName, params, null);
    }

    public void registerScript(String fileName, List<String> paramsFiles) throws IOException {
        this.registerScript(fileName, null, paramsFiles);
    }

    public void registerScript(String fileName, Map<String, String> params, List<String> paramsFiles) throws IOException {
        try {
            ArrayList<String> paramList = new ArrayList<String>();
            if (params != null) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    paramList.add(entry.getKey() + "=" + entry.getValue());
                }
            }
            ParameterSubstitutionPreprocessor psp = new ParameterSubstitutionPreprocessor(50);
            StringWriter writer = new StringWriter();
            psp.genSubstitutedFile(new BufferedReader(new InputStreamReader(new FileInputStream(fileName))), writer, paramList.size() > 0 ? paramList.toArray(new String[0]) : null, paramsFiles != null ? paramsFiles.toArray(new String[0]) : null);
            GruntParser grunt = new GruntParser(new StringReader(writer.toString()));
            grunt.setInteractive(false);
            grunt.setParams(this);
            grunt.parseStopOnError(true);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)e.getLocalizedMessage());
            throw new IOException(e.getCause());
        }
        catch (ParseException e) {
            this.log.error((Object)e.getLocalizedMessage());
            throw new IOException(e.getCause());
        }
        catch (org.apache.pig.tools.parameters.ParseException e) {
            this.log.error((Object)e.getLocalizedMessage());
            throw new IOException(e.getCause());
        }
    }

    public void printAliases() throws FrontendException {
        System.out.println("aliases: " + this.currDAG.getAliasOp().keySet());
    }

    public Schema dumpSchema(String alias) throws IOException {
        try {
            org.apache.pig.impl.logicalLayer.LogicalPlan lp = this.getPlanFromAlias(alias, "describe");
            lp = this.compileLp(alias, false);
            Schema schema = null;
            for (LogicalOperator lo : lp.getLeaves()) {
                if (!lo.getAlias().equals(alias)) continue;
                schema = lo.getSchema();
                break;
            }
            if (schema != null) {
                System.out.println(alias + ": " + schema.toString());
            } else {
                System.out.println("Schema for " + alias + " unknown.");
            }
            return schema;
        }
        catch (FrontendException fee) {
            int errCode = 1001;
            String msg = "Unable to describe schema for alias " + alias;
            throw new FrontendException(msg, errCode, 2, false, null, fee);
        }
    }

    public Schema dumpSchemaNested(String alias, String nestedAlias) throws IOException {
        org.apache.pig.impl.logicalLayer.LogicalPlan lp = this.getPlanFromAlias(alias, "describe");
        lp = this.compileLp(alias, false);
        LogicalOperator op = (LogicalOperator)lp.getLeaves().get(0);
        if (op instanceof LOForEach) {
            return ((LOForEach)op).dumpNestedSchema(alias, nestedAlias);
        }
        int errCode = 1001;
        String msg = "Unable to describe schema for " + alias + "::" + nestedAlias;
        throw new FrontendException(msg, errCode, 2, false, null);
    }

    public void setJobName(String name) {
        this.currDAG.setJobName(name);
    }

    public void setJobPriority(String priority) {
        this.currDAG.setJobPriority(priority);
    }

    public Iterator<Tuple> openIterator(String id) throws IOException {
        try {
            ExecJob job;
            LogicalOperator op = this.currDAG.getAliasOp().get(id);
            if (null == op) {
                int errCode = 1003;
                String msg = "Unable to find an operator for alias " + id;
                throw new FrontendException(msg, errCode, 2);
            }
            if (this.currDAG.isBatchOn()) {
                this.currDAG.execute();
            }
            if ((job = this.store(id, FileLocalizer.getTemporaryPath(this.pigContext).toString(), Utils.getTmpFileCompressorName(this.pigContext) + "()")).getStatus() == ExecJob.JOB_STATUS.COMPLETED) {
                return job.getResults();
            }
            if (job.getStatus() == ExecJob.JOB_STATUS.FAILED && job.getException() != null) {
                Exception e = job.getException();
                int errCode = 1066;
                String msg = "Unable to open iterator for alias " + id + ". Backend error : " + e.getMessage();
                throw new FrontendException(msg, errCode, 2, e);
            }
            throw new IOException("Job terminated with anomalous status " + job.getStatus().toString());
        }
        catch (FrontendException e) {
            throw e;
        }
        catch (Exception e) {
            int errCode = 1066;
            String msg = "Unable to open iterator for alias " + id;
            throw new FrontendException(msg, errCode, 2, e);
        }
    }

    public ExecJob store(String id, String filename) throws IOException {
        return this.store(id, filename, PigStorage.class.getName() + "()");
    }

    public ExecJob store(String id, String filename, String func) throws IOException {
        PigStats stats = this.storeEx(id, filename, func);
        if (stats.getOutputStats().size() < 1) {
            throw new IOException("Couldn't retrieve job.");
        }
        OutputStats output = stats.getOutputStats().get(0);
        if (stats.isSuccessful()) {
            return new HJob(ExecJob.JOB_STATUS.COMPLETED, this.pigContext, output.getPOStore(), output.getAlias(), stats);
        }
        HJob job = new HJob(ExecJob.JOB_STATUS.FAILED, this.pigContext, output.getPOStore(), output.getAlias(), stats);
        Exception ex = null;
        for (JobStats js : stats.getJobGraph()) {
            if (js.getException() == null) continue;
            ex = js.getException();
        }
        job.setException(ex);
        return job;
    }

    private PigStats storeEx(String id, String filename, String func) throws IOException {
        if (!this.currDAG.getAliasOp().containsKey(id)) {
            throw new IOException("Invalid alias: " + id);
        }
        try {
            Graph g = this.getClonedGraph();
            org.apache.pig.impl.logicalLayer.LogicalPlan lp = g.getPlan(id);
            List leaves = lp.getLeaves();
            LogicalOperator leaf = null;
            if (leaves.size() == 1) {
                leaf = (LogicalOperator)leaves.get(0);
            } else {
                for (LogicalOperator leafOp : leaves) {
                    if (!leafOp.getAlias().equals(id)) continue;
                    leaf = leafOp;
                }
            }
            org.apache.pig.impl.logicalLayer.LogicalPlan unCompiledstorePlan = QueryParser.generateStorePlan(this.scope, lp, filename, func, leaf, leaf.getAlias(), this.pigContext);
            org.apache.pig.impl.logicalLayer.LogicalPlan storePlan = this.compileLp(unCompiledstorePlan, g, true);
            return this.executeCompiledLogicalPlan(storePlan);
        }
        catch (PigException e) {
            int errCode = 1002;
            String msg = "Unable to store alias " + id;
            throw new PigException(msg, errCode, 2, e);
        }
    }

    public void explain(String alias, PrintStream stream) throws IOException {
        this.explain(alias, "text", true, false, stream, stream, stream);
    }

    public void explain(String alias, String format, boolean verbose, boolean markAsExecute, PrintStream lps, PrintStream pps, PrintStream eps) throws IOException {
        try {
            this.pigContext.inExplain = true;
            org.apache.pig.impl.logicalLayer.LogicalPlan lp = this.getStorePlan(alias);
            if (lp.size() == 0) {
                lps.println("Logical plan is empty.");
                pps.println("Physical plan is empty.");
                eps.println("Execution plan is empty.");
                return;
            }
            PhysicalPlan pp = this.compilePp(lp);
            lp.explain(lps, format, verbose);
            if (this.pigContext.getProperties().getProperty("pig.usenewlogicalplan", "true").equals("true")) {
                LogicalPlanMigrationVistor migrator = new LogicalPlanMigrationVistor(lp);
                migrator.visit();
                LogicalPlan newPlan = migrator.getNewLogicalPlan();
                HashSet optimizerRules = null;
                try {
                    optimizerRules = (HashSet)ObjectSerializer.deserialize(this.pigContext.getProperties().getProperty("pig.optimizer.rules"));
                }
                catch (IOException ioe) {
                    int errCode = 2110;
                    String msg = "Unable to deserialize optimizer rules.";
                    throw new FrontendException(msg, errCode, 4, ioe);
                }
                LogicalPlanOptimizer optimizer = new LogicalPlanOptimizer((OperatorPlan)newPlan, 3, optimizerRules);
                optimizer.optimize();
                newPlan.explain(lps, format, verbose);
            }
            pp.explain(pps, format, verbose);
            this.pigContext.getExecutionEngine().explain(pp, eps, format, verbose);
            if (markAsExecute) {
                this.currDAG.markAsExecuted();
            }
        }
        catch (Exception e) {
            int errCode = 1067;
            String msg = "Unable to explain alias " + alias;
            throw new FrontendException(msg, errCode, 2, e);
        }
        finally {
            this.pigContext.inExplain = false;
        }
    }

    public long capacity() throws IOException {
        if (this.pigContext.getExecType() == ExecType.LOCAL) {
            throw new IOException("capacity only supported for non-local execution");
        }
        DataStorage dds = this.pigContext.getDfs();
        Map<String, Object> stats = dds.getStatistics();
        String rawCapacityStr = (String)stats.get("pig.raw.capacity.bytes");
        String rawUsedStr = (String)stats.get("pig.raw.used.capacity.bytes");
        if (rawCapacityStr == null || rawUsedStr == null) {
            throw new IOException("Failed to retrieve capacity stats");
        }
        long rawCapacityBytes = new Long(rawCapacityStr);
        long rawUsedBytes = new Long(rawUsedStr);
        return rawCapacityBytes - rawUsedBytes;
    }

    public long fileSize(String filename) throws IOException {
        DataStorage dfs = this.pigContext.getDfs();
        ElementDescriptor elem = dfs.asElement(filename);
        Map<String, Object> stats = elem.getStatistics();
        long length = (Long)stats.get("pig.path.length");
        short replication = (Short)stats.get("pig.path.block.replication");
        return length * (long)replication;
    }

    public boolean existsFile(String filename) throws IOException {
        ElementDescriptor elem = this.pigContext.getDfs().asElement(filename);
        return elem.exists();
    }

    public boolean deleteFile(String filename) throws IOException {
        ElementDescriptor elem = this.pigContext.getDfs().asElement(filename);
        elem.delete();
        return true;
    }

    public boolean renameFile(String source, String target) throws IOException {
        this.pigContext.rename(source, target);
        return true;
    }

    public boolean mkdirs(String dirs) throws IOException {
        ContainerDescriptor container = this.pigContext.getDfs().asContainer(dirs);
        container.create();
        return true;
    }

    public String[] listPaths(String dir) throws IOException {
        ArrayList<String> allPaths = new ArrayList<String>();
        ContainerDescriptor container = this.pigContext.getDfs().asContainer(dir);
        for (ElementDescriptor elem : container) {
            allPaths.add(elem.toString());
        }
        String[] type = new String[1];
        return allPaths.toArray(type);
    }

    public long totalHadoopTimeSpent() {
        return 0L;
    }

    public Map<String, org.apache.pig.impl.logicalLayer.LogicalPlan> getAliases() {
        HashMap<String, org.apache.pig.impl.logicalLayer.LogicalPlan> aliasPlans = new HashMap<String, org.apache.pig.impl.logicalLayer.LogicalPlan>();
        for (LogicalOperator op : this.currDAG.getAliases().keySet()) {
            String alias = op.getAlias();
            if (null == alias) continue;
            aliasPlans.put(alias, this.currDAG.getAliases().get(op));
        }
        return aliasPlans;
    }

    public void shutdown() {
        FileLocalizer.deleteTempFiles();
    }

    public Set<String> getAliasKeySet() {
        return this.currDAG.getAliasOp().keySet();
    }

    public Map<LogicalOperator, DataBag> getExamples(String alias) {
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = null;
        try {
            if (this.currDAG.isBatchOn()) {
                this.currDAG.execute();
            }
            plan = this.getClonedGraph().getPlan(alias);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ExampleGenerator exgen = new ExampleGenerator(plan, this.pigContext);
        return exgen.getExamples();
    }

    private org.apache.pig.impl.logicalLayer.LogicalPlan getStorePlan(String alias) throws IOException {
        Graph g = this.getClonedGraph();
        org.apache.pig.impl.logicalLayer.LogicalPlan lp = g.getPlan(alias);
        if (!this.isBatchOn() || alias != null) {
            List leaves = lp.getLeaves();
            LogicalOperator leaf = null;
            if (leaves.size() == 1) {
                leaf = (LogicalOperator)leaves.get(0);
            } else {
                for (LogicalOperator leafOp : leaves) {
                    if (!leafOp.getAlias().equals(alias)) continue;
                    leaf = leafOp;
                }
            }
            lp = QueryParser.generateStorePlan(this.scope, lp, "fakefile", PigStorage.class.getName(), leaf, "fake", this.pigContext);
        }
        this.compileLp(lp, g, true);
        return lp;
    }

    private PigStats execute(String alias) throws FrontendException, ExecException {
        org.apache.pig.impl.logicalLayer.LogicalPlan typeCheckedLp = this.compileLp(alias);
        if (typeCheckedLp.size() == 0) {
            return PigStatsUtil.getEmptyPigStats();
        }
        LogicalOperator op = (LogicalOperator)typeCheckedLp.getLeaves().get(0);
        if (op instanceof LODefine) {
            this.log.info((Object)"Skip execution of DEFINE only logical plan.");
            return PigStatsUtil.getEmptyPigStats();
        }
        return this.executeCompiledLogicalPlan(typeCheckedLp);
    }

    private PigStats executeCompiledLogicalPlan(org.apache.pig.impl.logicalLayer.LogicalPlan compiledLp) throws ExecException, FrontendException {
        ScriptState.get().setScriptFeatures(compiledLp);
        PhysicalPlan pp = this.compilePp(compiledLp);
        List<ExecJob> jobs = this.pigContext.getExecutionEngine().execute(pp, "job_pigexec_");
        PigStats stats = null;
        stats = jobs.size() > 0 ? jobs.get(0).getStatistics() : PigStatsUtil.getEmptyPigStats();
        for (OutputStats output : stats.getOutputStats()) {
            if (output.isSuccessful()) continue;
            POStore store = output.getPOStore();
            try {
                store.getStoreFunc().cleanupOnFailure(store.getSFile().getFileName(), new Job(output.getConf()));
            }
            catch (IOException e) {
                throw new ExecException(e);
            }
        }
        return stats;
    }

    private org.apache.pig.impl.logicalLayer.LogicalPlan compileLp(String alias) throws FrontendException {
        return this.compileLp(alias, true);
    }

    private org.apache.pig.impl.logicalLayer.LogicalPlan compileLp(String alias, boolean optimize) throws FrontendException {
        org.apache.pig.impl.logicalLayer.LogicalPlan lpClone;
        Graph g;
        try {
            g = this.getClonedGraph();
            lpClone = g.getPlan(alias);
        }
        catch (IOException e) {
            int errCode = 2001;
            String msg = "Unable to clone plan before compiling";
            throw new FrontendException(msg, errCode, 4, e);
        }
        return this.compileLp(lpClone, g, optimize);
    }

    private void mergeScalars(org.apache.pig.impl.logicalLayer.LogicalPlan lp, Graph g) throws FrontendException {
        ScalarFinder scalarFinder = new ScalarFinder(lp);
        scalarFinder.visit();
        Map<LOUserFunc, Pair<org.apache.pig.impl.logicalLayer.LogicalPlan, LogicalOperator>> scalarMap = scalarFinder.getScalarMap();
        try {
            for (Map.Entry<LOUserFunc, Pair<org.apache.pig.impl.logicalLayer.LogicalPlan, LogicalOperator>> scalarEntry : scalarMap.entrySet()) {
                FileSpec fileSpec;
                String alias = scalarEntry.getKey().getImplicitReferencedOperator().getAlias();
                org.apache.pig.impl.logicalLayer.LogicalPlan referredPlan = g.getAliases().get(g.getAliasOp().get(alias));
                LogicalOperator store = (LogicalOperator)referredPlan.getLeaves().get(0);
                if (store instanceof LOStore && ((LOStore)store).getOutputFile().getFuncName().equals(InterStorage.class.getName())) {
                    fileSpec = ((LOStore)store).getOutputFile();
                } else {
                    FuncSpec funcSpec = new FuncSpec(InterStorage.class.getName());
                    fileSpec = new FileSpec(FileLocalizer.getTemporaryPath(this.pigContext).toString(), funcSpec);
                    store = new LOStore(referredPlan, new OperatorKey(this.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.scope)), fileSpec, alias);
                    referredPlan.addAsLeaf(store);
                    ((LOStore)store).setTmpStore(true);
                    scalarEntry.getKey().setImplicitReferencedOperator(store);
                }
                lp.mergeSharedPlan(referredPlan);
                org.apache.pig.impl.logicalLayer.LogicalPlan innerPlan = (org.apache.pig.impl.logicalLayer.LogicalPlan)scalarEntry.getValue().first;
                LOConst rconst = new LOConst(innerPlan, new OperatorKey(this.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.scope)), fileSpec.getFileName());
                rconst.setType((byte)55);
                innerPlan.add(rconst);
                innerPlan.connect(rconst, (Operator)scalarEntry.getKey());
                if (lp.getSoftLinkSuccessors(store) != null && lp.getSoftLinkSuccessors(store).contains(scalarEntry.getValue().second)) continue;
                lp.createSoftLink(store, (Operator)scalarEntry.getValue().second);
            }
        }
        catch (IOException ioe) {
            int errCode = 2219;
            String msg = "Unable to process scalar in the plan";
            throw new FrontendException(msg, errCode, 4, ioe);
        }
    }

    private org.apache.pig.impl.logicalLayer.LogicalPlan compileLp(org.apache.pig.impl.logicalLayer.LogicalPlan lp, Graph g, boolean optimize) throws FrontendException {
        this.mergeScalars(lp, g);
        return this.compileLp(lp, optimize);
    }

    private org.apache.pig.impl.logicalLayer.LogicalPlan compileLp(org.apache.pig.impl.logicalLayer.LogicalPlan lp, boolean optimize) throws FrontendException {
        PlanSetter ps = new PlanSetter(lp);
        ps.visit();
        UnionOnSchemaSetter setUnionOnSchema = new UnionOnSchemaSetter(lp, this.pigContext);
        setUnionOnSchema.visit();
        CompilationMessageCollector collector = new CompilationMessageCollector();
        boolean isBeforeOptimizer = true;
        this.validate(lp, collector, isBeforeOptimizer);
        if (optimize && this.pigContext.getProperties().getProperty("pig.usenewlogicalplan", "true").equals("false")) {
            HashSet optimizerRules = null;
            try {
                optimizerRules = (HashSet)ObjectSerializer.deserialize(this.pigContext.getProperties().getProperty("pig.optimizer.rules"));
            }
            catch (IOException ioe) {
                int errCode = 2110;
                String msg = "Unable to deserialize optimizer rules.";
                throw new FrontendException(msg, errCode, 4, ioe);
            }
            LogicalOptimizer optimizer = new LogicalOptimizer(lp, this.pigContext.getExecType(), optimizerRules);
            optimizer.optimize();
            SortInfoSetter sortInfoSetter = new SortInfoSetter(lp);
            sortInfoSetter.visit();
            isBeforeOptimizer = false;
            this.validate(lp, collector, isBeforeOptimizer);
        }
        return lp;
    }

    private PhysicalPlan compilePp(org.apache.pig.impl.logicalLayer.LogicalPlan lp) throws FrontendException {
        PhysicalPlan pp = this.pigContext.getExecutionEngine().compile(lp, null);
        return pp;
    }

    private void validate(org.apache.pig.impl.logicalLayer.LogicalPlan lp, CompilationMessageCollector collector, boolean isBeforeOptimizer) throws FrontendException {
        FrontendException caught = null;
        try {
            LogicalPlanValidationExecutor validator = new LogicalPlanValidationExecutor(lp, this.pigContext, isBeforeOptimizer);
            validator.validate(lp, collector);
        }
        catch (FrontendException fe) {
            caught = fe;
        }
        if (this.aggregateWarning) {
            CompilationMessageCollector.logMessages(collector, CompilationMessageCollector.MessageType.Warning, this.aggregateWarning, this.log);
        } else {
            for (CompilationMessageCollector.MessageType type : CompilationMessageCollector.MessageType.values()) {
                CompilationMessageCollector.logAllMessages(collector, this.log);
            }
        }
        if (caught != null) {
            throw caught;
        }
    }

    private org.apache.pig.impl.logicalLayer.LogicalPlan getPlanFromAlias(String alias, String operation) throws FrontendException {
        LogicalOperator lo = this.currDAG.getAliasOp().get(alias);
        if (lo == null) {
            int errCode = 1004;
            String msg = "No alias " + alias + " to " + operation;
            throw new FrontendException(msg, errCode, 2, false, null);
        }
        org.apache.pig.impl.logicalLayer.LogicalPlan lp = this.currDAG.getAliases().get(lo);
        if (lp == null) {
            int errCode = 1005;
            String msg = "No plan for " + alias + " to " + operation;
            throw new FrontendException(msg, errCode, 2, false, null);
        }
        return lp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Graph {
        private Map<LogicalOperator, org.apache.pig.impl.logicalLayer.LogicalPlan> aliases = new HashMap<LogicalOperator, org.apache.pig.impl.logicalLayer.LogicalPlan>();
        private Map<OperatorKey, LogicalOperator> opTable = new HashMap<OperatorKey, LogicalOperator>();
        private Map<String, LogicalOperator> aliasOp = new HashMap<String, LogicalOperator>();
        private List<String> scriptCache = new ArrayList<String>();
        private Map<String, String> fileNameMap = new HashMap<String, String>();
        private Map<LOStore, org.apache.pig.impl.logicalLayer.LogicalPlan> storeOpTable = new HashMap<LOStore, org.apache.pig.impl.logicalLayer.LogicalPlan>();
        private Set<LOLoad> loadOps = new HashSet<LOLoad>();
        private String jobName;
        private String jobPriority;
        private boolean batchMode;
        private int processedStores;
        private int ignoreNumStores;
        private org.apache.pig.impl.logicalLayer.LogicalPlan lp;

        Graph(boolean batchMode) {
            this.batchMode = batchMode;
            this.processedStores = 0;
            this.ignoreNumStores = 0;
            this.jobName = PigServer.this.pigContext.getProperties().getProperty("jobName", "PigLatin:DefaultJobName");
            this.lp = new org.apache.pig.impl.logicalLayer.LogicalPlan();
        }

        Map<LogicalOperator, org.apache.pig.impl.logicalLayer.LogicalPlan> getAliases() {
            return this.aliases;
        }

        Map<OperatorKey, LogicalOperator> getOpTable() {
            return this.opTable;
        }

        Map<String, LogicalOperator> getAliasOp() {
            return this.aliasOp;
        }

        List<String> getScriptCache() {
            return this.scriptCache;
        }

        boolean isBatchOn() {
            return this.batchMode;
        }

        boolean isBatchEmpty() {
            return this.processedStores == this.storeOpTable.keySet().size();
        }

        PigStats execute() throws ExecException, FrontendException {
            PigServer.this.pigContext.getProperties().setProperty("jobName", this.jobName);
            if (this.jobPriority != null) {
                PigServer.this.pigContext.getProperties().setProperty("jobPriority", this.jobPriority);
            }
            PigStats stats = PigServer.this.execute(null);
            this.processedStores = this.storeOpTable.keySet().size();
            return stats;
        }

        void markAsExecuted() {
            this.processedStores = this.storeOpTable.keySet().size();
        }

        void setJobName(String name) {
            this.jobName = "PigLatin:" + name;
        }

        public void setJobPriority(String priority) {
            this.jobPriority = priority;
        }

        org.apache.pig.impl.logicalLayer.LogicalPlan getPlan(String alias) throws IOException {
            org.apache.pig.impl.logicalLayer.LogicalPlan plan = this.lp;
            if (alias != null) {
                LogicalOperator op = this.aliasOp.get(alias);
                if (op == null) {
                    int errCode = 1003;
                    String msg = "Unable to find an operator for alias " + alias;
                    throw new FrontendException(msg, errCode, 2);
                }
                plan = this.aliases.get(op);
            }
            return plan;
        }

        void registerQuery(String query, int startLine) throws IOException {
            LogicalOperator op;
            org.apache.pig.impl.logicalLayer.LogicalPlan tmpLp = this.parseQuery(query, startLine);
            this.scriptCache.add(query);
            if (tmpLp.getLeaves().size() == 1 && (op = tmpLp.getSingleLeafPlanOutputOp()) instanceof LOStore) {
                if (!this.batchMode) {
                    this.lp = tmpLp;
                    try {
                        this.execute();
                    }
                    catch (Exception e) {
                        int errCode = 1002;
                        String msg = "Unable to store alias " + op.getOperatorKey().getId();
                        throw new FrontendException(msg, errCode, 2, e);
                    }
                } else if (0 == this.ignoreNumStores) {
                    this.storeOpTable.put((LOStore)op, tmpLp);
                    this.lp.mergeSharedPlan(tmpLp);
                    List roots = tmpLp.getRoots();
                    for (LogicalOperator root : roots) {
                        if (!(root instanceof LOLoad)) continue;
                        this.loadOps.add((LOLoad)root);
                    }
                } else {
                    --this.ignoreNumStores;
                }
            }
        }

        org.apache.pig.impl.logicalLayer.LogicalPlan parseQuery(String query, int startLine) throws IOException {
            if (query == null || query.length() == 0) {
                int errCode = 1084;
                String msg = "Invalid Query: Query is null or of size 0";
                throw new FrontendException(msg, errCode, 2);
            }
            query = query.trim();
            try {
                return new LogicalPlanBuilder(PigServer.this.pigContext).parse(PigServer.this.scope, query, this.aliases, this.opTable, this.aliasOp, startLine, this.fileNameMap);
            }
            catch (org.apache.pig.impl.logicalLayer.parser.ParseException e) {
                PigException pe = LogUtils.getPigException(e);
                int errCode = 1000;
                String msg = "Error during parsing. " + (pe == null ? e.getMessage() : pe.getMessage());
                throw new FrontendException(msg, errCode, 2, false, null, e);
            }
        }

        protected Graph clone() {
            int lineNumber = 1;
            Graph graph = new Graph(this.isBatchOn());
            graph.ignoreNumStores = this.processedStores;
            graph.processedStores = this.processedStores;
            graph.fileNameMap = this.fileNameMap;
            UDFContext.getUDFContext().reset();
            try {
                Iterator<String> it = this.getScriptCache().iterator();
                while (it.hasNext()) {
                    if (this.isBatchOn()) {
                        graph.registerQuery(it.next(), lineNumber);
                    } else {
                        graph.lp = graph.parseQuery(it.next(), lineNumber);
                    }
                    ++lineNumber;
                }
                graph.postProcess();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                graph = null;
            }
            return graph;
        }

        private void postProcess() throws IOException {
            PlanSetter ps = new PlanSetter(this.lp);
            ps.visit();
            for (LOLoad load : this.loadOps) {
                for (LOStore store : this.storeOpTable.keySet()) {
                    String ifile = load.getInputFile().getFileName();
                    String ofile = store.getOutputFile().getFileName();
                    if (ofile.compareTo(ifile) != 0) continue;
                    try {
                        if (store.getPlan().pathExists(load, store)) continue;
                        store.getPlan().connect(store, load);
                    }
                    catch (PlanException ex) {
                        int errCode = 2128;
                        String msg = "Failed to connect store with dependent load.";
                        throw new FrontendException(msg, errCode, ex);
                    }
                }
            }
        }
    }

    public static class SortInfoSetter
    extends LOVisitor {
        public SortInfoSetter(org.apache.pig.impl.logicalLayer.LogicalPlan plan) {
            super(plan, (PlanWalker<LogicalOperator, org.apache.pig.impl.logicalLayer.LogicalPlan>)new DependencyOrderWalker<LogicalOperator, org.apache.pig.impl.logicalLayer.LogicalPlan>(plan));
        }

        protected void visit(LOStore store) throws VisitorException {
            LogicalOperator split;
            Object value;
            LogicalOperator root;
            LOSplitOutput splitOutput;
            org.apache.pig.impl.logicalLayer.LogicalPlan conditionPlan;
            LogicalOperator storePred = store.getPlan().getPredecessors(store).get(0);
            if (storePred == null) {
                int errCode = 2051;
                String msg = "Did not find a predecessor for Store.";
                throw new VisitorException(msg, errCode, 4);
            }
            SortInfo sortInfo = null;
            if (storePred instanceof LOLimit) {
                storePred = store.getPlan().getPredecessors(storePred).get(0);
            } else if (storePred instanceof LOSplitOutput && (conditionPlan = (splitOutput = (LOSplitOutput)storePred).getConditionPlan()).getRoots().size() == 1 && (root = (LogicalOperator)conditionPlan.getRoots().get(0)) instanceof LOConst && (value = ((LOConst)root).getValue()) instanceof Boolean && ((Boolean)value).booleanValue() && (split = (LogicalOperator)splitOutput.getPlan().getPredecessors(splitOutput).get(0)) instanceof LOSplit) {
                storePred = store.getPlan().getPredecessors(split).get(0);
            }
            if (storePred instanceof LOSort) {
                try {
                    sortInfo = ((LOSort)storePred).getSortInfo();
                }
                catch (FrontendException e) {
                    throw new VisitorException(e);
                }
            }
            store.setSortInfo(sortInfo);
        }
    }
}

