/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOGenerate;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOPrinter
extends LOVisitor {
    private PrintStream mStream = null;
    private String TAB1 = "    ";
    private String TABMore = "|   ";
    private String LSep = "|\n|---";
    private String USep = "|   |\n|   ";
    private int levelCntr = -1;
    private boolean isVerbose = true;

    public LOPrinter(PrintStream ps, LogicalPlan plan) {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new DepthFirstWalker<LogicalOperator, LogicalPlan>(plan));
        this.mStream = ps;
    }

    @Override
    public void visit() throws VisitorException {
        try {
            this.mStream.write(this.depthFirstLP().getBytes());
        }
        catch (IOException e) {
            throw new VisitorException(e);
        }
    }

    public void setVerbose(boolean verbose) {
        this.isVerbose = verbose;
    }

    public void print(OutputStream printer) throws VisitorException, IOException {
        printer.write(this.depthFirstLP().getBytes());
    }

    protected String depthFirstLP() throws VisitorException, IOException {
        StringBuilder sb = new StringBuilder();
        List leaves = ((LogicalPlan)this.mPlan).getLeaves();
        Collections.sort(leaves);
        for (LogicalOperator leaf : leaves) {
            sb.append(this.depthFirst(leaf));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String planString(LogicalPlan lp) throws VisitorException, IOException {
        StringBuilder sb = new StringBuilder();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (lp == null) {
            return "";
        }
        lp.explain(baos, this.mStream);
        sb.append(this.USep);
        sb.append(this.shiftStringByTabs(baos.toString(), 2));
        return sb.toString();
    }

    private String planString(List<LogicalPlan> logicalPlanList) throws VisitorException, IOException {
        StringBuilder sb = new StringBuilder();
        if (logicalPlanList != null) {
            for (LogicalPlan lp : logicalPlanList) {
                sb.append(this.planString(lp));
            }
        }
        return sb.toString();
    }

    private String depthFirst(LogicalOperator node) throws VisitorException, IOException {
        List<LogicalOperator> originalPredecessors;
        StringBuilder sb = new StringBuilder(node.name());
        if (node instanceof ExpressionOperator) {
            sb.append(" FieldSchema: ");
            try {
                sb.append(((ExpressionOperator)node).getFieldSchema());
            }
            catch (Exception e) {
                sb.append("Caught Exception: " + e.getMessage());
            }
        } else {
            sb.append(" Schema: ");
            try {
                sb.append(node.getSchema());
            }
            catch (Exception e) {
                sb.append("Caught exception: " + e.getMessage());
            }
        }
        sb.append(" Type: " + DataType.findTypeName(node.getType()));
        sb.append("\n");
        if (this.isVerbose) {
            MultiMap<LogicalOperator, LogicalPlan> plans;
            if (node instanceof LOFilter) {
                sb.append(this.planString(((LOFilter)node).getComparisonPlan()));
            } else if (node instanceof LOForEach) {
                sb.append(this.planString(((LOForEach)node).getForEachPlans()));
            } else if (node instanceof LOGenerate) {
                sb.append(this.planString(((LOGenerate)node).getGeneratePlans()));
            } else if (node instanceof LOCogroup) {
                plans = ((LOCogroup)node).getGroupByPlans();
                for (LogicalOperator lo : plans.keySet()) {
                    for (LogicalPlan plan : plans.get(lo)) {
                        sb.append(this.planString(plan));
                    }
                }
            } else if (node instanceof LOJoin) {
                plans = ((LOJoin)node).getJoinPlans();
                for (LogicalOperator lo : plans.keySet()) {
                    for (LogicalPlan plan : plans.get(lo)) {
                        sb.append(this.planString(plan));
                    }
                }
            } else if (node instanceof LOSort) {
                sb.append(this.planString(((LOSort)node).getSortColPlans()));
            } else if (node instanceof LOSplitOutput) {
                sb.append(this.planString(((LOSplitOutput)node).getConditionPlan()));
            } else if (node instanceof LOProject) {
                sb.append("Input: ");
                sb.append(((LOProject)node).getExpression().name());
            }
        }
        if ((originalPredecessors = ((LogicalPlan)this.mPlan).getPredecessors(node)) == null) {
            return sb.toString();
        }
        ArrayList<LogicalOperator> predecessors = new ArrayList<LogicalOperator>(originalPredecessors);
        Collections.sort(predecessors);
        int i = 0;
        for (LogicalOperator pred : predecessors) {
            ++i;
            String DFStr = this.depthFirst(pred);
            if (DFStr == null) continue;
            sb.append(this.LSep);
            if (i < predecessors.size()) {
                sb.append(this.shiftStringByTabs(DFStr, 2));
                continue;
            }
            sb.append(this.shiftStringByTabs(DFStr, 1));
        }
        return sb.toString();
    }

    private String shiftStringByTabs(String DFStr, int TabType) {
        StringBuilder sb = new StringBuilder();
        String[] spl = DFStr.split("\n");
        String tab = TabType == 1 ? this.TAB1 : this.TABMore;
        sb.append(spl[0] + "\n");
        for (int i = 1; i < spl.length; ++i) {
            sb.append(tab);
            sb.append(spl[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    private void dispTabs() {
        for (int i = 0; i < this.levelCntr; ++i) {
            System.out.print(this.TAB1);
        }
    }
}

