/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.logicalLayer.BinaryExpressionOperator;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class LORegexp
extends BinaryExpressionOperator {
    private static final long serialVersionUID = 2L;
    private static Log log = LogFactory.getLog(LORegexp.class);

    public LORegexp(LogicalPlan plan, OperatorKey key) {
        super(plan, key);
    }

    public ExpressionOperator getOperand() {
        return this.getLhsOperand();
    }

    public String getRegexp() {
        ExpressionOperator op = this.getRhsOperand();
        if (!(op instanceof LOConst)) {
            throw new RuntimeException("Regular expression patterns must be a constant.");
        }
        Object o = ((LOConst)op).getValue();
        if (!(o instanceof String)) {
            throw new RuntimeException("Regular expression patterns must be a string.");
        }
        return (String)o;
    }

    public String name() {
        return "Regexp " + this.mKey.scope + "-" + this.mKey.id;
    }

    public boolean supportsMultipleInputs() {
        return true;
    }

    public Schema getSchema() {
        return this.mSchema;
    }

    public Schema.FieldSchema getFieldSchema() throws FrontendException {
        if (!this.mIsFieldSchemaComputed) {
            this.mFieldSchema = new Schema.FieldSchema(null, 5);
            this.mFieldSchema.setParent(this.getLhsOperand().getFieldSchema().canonicalName, this.getLhsOperand());
            this.mFieldSchema.setParent(this.getRhsOperand().getFieldSchema().canonicalName, this.getRhsOperand());
            this.mIsFieldSchemaComputed = true;
        }
        return this.mFieldSchema;
    }

    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }
}

