/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanVisitor;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyOrderWalkerWOSeenChk<O extends Operator, P extends OperatorPlan<O>>
extends PlanWalker<O, P> {
    public DependencyOrderWalkerWOSeenChk(P plan) {
        super(plan);
    }

    @Override
    public void walk(PlanVisitor<O, P> visitor) throws VisitorException {
        ArrayList fifo = new ArrayList();
        HashSet seen = new HashSet();
        List leaves = this.mPlan.getLeaves();
        if (leaves == null) {
            return;
        }
        for (Operator op : leaves) {
            this.doAllPredecessors(op, seen, fifo);
        }
        for (Operator op : fifo) {
            op.visit(visitor);
        }
    }

    @Override
    public PlanWalker<O, P> spawnChildWalker(P plan) {
        return new DependencyOrderWalkerWOSeenChk<O, P>(plan);
    }

    private void doAllPredecessors(O node, Set<O> seen, Collection<O> fifo) throws VisitorException {
        Collection<Operator> preds = Utils.mergeCollection(this.mPlan.getPredecessors(node), this.mPlan.getSoftLinkPredecessors(node));
        if (preds != null && preds.size() > 0) {
            for (Operator op : preds) {
                this.doAllPredecessors(op, seen, fifo);
            }
        }
        seen.add(node);
        fifo.add(node);
    }
}

