/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen.physicalOperators;

import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.util.ExampleTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POCross
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    DataBag[] inputBags;
    Tuple[] data;
    transient Iterator[] its;

    public POCross(OperatorKey k) {
        super(k);
    }

    public POCross(OperatorKey k, int rp) {
        super(k, rp);
    }

    public POCross(OperatorKey k, List<PhysicalOperator> inp) {
        super(k, inp);
    }

    public POCross(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitPenCross(this);
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        Result res = new Result();
        int noItems = this.inputs.size();
        if (this.inputBags == null) {
            this.accumulateData();
        }
        if (this.its != null) {
            boolean finished = true;
            for (int i = 0; i < this.its.length; ++i) {
                finished &= !this.its[i].hasNext();
            }
            if (finished) {
                res.returnStatus = (byte)3;
                return res;
            }
        }
        if (this.data == null) {
            this.data = new Tuple[noItems];
            for (int i = 0; i < noItems; ++i) {
                this.data[i] = (Tuple)this.its[i].next();
            }
            res.result = this.CreateTuple(this.data);
            res.returnStatus = 0;
            return res;
        }
        for (int index = noItems - 1; index >= 0; --index) {
            if (this.its[index].hasNext()) {
                this.data[index] = (Tuple)this.its[index].next();
                res.result = this.CreateTuple(this.data);
                res.returnStatus = 0;
                return res;
            }
            this.its[index] = this.inputBags[index].iterator();
            this.data[index] = (Tuple)this.its[index].next();
        }
        return null;
    }

    private void accumulateData() throws ExecException {
        int count = 0;
        this.inputBags = new DataBag[this.inputs.size()];
        this.its = new Iterator[this.inputs.size()];
        for (PhysicalOperator op : this.inputs) {
            DataBag bag;
            this.inputBags[count] = bag = BagFactory.getInstance().newDefaultBag();
            Result res = op.getNext(dummyTuple);
            while (res.returnStatus != 3) {
                if (res.returnStatus != 1) {
                    if (res.returnStatus == 2) {
                        throw new ExecException("Error accumulating data in the local Cross operator");
                    }
                    if (res.returnStatus == 0) {
                        bag.add((Tuple)res.result);
                    }
                }
                res = op.getNext(dummyTuple);
            }
            this.its[count++] = bag.iterator();
        }
    }

    private Tuple CreateTuple(Tuple[] data) throws ExecException {
        Tuple out = TupleFactory.getInstance().newTuple();
        for (int i = 0; i < data.length; ++i) {
            Tuple t = data[i];
            int size = t.size();
            for (int j = 0; j < size; ++j) {
                out.append(t.get(j));
            }
        }
        if (this.lineageTracer != null) {
            ExampleTuple tOut = new ExampleTuple();
            tOut.reference(out);
            this.lineageTracer.insert(tOut);
            for (int i = 0; i < data.length; ++i) {
                this.lineageTracer.union(tOut, data[i]);
            }
            return tOut;
        }
        return out;
    }

    @Override
    public String name() {
        return this.getAliasString() + "POCrossLocal" + " - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }
}

