/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.pig.impl.PigContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptEngine {
    private static final Map<String, String> supportedScriptLangs = new HashMap<String, String>();
    public static final String namespaceSeparator = ".";

    public abstract void registerFunctions(String var1, String var2, PigContext var3) throws IOException;

    protected static String getJarPath(Class<?> clazz) throws FileNotFoundException {
        URL resource = clazz.getClassLoader().getResource(clazz.getCanonicalName().replace(namespaceSeparator, "/") + ".class");
        if (resource.getProtocol().equals("jar")) {
            return resource.getPath().substring(resource.getPath().indexOf(58) + 1, resource.getPath().indexOf(33));
        }
        throw new FileNotFoundException("Jar for " + clazz.getName() + " class is not found");
    }

    public static ScriptEngine getInstance(String scriptingLang) throws IOException {
        String scriptingEngine = scriptingLang;
        try {
            if (supportedScriptLangs.containsKey(scriptingLang)) {
                scriptingEngine = supportedScriptLangs.get(scriptingLang);
            }
            return (ScriptEngine)Class.forName(scriptingEngine).newInstance();
        }
        catch (Exception e) {
            throw new IOException("Could not load ScriptEngine: " + scriptingEngine + ": " + e);
        }
    }

    static {
        supportedScriptLangs.put("jython", "org.apache.pig.scripting.jython.JythonScriptEngine");
    }
}

