/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.boot;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.pentaho.reporting.libraries.base.boot.DefaultModuleInfo;
import org.pentaho.reporting.libraries.base.boot.Module;
import org.pentaho.reporting.libraries.base.boot.ModuleInfo;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializeException;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializer;
import org.pentaho.reporting.libraries.base.boot.SubSystem;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public abstract class AbstractModule
extends DefaultModuleInfo
implements Module {
    private static final ModuleInfo[] EMPTY_MODULEINFO = new ModuleInfo[0];
    private ModuleInfo[] requiredModules;
    private ModuleInfo[] optionalModules;
    private String name;
    private String description;
    private String producer;
    private String subsystem;

    protected AbstractModule() {
        this.setModuleClass(this.getClass().getName());
    }

    protected void loadModuleInfo() throws ModuleInitializeException {
        InputStream in = ObjectUtilities.getResourceRelativeAsStream("module.properties", this.getClass());
        if (in == null) {
            throw new ModuleInitializeException("File 'module.properties' not found in module package.");
        }
        this.loadModuleInfo(in);
    }

    protected void loadModuleInfo(InputStream in) throws ModuleInitializeException {
        if (in == null) {
            throw new NullPointerException("Given InputStream is null.");
        }
        try {
            DefaultConfiguration props = new DefaultConfiguration();
            props.load(in);
            this.readModuleInfo(props);
            ArrayList<DefaultModuleInfo> optionalModules = new ArrayList<DefaultModuleInfo>();
            ArrayList<DefaultModuleInfo> dependendModules = new ArrayList<DefaultModuleInfo>();
            Iterator keys = props.findPropertyKeys("dependency.");
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!key.endsWith(".dependency-type")) continue;
                String moduleHandle = key.substring(0, key.length() - ".dependency-type".length());
                DefaultModuleInfo module = this.readExternalModule(props, moduleHandle);
                if ("optional".equals(props.getConfigProperty(key))) {
                    optionalModules.add(module);
                    continue;
                }
                dependendModules.add(module);
            }
            this.optionalModules = optionalModules.toArray(new ModuleInfo[optionalModules.size()]);
            this.requiredModules = dependendModules.toArray(new ModuleInfo[dependendModules.size()]);
        }
        catch (IOException ioe) {
            throw new ModuleInitializeException("Failed to load properties", ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    private void readModuleInfo(Configuration config) {
        this.setName(config.getConfigProperty("module.name"));
        this.setProducer(config.getConfigProperty("module.producer"));
        this.setDescription(config.getConfigProperty("module.description"));
        this.setMajorVersion(config.getConfigProperty("module.version.major"));
        this.setMinorVersion(config.getConfigProperty("module.version.minor"));
        this.setPatchLevel(config.getConfigProperty("module.version.patchlevel"));
        this.setSubSystem(config.getConfigProperty("module.subsystem"));
    }

    private DefaultModuleInfo readExternalModule(Configuration reader, String prefix) {
        DefaultModuleInfo mi = new DefaultModuleInfo();
        mi.setModuleClass(reader.getConfigProperty(prefix + ".module"));
        mi.setMajorVersion(reader.getConfigProperty(prefix + ".version.major"));
        mi.setMinorVersion(reader.getConfigProperty(prefix + ".version.minor"));
        mi.setPatchLevel(reader.getConfigProperty(prefix + ".version.patchlevel"));
        return mi;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public String getProducer() {
        return this.producer;
    }

    protected void setProducer(String producer) {
        this.producer = producer;
    }

    public ModuleInfo[] getRequiredModules() {
        if (this.requiredModules == null) {
            return EMPTY_MODULEINFO;
        }
        ModuleInfo[] retval = new ModuleInfo[this.requiredModules.length];
        System.arraycopy(this.requiredModules, 0, retval, 0, this.requiredModules.length);
        return retval;
    }

    public ModuleInfo[] getOptionalModules() {
        if (this.optionalModules == null) {
            return EMPTY_MODULEINFO;
        }
        ModuleInfo[] retval = new ModuleInfo[this.optionalModules.length];
        System.arraycopy(this.optionalModules, 0, retval, 0, this.optionalModules.length);
        return retval;
    }

    protected void setRequiredModules(ModuleInfo[] requiredModules) {
        this.requiredModules = new ModuleInfo[requiredModules.length];
        System.arraycopy(requiredModules, 0, this.requiredModules, 0, requiredModules.length);
    }

    public void setOptionalModules(ModuleInfo[] optionalModules) {
        this.optionalModules = new ModuleInfo[optionalModules.length];
        System.arraycopy(optionalModules, 0, this.optionalModules, 0, optionalModules.length);
    }

    public String toString() {
        String lineSeparator = StringUtils.getLineSeparator();
        StringBuilder buffer = new StringBuilder(120);
        buffer.append("Module : ");
        buffer.append(this.getName());
        buffer.append(lineSeparator);
        buffer.append("ModuleClass : ");
        buffer.append(this.getModuleClass());
        buffer.append(lineSeparator);
        buffer.append("Version: ");
        buffer.append(this.getMajorVersion());
        buffer.append('.');
        buffer.append(this.getMinorVersion());
        buffer.append('.');
        buffer.append(this.getPatchLevel());
        buffer.append(lineSeparator);
        buffer.append("Producer: ");
        buffer.append(this.getProducer());
        buffer.append(lineSeparator);
        buffer.append("Description: ");
        buffer.append(this.getDescription());
        buffer.append(lineSeparator);
        return buffer.toString();
    }

    protected static boolean isClassLoadable(String name, Class context) {
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(context);
            Class.forName(name, false, loader);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(SubSystem subSystem) {
        InputStream in = ObjectUtilities.getResourceRelativeAsStream("configuration.properties", this.getClass());
        if (in == null) {
            return;
        }
        try {
            subSystem.getPackageManager().getPackageConfiguration().load(in);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void performExternalInitialize(String classname) throws ModuleInitializeException {
        try {
            ModuleInitializer mi = (ModuleInitializer)ObjectUtilities.loadAndInstantiate(classname, AbstractModule.class, ModuleInitializer.class);
            if (mi == null) {
                throw new ModuleInitializeException("Failed to load specified initializer class.");
            }
            mi.performInit();
        }
        catch (ModuleInitializeException mie) {
            throw mie;
        }
        catch (Exception e) {
            throw new ModuleInitializeException("Failed to load specified initializer class.", e);
        }
    }

    protected void performExternalInitialize(String classname, Class context) throws ModuleInitializeException {
        try {
            ModuleInitializer mi = (ModuleInitializer)ObjectUtilities.loadAndInstantiate(classname, context, ModuleInitializer.class);
            if (mi == null) {
                throw new ModuleInitializeException("Failed to load specified initializer class.");
            }
            mi.performInit();
        }
        catch (ModuleInitializeException mie) {
            throw mie;
        }
        catch (Exception e) {
            throw new ModuleInitializeException("Failed to load specified initializer class.", e);
        }
    }

    public String getSubSystem() {
        if (this.subsystem == null) {
            return this.getName();
        }
        return this.subsystem;
    }

    protected void setSubSystem(String name) {
        this.subsystem = name;
    }
}

