/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.UnsupportedEncodingException;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class PasswordObscurification {
    public static final String PASSWORD_ENCRYPTED_PREFIX = "Encrypted ";
    private static final String SEED = "3n%34kdim5*\ufffd89(10-9)^8B@4513";
    private static final String[] byteToText;

    private PasswordObscurification() {
    }

    public static int charToHex(int c) throws UnsupportedEncodingException {
        switch (c) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
        }
        throw new UnsupportedEncodingException();
    }

    public static String encryptPassword(String password) {
        if (password == null) {
            return null;
        }
        if (password.length() == 0) {
            return password;
        }
        try {
            byte[] val = password.getBytes("UTF-8");
            byte[] seed = SEED.getBytes("UTF-8");
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < val.length; ++i) {
                byte seedByte = seed[i % seed.length];
                int b1 = 0xFF & (val[i] ^ seedByte);
                b.append(byteToText[b1]);
            }
            return b.toString();
        }
        catch (UnsupportedEncodingException e) {
            return password;
        }
    }

    public static String decryptPassword(String encrypted) {
        if (encrypted == null) {
            return null;
        }
        if (encrypted.length() == 0) {
            return null;
        }
        try {
            byte[] seed = SEED.getBytes("UTF-8");
            char[] chars = encrypted.toCharArray();
            if (chars.length % 2 != 0) {
                return null;
            }
            byte[] b = new byte[chars.length / 2];
            for (int i = 0; i < b.length; ++i) {
                int c1 = PasswordObscurification.charToHex(chars[i * 2]);
                int c2 = PasswordObscurification.charToHex(chars[i * 2 + 1]);
                int encodedByte = c1 * 16 + c2;
                int encByte = 0xFF & encodedByte;
                b[i] = (byte)(encByte ^ seed[i % seed.length]);
            }
            return new String(b, "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String encryptPasswordWithOptionalEncoding(String password) {
        if (password == null) {
            return null;
        }
        String s = PasswordObscurification.encryptPassword(password);
        if (password.equals(s)) {
            return s;
        }
        return PASSWORD_ENCRYPTED_PREFIX + s;
    }

    public static String decryptPasswordWithOptionalEncoding(String password) {
        if (!StringUtils.isEmpty(password) && password.startsWith(PASSWORD_ENCRYPTED_PREFIX)) {
            return PasswordObscurification.decryptPassword(password.substring(PASSWORD_ENCRYPTED_PREFIX.length()));
        }
        return password;
    }

    static {
        int i;
        byteToText = new String[256];
        for (i = 0; i < 16; ++i) {
            PasswordObscurification.byteToText[i] = '0' + Integer.toHexString(i);
        }
        for (i = 16; i < 256; ++i) {
            PasswordObscurification.byteToText[i] = Integer.toHexString(i);
        }
    }
}

