/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.geo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pentaho.agilebi.modeler.ColumnBackedNode;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.geo.GeoRole;
import org.pentaho.agilebi.modeler.geo.LocationRole;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.AvailableTable;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaData;
import org.pentaho.agilebi.modeler.nodes.HierarchyMetaData;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.agilebi.modeler.nodes.MemberPropertyMetaData;
import org.pentaho.metadata.model.IPhysicalColumn;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.ui.xul.util.AbstractModelList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoContext
extends AbstractModelList<GeoRole> {
    protected static final String GEO_PREFIX = "geo.";
    protected static final String GEO_DIM_NAME = "geo.dimension.name";
    protected static final String GEO_ROLE_KEY = "geo.roles";
    protected static final String GEO_MATCH_SEPARATOR = "geo.matchSeparator";
    protected static final String ALIAS_SUFFIX = ".aliases";
    protected static final String REQUIRED_PARENTS_SUFFIX = ".required-parents";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String ANNOTATION_DATA_ROLE = "Data.Role";
    public static final String ANNOTATION_GEO_ROLE = "Geo.Role";
    public static final String ANNOTATION_GEO_PARENTS = "Geo.RequiredParents";
    protected String dimensionName = "Geography";

    public GeoRole getGeoRole(int index) {
        if (index >= 0 && this.children.size() >= index) {
            return (GeoRole)this.children.get(index);
        }
        return null;
    }

    public void addGeoRole(GeoRole geoRole) {
        if (geoRole != null) {
            this.children.add(geoRole);
        }
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public void setDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    public GeoRole matchFieldToGeoRole(AvailableField field) {
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            GeoRole role = (GeoRole)i$.next();
            if (role.evaluate(field.getPhysicalColumn().getId())) {
                return role;
            }
            if (!field.getPhysicalColumn().getId().startsWith("pc__") || !role.evaluate(field.getPhysicalColumn().getId().substring(4))) continue;
            return role;
        }
        return null;
    }

    public GeoRole matchColumnToGeoRole(IPhysicalColumn column) {
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            GeoRole role = (GeoRole)i$.next();
            if (!role.evaluate(column.getId())) continue;
            return role;
        }
        return null;
    }

    public List<DimensionMetaData> buildDimensions(ModelerWorkspace workspace) {
        ArrayList<DimensionMetaData> geoDims = new ArrayList<DimensionMetaData>();
        List<AvailableTable> tableList = workspace.getAvailableTables().getAsAvailableTablesList();
        String locale = workspace.getWorkspaceHelper().getLocale();
        for (AvailableTable table : tableList) {
            if (table.isFactTable()) continue;
            String dimName = tableList.size() == 1 ? this.getDimensionName() : table.getName() + ((GeoRole)this.get(0)).getMatchSeparator() + this.getDimensionName();
            for (IPhysicalColumn col : table.getPhysicalTable().getPhysicalColumns()) {
                if (!col.getId().equalsIgnoreCase(this.getDimensionName())) continue;
                dimName = dimName + "2";
            }
            DimensionMetaData dim = new DimensionMetaData(dimName);
            dim.getMemberAnnotations().put(ANNOTATION_DATA_ROLE, new GeoRole());
            HierarchyMetaData hier = new HierarchyMetaData(dimName);
            hier.getMemberAnnotations().put(ANNOTATION_DATA_ROLE, new GeoRole());
            ArrayList<LevelMetaData> levels = new ArrayList<LevelMetaData>();
            AvailableField locationField = null;
            LocationRole locationRole = this.getLocationRole();
            boolean locationFieldDetected = false;
            int latColIndex = 0;
            int lonColIndex = 0;
            int count = 0;
            for (IPhysicalColumn col : table.getPhysicalTable().getPhysicalColumns()) {
                AvailableField field = table.findFieldByPhysicalColumn(col);
                GeoRole role = this.matchFieldToGeoRole(field);
                String fieldName = col.getId();
                if (role != null) {
                    if (role instanceof LocationRole) {
                        locationFieldDetected = true;
                        if (locationRole.evaluateLatitude(fieldName)) {
                            latColIndex = count;
                        } else if (locationRole.evaluateLongitude(fieldName)) {
                            lonColIndex = count;
                        }
                    } else {
                        ColumnBackedNode node = workspace.createColumnBackedNode(field, ModelerPerspective.ANALYSIS);
                        LevelMetaData level = workspace.createLevelForParentWithNode(hier, node);
                        level.getMemberAnnotations().put(ANNOTATION_DATA_ROLE, role);
                        level.getMemberAnnotations().put(ANNOTATION_GEO_ROLE, role);
                        levels.add(level);
                    }
                }
                ++count;
            }
            if (locationFieldDetected) {
                locationField = this.determineLocationField(table, locationRole, latColIndex, lonColIndex, workspace.getWorkspaceHelper().getLocale());
            }
            if (levels.size() > 0) {
                for (int i = 0; i < this.size(); ++i) {
                    GeoRole knownRole = (GeoRole)this.get(i);
                    for (LevelMetaData level : levels) {
                        if (!knownRole.equals(level.getMemberAnnotations().get(ANNOTATION_GEO_ROLE))) continue;
                        if (locationFieldDetected && locationField != null && locationRole != null && latColIndex > -1 && lonColIndex > -1 && locationField.isSameUnderlyingPhysicalColumn(level.getLogicalColumn().getPhysicalColumn())) {
                            level.getMemberAnnotations().put(ANNOTATION_DATA_ROLE, locationRole);
                            level.getMemberAnnotations().put(ANNOTATION_GEO_ROLE, locationRole);
                            AvailableField latField = table.findFieldByPhysicalColumn((IPhysicalColumn)table.getPhysicalTable().getPhysicalColumns().get(latColIndex));
                            AvailableField lonField = table.findFieldByPhysicalColumn((IPhysicalColumn)table.getPhysicalTable().getPhysicalColumns().get(lonColIndex));
                            ColumnBackedNode tmp = workspace.createColumnBackedNode(latField, ModelerPerspective.ANALYSIS);
                            tmp.getLogicalColumn().setName(new LocalizedString(workspace.getWorkspaceHelper().getLocale(), LATITUDE));
                            MemberPropertyMetaData memberProp = workspace.createMemberPropertyForParentWithNode(level, tmp);
                            memberProp.setName(LATITUDE);
                            level.add(memberProp);
                            tmp = workspace.createColumnBackedNode(lonField, ModelerPerspective.ANALYSIS);
                            tmp.getLogicalColumn().setName(new LocalizedString(workspace.getWorkspaceHelper().getLocale(), LONGITUDE));
                            memberProp = workspace.createMemberPropertyForParentWithNode(level, tmp);
                            memberProp.setName(LONGITUDE);
                            level.add(memberProp);
                        }
                        if (hier.contains(level)) continue;
                        hier.add(level);
                    }
                }
                hier.setParent(dim);
                dim.add(hier);
                geoDims.add(dim);
            }
            if (!locationFieldDetected || locationField == null || locationRole == null) continue;
            Iterator i$ = workspace.getModel().getDimensions().iterator();
            while (i$.hasNext()) {
                DimensionMetaData existingDim = (DimensionMetaData)i$.next();
                Iterator i$2 = existingDim.iterator();
                while (i$2.hasNext()) {
                    HierarchyMetaData existingHier = (HierarchyMetaData)i$2.next();
                    Iterator i$3 = existingHier.iterator();
                    while (i$3.hasNext()) {
                        LevelMetaData existingLevel = (LevelMetaData)i$3.next();
                        if (!locationField.isSameUnderlyingPhysicalColumn(existingLevel.getLogicalColumn().getPhysicalColumn())) continue;
                        existingLevel.getMemberAnnotations().put(ANNOTATION_DATA_ROLE, locationRole);
                        existingLevel.getMemberAnnotations().put(ANNOTATION_GEO_ROLE, locationRole);
                        AvailableField latField = table.findFieldByPhysicalColumn((IPhysicalColumn)table.getPhysicalTable().getPhysicalColumns().get(latColIndex));
                        AvailableField lonField = table.findFieldByPhysicalColumn((IPhysicalColumn)table.getPhysicalTable().getPhysicalColumns().get(lonColIndex));
                        ColumnBackedNode tmp = workspace.createColumnBackedNode(latField, ModelerPerspective.ANALYSIS);
                        tmp.getLogicalColumn().setName(new LocalizedString(workspace.getWorkspaceHelper().getLocale(), LATITUDE));
                        MemberPropertyMetaData memberProp = workspace.createMemberPropertyForParentWithNode(existingLevel, tmp);
                        memberProp.setName(LATITUDE);
                        existingLevel.add(memberProp);
                        tmp = workspace.createColumnBackedNode(lonField, ModelerPerspective.ANALYSIS);
                        tmp.getLogicalColumn().setName(new LocalizedString(workspace.getWorkspaceHelper().getLocale(), LONGITUDE));
                        memberProp = workspace.createMemberPropertyForParentWithNode(existingLevel, tmp);
                        memberProp.setName(LONGITUDE);
                        existingLevel.add(memberProp);
                    }
                }
            }
        }
        if (geoDims.size() == 1) {
            String resetDimName = this.getDimensionName();
            if (((DimensionMetaData)geoDims.get(0)).getName().endsWith(resetDimName + "2")) {
                resetDimName = resetDimName + "2";
            }
            ((DimensionMetaData)geoDims.get(0)).setName(resetDimName);
            ((HierarchyMetaData)((DimensionMetaData)geoDims.get(0)).get(0)).setName(resetDimName);
        }
        return geoDims;
    }

    public LocationRole getLocationRole() {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!(this.get(i) instanceof LocationRole)) continue;
            return (LocationRole)this.get(i);
        }
        return null;
    }

    protected AvailableField determineLocationField(AvailableTable table, LocationRole locationRole, int latColIndex, int lonColIndex, String locale) {
        IPhysicalColumn col;
        AvailableField locationField = null;
        int count = table.getAvailableFields().size();
        String prefix = locationRole.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            for (AvailableField field : table.getAvailableFields()) {
                col = field.getPhysicalColumn();
                if (!prefix.equalsIgnoreCase(col.getName(locale))) continue;
                locationField = field;
            }
        }
        if (locationField == null) {
            int min = Math.min(latColIndex, lonColIndex);
            int max = Math.max(latColIndex, lonColIndex);
            if (min > 0) {
                col = (IPhysicalColumn)table.getPhysicalTable().getPhysicalColumns().get(min - 1);
                locationField = table.findFieldByPhysicalColumn(col);
            } else if (max < count) {
                col = (IPhysicalColumn)table.getPhysicalTable().getPhysicalColumns().get(max + 1);
                locationField = table.findFieldByPhysicalColumn(col);
            }
        }
        return locationField;
    }

    public GeoRole getGeoRoleByName(String name) {
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            GeoRole role = (GeoRole)i$.next();
            if (!role.getName().equalsIgnoreCase(name)) continue;
            return role;
        }
        return null;
    }
}

