/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.util;

import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.util.ISpoonModelerSource;
import org.pentaho.agilebi.modeler.util.ModelerSourceUtil;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.SqlDataSource;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.metadata.model.SqlPhysicalTable;
import org.pentaho.metadata.util.ThinModelConverter;

public class TableModelerSource
implements ISpoonModelerSource {
    private String datasourceName;
    private String tableName;
    private transient DatabaseMeta databaseMeta;
    private String schemaName;
    public static final String SOURCE_TYPE = TableModelerSource.class.getSimpleName();

    public TableModelerSource() {
    }

    public TableModelerSource(DatabaseMeta databaseMeta, String tableName, String schemaName) {
        this(databaseMeta, tableName, schemaName, tableName);
    }

    public TableModelerSource(DatabaseMeta databaseMeta, String tableName, String schemaName, String datasourceName) {
        this.tableName = tableName;
        this.databaseMeta = databaseMeta;
        this.schemaName = schemaName;
        this.datasourceName = datasourceName;
        if (schemaName == null) {
            this.schemaName = "";
        }
    }

    public String getDatabaseName() {
        return this.databaseMeta.getName();
    }

    public Domain generateDomain() throws ModelerException {
        return ModelerSourceUtil.generateDomain(this.databaseMeta, this.schemaName, this.tableName, this.datasourceName, true);
    }

    public Domain generateDomain(boolean dualModelingMode) throws ModelerException {
        return ModelerSourceUtil.generateDomain(this.databaseMeta, this.schemaName, this.tableName, this.datasourceName, dualModelingMode);
    }

    public void initialize(Domain domain) throws ModelerException {
        SqlPhysicalModel model = (SqlPhysicalModel)domain.getPhysicalModels().get(0);
        SqlPhysicalTable table = (SqlPhysicalTable)model.getPhysicalTables().get(0);
        String targetTable = (String)table.getProperty("target_table");
        if (!StringUtils.isEmpty((String)targetTable)) {
            domain.setId(targetTable);
        }
        this.databaseMeta = ThinModelConverter.convertToLegacy((String)model.getId(), (SqlDataSource)model.getDatasource());
        this.tableName = table.getTargetTable();
        this.schemaName = table.getTargetSchema();
        if (this.schemaName == null) {
            this.schemaName = "";
        }
    }

    public void serializeIntoDomain(Domain d) {
        LogicalModel lm = (LogicalModel)d.getLogicalModels().get(0);
        lm.setProperty("source_type", (Object)SOURCE_TYPE);
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSchemaName() {
        return this.schemaName == null ? "" : this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        if (schemaName == null) {
            schemaName = "";
        }
        this.schemaName = schemaName;
    }

    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }
}

