/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TableDragSourceEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XButtonEvent;
import org.eclipse.swt.internal.motif.XmDropFinishCallbackStruct;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DragSourceEffect dragEffect;
    static final String DEFAULT_DRAG_SOURCE_EFFECT = "DEFAULT_DRAG_SOURCE_EFFECT";
    static final String DRAGSOURCEID = "DragSource";
    static Callback ConvertProc;
    static Callback DragDropFinish;
    static Callback DropFinish;
    boolean moveRequested;
    int dragContext;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ConvertProc = new Callback(clazz3, "ConvertProcCallback", 10)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz2 = class$0) == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((DragDropFinish = new Callback(clazz2, "DragDropFinishCallback", 3)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((DropFinish = new Callback(clazz, "DropFinishCallback", 3)).getAddress() == 0) {
            SWT.error(3);
        }
    }

    public DragSource(Control control, int n) {
        super(control, DragSource.checkStyle(n));
        if (ConvertProc == null || DragDropFinish == null || DropFinish == null) {
            DND.error(2000);
        }
        this.control = control;
        if (control.getData(DRAGSOURCEID) != null) {
            DND.error(2000);
        }
        control.setData(DRAGSOURCEID, this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12 && !DragSource.this.isDisposed()) {
                    DragSource.this.dispose();
                }
                if (event.type == 29 && !DragSource.this.isDisposed()) {
                    DragSource.this.drag(event);
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DragSource.this.onDispose();
            }
        });
        Object object = control.getData(DEFAULT_DRAG_SOURCE_EFFECT);
        if (object instanceof DragSourceEffect) {
            this.dragEffect = (DragSourceEffect)object;
        } else if (control instanceof Tree) {
            this.dragEffect = new TreeDragSourceEffect((Tree)control);
        } else if (control instanceof Table) {
            this.dragEffect = new TableDragSourceEffect((Table)control);
        }
    }

    static DragSource FindDragSource(int n) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        return (DragSource)display.getData(Integer.toString(n));
    }

    static int ConvertProcCallback(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        DragSource dragSource = DragSource.FindDragSource(n);
        if (dragSource == null) {
            return 0;
        }
        return dragSource.convertProcCallback(n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    static int DragDropFinishCallback(int n, int n2, int n3) {
        DragSource dragSource = DragSource.FindDragSource(n);
        if (dragSource == null) {
            return 0;
        }
        return dragSource.dragDropFinishCallback(n, n2, n3);
    }

    static int DropFinishCallback(int n, int n2, int n3) {
        DragSource dragSource = DragSource.FindDragSource(n);
        if (dragSource == null) {
            return 0;
        }
        return dragSource.dropFinishCallback(n, n2, n3);
    }

    public void addDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dragSourceListener);
        dNDListener.dndWidget = this;
        this.addListener(2008, dNDListener);
        this.addListener(2001, dNDListener);
        this.addListener(2000, dNDListener);
    }

    static int checkStyle(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            DND.error(43);
        }
    }

    int convertProcCallback(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        Transfer transfer;
        if (n2 == 0) {
            return 0;
        }
        int[] nArray = new int[1];
        OS.memmove(nArray, n2, 4);
        int n11 = this.getDisplay().xDisplay;
        byte[] byArray = Converter.wcsToMbcs(null, "_MOTIF_DROP", true);
        int n12 = OS.XmInternAtom(n11, byArray, true);
        if (nArray[0] != n12) {
            return 0;
        }
        int[] nArray2 = new int[1];
        OS.memmove(nArray2, n3, 4);
        byArray = Converter.wcsToMbcs(null, "DELETE", true);
        int n13 = OS.XmInternAtom(n11, byArray, true);
        if (nArray2[0] == n13) {
            this.moveRequested = true;
            byArray = Converter.wcsToMbcs(null, "NULL", true);
            int n14 = OS.XmInternAtom(n11, byArray, true);
            OS.memmove(n4, new int[]{n14}, 4);
            OS.memmove(n5, new int[1], 4);
            OS.memmove(n6, new int[1], 4);
            OS.memmove(n7, new int[]{8}, 4);
            return 1;
        }
        boolean bl = false;
        TransferData transferData = new TransferData();
        transferData.type = nArray2[0];
        int n15 = 0;
        while (n15 < this.transferAgents.length) {
            transfer = this.transferAgents[n15];
            if (transfer != null && transfer.isSupportedType(transferData)) {
                bl = true;
                break;
            }
            ++n15;
        }
        if (!bl) {
            return 0;
        }
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this.control;
        dNDEvent.dataType = transferData;
        this.notifyListeners(2001, dNDEvent);
        transfer = null;
        int n16 = 0;
        while (n16 < this.transferAgents.length) {
            Transfer transfer2 = this.transferAgents[n16];
            if (transfer2 != null && transfer2.isSupportedType(transferData)) {
                transfer = transfer2;
                break;
            }
            ++n16;
        }
        if (transfer == null) {
            return 0;
        }
        transfer.javaToNative(dNDEvent.data, transferData);
        if (transferData.result == 1) {
            OS.memmove(n5, new int[]{transferData.pValue}, 4);
            OS.memmove(n4, new int[]{transferData.type}, 4);
            OS.memmove(n6, new int[]{transferData.length}, 4);
            OS.memmove(n7, new int[]{transferData.format}, 4);
            return 1;
        }
        OS.memmove(n5, new int[1], 4);
        OS.memmove(n6, new int[1], 4);
        OS.memmove(n7, new int[]{8}, 4);
        return 0;
    }

    void drag(Event event) {
        Object[] objectArray;
        this.moveRequested = false;
        Display display = this.control.getDisplay();
        XButtonEvent xButtonEvent = new XButtonEvent();
        OS.memmove(xButtonEvent, display.xEvent, 60);
        if (xButtonEvent.type != 4) {
            return;
        }
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.x = event.x;
        dNDEvent.y = event.y;
        dNDEvent.time = xButtonEvent.time;
        dNDEvent.doit = true;
        this.notifyListeners(2008, dNDEvent);
        if (!dNDEvent.doit || this.transferAgents == null || this.transferAgents.length == 0) {
            int n = xButtonEvent.time;
            int n2 = OS.XmGetDragContext(this.control.handle, n);
            if (n2 != 0) {
                OS.XmDragCancel(n2);
            }
            return;
        }
        TransferData[] transferDataArray = new TransferData[]{};
        int n = 0;
        while (n < this.transferAgents.length) {
            Transfer transfer = this.transferAgents[n];
            if (transfer != null) {
                objectArray = transfer.getSupportedTypes();
                TransferData[] transferDataArray2 = new TransferData[transferDataArray.length + objectArray.length];
                System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray.length);
                System.arraycopy(objectArray, 0, transferDataArray2, transferDataArray.length, objectArray.length);
                transferDataArray = transferDataArray2;
            }
            ++n;
        }
        int[] nArray = new int[transferDataArray.length];
        int n3 = 0;
        while (n3 < transferDataArray.length) {
            nArray[n3] = transferDataArray[n3].type;
            ++n3;
        }
        n3 = OS.XtMalloc(nArray.length * 4);
        OS.memmove(n3, nArray, nArray.length * 4);
        int[] nArray2 = new int[18];
        nArray2[0] = OS.XmNexportTargets;
        nArray2[1] = n3;
        nArray2[2] = OS.XmNnumExportTargets;
        nArray2[3] = nArray.length;
        nArray2[4] = OS.XmNdragOperations;
        nArray2[5] = this.opToOsOp(this.getStyle());
        nArray2[6] = OS.XmNconvertProc;
        nArray2[7] = ConvertProc.getAddress();
        nArray2[8] = OS.XmNoperationCursorIcon;
        nArray2[10] = OS.XmNsourceCursorIcon;
        nArray2[12] = OS.XmNstateCursorIcon;
        nArray2[14] = OS.XmNclientData;
        nArray2[16] = OS.XmNblendModel;
        objectArray = nArray2;
        int n4 = xButtonEvent.time;
        this.dragContext = OS.XmGetDragContext(this.control.handle, n4);
        if (this.dragContext != 0) {
            OS.XtSetValues(this.dragContext, (int[])objectArray, objectArray.length / 2);
        } else {
            this.dragContext = OS.XmDragStart(this.control.handle, display.xEvent, (int[])objectArray, objectArray.length / 2);
        }
        OS.XtFree(n3);
        if (this.dragContext == 0) {
            return;
        }
        OS.XtAddCallback(this.dragContext, OS.XmNdragDropFinishCallback, DragDropFinish.getAddress(), 0);
        OS.XtAddCallback(this.dragContext, OS.XmNdropFinishCallback, DropFinish.getAddress(), 0);
        display.setData(Integer.toString(this.dragContext), this);
    }

    int dragDropFinishCallback(int n, int n2, int n3) {
        this.dragContext = 0;
        this.getDisplay().setData(Integer.toString(this.dragContext), null);
        return 0;
    }

    int dropFinishCallback(int n, int n2, int n3) {
        XmDropFinishCallbackStruct xmDropFinishCallbackStruct = new XmDropFinishCallbackStruct();
        OS.memmove(xmDropFinishCallbackStruct, n3, 20);
        if (xmDropFinishCallbackStruct.dropAction != 0 || xmDropFinishCallbackStruct.dropSiteStatus != 3) {
            DNDEvent dNDEvent = new DNDEvent();
            dNDEvent.widget = this.control;
            dNDEvent.time = xmDropFinishCallbackStruct.timeStamp;
            dNDEvent.detail = 0;
            dNDEvent.doit = false;
            this.notifyListeners(2000, dNDEvent);
            return 0;
        }
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this.control;
        dNDEvent.time = xmDropFinishCallbackStruct.timeStamp;
        dNDEvent.detail = this.moveRequested ? 2 : (xmDropFinishCallbackStruct.operation == 1 ? 0 : this.osOpToOp(xmDropFinishCallbackStruct.operation));
        dNDEvent.doit = xmDropFinishCallbackStruct.completionStatus != 0;
        this.notifyListeners(2000, dNDEvent);
        this.moveRequested = false;
        return 0;
    }

    public Control getControl() {
        return this.control;
    }

    public DragSourceEffect getDragSourceEffect() {
        return this.dragEffect;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData(DRAGSOURCEID, null);
        this.control = null;
        this.transferAgents = null;
    }

    byte opToOsOp(int n) {
        byte by = 0;
        if ((n & 1) == 1) {
            by = (byte)(by | 2);
        }
        if ((n & 2) == 2) {
            by = (byte)(by | 1);
        }
        if ((n & 4) == 4) {
            by = (byte)(by | 4);
        }
        return by;
    }

    int osOpToOp(byte by) {
        int n = 0;
        if ((by & 2) == 2) {
            n |= 1;
        }
        if ((by & 1) == 1) {
            n |= 2;
        }
        if ((by & 4) == 4) {
            n |= 4;
        }
        return n;
    }

    public void removeDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        this.removeListener(2008, dragSourceListener);
        this.removeListener(2001, dragSourceListener);
        this.removeListener(2000, dragSourceListener);
    }

    public void setDragSourceEffect(DragSourceEffect dragSourceEffect) {
        this.dragEffect = dragSourceEffect;
    }

    public void setTransfer(Transfer[] transferArray) {
        this.transferAgents = transferArray;
    }
}

