/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XmDragProcCallbackStruct;
import org.eclipse.swt.internal.motif.XmDropProcCallbackStruct;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    TransferData selectedDataType;
    int selectedOperation;
    long dragOverStart;
    Runnable dragOverHeartbeat;
    DNDEvent dragOverEvent;
    XmDropProcCallbackStruct droppedEventData;
    int dropTransferObject;
    int selectionTimeout;
    boolean registered = false;
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";
    static int DELETE_TYPE;
    static int NULL_TYPE;
    static final String DROPTARGETID = "DropTarget";
    static final int DRAGOVER_HYSTERESIS = 50;
    static Callback DropProc;
    static Callback DragProc;
    static Callback TransferProc;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz;
        Class<?> clazz2;
        DELETE_TYPE = Transfer.registerType("DELETE\u0000");
        NULL_TYPE = Transfer.registerType("NULL\u0000");
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((DropProc = new Callback(clazz3, "DropProcCallback", 3)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz2 = class$0) == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((DragProc = new Callback(clazz2, "DragProcCallback", 3)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((TransferProc = new Callback(clazz, "TransferProcCallback", 7)).getAddress() == 0) {
            SWT.error(3);
        }
    }

    public DropTarget(Control control, int n) {
        super(control, DropTarget.checkStyle(n));
        this.control = control;
        if (DropProc == null || DragProc == null || TransferProc == null) {
            DND.error(2001);
        }
        if (control.getData(DROPTARGETID) != null) {
            DND.error(2001);
        }
        control.setData(DROPTARGETID, this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        if (DropTarget.this.isDisposed()) break;
                        DropTarget.this.onDispose();
                        break;
                    }
                    case 22: {
                        if (!DropTarget.this.registered) {
                            DropTarget.this.registerDropTarget();
                            break;
                        }
                        int[] nArray = new int[2];
                        nArray[0] = OS.XmNdropSiteActivity;
                        int[] nArray2 = nArray;
                        OS.XmDropSiteUpdate(DropTarget.this.control.handle, nArray2, nArray2.length / 2);
                        if (!(DropTarget.this.control instanceof Label)) break;
                        int n = OS.XtParent(DropTarget.this.control.handle);
                        OS.XmDropSiteUpdate(n, nArray2, nArray2.length / 2);
                        break;
                    }
                    case 23: {
                        int[] nArray = new int[]{OS.XmNdropSiteActivity, 1};
                        OS.XmDropSiteUpdate(DropTarget.this.control.handle, nArray, nArray.length / 2);
                        if (!(DropTarget.this.control instanceof Label)) break;
                        int n = OS.XtParent(DropTarget.this.control.handle);
                        OS.XmDropSiteUpdate(n, nArray, nArray.length / 2);
                    }
                }
            }
        };
        control.addListener(12, this.controlListener);
        Control control2 = control;
        while (control2 != null) {
            control2.addListener(22, this.controlListener);
            control2.addListener(23, this.controlListener);
            control2 = control2.getParent();
        }
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (DropTarget.this.control == null || DropTarget.this.control.isDisposed()) {
                    return;
                }
                DropTarget.this.unregisterDropTarget();
                DropTarget.this.onDispose();
            }
        });
        Object object = control.getData(DEFAULT_DROP_TARGET_EFFECT);
        if (object instanceof DropTargetEffect) {
            this.dropEffect = (DropTargetEffect)object;
        } else if (control instanceof Table) {
            this.dropEffect = new TableDropTargetEffect((Table)control);
        } else if (control instanceof Tree) {
            this.dropEffect = new TreeDropTargetEffect((Tree)control);
        }
        if (control.isVisible()) {
            this.registerDropTarget();
        }
        this.dragOverHeartbeat = new Runnable(){

            public void run() {
                Control control = DropTarget.this.control;
                if (control == null || control.isDisposed() || DropTarget.this.dragOverStart == 0L) {
                    return;
                }
                long l = System.currentTimeMillis();
                int n = 50;
                if (l < DropTarget.this.dragOverStart) {
                    n = (int)(DropTarget.this.dragOverStart - l);
                } else {
                    int n2 = DropTarget.this.dragOverEvent.operations;
                    TransferData[] transferDataArray = DropTarget.this.dragOverEvent.dataTypes;
                    TransferData[] transferDataArray2 = new TransferData[transferDataArray.length];
                    System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray2.length);
                    DNDEvent dNDEvent = new DNDEvent();
                    dNDEvent.widget = DropTarget.this.dragOverEvent.widget;
                    dNDEvent.x = DropTarget.this.dragOverEvent.x;
                    dNDEvent.y = DropTarget.this.dragOverEvent.y;
                    dNDEvent.time = (int)l;
                    dNDEvent.feedback = 1;
                    dNDEvent.dataTypes = transferDataArray2;
                    dNDEvent.dataType = DropTarget.this.selectedDataType;
                    dNDEvent.operations = DropTarget.this.dragOverEvent.operations;
                    dNDEvent.detail = DropTarget.this.selectedOperation;
                    if (DropTarget.this.dropEffect != null) {
                        dNDEvent.item = DropTarget.this.dropEffect.getItem(DropTarget.this.dragOverEvent.x, DropTarget.this.dragOverEvent.y);
                    }
                    DropTarget.this.notifyListeners(2004, dNDEvent);
                    DropTarget.this.selectedDataType = null;
                    if (dNDEvent.dataType != null) {
                        int n3 = 0;
                        while (n3 < transferDataArray.length) {
                            if (transferDataArray[n3].type == dNDEvent.dataType.type) {
                                DropTarget.this.selectedDataType = dNDEvent.dataType;
                                break;
                            }
                            ++n3;
                        }
                    }
                    DropTarget.this.selectedOperation = 0;
                    if (DropTarget.this.selectedDataType != null && (dNDEvent.detail & n2) != 0) {
                        DropTarget.this.selectedOperation = dNDEvent.detail;
                    }
                }
                control = DropTarget.this.control;
                if (control == null || control.isDisposed()) {
                    return;
                }
                control.getDisplay().timerExec(n, DropTarget.this.dragOverHeartbeat);
            }
        };
    }

    static int checkStyle(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    static int DragProcCallback(int n, int n2, int n3) {
        DropTarget dropTarget = DropTarget.FindDropTarget(n);
        if (dropTarget != null) {
            dropTarget.dragProcCallback(n, n2, n3);
        }
        return 0;
    }

    static int DropProcCallback(int n, int n2, int n3) {
        DropTarget dropTarget = DropTarget.FindDropTarget(n);
        if (dropTarget != null) {
            dropTarget.dropProcCallback(n, n2, n3);
        }
        return 0;
    }

    static DropTarget FindDropTarget(int n) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return null;
        }
        return (DropTarget)widget.getData(DROPTARGETID);
    }

    static int TransferProcCallback(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        DropTarget dropTarget = DropTarget.FindDropTarget(n2);
        if (dropTarget != null) {
            dropTarget.transferProcCallback(n, n2, n3, n4, n5, n6, n7);
        }
        return 0;
    }

    public void addDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dropTargetListener);
        dNDListener.dndWidget = this;
        this.addListener(2002, dNDListener);
        this.addListener(2003, dNDListener);
        this.addListener(2004, dNDListener);
        this.addListener(2005, dNDListener);
        this.addListener(2006, dNDListener);
        this.addListener(2007, dNDListener);
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            DND.error(43);
        }
    }

    void dragProcCallback(int n, int n2, int n3) {
        DNDEvent dNDEvent;
        if (n3 == 0) {
            return;
        }
        XmDragProcCallbackStruct xmDragProcCallbackStruct = new XmDragProcCallbackStruct();
        OS.memmove(xmDragProcCallbackStruct, n3, 24);
        if (xmDragProcCallbackStruct.reason == 1) {
            this.updateDragOverHover(0L, null);
            if (xmDragProcCallbackStruct.dropSiteStatus == 2) {
                return;
            }
            DNDEvent dNDEvent2 = new DNDEvent();
            dNDEvent2.widget = this;
            dNDEvent2.time = xmDragProcCallbackStruct.timeStamp;
            dNDEvent2.detail = 0;
            this.notifyListeners(2003, dNDEvent2);
            return;
        }
        if (xmDragProcCallbackStruct.reason == 2) {
            this.selectedDataType = null;
            this.selectedOperation = 0;
            this.droppedEventData = null;
            this.dropTransferObject = 0;
        }
        if (!this.setEventData(xmDragProcCallbackStruct.operations, xmDragProcCallbackStruct.operation, xmDragProcCallbackStruct.dragContext, xmDragProcCallbackStruct.x, xmDragProcCallbackStruct.y, xmDragProcCallbackStruct.timeStamp, dNDEvent = new DNDEvent())) {
            xmDragProcCallbackStruct.dropSiteStatus = (byte)2;
            xmDragProcCallbackStruct.operation = this.opToOsOp(0);
            OS.memmove(n3, xmDragProcCallbackStruct, 24);
            return;
        }
        int n4 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        switch (xmDragProcCallbackStruct.reason) {
            case 2: {
                dNDEvent.type = 2002;
                break;
            }
            case 3: {
                dNDEvent.type = 2004;
                dNDEvent.dataType = this.selectedDataType;
                dNDEvent.detail = this.selectedOperation;
                break;
            }
            case 8: {
                dNDEvent.type = 2005;
                dNDEvent.dataType = this.selectedDataType;
            }
        }
        this.updateDragOverHover(50L, dNDEvent);
        this.notifyListeners(dNDEvent.type, dNDEvent);
        if (dNDEvent.detail == 16) {
            dNDEvent.detail = (n4 & 2) != 0 ? 2 : 0;
        }
        this.selectedDataType = null;
        if (dNDEvent.dataType != null) {
            int n5 = 0;
            while (n5 < transferDataArray.length) {
                if (transferDataArray[n5].type == dNDEvent.dataType.type) {
                    this.selectedDataType = transferDataArray[n5];
                    break;
                }
                ++n5;
            }
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (n4 & dNDEvent.detail) != 0) {
            this.selectedOperation = dNDEvent.detail;
        }
        xmDragProcCallbackStruct.dropSiteStatus = (byte)3;
        xmDragProcCallbackStruct.operation = this.opToOsOp(this.selectedOperation);
        OS.memmove(n3, xmDragProcCallbackStruct, 24);
        if (xmDragProcCallbackStruct.reason == 2) {
            this.dragOverHeartbeat.run();
        }
    }

    void dropProcCallback(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        this.droppedEventData = new XmDropProcCallbackStruct();
        OS.memmove(this.droppedEventData, n3, 24);
        if (this.droppedEventData.dropSiteStatus == 2) {
            int[] nArray = new int[4];
            nArray[0] = OS.XmNtransferStatus;
            nArray[2] = OS.XmNnumDropTransfers;
            int[] nArray2 = nArray;
            this.dropTransferObject = OS.XmDropTransferStart(this.droppedEventData.dragContext, nArray2, nArray2.length / 2);
            return;
        }
        DNDEvent dNDEvent = new DNDEvent();
        if (!this.setEventData(this.droppedEventData.operations, this.droppedEventData.operation, this.droppedEventData.dragContext, this.droppedEventData.x, this.droppedEventData.y, this.droppedEventData.timeStamp, dNDEvent)) {
            return;
        }
        int n4 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.detail = this.selectedOperation;
        this.notifyListeners(2007, dNDEvent);
        this.selectedDataType = null;
        if (dNDEvent.dataType != null) {
            int n5 = 0;
            while (n5 < transferDataArray.length) {
                if (transferDataArray[n5].type == dNDEvent.dataType.type) {
                    this.selectedDataType = transferDataArray[n5];
                    break;
                }
                ++n5;
            }
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (dNDEvent.detail & n4) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        if (this.selectedOperation == 0) {
            int[] nArray = new int[4];
            nArray[0] = OS.XmNtransferStatus;
            nArray[2] = OS.XmNnumDropTransfers;
            int[] nArray3 = nArray;
            this.dropTransferObject = OS.XmDropTransferStart(this.droppedEventData.dragContext, nArray3, nArray3.length / 2);
            return;
        }
        int[] nArray = new int[]{this.control.handle, this.selectedDataType.type};
        int n6 = OS.XtMalloc(nArray.length * 4);
        OS.memmove(n6, nArray, nArray.length * 4);
        int n7 = OS.XtDisplayToApplicationContext(this.getDisplay().xDisplay);
        this.selectionTimeout = OS.XtAppGetSelectionTimeout(n7);
        OS.XtAppSetSelectionTimeout(n7, Integer.MAX_VALUE);
        int[] nArray4 = new int[]{OS.XmNdropTransfers, n6, OS.XmNnumDropTransfers, nArray.length / 2, OS.XmNtransferProc, TransferProc.getAddress()};
        this.dropTransferObject = OS.XmDropTransferStart(this.droppedEventData.dragContext, nArray4, nArray4.length / 2);
        OS.XtFree(n6);
    }

    public Control getControl() {
        return this.control;
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            Control control = this.control;
            while (control != null) {
                control.removeListener(22, this.controlListener);
                control.removeListener(23, this.controlListener);
                control = control.getParent();
            }
            this.control.removeListener(12, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData(DROPTARGETID, null);
        this.control = null;
        this.transferAgents = null;
    }

    byte opToOsOp(int n) {
        byte by = 0;
        if ((n & 1) == 1) {
            by = (byte)(by | 2);
        }
        if ((n & 2) == 2) {
            by = (byte)(by | 1);
        }
        if ((n & 4) == 4) {
            by = (byte)(by | 4);
        }
        return by;
    }

    int osOpToOp(byte by) {
        int n = 0;
        if ((by & 2) == 2) {
            n |= 1;
        }
        if ((by & 1) == 1) {
            n |= 2;
        }
        if ((by & 4) == 4) {
            n |= 4;
        }
        return n;
    }

    void registerDropTarget() {
        if (this.control == null || this.control.isDisposed() || this.registered) {
            return;
        }
        int[] nArray = new int[12];
        nArray[0] = OS.XmNdropSiteOperations;
        nArray[1] = this.opToOsOp(this.getStyle());
        nArray[2] = OS.XmNdropSiteActivity;
        nArray[4] = OS.XmNdropProc;
        nArray[5] = DropProc.getAddress();
        nArray[6] = OS.XmNdragProc;
        nArray[7] = DragProc.getAddress();
        nArray[8] = OS.XmNanimationStyle;
        nArray[10] = OS.XmNdropSiteType;
        nArray[11] = 1;
        Object[] objectArray = nArray;
        if (this.transferAgents != null && this.transferAgents.length != 0) {
            Object[] objectArray2;
            TransferData[] transferDataArray = new TransferData[]{};
            int n = 0;
            int n2 = this.transferAgents.length;
            while (n < n2) {
                Transfer transfer = this.transferAgents[n];
                if (transfer != null) {
                    objectArray2 = transfer.getSupportedTypes();
                    TransferData[] transferDataArray2 = new TransferData[transferDataArray.length + objectArray2.length];
                    System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray.length);
                    System.arraycopy(objectArray2, 0, transferDataArray2, transferDataArray.length, objectArray2.length);
                    transferDataArray = transferDataArray2;
                }
                ++n;
            }
            int[] nArray2 = new int[transferDataArray.length];
            n2 = 0;
            int n3 = transferDataArray.length;
            while (n2 < n3) {
                nArray2[n2] = transferDataArray[n2].type;
                ++n2;
            }
            n2 = OS.XtMalloc(nArray2.length * 4);
            OS.memmove(n2, nArray2, nArray2.length * 4);
            int[] nArray3 = new int[]{OS.XmNimportTargets, n2, OS.XmNnumImportTargets, nArray2.length};
            objectArray2 = new int[objectArray.length + nArray3.length];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            System.arraycopy(nArray3, 0, objectArray2, objectArray.length, nArray3.length);
            objectArray = objectArray2;
        }
        OS.XmDropSiteRegister(this.control.handle, objectArray, objectArray.length / 2);
        if (this.control instanceof Label) {
            int n = OS.XtParent(this.control.handle);
            OS.XmDropSiteRegister(n, objectArray, objectArray.length / 2);
        }
        this.registered = true;
    }

    public void removeDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        this.removeListener(2002, dropTargetListener);
        this.removeListener(2003, dropTargetListener);
        this.removeListener(2004, dropTargetListener);
        this.removeListener(2005, dropTargetListener);
        this.removeListener(2006, dropTargetListener);
        this.removeListener(2007, dropTargetListener);
    }

    public void setDropTargetEffect(DropTargetEffect dropTargetEffect) {
        this.dropEffect = dropTargetEffect;
    }

    boolean setEventData(byte by, byte by2, int n, short s, short s2, int n2, DNDEvent dNDEvent) {
        int n3 = this.getStyle();
        int n4 = this.osOpToOp(by) & n3;
        if (n4 == 0) {
            return false;
        }
        int n5 = this.osOpToOp(by2);
        int n6 = this.getDisplay().xDisplay;
        int n7 = OS.XDefaultRootWindow(n6);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.XQueryPointer(n6, n7, nArray, nArray, nArray, nArray, nArray, nArray, nArray2);
        int n8 = nArray2[0];
        if ((n8 & 1) == 0 && (n8 & 4) == 0) {
            n5 = 16;
        }
        if (n5 == 16) {
            if ((n3 & 0x10) == 0) {
                n5 = (n4 & 2) != 0 ? 2 : 0;
            }
        } else if ((n5 & n4) == 0) {
            n5 = 0;
        }
        int n9 = OS.XtMalloc(4);
        int n10 = OS.XtMalloc(4);
        int[] nArray3 = new int[]{OS.XmNexportTargets, n9, OS.XmNnumExportTargets, n10};
        OS.XtGetValues(n, nArray3, nArray3.length / 2);
        int[] nArray4 = new int[1];
        OS.memmove(nArray4, n10, 4);
        OS.XtFree(n10);
        int[] nArray5 = new int[1];
        OS.memmove(nArray5, n9, 4);
        OS.XtFree(n9);
        int[] nArray6 = new int[nArray4[0]];
        OS.memmove(nArray6, nArray5[0], 4 * nArray4[0]);
        TransferData[] transferDataArray = new TransferData[]{};
        int n11 = 0;
        while (n11 < nArray6.length) {
            int n12 = 0;
            while (n12 < this.transferAgents.length) {
                TransferData transferData = new TransferData();
                transferData.type = nArray6[n11];
                Transfer transfer = this.transferAgents[n12];
                if (transfer != null && transfer.isSupportedType(transferData)) {
                    TransferData[] transferDataArray2 = new TransferData[transferDataArray.length + 1];
                    System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray.length);
                    transferDataArray2[transferDataArray.length] = transferData;
                    transferDataArray = transferDataArray2;
                    break;
                }
                ++n12;
            }
            ++n11;
        }
        if (transferDataArray.length == 0) {
            return false;
        }
        short[] sArray = new short[1];
        short[] sArray2 = new short[1];
        OS.XtTranslateCoords(this.control.handle, s, s2, sArray, sArray2);
        dNDEvent.widget = this;
        dNDEvent.x = sArray[0];
        dNDEvent.y = sArray2[0];
        dNDEvent.time = n2;
        dNDEvent.feedback = 1;
        dNDEvent.dataTypes = transferDataArray;
        dNDEvent.dataType = transferDataArray[0];
        dNDEvent.operations = n4;
        dNDEvent.detail = n5;
        if (this.dropEffect != null) {
            dNDEvent.item = this.dropEffect.getItem(dNDEvent.x, dNDEvent.y);
        }
        return true;
    }

    public void setTransfer(Transfer[] transferArray) {
        if (transferArray == null) {
            DND.error(4);
        }
        this.transferAgents = transferArray;
        if (!this.control.isVisible()) {
            return;
        }
        TransferData[] transferDataArray = new TransferData[]{};
        int n = 0;
        int n2 = transferArray.length;
        while (n < n2) {
            Transfer transfer = transferArray[n];
            if (transfer != null) {
                TransferData[] transferDataArray2 = transfer.getSupportedTypes();
                TransferData[] transferDataArray3 = new TransferData[transferDataArray.length + transferDataArray2.length];
                System.arraycopy(transferDataArray, 0, transferDataArray3, 0, transferDataArray.length);
                System.arraycopy(transferDataArray2, 0, transferDataArray3, transferDataArray.length, transferDataArray2.length);
                transferDataArray = transferDataArray3;
            }
            ++n;
        }
        int[] nArray = new int[transferDataArray.length];
        n2 = 0;
        int n3 = transferDataArray.length;
        while (n2 < n3) {
            nArray[n2] = transferDataArray[n2].type;
            ++n2;
        }
        n2 = OS.XtMalloc(nArray.length * 4);
        OS.memmove(n2, nArray, nArray.length * 4);
        int[] nArray2 = new int[]{OS.XmNimportTargets, n2, OS.XmNnumImportTargets, nArray.length};
        OS.XmDropSiteUpdate(this.control.handle, nArray2, nArray2.length / 2);
        if (this.control instanceof Label) {
            int n4 = OS.XtParent(this.control.handle);
            OS.XmDropSiteUpdate(n4, nArray2, nArray2.length / 2);
        }
        OS.XtFree(n2);
    }

    void transferProcCallback(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Object object;
        if (n4 == 0 || n5 == 0 || n6 == 0 || n7 == 0) {
            return;
        }
        int[] nArray = new int[1];
        OS.memmove(nArray, n4, 4);
        if (nArray[0] == NULL_TYPE) {
            return;
        }
        DNDEvent dNDEvent = new DNDEvent();
        if (!this.setEventData(this.droppedEventData.operations, this.droppedEventData.operation, this.droppedEventData.dragContext, this.droppedEventData.x, this.droppedEventData.y, this.droppedEventData.timeStamp, dNDEvent)) {
            return;
        }
        int n8 = dNDEvent.operations;
        Object object2 = null;
        TransferData transferData = new TransferData();
        int[] nArray2 = new int[1];
        OS.memmove(nArray2, n6, 4);
        int[] nArray3 = new int[1];
        OS.memmove(nArray3, n7, 4);
        transferData.type = nArray[0];
        transferData.length = nArray2[0];
        transferData.pValue = n5;
        transferData.format = nArray3[0];
        int n9 = 0;
        while (n9 < this.transferAgents.length) {
            object = this.transferAgents[n9];
            if (object != null && ((Transfer)object).isSupportedType(transferData)) {
                object2 = ((Transfer)object).nativeToJava(transferData);
                break;
            }
            ++n9;
        }
        OS.XtFree(n5);
        if (object2 == null) {
            this.selectedOperation = 0;
        }
        dNDEvent.detail = this.selectedOperation;
        dNDEvent.dataType = transferData;
        dNDEvent.data = object2;
        this.notifyListeners(2006, dNDEvent);
        this.selectedOperation = 0;
        if ((n8 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        n9 = OS.XtDisplayToApplicationContext(this.getDisplay().xDisplay);
        OS.XtAppSetSelectionTimeout(n9, this.selectionTimeout);
        if ((this.selectedOperation & 2) == 2) {
            object = new int[]{this.control.handle, DELETE_TYPE};
            OS.XmDropTransferAdd(this.dropTransferObject, (int[])object, ((Object)object).length / 2);
        }
    }

    void unregisterDropTarget() {
        if (this.control == null || this.control.isDisposed() || !this.registered) {
            return;
        }
        OS.XmDropSiteUnregister(this.control.handle);
        if (this.control instanceof Label) {
            int n = OS.XtParent(this.control.handle);
            OS.XmDropSiteUnregister(n);
        }
        this.registered = false;
    }

    void updateDragOverHover(long l, DNDEvent dNDEvent) {
        if (l == 0L) {
            this.dragOverStart = 0L;
            this.dragOverEvent = null;
            return;
        }
        this.dragOverStart = System.currentTimeMillis() + l;
        if (this.dragOverEvent == null) {
            this.dragOverEvent = new DNDEvent();
        }
        this.dragOverEvent.x = dNDEvent.x;
        this.dragOverEvent.y = dNDEvent.y;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        this.dragOverEvent.dataTypes = transferDataArray;
        this.dragOverEvent.operations = dNDEvent.operations;
    }
}

