/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XColor;

public abstract class Device
implements Drawable {
    public int xDisplay;
    public boolean setDPI;
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    String display_name;
    String application_name;
    String application_class;
    XColor[] xcolors;
    int[] colorRefCount;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    int shellHandle;
    boolean useXRender;
    static boolean CAIRO_LOADED;
    int tabPointer;
    int crPointer;
    public int tabMapping;
    public int crMapping;
    boolean warnings = true;
    Callback xtWarningCallback;
    Callback xtErrorCallback;
    int xtWarningProc;
    int xtErrorProc;
    int xtNullWarningProc;
    int xtNullErrorProc;
    static Callback XErrorCallback;
    static Callback XIOErrorCallback;
    static int XErrorProc;
    static int XIOErrorProc;
    static int XNullErrorProc;
    static int XNullIOErrorProc;
    static Device[] Devices;
    static final Object CREATE_LOCK;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static {
        Devices = new Device[4];
        CREATE_LOCK = new Object();
        OS.XtToolkitInitialize();
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (Throwable throwable) {}
    }

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData deviceData) {
        Object object = CREATE_LOCK;
        synchronized (object) {
            if (deviceData != null) {
                this.display_name = deviceData.display_name;
                this.application_name = deviceData.application_name;
                this.application_class = deviceData.application_class;
                this.tracking = deviceData.tracking;
                this.debug = deviceData.debug;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
            }
            this.create(deviceData);
            this.init();
            Device.register(this);
            this.systemFont = this.getSystemFont();
        }
    }

    void checkCairo() {
        if (CAIRO_LOADED) {
            return;
        }
        try {
            byte[] byArray = Converter.wcsToMbcs(null, "libcairo.so.2", true);
            int n = OS.dlopen(byArray, 1);
            if (n != 0) {
                OS.dlclose(n);
            } else {
                try {
                    System.loadLibrary("cairo-swt");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            }
            Class.forName("org.eclipse.swt.internal.cairo.Cairo");
            CAIRO_LOADED = true;
        }
        catch (Throwable throwable) {
            SWT.error(16, throwable, " [Cairo required]");
        }
    }

    protected void checkDevice() {
        if (this.xDisplay == 0) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData deviceData) {
    }

    static synchronized void deregister(Device device) {
        int n = 0;
        while (n < Devices.length) {
            if (device == Devices[n]) {
                Device.Devices[n] = null;
            }
            ++n;
        }
    }

    protected void destroy() {
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.checkDevice();
        this.release();
        this.destroy();
        Device.deregister(this);
        this.xDisplay = 0;
        if (this.tracking) {
            this.objects = null;
            this.errors = null;
        }
    }

    void dispose_Object(Object object) {
        int n = 0;
        while (n < this.objects.length) {
            if (this.objects[n] == object) {
                this.objects[n] = null;
                this.errors[n] = null;
                return;
            }
            ++n;
        }
    }

    static synchronized Device findDevice(int n) {
        int n2 = 0;
        while (n2 < Devices.length) {
            Device device = Devices[n2];
            if (device != null && device.xDisplay == n) {
                return device;
            }
            ++n2;
        }
        return null;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int n = OS.XDefaultScreen(this.xDisplay);
        int n2 = OS.XDisplayWidth(this.xDisplay, n);
        int n3 = OS.XDisplayHeight(this.xDisplay, n);
        return new Rectangle(0, 0, n2, n3);
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        int n = OS.XDefaultScreenOfDisplay(this.xDisplay);
        return OS.XDefaultDepthOfScreen(n);
    }

    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData deviceData = new DeviceData();
        deviceData.display_name = this.display_name;
        deviceData.application_name = this.application_name;
        deviceData.application_class = this.application_class;
        deviceData.debug = this.debug;
        deviceData.tracking = this.tracking;
        int n = 0;
        int n2 = 0;
        if (this.tracking) {
            n2 = this.objects.length;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.objects[n3] != null) {
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        deviceData.objects = new Object[n];
        deviceData.errors = new Error[n];
        int n4 = 0;
        while (n4 < n2) {
            if (this.objects[n4] != null) {
                deviceData.objects[n3] = this.objects[n4];
                deviceData.errors[n3] = this.errors[n4];
                ++n3;
            }
            ++n4;
        }
        return deviceData;
    }

    public Point getDPI() {
        this.checkDevice();
        int n = OS.XDefaultScreen(this.xDisplay);
        int n2 = OS.XDisplayWidth(this.xDisplay, n);
        int n3 = OS.XDisplayHeight(this.xDisplay, n);
        int n4 = OS.XDisplayWidthMM(this.xDisplay, n);
        int n5 = OS.XDisplayHeightMM(this.xDisplay, n);
        double d = (double)n4 * 0.03937;
        double d2 = (double)n5 * 0.03937;
        int n6 = (int)((double)n2 / d + 0.5);
        int n7 = (int)((double)n3 / d2 + 0.5);
        return new Point(n6, n7);
    }

    public FontData[] getFontList(String string, boolean bl) {
        int n;
        int n2;
        this.checkDevice();
        String string2 = string == null ? "-*-*-*-*-*-*-*-*-*-*-*-*-*-*" : ((n2 = string.indexOf(45)) < 0 ? "-*-" + string + "-*-*-*-*-*-*-*-*-*-*-*-*" : "-" + string + "-*-*-*-*-*-*-*-*-*-*-*-*");
        byte[] byArray = Converter.wcsToMbcs(null, string2, true);
        int[] nArray = new int[1];
        int n3 = n = OS.XListFonts(this.xDisplay, byArray, 65535, nArray);
        int[] nArray2 = new int[1];
        FontData[] fontDataArray = new FontData[nArray[0]];
        int n4 = 0;
        int n5 = 0;
        while (n5 < nArray[0]) {
            OS.memmove(nArray2, n3, 4);
            int n6 = nArray2[0];
            int n7 = OS.strlen(n6);
            byte[] byArray2 = new byte[n7];
            OS.memmove(byArray2, n6, n7);
            char[] cArray = Converter.mbcsToWcs(null, byArray2);
            try {
                boolean bl2;
                FontData fontData = FontData.motif_new(new String(cArray));
                boolean bl3 = bl2 = fontData.averageWidth == 0 && fontData.pixels == 0 && fontData.points == 0;
                if (bl2 == bl) {
                    fontDataArray[n4++] = fontData;
                }
            }
            catch (Exception exception) {}
            n3 += 4;
            ++n5;
        }
        OS.XFreeFontNames(n);
        if (n4 == nArray[0]) {
            return fontDataArray;
        }
        FontData[] fontDataArray2 = new FontData[n4];
        System.arraycopy(fontDataArray, 0, fontDataArray2, 0, n4);
        return fontDataArray2;
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        switch (n) {
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this._getWarnings();
    }

    boolean _getWarnings() {
        return this.warnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        int[] nArray;
        Object object;
        int[] nArray2;
        int[] nArray3;
        if (this.debug) {
            OS.XSynchronize(this.xDisplay, true);
        }
        if (OS.XRenderQueryExtension(this.xDisplay, nArray3 = new int[1], nArray2 = new int[1])) {
            object = new int[1];
            nArray = new int[1];
            OS.XRenderQueryVersion(this.xDisplay, object, nArray);
            this.useXRender = object[0] > 0 || object[0] == 0 && nArray[0] >= 8;
        }
        object = this.getClass();
        nArray = object;
        synchronized (object) {
            int n;
            if (XErrorCallback == null) {
                XErrorCallback = new Callback(object, "XErrorProc", 2);
                XNullErrorProc = XErrorCallback.getAddress();
                if (XNullErrorProc == 0) {
                    SWT.error(3);
                }
                XErrorProc = OS.XSetErrorHandler(XNullErrorProc);
            }
            if (XIOErrorCallback == null) {
                XIOErrorCallback = new Callback(object, "XIOErrorProc", 1);
                XNullIOErrorProc = XIOErrorCallback.getAddress();
                if (XNullIOErrorProc == 0) {
                    SWT.error(3);
                }
                XIOErrorProc = OS.XSetIOErrorHandler(XNullIOErrorProc);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.xtWarningCallback = new Callback(this, "xtWarningProc", 1);
            this.xtNullWarningProc = this.xtWarningCallback.getAddress();
            if (this.xtNullWarningProc == 0) {
                SWT.error(3);
            }
            this.xtErrorCallback = new Callback(this, "xtErrorProc", 1);
            this.xtNullErrorProc = this.xtErrorCallback.getAddress();
            if (this.xtNullErrorProc == 0) {
                SWT.error(3);
            }
            int n2 = OS.XtDisplayToApplicationContext(this.xDisplay);
            this.xtWarningProc = OS.XtAppSetWarningHandler(n2, this.xtNullWarningProc);
            this.xtErrorProc = OS.XtAppSetErrorHandler(n2, this.xtNullErrorProc);
            int n3 = OS.XDefaultScreenOfDisplay(this.xDisplay);
            int n4 = OS.XDefaultDepthOfScreen(n3);
            if (n4 <= 8) {
                n = 1 << n4;
                this.colorRefCount = new int[n];
                this.xcolors = new XColor[n];
            }
            this.COLOR_BLACK = new Color(this, 0, 0, 0);
            this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
            this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
            this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
            this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
            this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
            this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
            this.COLOR_GRAY = new Color(this, 192, 192, 192);
            this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
            this.COLOR_RED = new Color(this, 255, 0, 0);
            this.COLOR_GREEN = new Color(this, 0, 255, 0);
            this.COLOR_YELLOW = new Color(this, 255, 255, 0);
            this.COLOR_BLUE = new Color(this, 0, 0, 255);
            this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
            this.COLOR_CYAN = new Color(this, 0, 255, 255);
            this.COLOR_WHITE = new Color(this, 255, 255, 255);
            n = OS.topLevelShellWidgetClass();
            this.shellHandle = OS.XtAppCreateShell(null, null, n, this.xDisplay, null, 0);
            if (this.shellHandle == 0) {
                SWT.error(2);
            }
            byte[] byArray = new byte[2];
            byArray[0] = 9;
            byte[] byArray2 = byArray;
            this.tabPointer = OS.XtMalloc(byArray2.length);
            OS.memmove(this.tabPointer, byArray2, byArray2.length);
            int n5 = OS.XmStringComponentCreate(12, 0, null);
            int[] nArray4 = new int[]{OS.XmNpattern, this.tabPointer, OS.XmNsubstitute, n5};
            this.tabMapping = OS.XmParseMappingCreate(nArray4, nArray4.length / 2);
            OS.XmStringFree(n5);
            byte[] byArray3 = new byte[2];
            byArray3[0] = 10;
            byte[] byArray4 = byArray3;
            this.crPointer = OS.XtMalloc(byArray4.length);
            OS.memmove(this.crPointer, byArray4, byArray4.length);
            int n6 = OS.XmStringComponentCreate(4, 0, null);
            nArray4 = new int[]{OS.XmNpattern, this.crPointer, OS.XmNsubstitute, n6};
            this.crMapping = OS.XmParseMappingCreate(nArray4, nArray4.length / 2);
            OS.XmStringFree(n6);
            return;
        }
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    public boolean isDisposed() {
        return this.xDisplay == 0;
    }

    public boolean loadFont(String string) {
        this.checkDevice();
        if (string == null) {
            SWT.error(4);
        }
        return false;
    }

    void new_Object(Object object) {
        int n = 0;
        while (n < this.objects.length) {
            if (this.objects[n] == null) {
                this.objects[n] = object;
                this.errors[n] = new Error();
                return;
            }
            ++n;
        }
        Object[] objectArray = new Object[this.objects.length + 128];
        System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
        objectArray[this.objects.length] = object;
        this.objects = objectArray;
        Error[] errorArray = new Error[this.errors.length + 128];
        System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
        errorArray[this.errors.length] = new Error();
        this.errors = errorArray;
    }

    static synchronized void register(Device device) {
        int n = 0;
        while (n < Devices.length) {
            if (Devices[n] == null) {
                Device.Devices[n] = device;
                return;
            }
            ++n;
        }
        Device[] deviceArray = new Device[Devices.length + 4];
        System.arraycopy(Devices, 0, deviceArray, 0, Devices.length);
        deviceArray[Device.Devices.length] = device;
        Devices = deviceArray;
    }

    protected void release() {
        int n;
        int n2;
        OS.XtFree(this.tabPointer);
        OS.XtFree(this.crPointer);
        OS.XmParseMappingFree(this.tabMapping);
        OS.XmParseMappingFree(this.crMapping);
        this.crMapping = 0;
        this.tabMapping = 0;
        this.crPointer = 0;
        this.tabPointer = 0;
        if (this.shellHandle != 0) {
            OS.XtDestroyWidget(this.shellHandle);
        }
        this.shellHandle = 0;
        if (this.xcolors != null) {
            n2 = OS.XDefaultScreen(this.xDisplay);
            n = OS.XDefaultColormap(this.xDisplay, n2);
            int[] nArray = new int[1];
            int n3 = 0;
            while (n3 < this.xcolors.length) {
                XColor xColor = this.xcolors[n3];
                if (xColor != null) {
                    nArray[0] = xColor.pixel;
                    while (this.colorRefCount[n3] > 0) {
                        OS.XFreeColors(this.xDisplay, n, nArray, 1, 0);
                        int n4 = n3;
                        this.colorRefCount[n4] = this.colorRefCount[n4] - 1;
                    }
                }
                ++n3;
            }
        }
        this.xcolors = null;
        this.colorRefCount = null;
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
        n2 = OS.XtDisplayToApplicationContext(this.xDisplay);
        OS.XtAppSetErrorHandler(n2, this.xtErrorProc);
        this.xtErrorCallback.dispose();
        this.xtErrorCallback = null;
        this.xtErrorProc = 0;
        this.xtNullErrorProc = 0;
        OS.XtAppSetWarningHandler(n2, this.xtWarningProc);
        this.xtWarningCallback.dispose();
        this.xtWarningCallback = null;
        this.xtWarningProc = 0;
        this.xtNullWarningProc = 0;
        n = 0;
        int n5 = 0;
        while (n5 < Devices.length) {
            if (Devices[n5] != null) {
                ++n;
            }
            ++n5;
        }
        if (n == 1) {
            OS.XSetIOErrorHandler(XIOErrorProc);
            XIOErrorCallback.dispose();
            XIOErrorCallback = null;
            XIOErrorProc = 0;
            XNullIOErrorProc = 0;
            this.warnings = false;
        }
    }

    public void setWarnings(boolean bl) {
        this.checkDevice();
        this._setWarnings(bl);
    }

    void _setWarnings(boolean bl) {
        this.warnings = bl;
    }

    static int XErrorProc(int n, int n2) {
        Device device = Device.findDevice(n);
        if (device != null) {
            if (device.warnings) {
                if (DEBUG || device.debug) {
                    new SWTError().printStackTrace();
                }
                OS.Call(XErrorProc, n, n2);
            }
        } else {
            if (DEBUG) {
                new SWTError().printStackTrace();
            }
            OS.Call(XErrorProc, n, n2);
        }
        return 0;
    }

    static int XIOErrorProc(int n) {
        Device device = Device.findDevice(n);
        if (device != null) {
            if (DEBUG || device.debug) {
                new SWTError().printStackTrace();
            }
        } else if (DEBUG) {
            new SWTError().printStackTrace();
        }
        OS.Call(XIOErrorProc, n, 0);
        return 0;
    }

    int xtErrorProc(int n) {
        if (DEBUG || this.debug) {
            new SWTError().printStackTrace();
        }
        OS.Call(this.xtErrorProc, n, 0);
        return 0;
    }

    int xtWarningProc(int n) {
        if (this.warnings) {
            if (DEBUG || this.debug) {
                new SWTError().printStackTrace();
            }
            OS.Call(this.xtWarningProc, n, 0);
        }
        return 0;
    }
}

