/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFontStruct;

public final class Font
extends Resource {
    public int handle;
    public String codePage;

    Font() {
    }

    public Font(Device device, FontData fontData) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (fontData == null) {
            SWT.error(4);
        }
        this.init(device, new FontData[]{fontData});
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Font(Device device, FontData[] fontDataArray) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (fontDataArray == null) {
            SWT.error(4);
        }
        if (fontDataArray.length == 0) {
            SWT.error(5);
        }
        int n = 0;
        while (n < fontDataArray.length) {
            if (fontDataArray[n] == null) {
                SWT.error(4);
            }
            ++n;
        }
        this.init(device, fontDataArray);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Font(Device device, String string, int n, int n2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.init(device, new FontData[]{new FontData(string, n, n2)});
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    Font(Device device, String string, float f, int n) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.init(device, new FontData[]{new FontData(string, f, n)});
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        if (this.handle == this.device.systemFont.handle) {
            return;
        }
        OS.XmFontListFree(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return this.device == font.device && this.handle == font.handle;
    }

    static String getCodePage(int n, int n2) {
        int n3;
        int[] nArray = new int[1];
        if (!OS.XmFontListInitFontContext(nArray, n2)) {
            return null;
        }
        int n4 = nArray[0];
        XFontStruct xFontStruct = new XFontStruct();
        String string = null;
        block0: while ((n3 = OS.XmFontListNextEntry(n4)) != 0) {
            int n5;
            Object[] objectArray;
            int n6;
            int n7;
            int n8 = OS.XmFontListEntryGetFont(n3, nArray);
            if (nArray[0] == 0) {
                OS.memmove(xFontStruct, n8, 80);
                n7 = xFontStruct.properties;
                n6 = 0;
                while (n6 < xFontStruct.n_properties) {
                    objectArray = new int[2];
                    OS.memmove((int[])objectArray, n7, 8);
                    if (objectArray[0] == 18) {
                        n5 = OS.XmGetAtomName(n, objectArray[1]);
                        int n9 = OS.strlen(n5);
                        byte[] byArray = new byte[n9];
                        OS.memmove(byArray, n5, n9);
                        String string2 = new String(Converter.mbcsToWcs(null, byArray)).toLowerCase();
                        int n10 = string2.lastIndexOf(45);
                        if (n10 != -1 && n10 > 0 && (n10 = string2.lastIndexOf(45, n10 - 1)) != -1 && (string = string2.substring(n10 + 1, string2.length())).indexOf("iso") == 0) {
                            if (OS.IsLinux) {
                                string = "ISO-" + string.substring(3, string.length());
                            }
                            if (OS.IsAIX) {
                                string = "ISO" + string.substring(3, string.length());
                            }
                            if (OS.IsHPUX && (n10 = string.lastIndexOf(45)) != -1) {
                                string = String.valueOf(string.substring(0, n10)) + string.substring(n10 + 1, string.length());
                            }
                        }
                        OS.XtFree(n5);
                        continue block0;
                    }
                    n7 += 8;
                    ++n6;
                }
                continue;
            }
            n7 = OS.XLocaleOfFontSet(n8);
            n6 = OS.strlen(n7);
            objectArray = new byte[n6 + 1];
            OS.memmove(objectArray, n7, n6);
            OS.setlocale(OS.LC_CTYPE, objectArray);
            n5 = OS.nl_langinfo(OS.CODESET);
            n6 = OS.strlen(n5);
            byte[] byArray = new byte[n6];
            OS.memmove(byArray, n5, n6);
            string = new String(Converter.mbcsToWcs(null, byArray));
            OS.setlocale(OS.LC_CTYPE, new byte[1]);
        }
        OS.XmFontListFreeFontContext(n4);
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        var1_1 = this.device.xDisplay;
        var2_2 = new int[1];
        if (!OS.XmFontListInitFontContext(var2_2, this.handle)) {
            SWT.error(48);
        }
        var3_3 = var2_2[0];
        var4_4 = new XFontStruct();
        var6_5 = new int[1];
        var7_6 = new int[1];
        var8_7 = new FontData[]{};
        try {
            try {
                block7: while (true) {
                    block18: {
                        if ((var5_8 = OS.XmFontListNextEntry(var3_3)) != 0) break block18;
                        if (var8_7.length == 0) {
                            SWT.error(48);
                        }
                        break;
                    }
                    var9_9 = OS.XmFontListEntryGetFont(var5_8, var2_2);
                    if (var2_2[0] == 0) {
                        OS.memmove(var4_4, var9_9, 80);
                        var10_10 = var4_4.properties;
                        var11_11 = 0;
                        while (true) {
                            if (var11_11 >= var4_4.n_properties) continue block7;
                            var12_13 = new int[2];
                            OS.memmove(var12_13, var10_10, 8);
                            if (var12_13[0] == 18) {
                                var13_15 = OS.XmGetAtomName(var1_1, var12_13[1]);
                                var14_16 = OS.strlen(var13_15);
                                var15_17 /* !! */  = new byte[var14_16];
                                OS.memmove(var15_17 /* !! */ , var13_15, var14_16);
                                OS.XtFree(var13_15);
                                var16_18 = new String(Converter.mbcsToWcs(null, var15_17 /* !! */ )).toLowerCase();
                                var17_20 = new FontData[var8_7.length + 1];
                                System.arraycopy(var8_7, 0, var17_20, 0, var8_7.length);
                                var17_20[var17_20.length - 1] = FontData.motif_new(var16_18);
                                var8_7 = var17_20;
                                continue block7;
                            }
                            var10_10 += 8;
                            ++var11_11;
                        }
                    }
                    var10_10 = OS.XFontsOfFontSet(var9_9, var6_5, var7_6);
                    var11_12 = new int[var10_10];
                    OS.memmove(var11_12, var6_5[0], var10_10 * 4);
                    var12_14 = 0;
                    while (true) {
                        if (var12_14 < var10_10) ** break;
                        continue block7;
                        OS.memmove(var4_4, var11_12[var12_14], 80);
                        var13_15 = var4_4.properties;
                        var14_16 = 0;
                        while (var14_16 < var4_4.n_properties) {
                            var15_17 /* !! */  = (byte[])new int[2];
                            OS.memmove((int[])var15_17 /* !! */ , var13_15, 8);
                            if (var15_17 /* !! */ [0] == 18) {
                                block17: {
                                    var16_19 = OS.XmGetAtomName(var1_1, var15_17 /* !! */ [1]);
                                    var17_21 = OS.strlen(var16_19);
                                    var18_22 = new byte[var17_21];
                                    OS.memmove(var18_22, var16_19, var17_21);
                                    OS.XFree(var16_19);
                                    var19_23 = new String(Converter.mbcsToWcs(null, var18_22)).toLowerCase();
                                    var20_24 = new FontData[var8_7.length + 1];
                                    System.arraycopy(var8_7, 0, var20_24, 0, var8_7.length);
                                    try {
                                        var20_24[var20_24.length - 1] = FontData.motif_new(var19_23);
                                    }
                                    catch (Exception v0) {
                                        var21_25 = new int[1];
                                        OS.memmove(var21_25, var7_6[0] + var12_14 * 4, 4);
                                        var16_19 = var21_25[0];
                                        if (var16_19 == 0) break block17;
                                        var17_21 = OS.strlen(var16_19);
                                        var18_22 = new byte[var17_21];
                                        OS.memmove(var18_22, var16_19, var17_21);
                                        var19_23 = new String(Converter.mbcsToWcs(null, var18_22)).toLowerCase();
                                        var20_24[var20_24.length - 1] = FontData.motif_new(var19_23);
                                    }
                                }
                                var8_7 = var20_24;
                                break;
                            }
                            var13_15 += 8;
                            ++var14_16;
                        }
                        ++var12_14;
                    }
                    break;
                }
            }
            catch (Exception v1) {
                SWT.error(48);
            }
        }
        catch (Throwable var23_26) {
            var22_27 = null;
            OS.XmFontListFreeFontContext(var3_3);
            throw var23_26;
        }
        {
            var22_28 = null;
        }
        OS.XmFontListFreeFontContext(var3_3);
        return var8_7;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Device device, FontData[] fontDataArray) {
        int n;
        byte[] byArray;
        int n2;
        Object object;
        CharSequence charSequence;
        Object object2;
        this.device = device;
        FontData fontData = fontDataArray[0];
        if (fontData.lang != null) {
            String string = fontData.lang;
            object2 = fontData.country;
            charSequence = fontData.variant;
            object = string;
            if (object2 != null) {
                object = String.valueOf(object) + "_" + (String)object2;
            }
            if (charSequence != null) {
                object = String.valueOf(object) + "." + (String)charSequence;
            }
            n2 = ((String)object).length();
            byArray = new byte[n2 + 1];
            n = 0;
            while (n < n2) {
                byArray[n] = (byte)((String)object).charAt(n);
                ++n;
            }
            OS.setlocale(OS.LC_CTYPE, byArray);
        }
        int n3 = 1;
        if (OS.IsHPUX) {
            int n4 = OS.setlocale(OS.LC_CTYPE, null);
            int n5 = OS.strlen(n4);
            object = new byte[n5];
            OS.memmove((byte[])object, n4, n5);
            if ("C".equals(new String(Converter.mbcsToWcs(null, (byte[])object)))) {
                n3 = 0;
            }
        }
        object2 = null;
        if (device.setDPI) {
            object2 = device.getDPI();
        }
        charSequence = new StringBuffer();
        int n6 = 0;
        while (n6 < fontDataArray.length) {
            if (n6 != 0) {
                ((StringBuffer)charSequence).append(',');
            }
            FontData fontData2 = fontDataArray[n6];
            int n7 = fontData2.horizontalResolution;
            n = fontData2.verticalResolution;
            if (object2 != null) {
                fontData2.horizontalResolution = ((Point)object2).x;
                fontData2.verticalResolution = ((Point)object2).y;
            }
            ((StringBuffer)charSequence).append(fontData2.getXlfd());
            fontData2.horizontalResolution = n7;
            fontData2.verticalResolution = n;
            ++n6;
        }
        FontData fontData3 = new FontData();
        fontData3.points = fontData.points;
        if (n3 == 1) {
            if (OS.IsAIX && OS.IsDBLocale) {
                ((StringBuffer)charSequence).append(',');
                ((StringBuffer)charSequence).append(fontData3.getXlfd());
            } else {
                fontData3.weight = fontData.weight;
                fontData3.slant = fontData.slant;
                ((StringBuffer)charSequence).append(',');
                ((StringBuffer)charSequence).append(fontData3.getXlfd());
                fontData3.weight = null;
                fontData3.slant = null;
                ((StringBuffer)charSequence).append(',');
                ((StringBuffer)charSequence).append(fontData3.getXlfd());
            }
        }
        n2 = device._getWarnings() ? 1 : 0;
        device._setWarnings(false);
        byArray = Converter.wcsToMbcs(null, ((StringBuffer)charSequence).toString(), true);
        n = OS.XmFontListEntryLoad(device.xDisplay, byArray, n3, OS.XmFONTLIST_DEFAULT_TAG);
        device._setWarnings(n2 != 0);
        if (n != 0) {
            this.handle = OS.XmFontListAppendEntry(0, n);
            OS.XmFontListEntryFree(new int[]{n});
            int n8 = OS.nl_langinfo(OS.CODESET);
            int n9 = OS.strlen(n8);
            byArray = new byte[n9];
            OS.memmove(byArray, n8, n9);
            this.codePage = new String(Converter.mbcsToWcs(null, byArray));
        } else {
            Font font = device.systemFont;
            this.handle = font.handle;
            this.codePage = font.codePage;
        }
        if (fontData.lang != null) {
            OS.setlocale(OS.LC_CTYPE, new byte[0]);
        }
        if (this.handle == 0) {
            SWT.error(2);
        }
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public static Font motif_new(Device device, int n) {
        if (device == null) {
            device = Device.getDevice();
        }
        Font font = new Font();
        font.device = device;
        font.handle = n;
        font.codePage = Font.getCodePage(device.xDisplay, n);
        return font;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }
}

