/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XRectangle;

public final class Region
extends Resource {
    public int handle;

    public Region() {
        this(null);
    }

    public Region(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.handle = OS.XCreateRegion();
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    Region(Device device, int n) {
        this.device = device;
        this.handle = n;
    }

    public void add(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        short[] sArray = new short[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            sArray[n] = (short)nArray[n];
            ++n;
        }
        n = OS.XPolygonRegion(sArray, sArray.length / 2, 0);
        OS.XUnionRegion(this.handle, n, this.handle);
        OS.XDestroyRegion(n);
    }

    public void add(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.add(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void add(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        XRectangle xRectangle = new XRectangle();
        xRectangle.x = (short)n;
        xRectangle.y = (short)n2;
        xRectangle.width = (short)n3;
        xRectangle.height = (short)n4;
        OS.XUnionRectWithRegion(xRectangle, this.handle, this.handle);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.XUnionRegion(this.handle, region.handle, this.handle);
    }

    public boolean contains(int n, int n2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.XPointInRegion(this.handle, n, n2);
    }

    public boolean contains(Point point) {
        if (point == null) {
            SWT.error(4);
        }
        return this.contains(point.x, point.y);
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        OS.XDestroyRegion(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        XRectangle xRectangle = new XRectangle();
        OS.XClipBox(this.handle, xRectangle);
        return new Rectangle(xRectangle.x, xRectangle.y, xRectangle.width, xRectangle.height);
    }

    public int hashCode() {
        return this.handle;
    }

    public void intersect(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.intersect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void intersect(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        int n5 = OS.XCreateRegion();
        XRectangle xRectangle = new XRectangle();
        xRectangle.x = (short)n;
        xRectangle.y = (short)n2;
        xRectangle.width = (short)n3;
        xRectangle.height = (short)n4;
        OS.XUnionRectWithRegion(xRectangle, n5, n5);
        OS.XIntersectRegion(this.handle, n5, this.handle);
        OS.XDestroyRegion(n5);
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.XIntersectRegion(this.handle, region.handle, this.handle);
    }

    public boolean intersects(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.XRectInRegion(this.handle, n, n2, n3, n4) != 0;
    }

    public boolean intersects(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        return this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.XEmptyRegion(this.handle);
    }

    public static Region motif_new(Device device, int n) {
        return new Region(device, n);
    }

    public void subtract(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        short[] sArray = new short[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            sArray[n] = (short)nArray[n];
            ++n;
        }
        n = OS.XPolygonRegion(sArray, sArray.length / 2, 0);
        OS.XSubtractRegion(this.handle, n, this.handle);
        OS.XDestroyRegion(n);
    }

    public void subtract(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.subtract(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void subtract(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        int n5 = OS.XCreateRegion();
        XRectangle xRectangle = new XRectangle();
        xRectangle.x = (short)n;
        xRectangle.y = (short)n2;
        xRectangle.width = (short)n3;
        xRectangle.height = (short)n4;
        OS.XUnionRectWithRegion(xRectangle, n5, n5);
        OS.XSubtractRegion(this.handle, n5, this.handle);
        OS.XDestroyRegion(n5);
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.XSubtractRegion(this.handle, region.handle, this.handle);
    }

    public void translate(int n, int n2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.XOffsetRegion(this.handle, n, n2);
    }

    public void translate(Point point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        this.translate(point.x, point.y);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

