/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.opengl;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XSetWindowAttributes;
import org.eclipse.swt.internal.opengl.glx.GLX;
import org.eclipse.swt.internal.opengl.glx.XVisualInfo;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GLCanvas
extends Canvas {
    int xWindow;
    int context;
    int colormap;
    XVisualInfo vinfo;
    static final int MAX_ATTRIBUTES = 32;

    public GLCanvas(Composite composite, int n, GLData gLData) {
        super(composite, n);
        if (gLData == null) {
            SWT.error(4);
        }
        int[] nArray = new int[32];
        int n2 = 0;
        nArray[n2++] = 4;
        if (gLData.doubleBuffer) {
            nArray[n2++] = 5;
        }
        if (gLData.stereo) {
            nArray[n2++] = 6;
        }
        if (gLData.redSize > 0) {
            nArray[n2++] = 8;
            nArray[n2++] = gLData.redSize;
        }
        if (gLData.greenSize > 0) {
            nArray[n2++] = 9;
            nArray[n2++] = gLData.greenSize;
        }
        if (gLData.blueSize > 0) {
            nArray[n2++] = 10;
            nArray[n2++] = gLData.blueSize;
        }
        if (gLData.alphaSize > 0) {
            nArray[n2++] = 11;
            nArray[n2++] = gLData.alphaSize;
        }
        if (gLData.depthSize > 0) {
            nArray[n2++] = 12;
            nArray[n2++] = gLData.depthSize;
        }
        if (gLData.stencilSize > 0) {
            nArray[n2++] = 13;
            nArray[n2++] = gLData.stencilSize;
        }
        if (gLData.accumRedSize > 0) {
            nArray[n2++] = 14;
            nArray[n2++] = gLData.accumRedSize;
        }
        if (gLData.accumGreenSize > 0) {
            nArray[n2++] = 15;
            nArray[n2++] = gLData.accumGreenSize;
        }
        if (gLData.accumBlueSize > 0) {
            nArray[n2++] = 16;
            nArray[n2++] = gLData.accumBlueSize;
        }
        if (gLData.accumAlphaSize > 0) {
            nArray[n2++] = 17;
            nArray[n2++] = gLData.accumAlphaSize;
        }
        if (gLData.sampleBuffers > 0) {
            nArray[n2++] = 100000;
            nArray[n2++] = gLData.sampleBuffers;
        }
        if (gLData.samples > 0) {
            nArray[n2++] = 100001;
            nArray[n2++] = gLData.samples;
        }
        nArray[n2++] = 0;
        new GC(this).dispose();
        int n3 = OS.XtDisplay(this.handle);
        int n4 = OS.XDefaultScreen(n3);
        int n5 = GLX.glXChooseVisual(n3, n4, nArray);
        if (n5 == 0) {
            this.dispose();
            SWT.error(38);
        }
        this.vinfo = new XVisualInfo();
        GLX.memmove(this.vinfo, n5, XVisualInfo.sizeof);
        OS.XFree(n5);
        this.context = GLX.glXCreateContext(n3, this.vinfo, 0, true);
        if (this.context == 0) {
            SWT.error(2);
        }
        int n6 = OS.XtWindow(this.handle);
        XSetWindowAttributes xSetWindowAttributes = new XSetWindowAttributes();
        int n7 = 14336;
        xSetWindowAttributes.colormap = this.colormap = OS.XCreateColormap(n3, n6, this.vinfo.visual, 0);
        this.xWindow = OS.XCreateWindow(n3, n6, 0, 0, 1, 1, 0, this.vinfo.depth, 1, this.vinfo.visual, n7, xSetWindowAttributes);
        int n8 = OS.XtBuildEventMask(this.handle);
        OS.XSelectInput(n3, this.xWindow, n8);
        OS.XMapWindow(n3, this.xWindow);
        OS.XtRegisterDrawable(n3, this.xWindow, this.handle);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                int n = OS.XtDisplay(GLCanvas.this.handle);
                switch (event.type) {
                    case 9: {
                        int[] nArray = new int[4];
                        GLX.glGetIntegerv(2978, nArray);
                        GLX.glViewport(nArray[0], nArray[1], nArray[2], nArray[3]);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 11: {
                        Rectangle rectangle = GLCanvas.this.getClientArea();
                        OS.XMoveResizeWindow(n, GLCanvas.this.xWindow, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        break;
                    }
                    case 12: {
                        if (GLCanvas.this.context != 0) {
                            if (GLX.glXGetCurrentContext() == GLCanvas.this.context) {
                                GLX.glXMakeCurrent(n, 0, 0);
                            }
                            GLX.glXDestroyContext(n, GLCanvas.this.context);
                            GLCanvas.this.context = 0;
                        }
                        if (GLCanvas.this.xWindow != 0) {
                            OS.XtUnregisterDrawable(n, GLCanvas.this.xWindow);
                            OS.XDestroyWindow(n, GLCanvas.this.xWindow);
                            GLCanvas.this.xWindow = 0;
                        }
                        if (GLCanvas.this.colormap == 0) break;
                        OS.XFreeColormap(n, GLCanvas.this.colormap);
                        GLCanvas.this.colormap = 0;
                    }
                }
            }
        };
        this.addListener(1, listener);
        this.addListener(11, listener);
        this.addListener(9, listener);
        this.addListener(12, listener);
    }

    public GLData getGLData() {
        this.checkWidget();
        int n = OS.XtDisplay(this.handle);
        GLData gLData = new GLData();
        int[] nArray = new int[1];
        GLX.glXGetConfig(n, this.vinfo, 5, nArray);
        gLData.doubleBuffer = nArray[0] != 0;
        GLX.glXGetConfig(n, this.vinfo, 6, nArray);
        gLData.stereo = nArray[0] != 0;
        GLX.glXGetConfig(n, this.vinfo, 8, nArray);
        gLData.redSize = nArray[0];
        GLX.glXGetConfig(n, this.vinfo, 9, nArray);
        gLData.greenSize = nArray[0];
        GLX.glXGetConfig(n, this.vinfo, 10, nArray);
        gLData.blueSize = nArray[0];
        GLX.glXGetConfig(n, this.vinfo, 11, nArray);
        gLData.alphaSize = nArray[0];
        GLX.glXGetConfig(n, this.vinfo, 12, nArray);
        gLData.depthSize = nArray[0];
        GLX.glXGetConfig(n, this.vinfo, 13, nArray);
        gLData.stencilSize = nArray[0];
        GLX.glXGetConfig(n, this.vinfo, 14, nArray);
        gLData.accumRedSize = nArray[0];
        GLX.glXGetConfig(n, this.vinfo, 15, nArray);
        gLData.accumGreenSize = nArray[0];
        GLX.glXGetConfig(n, this.vinfo, 16, nArray);
        gLData.accumBlueSize = nArray[0];
        GLX.glXGetConfig(n, this.vinfo, 17, nArray);
        gLData.accumAlphaSize = nArray[0];
        GLX.glXGetConfig(n, this.vinfo, 100000, nArray);
        gLData.sampleBuffers = nArray[0];
        GLX.glXGetConfig(n, this.vinfo, 100001, nArray);
        gLData.samples = nArray[0];
        return gLData;
    }

    public boolean isCurrent() {
        this.checkWidget();
        return GLX.glXGetCurrentContext() == this.context;
    }

    public void setCurrent() {
        this.checkWidget();
        if (GLX.glXGetCurrentContext() == this.context) {
            return;
        }
        int n = OS.XtDisplay(this.handle);
        GLX.glXMakeCurrent(n, this.xWindow, this.context);
    }

    public void swapBuffers() {
        this.checkWidget();
        int n = OS.XtDisplay(this.handle);
        GLX.glXSwapBuffers(n, this.xWindow);
    }
}

