/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XColor;
import org.eclipse.swt.internal.motif.XGCValues;
import org.eclipse.swt.internal.motif.XRectangle;
import org.eclipse.swt.printing.PrinterData;

public final class Printer
extends Device {
    PrinterData data;
    int printContext;
    int xScreen;
    int xDrawable;
    int xtContext;
    Font defaultFont;
    boolean isGCCreated;
    static String APP_NAME = "SWT_Printer";

    static DeviceData checkNull(PrinterData printerData) {
        if (printerData == null) {
            printerData = new PrinterData();
        }
        if (printerData.application_name == null) {
            printerData.application_name = APP_NAME;
        }
        if (printerData.application_class == null) {
            printerData.application_class = APP_NAME;
        }
        if (printerData.name == null || printerData.driver == null) {
            PrinterData printerData2 = Printer.getDefaultPrinterData();
            if (printerData2 == null) {
                SWT.error(2);
            }
            printerData.name = printerData2.name;
            printerData.driver = printerData2.driver;
        }
        return printerData;
    }

    public static PrinterData getDefaultPrinterData() {
        PrinterData[] printerDataArray = Printer.getEnvPrinterList();
        PrinterData printerData = Printer.getEnvDefaultPrinter(printerDataArray);
        if (printerData != null) {
            return printerData;
        }
        if (printerDataArray.length != 0) {
            return printerDataArray[0];
        }
        return null;
    }

    static PrinterData getEnvDefaultPrinter(PrinterData[] printerDataArray) {
        String[] stringArray = new String[]{"XPRINTER", "PDPRINTER", "LPDEST", "PRINTER"};
        int n = 0;
        while (n < stringArray.length) {
            int n2 = OS.getenv(Converter.wcsToMbcs(null, stringArray[n], true));
            if (n2 != 0) {
                Object object;
                int n3 = OS.strlen(n2);
                byte[] byArray = new byte[n3];
                OS.memmove(byArray, n2, n3);
                String string = new String(Converter.mbcsToWcs(null, byArray));
                int n4 = string.indexOf("@");
                if (n4 != -1) {
                    String string2 = string.substring(0, n4);
                    object = string.substring(n4 + 1);
                    return new PrinterData((String)object, string2);
                }
                int n5 = 0;
                while (n5 < printerDataArray.length) {
                    object = printerDataArray[n5];
                    if (string.equals(((PrinterData)object).name)) {
                        return new PrinterData(((PrinterData)object).driver, string);
                    }
                    ++n5;
                }
            }
            ++n;
        }
        return null;
    }

    public static PrinterData[] getPrinterList() {
        PrinterData[] printerDataArray = Printer.getEnvPrinterList();
        PrinterData printerData = Printer.getEnvDefaultPrinter(printerDataArray);
        if (printerData == null) {
            return printerDataArray;
        }
        int n = 0;
        while (n < printerDataArray.length) {
            PrinterData printerData2 = printerDataArray[n];
            if (printerData2.name.equals(printerData.name) && printerData2.driver.equals(printerData.driver)) {
                return printerDataArray;
            }
            ++n;
        }
        PrinterData[] printerDataArray2 = new PrinterData[printerDataArray.length + 1];
        System.arraycopy(printerDataArray, 0, printerDataArray2, 1, printerDataArray.length);
        printerDataArray2[0] = printerData;
        return printerDataArray2;
    }

    static PrinterData[] getEnvPrinterList() {
        String[] stringArray = Printer.getXPServerList();
        PrinterData[] printerDataArray = new PrinterData[]{};
        int n = 0;
        while (n < stringArray.length) {
            PrinterData[] printerDataArray2 = Printer.getEnvPrinterList(stringArray[n]);
            if (printerDataArray2.length != 0) {
                PrinterData[] printerDataArray3 = new PrinterData[printerDataArray.length + printerDataArray2.length];
                System.arraycopy(printerDataArray, 0, printerDataArray3, 0, printerDataArray.length);
                System.arraycopy(printerDataArray2, 0, printerDataArray3, printerDataArray.length, printerDataArray2.length);
                printerDataArray = printerDataArray3;
            }
            ++n;
        }
        return printerDataArray;
    }

    static PrinterData[] getEnvPrinterList(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n = OS.XOpenDisplay(byArray);
        if (n == 0) {
            return new PrinterData[0];
        }
        int[] nArray = new int[1];
        int n2 = OS.XpGetPrinterList(n, null, nArray);
        int n3 = nArray[0];
        if (n2 == 0 || n3 == 0) {
            OS.XCloseDisplay(n);
            if (n2 != 0) {
                OS.XpFreePrinterList(n2);
            }
            return new PrinterData[0];
        }
        int[] nArray2 = new int[n3 * 2];
        OS.memmove(nArray2, n2, n3 * 2 * 4);
        PrinterData[] printerDataArray = new PrinterData[n3];
        int n4 = 0;
        while (n4 < n3) {
            String string2 = "";
            int n5 = nArray2[n4 * 2];
            if (n5 != 0) {
                int n6 = OS.strlen(n5);
                byArray = new byte[n6];
                OS.memmove(byArray, n5, n6);
                string2 = new String(Converter.mbcsToWcs(null, byArray));
            }
            printerDataArray[n4] = new PrinterData(string, string2);
            ++n4;
        }
        OS.XCloseDisplay(n);
        OS.XpFreePrinterList(n2);
        return printerDataArray;
    }

    static String[] getXPServerList() {
        byte[] byArray = Converter.wcsToMbcs(null, "XPSERVERLIST", true);
        int n = OS.getenv(byArray);
        String[] stringArray = new String[]{};
        if (n != 0) {
            int n2 = OS.strlen(n);
            byte[] byArray2 = new byte[n2];
            OS.memmove(byArray2, n, n2);
            char[] cArray = Converter.mbcsToWcs(null, byArray2);
            int n3 = 0;
            while (n3 < cArray.length) {
                if (cArray[n3] != ' ') {
                    int n4 = n3;
                    while (++n3 < cArray.length && cArray[n3] != ' ') {
                    }
                    String string = new String(cArray, n4, n3 - n4);
                    String[] stringArray2 = new String[stringArray.length + 1];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    stringArray2[stringArray.length] = string;
                    stringArray = stringArray2;
                }
                ++n3;
            }
        }
        return stringArray;
    }

    public Printer() {
        this(null);
    }

    public Printer(PrinterData printerData) {
        super(Printer.checkNull(printerData));
    }

    protected void create(DeviceData deviceData) {
        this.data = (PrinterData)deviceData;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byArray = Converter.wcsToMbcs(null, this.data.driver, true);
        byArray2 = Converter.wcsToMbcs(null, this.data.application_name, true);
        byArray3 = Converter.wcsToMbcs(null, this.data.application_class, true);
        this.xtContext = OS.XtCreateApplicationContext();
        if (this.xtContext == 0) {
            SWT.error(2);
        }
        this.xDisplay = OS.XtOpenDisplay(this.xtContext, byArray, byArray2, byArray3, 0, 0, new int[1], 0);
        if (this.xDisplay == 0) {
            OS.XtDestroyApplicationContext(this.xtContext);
            SWT.error(2);
        }
        this.setDPI = true;
    }

    protected void init() {
        super.init();
        byte[] byArray = Converter.wcsToMbcs(null, this.data.name, true);
        int[] nArray = new int[1];
        int n = OS.XpGetPrinterList(this.xDisplay, byArray, nArray);
        if (n != 0) {
            OS.XpFreePrinterList(n);
        }
        if (nArray[0] == 0) {
            SWT.error(2);
        }
        this.printContext = OS.XpCreateContext(this.xDisplay, byArray);
        OS.XpSetContext(this.xDisplay, this.printContext);
        this.xScreen = OS.XpGetScreenOfContext(this.xDisplay, this.printContext);
        if (this.xScreen == 0) {
            SWT.error(2);
        }
        XRectangle xRectangle = new XRectangle();
        short[] sArray = new short[1];
        short[] sArray2 = new short[1];
        OS.XpGetPageDimensions(this.xDisplay, this.printContext, sArray, sArray2, xRectangle);
        this.xDrawable = OS.XCreateWindow(this.xDisplay, OS.XRootWindowOfScreen(this.xScreen), 0, 0, xRectangle.width, xRectangle.height, 0, 0, 0, 0, 0L, null);
        if (this.xDrawable == 0) {
            SWT.error(2);
        }
        Point point = this.getDPI();
        byArray = Converter.wcsToMbcs(null, "-*-courier-medium-r-*-*-*-120-" + point.x + "-" + point.y + "-*-*-iso8859-1", true);
        int n2 = OS.XmFontListEntryLoad(this.xDisplay, byArray, 1, OS.XmFONTLIST_DEFAULT_TAG);
        if (n2 == 0) {
            SWT.error(2);
        }
        int n3 = OS.XmFontListAppendEntry(0, n2);
        OS.XmFontListEntryFree(new int[]{n2});
        this.defaultFont = Font.motif_new(this, n3);
    }

    protected void destroy() {
        if (this.xtContext != 0) {
            OS.XtDestroyApplicationContext(this.xtContext);
        }
    }

    public int internal_new_GC(GCData gCData) {
        int n;
        if (gCData != null) {
            if (this.isGCCreated) {
                SWT.error(5);
            }
            if ((gCData.style & (n = 0x6000000)) == 0) {
                gCData.style |= 0x2000000;
            }
            gCData.device = this;
            gCData.display = this.xDisplay;
            gCData.drawable = this.xDrawable;
            gCData.font = this.defaultFont;
            gCData.colormap = OS.XDefaultColormapOfScreen(this.xScreen);
            int n2 = OS.XDefaultGCOfScreen(this.xScreen);
            if (n2 != 0) {
                XGCValues xGCValues = new XGCValues();
                OS.XGetGCValues(this.xDisplay, n2, 12, xGCValues);
                XColor xColor = new XColor();
                xColor.pixel = xGCValues.foreground;
                gCData.foreground = xColor;
                XColor xColor2 = new XColor();
                xColor2.pixel = xGCValues.background;
                gCData.background = xColor2;
            }
            this.isGCCreated = true;
        }
        if ((n = OS.XCreateGC(this.xDisplay, this.xDrawable, 0, null)) == 0) {
            SWT.error(2);
        }
        return n;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        OS.XFreeGC(this.xDisplay, n);
        if (gCData != null) {
            this.isGCCreated = false;
        }
    }

    public boolean startJob(String string) {
        this.checkDevice();
        byte[] byArray = Converter.wcsToMbcs(null, "*job-name: " + string, true);
        OS.XpSetAttributes(this.xDisplay, this.printContext, (byte)1, byArray, (byte)2);
        OS.XpStartJob(this.xDisplay, (byte)1);
        return true;
    }

    public void endJob() {
        this.checkDevice();
        OS.XpEndJob(this.xDisplay);
        OS.XFlush(this.xDisplay);
    }

    public void cancelJob() {
        this.checkDevice();
        OS.XpCancelJob(this.xDisplay, true);
    }

    public boolean startPage() {
        this.checkDevice();
        OS.XpStartPage(this.xDisplay, this.xDrawable);
        return true;
    }

    public void endPage() {
        this.checkDevice();
        OS.XpEndPage(this.xDisplay);
    }

    public Point getDPI() {
        this.checkDevice();
        byte[] byArray = Converter.wcsToMbcs(null, "default-printer-resolution", true);
        int n = OS.XpGetOneAttribute(this.xDisplay, this.printContext, (byte)2, byArray);
        int n2 = OS.strlen(n);
        byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        OS.XtFree(n);
        String string = new String(byArray, 0, byArray.length);
        int n3 = 300;
        if (string.length() == 0) {
            byArray = Converter.wcsToMbcs(null, "printer-resolutions-supported", true);
            n = OS.XpGetOneAttribute(this.xDisplay, this.printContext, (byte)4, byArray);
            n2 = OS.strlen(n);
            byArray = new byte[n2];
            OS.memmove(byArray, n, n2);
            OS.XtFree(n);
            int n4 = 0;
            while (!Compatibility.isWhitespace((char)byArray[n4]) && n4 < byArray.length) {
                ++n4;
            }
            string = new String(byArray, 0, n4);
        }
        if (string.length() != 0) {
            try {
                n3 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new Point(n3, n3);
    }

    public Rectangle getBounds() {
        this.checkDevice();
        XRectangle xRectangle = new XRectangle();
        short[] sArray = new short[1];
        short[] sArray2 = new short[1];
        OS.XpGetPageDimensions(this.xDisplay, this.printContext, sArray, sArray2, xRectangle);
        return new Rectangle(0, 0, sArray[0], sArray2[0]);
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        XRectangle xRectangle = new XRectangle();
        OS.XpGetPageDimensions(this.xDisplay, this.printContext, new short[1], new short[1], xRectangle);
        return new Rectangle(xRectangle.x, xRectangle.y, xRectangle.width, xRectangle.height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkDevice();
        XRectangle xRectangle = new XRectangle();
        short[] sArray = new short[1];
        short[] sArray2 = new short[1];
        OS.XpGetPageDimensions(this.xDisplay, this.printContext, sArray, sArray2, xRectangle);
        int n5 = sArray[0] - xRectangle.width;
        int n6 = sArray2[0] - xRectangle.height;
        return new Rectangle(n - xRectangle.x, n2 - xRectangle.y, n3 + n5, n4 + n6);
    }

    public PrinterData getPrinterData() {
        return this.data;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.defaultFont;
    }

    protected void checkDevice() {
        if (this.xDisplay == 0) {
            SWT.error(45);
        }
    }

    protected void release() {
        super.release();
        if (this.defaultFont != null) {
            OS.XmFontListFree(this.defaultFont.handle);
            this.defaultFont.handle = 0;
            this.defaultFont = null;
        }
        if (this.printContext != 0) {
            OS.XpDestroyContext(this.xDisplay, this.printContext);
            this.printContext = 0;
        }
        if (this.xDrawable != 0) {
            OS.XDestroyWindow(this.xDisplay, this.xDrawable);
            this.xDrawable = 0;
        }
        this.xScreen = 0;
        this.data = null;
    }
}

