/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    private static final int COLORSWATCH_SIZE_DEPTH4 = 40;
    private static final int COLORSWATCH_SIZE_DEPTH8 = 15;
    private static final int COLORSWATCH_SIZE_DEPTH16 = 10;
    private static final int COLORSWATCH_BORDER = 1;
    private Shell shell;
    private Canvas colorsCanvas;
    private Label sampleLabel;
    private Label selectionLabel;
    private Canvas sampleCanvas;
    private Canvas selectionCanvas;
    private Button okButton;
    private Button cancelButton;
    private int colorChooserWidth;
    private int colorChooserHeight;
    private boolean okSelected;
    private RGB rgb;
    private int colorSwatchExtent;
    private Color[][] colorGrid;

    public ColorDialog(Shell shell) {
        this(shell, 0);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, n | 0x20 | 0x800 | 0x10000);
        this.checkSubclass();
    }

    void createChildren() {
        Shell shell = this.shell;
        GridLayout gridLayout = new GridLayout(2, false);
        shell.setLayout(gridLayout);
        this.colorChooserWidth = this.colorSwatchExtent * this.colorGrid.length - 1;
        this.colorChooserHeight = this.colorSwatchExtent * this.colorGrid[0].length - 1;
        this.colorsCanvas = new Canvas(shell, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = this.colorChooserWidth;
        gridData.heightHint = this.colorChooserHeight;
        this.colorsCanvas.setLayoutData(gridData);
        Composite composite = new Composite(shell, 0);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(1));
        this.createOkCancel(composite);
        Composite composite2 = new Composite(shell, 0);
        gridLayout = new GridLayout(2, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout(gridLayout);
        composite2.setLayoutData(new GridData(1808));
        this.createSampleGroup(composite2);
        this.createSelectionGroup(composite2);
    }

    void createOkCancel(Composite composite) {
        this.okButton = new Button(composite, 8);
        this.okButton.setText(SWT.getMessage("SWT_OK"));
        this.shell.setDefaultButton(this.okButton);
        GridData gridData = new GridData(768);
        this.okButton.setLayoutData(gridData);
        this.cancelButton = new Button(composite, 8);
        this.cancelButton.setText(SWT.getMessage("SWT_Cancel"));
        gridData = new GridData(768);
        this.cancelButton.setLayoutData(gridData);
    }

    void createSampleGroup(Composite composite) {
        Group group = new Group(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        group.setLayout(new GridLayout());
        group.setLayoutData(gridData);
        group.setText(SWT.getMessage("SWT_Sample"));
        this.sampleLabel = new Label(group, 0x1000800);
        this.sampleLabel.setAlignment(0x1000000);
        this.sampleLabel.setText(SWT.getMessage("SWT_A_Sample_Text"));
        gridData = new GridData(768);
        this.sampleLabel.setLayoutData(gridData);
        this.sampleCanvas = new Canvas(group, 2048);
        gridData = new GridData(768);
        gridData.heightHint = 15;
        this.sampleCanvas.setLayoutData(gridData);
    }

    void createSelectionGroup(Composite composite) {
        Group group = new Group(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        group.setLayout(new GridLayout());
        group.setLayoutData(gridData);
        group.setText(SWT.getMessage("SWT_Selection"));
        this.selectionLabel = new Label(group, 0x1000800);
        this.selectionLabel.setAlignment(0x1000000);
        this.selectionLabel.setText(SWT.getMessage("SWT_Current_Selection"));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.selectionLabel.setLayoutData(gridData);
        this.selectionCanvas = new Canvas(group, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 15;
        this.selectionCanvas.setLayoutData(gridData);
    }

    void disposeColors() {
        int n = 0;
        while (n < this.colorGrid.length) {
            int n2 = 0;
            while (n2 < this.colorGrid[n].length) {
                this.colorGrid[n][n2].dispose();
                ++n2;
            }
            ++n;
        }
    }

    void drawColor(int n, int n2, Color color, GC gC) {
        int n3 = this.colorSwatchExtent - 1;
        gC.setBackground(color);
        gC.fillRectangle(n * this.colorSwatchExtent, n2 * this.colorSwatchExtent, n3, n3);
    }

    public RGB getRGB() {
        return this.rgb;
    }

    void handleEvents(Event event) {
        if (event.type == 9) {
            this.paint(event);
        } else if (event.type == 3) {
            this.mouseDown(event);
        } else if (event.type == 5) {
            this.mouseMove(event);
        } else if (event.type == 13) {
            if (event.widget == this.okButton) {
                this.okSelected = true;
                this.shell.setVisible(false);
            } else if (event.widget == this.cancelButton) {
                this.okSelected = false;
                this.shell.setVisible(false);
            }
        }
    }

    void initialize4BitColors() {
        Display display = this.shell.display;
        this.colorGrid[0][0] = new Color(display, 0, 0, 0);
        this.colorGrid[0][1] = new Color(display, 255, 255, 255);
        this.colorGrid[1][0] = new Color(display, 128, 128, 128);
        this.colorGrid[1][1] = new Color(display, 192, 192, 192);
        this.colorGrid[2][0] = new Color(display, 0, 0, 128);
        this.colorGrid[2][1] = new Color(display, 0, 0, 255);
        this.colorGrid[3][0] = new Color(display, 0, 128, 128);
        this.colorGrid[3][1] = new Color(display, 0, 255, 255);
        this.colorGrid[4][0] = new Color(display, 0, 128, 0);
        this.colorGrid[4][1] = new Color(display, 0, 255, 0);
        this.colorGrid[5][0] = new Color(display, 128, 128, 0);
        this.colorGrid[5][1] = new Color(display, 255, 255, 0);
        this.colorGrid[6][0] = new Color(display, 128, 0, 0);
        this.colorGrid[6][1] = new Color(display, 255, 0, 0);
        this.colorGrid[7][0] = new Color(display, 128, 0, 128);
        this.colorGrid[7][1] = new Color(display, 255, 0, 255);
    }

    void initialize8BitColors() {
        Display display = this.shell.display;
        int n = this.colorGrid[0].length;
        int n2 = 64;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 <= 256) {
            int n6 = 0;
            while (n6 <= 256) {
                int n7 = 0;
                while (n7 <= 256) {
                    if (n3 == n) {
                        n3 = 0;
                        ++n4;
                    }
                    if (n5 == 256) {
                        n5 = 255;
                    }
                    if (n6 == 256) {
                        n6 = 255;
                    }
                    if (n7 == 256) {
                        n7 = 255;
                    }
                    this.colorGrid[n4][n3++] = new Color(display, n5, n7, n6);
                    n7 += n2;
                }
                n6 += n2;
            }
            n5 += n2;
        }
    }

    void initialize16BitColors() {
        Display display = this.shell.display;
        int n = this.colorGrid[0].length;
        int n2 = 51;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 <= 255) {
            int n6 = 0;
            while (n6 <= 255) {
                if (n6 == n2 && n4 < 20) {
                    n6 += n2;
                }
                int n7 = 0;
                while (n7 <= 255) {
                    if (n3 == 2 || n3 == 5) {
                        this.colorGrid[n4][n3++] = new Color(display, n5, n7 - n2 / 2, n6);
                    }
                    if (n3 == n) {
                        n3 = 0;
                        ++n4;
                    }
                    this.colorGrid[n4][n3++] = new Color(display, n5, n7, n6);
                    n7 += n2;
                }
                n6 += n2;
            }
            n5 += n2;
        }
    }

    void initializeWidgets() {
        Display display = this.shell.display;
        if (this.rgb != null) {
            Color color = new Color(display, this.rgb);
            this.selectionCanvas.setBackground(color);
            this.selectionLabel.setBackground(color);
            color.dispose();
        }
    }

    void installListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ColorDialog.this.handleEvents(event);
            }
        };
        this.okButton.addListener(13, listener);
        this.cancelButton.addListener(13, listener);
        this.colorsCanvas.addListener(9, listener);
        this.colorsCanvas.addListener(3, listener);
        this.colorsCanvas.addListener(5, listener);
    }

    void mouseDown(Event event) {
        int n = this.colorSwatchExtent;
        Color color = this.colorGrid[event.x / n][event.y / n];
        this.selectionCanvas.setBackground(color);
        this.selectionLabel.setBackground(color);
    }

    void mouseMove(Event event) {
        int n = this.colorSwatchExtent;
        if (event.x < 0 || event.x > this.colorChooserWidth) {
            return;
        }
        if (event.y < 0 || event.y > this.colorChooserHeight) {
            return;
        }
        int n2 = Math.min(this.colorGrid.length - 1, event.x / n);
        int n3 = Math.min(this.colorGrid[0].length - 1, event.y / n);
        Color color = this.colorGrid[n2][n3];
        this.sampleCanvas.setBackground(color);
        this.sampleLabel.setBackground(color);
    }

    public RGB open() {
        this.shell = new Shell(this.parent, this.getStyle() | 0x20 | 0x800 | 0x10000);
        Display display = this.shell.display;
        this.setColorDepth(display.getDepth());
        this.createChildren();
        this.installListeners();
        this.openModal();
        if (this.okSelected) {
            Color color = this.selectionCanvas.getBackground();
            this.rgb = new RGB(color.getRed(), color.getGreen(), color.getBlue());
        }
        this.disposeColors();
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
        if (!this.okSelected) {
            return null;
        }
        return this.rgb;
    }

    void openDialog() {
        Shell shell = this.shell;
        Point point = shell.computeSize(-1, -1, false);
        Display display = shell.display;
        Rectangle rectangle = display.getBounds();
        int n = rectangle.width * 7 / 8;
        int n2 = rectangle.height * 7 / 8;
        if (point.x > n) {
            point = shell.computeSize(n, -1, false);
        }
        Rectangle rectangle2 = null;
        rectangle2 = this.parent.isVisible() ? this.getParent().getBounds() : this.parent.getMonitor().getBounds();
        int n3 = (rectangle2.width - point.x) / 2 + rectangle2.x;
        n3 = Math.max(n3, 0);
        n3 = Math.min(n3, n - point.x);
        int n4 = (rectangle2.height - point.y) / 2 + rectangle2.y;
        n4 = Math.max(n4, 0);
        n4 = Math.min(n4, n2 - point.y);
        shell.setBounds(n3, n4, point.x, point.y);
        String string = this.getText();
        if (string.length() == 0) {
            string = SWT.getMessage("SWT_ColorDialog_Title");
        }
        this.shell.setText(string);
        shell.open();
    }

    void openModal() {
        Display display = this.shell.display;
        this.initializeWidgets();
        this.openDialog();
        while (!this.shell.isDisposed() && this.shell.getVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    void paint(Event event) {
        int n = 0;
        while (n < this.colorGrid.length) {
            int n2 = 0;
            while (n2 < this.colorGrid[0].length) {
                this.drawColor(n, n2, this.colorGrid[n][n2], event.gc);
                ++n2;
            }
            ++n;
        }
    }

    void setColorDepth(int n) {
        if (n == 4) {
            this.colorSwatchExtent = 40;
            this.colorGrid = new Color[8][2];
            this.initialize4BitColors();
            return;
        }
        if (n == 8) {
            this.colorSwatchExtent = 15;
            this.colorGrid = new Color[25][5];
            this.initialize8BitColors();
            return;
        }
        this.colorSwatchExtent = 10;
        this.colorGrid = new Color[32][8];
        this.initialize16BitColors();
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

