/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XButtonEvent;
import org.eclipse.swt.internal.motif.XClientMessageEvent;
import org.eclipse.swt.internal.motif.XColor;
import org.eclipse.swt.internal.motif.XConfigureEvent;
import org.eclipse.swt.internal.motif.XCreateWindowEvent;
import org.eclipse.swt.internal.motif.XDestroyWindowEvent;
import org.eclipse.swt.internal.motif.XEvent;
import org.eclipse.swt.internal.motif.XExposeEvent;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XGCValues;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XPropertyEvent;
import org.eclipse.swt.internal.motif.XRectangle;
import org.eclipse.swt.internal.motif.XReparentEvent;
import org.eclipse.swt.internal.motif.XSetWindowAttributes;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    Layout layout;
    public int embeddedHandle;
    int focusHandle;
    int damagedRegion;
    int clientWindow;
    Control[] tabList;
    int layoutCount;
    int backgroundMode;
    static byte[] _XEMBED_INFO = Converter.wcsToMbcs(null, "_XEMBED_INFO", true);
    static byte[] _XEMBED = Converter.wcsToMbcs(null, "_XEMBED", true);

    Composite() {
    }

    public Composite(Composite composite, int n) {
        super(composite, n);
    }

    Control[] _getChildren() {
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = nArray2[1];
        int n2 = nArray2[3];
        if (n2 == 0 || n == 0) {
            return new Control[0];
        }
        int[] nArray3 = new int[n2];
        OS.memmove(nArray3, n, n2 * 4);
        int n3 = this.focusHandle != 0 ? n2 - 1 : n2;
        Control[] controlArray = new Control[n3];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2) {
            Widget widget;
            int n6 = nArray3[n4];
            if (n6 != 0 && (widget = this.display.getWidget(n6)) != null && widget != this && widget instanceof Control) {
                controlArray[n5++] = (Control)widget;
            }
            ++n4;
        }
        if (n5 == n3) {
            return controlArray;
        }
        Control[] controlArray2 = new Control[n5];
        System.arraycopy(controlArray, 0, controlArray2, 0, n5);
        return controlArray2;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.tabList.length) {
            if (!this.tabList[n2].isDisposed()) {
                ++n;
            }
            ++n2;
        }
        if (n == this.tabList.length) {
            return this.tabList;
        }
        Control[] controlArray = new Control[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.tabList.length) {
            if (!this.tabList[n4].isDisposed()) {
                controlArray[n3++] = this.tabList[n4];
            }
            ++n4;
        }
        this.tabList = controlArray;
        return this.tabList;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Point point;
        this.checkWidget();
        if (this.layout != null) {
            if (n == -1 || n2 == -1) {
                point = this.layout.computeSize(this, n, n2, bl |= (this.state & 0x200) != 0);
                this.state &= 0xFFFFFDFF;
            } else {
                point = new Point(n, n2);
            }
        } else {
            point = this.minimumSize(n, n2, bl);
        }
        if (point.x == 0) {
            point.x = 64;
        }
        if (point.y == 0) {
            point.y = 64;
        }
        if (n != -1) {
            point.x = n;
        }
        if (n2 != -1) {
            point.y = n2;
        }
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        return new Point(rectangle.width, rectangle.height);
    }

    Control[] computeTabList() {
        Control[] controlArray = super.computeTabList();
        if (controlArray.length == 0) {
            return controlArray;
        }
        Control[] controlArray2 = this.tabList != null ? this._getTabList() : this._getChildren();
        int n = 0;
        while (n < controlArray2.length) {
            Control control = controlArray2[n];
            Control[] controlArray3 = control.computeTabList();
            if (controlArray3.length != 0) {
                Control[] controlArray4 = new Control[controlArray.length + controlArray3.length];
                System.arraycopy(controlArray, 0, controlArray4, 0, controlArray.length);
                System.arraycopy(controlArray3, 0, controlArray4, controlArray.length, controlArray3.length);
                controlArray = controlArray4;
            }
            ++n;
        }
        return controlArray;
    }

    public void changed(Control[] controlArray) {
        Control control;
        this.checkWidget();
        if (controlArray == null) {
            this.error(5);
        }
        int n = 0;
        while (n < controlArray.length) {
            control = controlArray[n];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean bl = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl2 = bl = composite == this;
                if (bl) break;
                composite = composite.parent;
            }
            if (!bl) {
                this.error(32);
            }
            ++n;
        }
        n = 0;
        while (n < controlArray.length) {
            control = controlArray[n];
            Composite composite = control.parent;
            while (control != this) {
                if (composite.layout == null || !composite.layout.flushCache(control)) {
                    composite.state |= 0x200;
                }
                control = composite;
                composite = control.parent;
            }
            ++n;
        }
    }

    void checkBuffered() {
        if ((this.state & 2) == 0) {
            super.checkBuffered();
        }
    }

    protected void checkSubclass() {
    }

    void createHandle(int n) {
        boolean bl;
        this.state |= 2;
        boolean bl2 = bl = (this.style & 0x300) != 0;
        if (!bl) {
            this.state |= 0x80;
        }
        this.createHandle(n, this.parent.handle, bl);
    }

    void createHandle(int n, int n2, boolean bl) {
        int[] nArray;
        int[] nArray2;
        if (bl) {
            nArray2 = new int[]{OS.XmNancestorSensitive, 1};
            this.scrolledHandle = OS.XmCreateMainWindow(n2, null, nArray2, nArray2.length / 2);
            if (this.scrolledHandle == 0) {
                this.error(2);
            }
        }
        if ((this.style & 0x300) != 0) {
            int[] nArray3 = new int[10];
            nArray3[0] = OS.XmNmarginWidth;
            nArray3[1] = 3;
            nArray3[2] = OS.XmNmarginHeight;
            nArray3[3] = 3;
            nArray3[4] = OS.XmNresizePolicy;
            nArray3[6] = OS.XmNshadowType;
            nArray3[7] = 7;
            nArray3[8] = OS.XmNshadowThickness;
            nArray3[9] = this.hasBorder() ? this.display.buttonShadowThickness : 0;
            nArray2 = nArray3;
            this.formHandle = OS.XmCreateForm(this.scrolledHandle, null, nArray2, nArray2.length / 2);
            if (this.formHandle == 0) {
                this.error(2);
            }
            int[] nArray4 = new int[18];
            nArray4[0] = OS.XmNtopAttachment;
            nArray4[1] = 1;
            nArray4[2] = OS.XmNbottomAttachment;
            nArray4[3] = 1;
            nArray4[4] = OS.XmNleftAttachment;
            nArray4[5] = 1;
            nArray4[6] = OS.XmNrightAttachment;
            nArray4[7] = 1;
            nArray4[8] = OS.XmNresizable;
            nArray4[10] = OS.XmNmarginWidth;
            nArray4[12] = OS.XmNmarginHeight;
            nArray4[14] = OS.XmNresizePolicy;
            nArray4[16] = OS.XmNtraversalOn;
            nArray4[17] = (this.style & 0x80000) != 0 ? 0 : 1;
            nArray = nArray4;
            this.handle = OS.XmCreateDrawingArea(this.formHandle, null, nArray, nArray.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
        } else {
            int[] nArray5 = new int[12];
            nArray5[0] = OS.XmNancestorSensitive;
            nArray5[1] = 1;
            nArray5[2] = OS.XmNborderWidth;
            nArray5[3] = this.hasBorder() ? 1 : 0;
            nArray5[4] = OS.XmNmarginWidth;
            nArray5[6] = OS.XmNmarginHeight;
            nArray5[8] = OS.XmNresizePolicy;
            nArray5[10] = OS.XmNtraversalOn;
            nArray5[11] = (this.style & 0x80000) != 0 ? 0 : 1;
            nArray2 = nArray5;
            if (this.scrolledHandle != 0) {
                n2 = this.scrolledHandle;
            }
            this.handle = OS.XmCreateDrawingArea(n2, null, nArray2, nArray2.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
        }
        int[] nArray6 = new int[2];
        nArray6[0] = OS.XmNtraversalOn;
        nArray2 = nArray6;
        this.focusHandle = OS.XmCreateDrawingArea(this.handle, null, nArray2, nArray2.length / 2);
        if (this.focusHandle == 0) {
            this.error(2);
        }
        int[] nArray7 = new int[4];
        nArray7[0] = OS.XmNforeground;
        nArray7[2] = OS.XmNbackground;
        nArray = nArray7;
        OS.XtGetValues(this.handle, nArray, nArray.length / 2);
        if (this.formHandle != 0) {
            OS.XtSetValues(this.formHandle, nArray, nArray.length / 2);
        }
    }

    int defaultBackground() {
        return this.display.compositeBackground;
    }

    int defaultForeground() {
        return this.display.compositeForeground;
    }

    void deregister() {
        super.deregister();
        if (this.focusHandle != 0) {
            this.display.removeWidget(this.focusHandle);
        }
    }

    void drawBackground(GC gC, int n, int n2, int n3, int n4) {
        Control control = this.findBackgroundControl();
        if (control != null) {
            GCData gCData = gC.getGCData();
            int n5 = gCData.cairo;
            if (n5 != 0) {
                Cairo.cairo_save(n5);
                if (control.backgroundImage != null) {
                    int n6;
                    short[] sArray = new short[1];
                    short[] sArray2 = new short[1];
                    OS.XtTranslateCoords(this.handle, (short)0, (short)0, sArray, sArray2);
                    short[] sArray3 = new short[1];
                    short[] sArray4 = new short[1];
                    OS.XtTranslateCoords(control.handle, (short)0, (short)0, sArray3, sArray4);
                    int n7 = sArray[0] - sArray3[0];
                    int n8 = sArray2[0] - sArray4[0];
                    Cairo.cairo_translate(n5, -n7, -n8);
                    n += n7;
                    n2 += n8;
                    int n9 = OS.XtDisplay(this.handle);
                    int n10 = OS.XDefaultVisual(n9, OS.XDefaultScreen(n9));
                    int n11 = control.backgroundImage.pixmap;
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    int[] nArray3 = new int[1];
                    OS.XGetGeometry(n9, n11, nArray, nArray, nArray, nArray2, nArray3, nArray, nArray);
                    int n12 = Cairo.cairo_xlib_surface_create(n9, n11, n10, nArray2[0], nArray3[0]);
                    if (n12 == 0) {
                        this.error(2);
                    }
                    if ((n6 = Cairo.cairo_pattern_create_for_surface(n12)) == 0) {
                        this.error(2);
                    }
                    Cairo.cairo_pattern_set_extend(n6, 1);
                    Cairo.cairo_set_source(n5, n6);
                    Cairo.cairo_surface_destroy(n12);
                    Cairo.cairo_pattern_destroy(n6);
                } else {
                    XColor xColor = this.getXColor(control.getBackgroundPixel());
                    Cairo.cairo_set_source_rgba(n5, (float)(xColor.red & 0xFFFF) / 65535.0f, (float)(xColor.green & 0xFFFF) / 65535.0f, (float)(xColor.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
                }
                Cairo.cairo_rectangle(n5, n, n2, n3, n4);
                Cairo.cairo_fill(n5);
                Cairo.cairo_restore(n5);
            } else {
                int n13 = OS.XtDisplay(this.handle);
                if (n13 == 0) {
                    return;
                }
                int n14 = gC.handle;
                XGCValues xGCValues = new XGCValues();
                if (control.backgroundImage != null) {
                    OS.XGetGCValues(n13, n14, 13568, xGCValues);
                    short[] sArray = new short[1];
                    short[] sArray5 = new short[1];
                    OS.XtTranslateCoords(this.handle, (short)0, (short)0, sArray, sArray5);
                    short[] sArray6 = new short[1];
                    short[] sArray7 = new short[1];
                    OS.XtTranslateCoords(control.handle, (short)0, (short)0, sArray6, sArray7);
                    int n15 = sArray[0] - sArray6[0];
                    int n16 = sArray5[0] - sArray7[0];
                    OS.XSetFillStyle(n13, n14, 1);
                    OS.XSetTSOrigin(n13, n14, -n15, -n16);
                    OS.XSetTile(n13, n14, control.backgroundImage.pixmap);
                    OS.XFillRectangle(gCData.display, gCData.drawable, n14, n, n2, n3, n4);
                    OS.XSetFillStyle(n13, n14, xGCValues.fill_style);
                    OS.XSetTSOrigin(n13, n14, xGCValues.ts_x_origin, xGCValues.ts_y_origin);
                } else {
                    OS.XGetGCValues(n13, n14, 4, xGCValues);
                    OS.XSetForeground(n13, n14, control.getBackgroundPixel());
                    OS.XFillRectangle(gCData.display, gCData.drawable, n14, n, n2, n3, n4);
                    OS.XSetForeground(n13, n14, xGCValues.foreground);
                }
            }
        } else {
            gC.fillRectangle(n, n2, n3, n4);
        }
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this.parent.findDeferredControl();
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.tabList.length) {
            if (this.tabList[n2] == control) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return;
        }
        Control[] controlArray = null;
        int n3 = this.tabList.length - n;
        if (n3 != 0) {
            controlArray = new Control[n3];
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.tabList.length) {
                if (this.tabList[n5] != control) {
                    controlArray[n4++] = this.tabList[n5];
                }
                ++n5;
            }
        }
        this.tabList = controlArray;
    }

    int focusHandle() {
        if (this.focusHandle == 0) {
            return super.focusHandle();
        }
        return this.focusHandle;
    }

    int focusProc(int n, int n2, int n3, int n4) {
        XFocusChangeEvent xFocusChangeEvent = new XFocusChangeEvent();
        OS.memmove(xFocusChangeEvent, n3, 28);
        int n5 = OS.XtWindowToWidget(xFocusChangeEvent.display, xFocusChangeEvent.window);
        Shell shell = this.getShell();
        if (n5 != shell.shellHandle) {
            return super.XFocusChange(n, n2, n3, n4);
        }
        if (xFocusChangeEvent.mode != 0) {
            return 0;
        }
        block0 : switch (xFocusChangeEvent.detail) {
            case 3: 
            case 4: {
                switch (xFocusChangeEvent.type) {
                    case 9: {
                        this.sendClientEvent(0, 1, 0, 0, 0);
                        break block0;
                    }
                    case 10: {
                        this.sendClientEvent(0, 2, 0, 0, 0);
                    }
                }
            }
        }
        return 0;
    }

    boolean fowardKeyEvent(int n) {
        if (this.clientWindow == 0) {
            return false;
        }
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        XKeyEvent xKeyEvent = new XKeyEvent();
        OS.memmove(xKeyEvent, n, 60);
        xKeyEvent.window = this.clientWindow;
        int n2 = OS.XtMalloc(96);
        OS.memmove(n2, xKeyEvent, 60);
        int n3 = OS.XtDisplay(this.handle);
        OS.XSendEvent(n3, this.clientWindow, false, 0, n2);
        OS.XSync(n3, false);
        OS.XtFree(n2);
        this.display.setWarnings(bl);
        return true;
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (this.formHandle != 0 && !OS.XtIsRealized(this.handle)) {
            this.getShell().realizeWidget();
        }
        return super.getClientArea();
    }

    int getChildrenCount() {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNnumChildren;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (this.focusHandle != 0) {
            return Math.max(0, nArray2[1] - 1);
        }
        return nArray2[1];
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] controlArray = this._getTabList();
        if (controlArray == null) {
            int n = 0;
            Control[] controlArray2 = this._getChildren();
            int n2 = 0;
            while (n2 < controlArray2.length) {
                if (controlArray2[n2].isTabGroup()) {
                    ++n;
                }
                ++n2;
            }
            controlArray = new Control[n];
            n2 = 0;
            int n3 = 0;
            while (n3 < controlArray2.length) {
                if (controlArray2[n3].isTabGroup()) {
                    controlArray[n2++] = controlArray2[n3];
                }
                ++n3;
            }
        }
        return controlArray;
    }

    boolean hasBorder() {
        return (this.style & 0x800) != 0;
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.state & 2) != 0) {
            OS.XtInsertEventHandler(this.handle, 0, true, this.display.windowProc, 25, 1);
        }
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            int n = this.display.focusProc;
            int n2 = this.display.windowProc;
            OS.XtInsertEventHandler(this.handle, 655360, false, n2, 27, 1);
            OS.XtInsertEventHandler(this.handle, 0x400000, false, n2, 33, 1);
            OS.XtInsertEventHandler(this.handle, 0, true, n2, 25, 1);
            Shell shell = this.getShell();
            OS.XtInsertEventHandler(shell.shellHandle, 0x200000, false, n, this.handle, 1);
        }
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean bl) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(bl, false);
    }

    public void layout(boolean bl, boolean bl2) {
        this.checkWidget();
        if (this.layout == null && !bl2) {
            return;
        }
        this.markLayout(bl, bl2);
        this.updateLayout(bl2);
    }

    public void layout(Control[] controlArray) {
        Control control;
        int n;
        Composite[] compositeArray;
        this.checkWidget();
        if (controlArray == null) {
            this.error(5);
        }
        int n2 = 0;
        while (n2 < controlArray.length) {
            compositeArray = controlArray[n2];
            if (compositeArray == null) {
                this.error(5);
            }
            if (compositeArray.isDisposed()) {
                this.error(5);
            }
            n = 0;
            control = compositeArray.parent;
            while (control != null) {
                int n3 = n = control == this ? 1 : 0;
                if (n != 0) break;
                control = control.parent;
            }
            if (n == 0) {
                this.error(32);
            }
            ++n2;
        }
        n2 = 0;
        compositeArray = new Composite[16];
        n = 0;
        while (n < controlArray.length) {
            control = controlArray[n];
            Composite composite = control.parent;
            while (control != this) {
                if (composite.layout != null) {
                    composite.state |= 0x100;
                    if (!composite.layout.flushCache(control)) {
                        composite.state |= 0x200;
                    }
                }
                if (n2 == compositeArray.length) {
                    Composite[] compositeArray2 = new Composite[compositeArray.length + 16];
                    System.arraycopy(compositeArray, 0, compositeArray2, 0, compositeArray.length);
                    compositeArray = compositeArray2;
                }
                int n4 = n2++;
                Composite composite2 = composite;
                compositeArray[n4] = composite2;
                control = composite2;
                composite = control.parent;
            }
            ++n;
        }
        n = n2 - 1;
        while (n >= 0) {
            compositeArray[n].updateLayout(false);
            --n;
        }
    }

    void manageChildren() {
        if (this.focusHandle != 0) {
            OS.XtSetMappedWhenManaged(this.focusHandle, false);
            OS.XtManageChild(this.focusHandle);
        }
        super.manageChildren();
        if (this.focusHandle != 0) {
            OS.XtConfigureWidget(this.focusHandle, 0, 0, 1, 1, 0);
            OS.XtSetMappedWhenManaged(this.focusHandle, true);
        }
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            Shell shell = this.getShell();
            shell.createFocusProxy();
            if (!OS.XtIsRealized(this.handle)) {
                shell.realizeWidget();
            }
            int n = OS.XtDisplay(this.handle);
            OS.XSync(n, false);
            this.embeddedHandle = OS.XtWindow(this.handle);
        }
    }

    void markLayout(boolean bl, boolean bl2) {
        if (this.layout != null) {
            this.state |= 0x100;
            if (bl) {
                this.state |= 0x200;
            }
        }
        if (bl2) {
            Control[] controlArray = this._getChildren();
            int n = 0;
            while (n < controlArray.length) {
                controlArray[n].markLayout(bl, bl2);
                ++n;
            }
        }
    }

    Point minimumSize(int n, int n2, boolean bl) {
        Control[] controlArray = this._getChildren();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < controlArray.length) {
            Rectangle rectangle = controlArray[n5].getBounds();
            n3 = Math.max(n3, rectangle.x + rectangle.width);
            n4 = Math.max(n4, rectangle.y + rectangle.height);
            ++n5;
        }
        return new Point(n3, n4);
    }

    void moveAbove(int n, int n2) {
        if (n == n2) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n3 = nArray2[1];
        int n4 = nArray2[3];
        if (n4 == 0 || n3 == 0) {
            return;
        }
        int[] nArray3 = new int[n4];
        OS.memmove(nArray3, n3, n4 * 4);
        if (n2 == 0) {
            n2 = nArray3[0];
        }
        int n5 = 0;
        int n6 = -1;
        int n7 = -1;
        while (n5 < n4) {
            int n8 = nArray3[n5];
            if (n8 == n) {
                n6 = n5;
            }
            if (n8 == n2) {
                n7 = n5;
            }
            if (n6 != -1 && n7 != -1) break;
            ++n5;
        }
        if (n6 == -1 || n7 == -1) {
            return;
        }
        if (n6 == n7) {
            return;
        }
        if (n6 < n7) {
            System.arraycopy(nArray3, n6 + 1, nArray3, n6, n7 - n6 - 1);
            nArray3[n7 - 1] = n;
        } else {
            System.arraycopy(nArray3, n7, nArray3, n7 + 1, n6 - n7);
            nArray3[n7] = n;
        }
        OS.memmove(n3, nArray3, n4 * 4);
    }

    void moveBelow(int n, int n2) {
        if (n == n2) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n3 = nArray2[1];
        int n4 = nArray2[3];
        if (n4 == 0 || n3 == 0) {
            return;
        }
        int[] nArray3 = new int[n4];
        OS.memmove(nArray3, n3, n4 * 4);
        if (n2 == 0) {
            n2 = nArray3[n4 - 1];
        }
        int n5 = 0;
        int n6 = -1;
        int n7 = -1;
        while (n5 < n4) {
            int n8 = nArray3[n5];
            if (n8 == n) {
                n6 = n5;
            }
            if (n8 == n2) {
                n7 = n5;
            }
            if (n6 != -1 && n7 != -1) break;
            ++n5;
        }
        if (n6 == -1 || n7 == -1) {
            return;
        }
        if (n6 == n7) {
            return;
        }
        if (n6 < n7) {
            System.arraycopy(nArray3, n6 + 1, nArray3, n6, n7 - n6);
            nArray3[n7] = n;
        } else {
            System.arraycopy(nArray3, n7 + 1, nArray3, n7 + 2, n6 - n7 - 1);
            nArray3[n7 + 1] = n;
        }
        OS.memmove(n3, nArray3, n4 * 4);
    }

    void propagateChildren(boolean bl) {
        super.propagateChildren(bl);
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (control.getEnabled()) {
                control.propagateChildren(bl);
            }
            ++n;
        }
    }

    void realizeChildren() {
        super.realizeChildren();
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].realizeChildren();
            ++n;
        }
        if (this.focusHandle != 0) {
            OS.XtUnmapWidget(this.focusHandle);
        }
        if ((this.state & 2) != 0 && ((this.style & 0x20040000) != 0 || (this.style & 0x100000) == 0)) {
            n = OS.XtDisplay(this.handle);
            if (n == 0) {
                return;
            }
            int n2 = OS.XtWindow(this.handle);
            if (n2 == 0) {
                return;
            }
            int n3 = 0;
            XSetWindowAttributes xSetWindowAttributes = new XSetWindowAttributes();
            if ((this.style & 0x20040000) != 0) {
                n3 |= 1;
                xSetWindowAttributes.background_pixmap = 0;
            }
            if ((this.style & 0x100000) == 0) {
                n3 |= 0x10;
                xSetWindowAttributes.bit_gravity = 0;
            }
            if (n3 != 0) {
                OS.XChangeWindowAttributes(n, n2, n3, xSetWindowAttributes);
            }
        }
    }

    void redrawChildren() {
        super.redrawChildren();
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if ((control.state & 0x40) != 0) {
                control.redrawWidget(0, 0, 0, 0, true, false, true);
                control.redrawChildren();
            }
            ++n;
        }
    }

    void register() {
        super.register();
        if (this.focusHandle != 0) {
            this.display.addWidget(this.focusHandle, this);
        }
    }

    void redrawWidget(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        super.redrawWidget(n, n2, n3, n4, bl, bl2, bl3);
        if (!bl2) {
            return;
        }
        Control[] controlArray = this._getChildren();
        int n5 = 0;
        while (n5 < controlArray.length) {
            Control control = controlArray[n5];
            Point point = control.getClientLocation();
            control.redrawWidget(n - point.x, n2 - point.y, n3, n4, bl, bl2, true);
            ++n5;
        }
    }

    void release(boolean bl) {
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            Shell shell = this.getShell();
            int n = this.display.focusProc;
            OS.XtRemoveEventHandler(shell.shellHandle, 0x200000, false, n, this.handle);
            if (this.clientWindow != 0) {
                boolean bl2 = this.display.getWarnings();
                this.display.setWarnings(false);
                int n2 = OS.XtDisplay(this.handle);
                OS.XUnmapWindow(n2, this.clientWindow);
                OS.XReparentWindow(n2, this.clientWindow, OS.XDefaultRootWindow(n2), 0, 0);
                OS.XSync(n2, false);
                this.display.setWarnings(bl2);
            }
            this.setClientWindow(0);
        }
        super.release(bl);
    }

    void releaseChildren(boolean bl) {
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (control != null && !control.isDisposed()) {
                control.release(false);
            }
            ++n;
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.embeddedHandle = 0;
        this.focusHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.layout = null;
        this.tabList = null;
        if (this.damagedRegion != 0) {
            OS.XDestroyRegion(this.damagedRegion);
        }
        this.damagedRegion = 0;
    }

    void removeControl(Control control) {
        this.fixTabList(control);
    }

    void resizeClientWindow() {
        if (this.clientWindow == 0) {
            return;
        }
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        int[] nArray = new int[4];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = OS.XtDisplay(this.handle);
        OS.XMoveResizeWindow(n, this.clientWindow, 0, 0, Math.max(1, nArray2[1]), Math.max(1, nArray2[3]));
        this.display.setWarnings(bl);
    }

    void sendClientEvent(int n, int n2, int n3, int n4, int n5) {
        if (this.clientWindow == 0) {
            return;
        }
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        int n6 = OS.XtDisplay(this.handle);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        xClientMessageEvent.type = 33;
        xClientMessageEvent.window = this.clientWindow;
        xClientMessageEvent.message_type = OS.XInternAtom(n6, _XEMBED, false);
        xClientMessageEvent.format = 32;
        xClientMessageEvent.data[0] = n != 0 ? n : OS.XtLastTimestampProcessed(n6);
        xClientMessageEvent.data[1] = n2;
        xClientMessageEvent.data[2] = n3;
        xClientMessageEvent.data[3] = n4;
        xClientMessageEvent.data[4] = n5;
        int n7 = OS.XtMalloc(96);
        OS.memmove(n7, xClientMessageEvent, 48);
        OS.XSendEvent(n6, this.clientWindow, false, 0, n7);
        OS.XSync(n6, false);
        OS.XtFree(n7);
        this.display.setWarnings(bl);
    }

    public void setBackgroundMode(int n) {
        this.checkWidget();
        this.backgroundMode = n;
        Control[] controlArray = this._getChildren();
        int n2 = 0;
        while (n2 < controlArray.length) {
            controlArray[n2].updateBackgroundMode();
            ++n2;
        }
    }

    void setBackgroundPixel(int n) {
        super.setBackgroundPixel(n);
        if ((this.state & 2) != 0 && (this.style & 0x20040000) != 0) {
            int n2 = OS.XtDisplay(this.handle);
            if (n2 == 0) {
                return;
            }
            int n3 = OS.XtWindow(this.handle);
            if (n3 == 0) {
                return;
            }
            XSetWindowAttributes xSetWindowAttributes = new XSetWindowAttributes();
            xSetWindowAttributes.background_pixmap = 0;
            OS.XChangeWindowAttributes(n2, n3, 1, xSetWindowAttributes);
        }
    }

    boolean setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (bl3 && bl2) {
            if (this.focusHandle != 0) {
                int[] nArray = new int[4];
                nArray[0] = OS.XmNwidth;
                nArray[2] = OS.XmNheight;
                int[] nArray2 = nArray;
                OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
                OS.XtConfigureWidget(this.focusHandle, 0, 0, nArray2[1], nArray2[3], 0);
            }
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false);
            }
            if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
                this.resizeClientWindow();
            }
        }
        return bl3;
    }

    void setClientWindow(int n) {
        if (this.focusHandle != 0 && n == OS.XtWindow(this.focusHandle)) {
            return;
        }
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        int n2 = OS.XtDisplay(this.handle);
        if (n != 0) {
            if (this.clientWindow == 0) {
                this.clientWindow = n;
                this.sendClientEvent(0, 0, 0, 0, 0);
                OS.XtRegisterDrawable(n2, this.clientWindow, this.handle);
                OS.XSelectInput(n2, this.clientWindow, 0x400000);
                this.updateMapped();
                this.resizeClientWindow();
                Shell shell = this.getShell();
                if (shell == this.display.getActiveShell()) {
                    shell.bringToTop(true);
                    this.sendClientEvent(0, 1, 0, 0, 0);
                    if (this == this.display.getFocusControl()) {
                        this.sendClientEvent(0, 4, 0, 0, 0);
                    }
                }
            }
        } else {
            if (this.clientWindow != 0) {
                OS.XtUnregisterDrawable(n2, this.clientWindow);
            }
            this.clientWindow = 0;
        }
        this.display.setWarnings(bl);
    }

    public boolean setFocus() {
        this.checkWidget();
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (control.setFocus()) {
                return true;
            }
            ++n;
        }
        return super.setFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if ((this.state & 2) != 0) {
            int n = OS.XtDisplay(this.handle);
            if (n == 0) {
                return;
            }
            int n2 = OS.XtWindow(this.handle);
            if (n2 == 0) {
                return;
            }
            OS.XClearArea(n, n2, 0, 0, 0, 0, true);
        }
    }

    void setForegroundPixel(int n) {
        super.setForegroundPixel(n);
        if ((this.state & 2) != 0) {
            int n2 = OS.XtDisplay(this.handle);
            if (n2 == 0) {
                return;
            }
            int n3 = OS.XtWindow(this.handle);
            if (n3 == 0) {
                return;
            }
            OS.XClearArea(n2, n3, 0, 0, 0, 0, true);
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean bl) {
        if (!bl) {
            if (--this.layoutCount == 0 && ((this.state & 0x400) != 0 || (this.state & 0x100) != 0)) {
                this.updateLayout(true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    public void setTabList(Control[] controlArray) {
        this.checkWidget();
        if (controlArray != null) {
            int n = 0;
            while (n < controlArray.length) {
                Control control = controlArray[n];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent != this) {
                    this.error(32);
                }
                ++n;
            }
            Control[] controlArray2 = new Control[controlArray.length];
            System.arraycopy(controlArray, 0, controlArray2, 0, controlArray.length);
            controlArray = controlArray2;
        }
        this.tabList = controlArray;
    }

    void setParentBackground() {
        super.setParentBackground();
        if (this.scrolledHandle != 0) {
            this.setParentBackground(this.scrolledHandle);
        }
        if (this.formHandle != 0) {
            this.setParentBackground(this.formHandle);
        }
    }

    boolean setScrollBarVisible(ScrollBar scrollBar, boolean bl) {
        boolean bl2 = super.setScrollBarVisible(scrollBar, bl);
        if (bl2 && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return bl2;
    }

    boolean setTabGroupFocus(boolean bl) {
        boolean bl2;
        if (this.isTabItem()) {
            return this.setTabItemFocus(bl);
        }
        boolean bl3 = bl2 = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            bl2 = this.hooksKeys();
            if ((this.style & 0x1000000) != 0) {
                bl2 = true;
            }
        }
        if (bl2 && this.setTabItemFocus(bl)) {
            return true;
        }
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (control.isTabItem() && control.setTabItemFocus(bl)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean setTabItemFocus(boolean bl) {
        if (!super.setTabItemFocus(bl)) {
            return false;
        }
        if (this.handle != 0 && (this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            int n = bl ? 1 : 2;
            this.sendClientEvent(0, 4, n, 0, 0);
        }
        return true;
    }

    int traversalCode(int n, XKeyEvent xKeyEvent) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(n, xKeyEvent);
    }

    boolean translateMnemonic(Event event, Control control) {
        if (super.translateMnemonic(event, control)) {
            return true;
        }
        if (control != null) {
            Control[] controlArray = this._getChildren();
            int n = 0;
            while (n < controlArray.length) {
                Control control2 = controlArray[n];
                if (control2.translateMnemonic(event, control)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    boolean translateTraversal(int n, XKeyEvent xKeyEvent) {
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            return false;
        }
        return super.translateTraversal(n, xKeyEvent);
    }

    void updateBackgroundMode() {
        super.updateBackgroundMode();
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].updateBackgroundMode();
            ++n;
        }
    }

    void updateLayout(boolean bl) {
        Composite composite = this.findDeferredControl();
        if (composite != null) {
            composite.state |= 0x400;
            return;
        }
        if ((this.state & 0x100) != 0) {
            boolean bl2 = (this.state & 0x200) != 0;
            this.state &= 0xFFFFFCFF;
            this.layout.layout(this, bl2);
        }
        if (bl) {
            this.state &= 0xFFFFFBFF;
            Control[] controlArray = this._getChildren();
            int n = 0;
            while (n < controlArray.length) {
                controlArray[n].updateLayout(bl);
                ++n;
            }
        }
    }

    int XButtonPress(int n, int n2, int n3, int n4) {
        int n5 = super.XButtonPress(n, n2, n3, n4);
        if (n5 != 0) {
            return n5;
        }
        if ((this.state & 2) != 0) {
            XButtonEvent xButtonEvent = new XButtonEvent();
            OS.memmove(xButtonEvent, n3, 60);
            if ((this.style & 0x80000) == 0 && this.hooksKeys() && xButtonEvent.button == 1 && this.getChildrenCount() == 0) {
                this.setFocus();
            }
            if (xButtonEvent.button != 3) {
                OS.memmove(n4, new int[1], 4);
            }
            return 1;
        }
        return n5;
    }

    int XExposure(int n, int n2, int n3, int n4) {
        Object object;
        int n5;
        Object object2;
        int n6;
        if ((this.state & 2) == 0) {
            return super.XExposure(n, n2, n3, n4);
        }
        if (!this.hooks(9) && !this.filters(9)) {
            return 0;
        }
        if (this.damagedRegion == 0) {
            this.damagedRegion = OS.XCreateRegion();
        }
        OS.XtAddExposureToRegion(n3, this.damagedRegion);
        if ((this.style & 0x200000) == 0) {
            XExposeEvent xExposeEvent = new XExposeEvent();
            OS.memmove(xExposeEvent, n3, 40);
            n6 = xExposeEvent.count;
            if (n6 == 0 && OS.XEventsQueued(xExposeEvent.display, 1) != 0) {
                int n7 = OS.XtMalloc(96);
                this.display.lastExpose = 0;
                this.display.exposeCount = 0;
                int n8 = this.display.checkExposeProc;
                OS.XCheckIfEvent(xExposeEvent.display, n7, n8, xExposeEvent.window);
                n6 = this.display.exposeCount;
                int n9 = this.display.lastExpose;
                if (n6 != 0 && n9 != 0) {
                    object2 = this.display.xExposeEvent;
                    OS.memmove((XExposeEvent)object2, n9, 40);
                    ((XExposeEvent)object2).count = 0;
                    OS.memmove(n9, (XExposeEvent)object2, 40);
                }
                OS.XtFree(n7);
            }
            if (n6 != 0) {
                return 0;
            }
        }
        if ((n5 = OS.XtDisplay(this.handle)) == 0) {
            return 0;
        }
        n6 = this.damagedRegion;
        this.damagedRegion = 0;
        GCData gCData = new GCData();
        gCData.damageRgn = n6;
        Object object3 = GC.motif_new(this, gCData);
        OS.XSetRegion(n5, ((GC)object3).handle, n6);
        XRectangle xRectangle = new XRectangle();
        OS.XClipBox(n6, xRectangle);
        object2 = null;
        Image image = null;
        if ((this.style & 0x20000000) != 0) {
            object = this.getClientArea();
            int n10 = Math.max(1, Math.min(((Rectangle)object).width, xRectangle.x + xRectangle.width));
            int n11 = Math.max(1, Math.min(((Rectangle)object).height, xRectangle.y + xRectangle.height));
            image = new Image((Device)this.display, n10, n11);
            object2 = object3;
            GCData gCData2 = new GCData();
            gCData2.damageRgn = n6;
            object3 = GC.motif_new(image, gCData2);
            ((GC)object3).setForeground(this.getForeground());
            ((GC)object3).setBackground(this.getBackground());
            ((GC)object3).setFont(this.getFont());
            if ((this.style & 0x40000) == 0) {
                this.drawBackground((GC)object3, 0, 0, n10, n11);
            }
        }
        object = new Event();
        ((Event)object).x = xRectangle.x;
        ((Event)object).y = xRectangle.y;
        ((Event)object).width = xRectangle.width;
        ((Event)object).height = xRectangle.height;
        ((Event)object).gc = object3;
        this.sendEvent(9, (Event)object);
        ((Event)object).gc = null;
        if ((this.style & 0x20000000) != 0) {
            ((GC)object3).dispose();
            if (!this.isDisposed()) {
                ((GC)object2).drawImage(image, 0, 0);
            }
            image.dispose();
            object3 = object2;
        }
        ((GC)object3).dispose();
        OS.XDestroyRegion(n6);
        return 0;
    }

    int xFocusIn(XFocusChangeEvent xFocusChangeEvent) {
        int n = super.xFocusIn(xFocusChangeEvent);
        if (this.handle != 0 && (this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            this.sendClientEvent(0, 4, 0, 0, 0);
        }
        return n;
    }

    int xFocusOut(XFocusChangeEvent xFocusChangeEvent) {
        int n = super.xFocusOut(xFocusChangeEvent);
        if (this.handle != 0 && (this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            this.sendClientEvent(0, 5, 0, 0, 0);
        }
        return n;
    }

    int XKeyPress(int n, int n2, int n3, int n4) {
        int n5 = super.XKeyPress(n, n2, n3, n4);
        if (n5 == 0 && (this.state & 2) != 0 && (this.style & 0x1000000) != 0 && this.fowardKeyEvent(n3)) {
            return 0;
        }
        return n5;
    }

    int XKeyRelease(int n, int n2, int n3, int n4) {
        int n5 = super.XKeyRelease(n, n2, n3, n4);
        if (n5 == 0 && (this.state & 2) != 0 && (this.style & 0x1000000) != 0 && this.fowardKeyEvent(n3)) {
            return 0;
        }
        return n5;
    }

    int XNonMaskable(int n, int n2, int n3, int n4) {
        XEvent xEvent;
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            xEvent = new XEvent();
            OS.memmove(xEvent, n3, 96);
            if (xEvent.type == 33) {
                XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
                OS.memmove(xClientMessageEvent, n3, 48);
                int n5 = OS.XtDisplay(this.handle);
                if (xClientMessageEvent.message_type == OS.XInternAtom(n5, _XEMBED, false)) {
                    int n6 = xClientMessageEvent.data[1];
                    switch (n6) {
                        case 3: {
                            this.setFocus();
                            break;
                        }
                        case 7: {
                            this.traverse(8);
                            break;
                        }
                        case 6: {
                            this.traverse(16);
                        }
                    }
                }
                return 0;
            }
        }
        if ((this.state & 2) != 0) {
            xEvent = new XEvent();
            OS.memmove(xEvent, n3, 96);
            if (xEvent.type == 13) {
                return this.XExposure(n, n2, n3, n4);
            }
        }
        return 0;
    }

    int XPropertyChange(int n, int n2, int n3, int n4) {
        int n5 = super.XPropertyChange(n, n2, n3, n4);
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            int n6;
            int n7;
            XPropertyEvent xPropertyEvent = new XPropertyEvent();
            OS.memmove(xPropertyEvent, n3, 32);
            if (xPropertyEvent.window == this.clientWindow && (n7 = xPropertyEvent.atom) == OS.XInternAtom(n6 = xPropertyEvent.display, _XEMBED_INFO, false)) {
                this.updateMapped();
            }
        }
        return n5;
    }

    int XStructureNotify(int n, int n2, int n3, int n4) {
        int n5 = super.XStructureNotify(n, n2, n3, n4);
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            XEvent xEvent = new XEvent();
            OS.memmove(xEvent, n3, 96);
            switch (xEvent.type) {
                case 21: {
                    XReparentEvent xReparentEvent = new XReparentEvent();
                    OS.memmove(xReparentEvent, n3, 40);
                    if (this.clientWindow != 0) break;
                    this.setClientWindow(xReparentEvent.window);
                    break;
                }
                case 16: {
                    XCreateWindowEvent xCreateWindowEvent = new XCreateWindowEvent();
                    OS.memmove(xCreateWindowEvent, n3, 48);
                    if (this.clientWindow != 0) break;
                    this.setClientWindow(xCreateWindowEvent.window);
                    break;
                }
                case 17: {
                    XDestroyWindowEvent xDestroyWindowEvent = new XDestroyWindowEvent();
                    OS.memmove(xDestroyWindowEvent, n3, 24);
                    if (xDestroyWindowEvent.window != this.clientWindow) break;
                    this.setClientWindow(0);
                    break;
                }
                case 22: {
                    XConfigureEvent xConfigureEvent = new XConfigureEvent();
                    OS.memmove(xConfigureEvent, n3, 52);
                    if (xConfigureEvent.window != this.clientWindow) break;
                    this.resizeClientWindow();
                }
            }
        }
        return n5;
    }

    void updateMapped() {
        if (this.clientWindow == 0) {
            return;
        }
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        int n = OS.XtDisplay(this.handle);
        int n2 = OS.XInternAtom(n, _XEMBED_INFO, false);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        if (OS.XGetWindowProperty(n, this.clientWindow, n2, 0, 2, false, n2, nArray, nArray2, nArray3, nArray4, nArray5) == 0 && nArray[0] == n2 && nArray3[0] >= 2) {
            int[] nArray6 = new int[2];
            OS.memmove(nArray6, nArray5[0], nArray6.length * 4);
            int n3 = nArray6[1];
            if ((n3 & 1) != 0) {
                OS.XMapWindow(n, this.clientWindow);
            } else {
                OS.XUnmapWindow(n, this.clientWindow);
            }
        }
        if (nArray5[0] != 0) {
            OS.XFree(nArray5[0]);
        }
        this.display.setWarnings(bl);
    }
}

