/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    private FontData[] fontData;
    private FontData currentFontData;
    private Font sampleFont;
    private Color sampleColor;
    private RGB rgb;
    private boolean okSelected = false;
    private boolean ignoreEvents = false;
    private Hashtable characterSets = new Hashtable();
    private Shell shell;
    private List fontSetList;
    private List charSetList;
    private List faceNameList;
    private List extStyleList;
    private List fontStyleList;
    private List fontSizeList;
    private Label sampleLabel;
    private Button upButton;
    private Button downButton;
    private Button newButton;
    private Button removeButton;
    private Button okButton;
    private Button cancelButton;
    private Button colorButton;
    private static final String TEXT_SAMPLE = "AaBbYyZz";
    private static String[] SCALABLE_SIZES;
    private static final int DEFAULT_SIZE = 14;
    private static final String DEFAULT_STYLE = "medium";
    private static final Integer SCALABLE_KEY;
    private static final int LIST_WIDTH = 200;
    private static final int EXTSTYLE_WIDTH = 150;
    private static final int LIST_HEIGHT = 150;
    private static final int SAMPLE_HEIGHT = 75;
    private static final String PREFIX_ISO8859 = "iso8859";
    private static final String PREFIX_ISO646 = "iso646";
    private static final String PREFIX_UNICODE = "ucs";
    private static final String PREFIX_JAPANESE = "jis";
    private static final String PREFIX_SIMPLIFIEDCHINESE = "gb";
    private static final String PREFIX_TRADITIONALCHINESE = "cns";
    private static final String PREFIX_KOREAN = "ks";
    private static final String[] ISO_CHARSETS;

    static {
        SCALABLE_KEY = new Integer(0);
        ISO_CHARSETS = new String[]{"", SWT.getMessage("SWT_Charset_Western"), SWT.getMessage("SWT_Charset_EastEuropean"), SWT.getMessage("SWT_Charset_SouthEuropean"), SWT.getMessage("SWT_Charset_NorthEuropean"), SWT.getMessage("SWT_Charset_Cyrillic"), SWT.getMessage("SWT_Charset_Arabic"), SWT.getMessage("SWT_Charset_Greek"), SWT.getMessage("SWT_Charset_Hebrew"), SWT.getMessage("SWT_Charset_Turkish"), SWT.getMessage("SWT_Charset_Nordic"), SWT.getMessage("SWT_Charset_Thai"), "", SWT.getMessage("SWT_Charset_BalticRim"), SWT.getMessage("SWT_Charset_Celtic"), SWT.getMessage("SWT_Charset_Euro"), SWT.getMessage("SWT_Charset_Romanian")};
        SCALABLE_SIZES = new String[69];
        int n = 0;
        while (n < 69) {
            FontDialog.SCALABLE_SIZES[n] = String.valueOf(n + 4);
            ++n;
        }
    }

    public FontDialog(Shell shell) {
        this(shell, 0);
    }

    public FontDialog(Shell shell, int n) {
        super(shell, n | 0x20 | 0x800 | 0x10000);
        this.checkSubclass();
    }

    void addFonts(FontData[] fontDataArray) {
        int n = 0;
        while (n < fontDataArray.length) {
            Integer n2;
            Hashtable<String, FontData> hashtable;
            String string;
            Hashtable<Integer, Hashtable<String, FontData>> hashtable2;
            String string2;
            Hashtable hashtable3;
            FontData fontData = fontDataArray[n];
            String string3 = this.getTranslatedCharSet(fontData, true);
            Hashtable hashtable4 = (Hashtable)this.characterSets.get(string3);
            if (hashtable4 == null) {
                hashtable4 = new Hashtable(9);
                this.characterSets.put(string3, hashtable4);
            }
            if ((hashtable3 = (Hashtable)hashtable4.get(string2 = this.getTranslatedFaceName(fontData))) == null) {
                hashtable3 = new Hashtable(9);
                hashtable4.put(string2, hashtable3);
            }
            if ((hashtable2 = (Hashtable<Integer, Hashtable<String, FontData>>)hashtable3.get(string = fontData.addStyle)) == null) {
                hashtable2 = new Hashtable<Integer, Hashtable<String, FontData>>(9);
                hashtable3.put(string, hashtable2);
            }
            if ((hashtable = (Hashtable<String, FontData>)hashtable2.get(n2 = new Integer(fontData.getHeight()))) == null) {
                hashtable = new Hashtable<String, FontData>(9);
                hashtable2.put(n2, hashtable);
            }
            String string4 = fontData.weight;
            hashtable.put(string4, fontData);
            ++n;
        }
    }

    void centerListIndex(List list, int n) {
        int n2 = list.getSize().y / list.getItemHeight();
        int n3 = Math.max(0, n - n2 / 2);
        list.setTopIndex(n3);
    }

    FontData copyFontData(FontData fontData) {
        FontData fontData2 = new FontData();
        fontData2.addStyle = fontData.addStyle;
        fontData2.averageWidth = fontData.averageWidth;
        fontData2.characterSetName = fontData.characterSetName;
        fontData2.characterSetRegistry = fontData.characterSetRegistry;
        fontData2.fontFamily = fontData.fontFamily;
        fontData2.foundry = fontData.foundry;
        fontData2.horizontalResolution = fontData.horizontalResolution;
        fontData2.pixels = fontData.pixels;
        fontData2.points = fontData.points;
        fontData2.setWidth = fontData.setWidth;
        fontData2.slant = fontData.slant;
        fontData2.spacing = fontData.spacing;
        fontData2.verticalResolution = fontData.verticalResolution;
        fontData2.weight = fontData.weight;
        return fontData2;
    }

    void createButtons(Composite composite) {
        int n = 770;
        this.okButton = new Button(composite, 8);
        this.okButton.setText(SWT.getMessage("SWT_OK"));
        this.okButton.setLayoutData(new GridData(n));
        this.shell.setDefaultButton(this.okButton);
        this.cancelButton = new Button(composite, 8);
        this.cancelButton.setText(SWT.getMessage("SWT_Cancel"));
        this.cancelButton.setLayoutData(new GridData(n));
        this.colorButton = new Button(composite, 8);
        this.colorButton.setText(SWT.getMessage("SWT_Color"));
        this.colorButton.setLayoutData(new GridData(n));
    }

    void createControls(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout(gridLayout);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 3;
        composite3.setLayout(gridLayout);
        new Label(composite3, 0).setText(String.valueOf(SWT.getMessage("SWT_Character_set")) + ":");
        new Label(composite3, 0).setText(String.valueOf(SWT.getMessage("SWT_Font")) + ":");
        new Label(composite3, 0).setText(String.valueOf(SWT.getMessage("SWT_Extended_style")) + ":");
        this.charSetList = new List(composite3, 2560);
        GridData gridData = new GridData(768);
        gridData.heightHint = 150;
        gridData.widthHint = 200;
        this.charSetList.setLayoutData(gridData);
        this.faceNameList = new List(composite3, 2560);
        gridData = new GridData(768);
        gridData.heightHint = 150;
        gridData.widthHint = 200;
        this.faceNameList.setLayoutData(gridData);
        this.extStyleList = new List(composite3, 2562);
        gridData = new GridData(768);
        gridData.heightHint = 150;
        gridData.widthHint = 150;
        this.extStyleList.setLayoutData(gridData);
        new Label(composite3, 0).setText(String.valueOf(SWT.getMessage("SWT_Size")) + ":");
        new Label(composite3, 0).setText(String.valueOf(SWT.getMessage("SWT_Style")) + ":");
        new Label(composite3, 0);
        this.fontSizeList = new List(composite3, 2560);
        gridData = new GridData(768);
        gridData.heightHint = 150;
        gridData.widthHint = 200;
        this.fontSizeList.setLayoutData(gridData);
        this.fontStyleList = new List(composite3, 2560);
        gridData = new GridData(768);
        gridData.heightHint = 150;
        gridData.widthHint = 200;
        this.fontStyleList.setLayoutData(gridData);
        new Label(composite3, 0);
        Group group = new Group(composite3, 0);
        group.setText(SWT.getMessage("SWT_FontSet"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout(gridLayout);
        GridData gridData2 = new GridData(1808);
        gridData2.horizontalSpan = 3;
        group.setLayoutData(gridData2);
        this.fontSetList = new List(group, 2560);
        gridData2 = new GridData(1808);
        gridData2.grabExcessHorizontalSpace = true;
        this.fontSetList.setLayoutData(gridData2);
        Composite composite4 = new Composite(group, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite4.setLayout(gridLayout);
        Composite composite5 = new Composite(composite4, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite5.setLayout(gridLayout);
        int n = 770;
        this.upButton = new Button(composite5, 8);
        this.upButton.setLayoutData(new GridData(n));
        this.upButton.setText(SWT.getMessage("SWT_Up"));
        this.downButton = new Button(composite5, 8);
        this.downButton.setLayoutData(new GridData(n));
        this.downButton.setText(SWT.getMessage("SWT_Down"));
        new Label(composite4, 514);
        Composite composite6 = new Composite(composite4, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite6.setLayout(gridLayout);
        this.newButton = new Button(composite6, 8);
        this.newButton.setLayoutData(new GridData(n));
        this.newButton.setText(SWT.getMessage("SWT_NewFont"));
        this.removeButton = new Button(composite6, 8);
        this.removeButton.setLayoutData(new GridData(n));
        this.removeButton.setText(SWT.getMessage("SWT_Remove"));
        Group group2 = new Group(composite3, 0);
        group2.setText(SWT.getMessage("SWT_Sample"));
        gridData = new GridData();
        gridData.heightHint = 75;
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        group2.setLayoutData(gridData);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        group2.setLayout(gridLayout);
        this.sampleLabel = new Label(group2, 0x1000000);
        this.sampleLabel.setText(TEXT_SAMPLE);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.sampleLabel.setLayoutData(gridData);
        Composite composite7 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite7.setLayout(gridLayout);
        composite7.setLayoutData(new GridData(2));
        this.createButtons(composite7);
    }

    Hashtable getExtStyles(String string, String string2) {
        Hashtable hashtable = this.getFaces(string);
        if (hashtable == null) {
            return null;
        }
        return (Hashtable)hashtable.get(string2);
    }

    Hashtable getFaces(String string) {
        return (Hashtable)this.getFonts().get(string);
    }

    public FontData getFontData() {
        if (this.fontData != null && this.fontData.length > 0) {
            return this.fontData[0];
        }
        return null;
    }

    FontData getFontData(String string, String string2, String string3, int n, String string4) {
        Hashtable hashtable = this.getStyles(string, string2, string3, n);
        if (hashtable == null) {
            return null;
        }
        return (FontData)hashtable.get(string4);
    }

    public FontData[] getFontList() {
        return this.fontData;
    }

    Hashtable getFonts() {
        return this.characterSets;
    }

    String getListSelection(List list) {
        String[] stringArray = list.getSelection();
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return "";
    }

    public RGB getRGB() {
        return this.rgb;
    }

    FontData getSelectionFontData() {
        String string;
        FontData fontData;
        String string2 = this.getListSelection(this.charSetList);
        String string3 = this.getListSelection(this.faceNameList);
        String string4 = this.getListSelection(this.extStyleList);
        int n = 14;
        try {
            n = Integer.valueOf(this.getListSelection(this.fontSizeList));
            if (n < 1) {
                n = 14;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if ((fontData = this.getFontData(string2, string3, string4, n, string = this.getListSelection(this.fontStyleList))) != null) {
            fontData = this.copyFontData(fontData);
        } else {
            fontData = new FontData();
            fontData.characterSetRegistry = string2;
            fontData.setName(string3);
            fontData.addStyle = string4;
            fontData.weight = string;
        }
        fontData.setHeight(n);
        return fontData;
    }

    Hashtable getSizes(String string, String string2, String string3) {
        Hashtable hashtable = this.getExtStyles(string, string2);
        if (hashtable == null) {
            return null;
        }
        return (Hashtable)hashtable.get(string3);
    }

    Hashtable getStyles(String string, String string2, String string3, int n) {
        Hashtable hashtable = this.getSizes(string, string2, string3);
        if (hashtable == null) {
            return null;
        }
        Hashtable hashtable2 = (Hashtable)hashtable.get(new Integer(n));
        if (hashtable2 == null) {
            hashtable2 = (Hashtable)hashtable.get(SCALABLE_KEY);
        }
        return hashtable2;
    }

    String getTranslatedCharSet(FontData fontData, boolean bl) {
        String string = fontData.characterSetRegistry;
        String string2 = null;
        if (string.startsWith(PREFIX_ISO8859)) {
            int n = 1;
            try {
                n = Integer.valueOf(fontData.characterSetName);
            }
            catch (NumberFormatException numberFormatException) {}
            string = "iso8859-" + n;
            if (n < ISO_CHARSETS.length) {
                string2 = ISO_CHARSETS[n];
            }
        } else if (string.startsWith(PREFIX_ISO646)) {
            string2 = SWT.getMessage("SWT_Charset_ASCII");
        } else if (string.startsWith(PREFIX_UNICODE)) {
            string2 = SWT.getMessage("SWT_Charset_Unicode");
        } else if (string.startsWith(PREFIX_JAPANESE)) {
            string2 = SWT.getMessage("SWT_Charset_Japanese");
        } else if (string.startsWith(PREFIX_SIMPLIFIEDCHINESE)) {
            string2 = SWT.getMessage("SWT_Charset_SimplifiedChinese");
        } else if (string.startsWith(PREFIX_TRADITIONALCHINESE)) {
            string2 = SWT.getMessage("SWT_Charset_TraditionalChinese");
        } else if (string.startsWith(PREFIX_KOREAN)) {
            string2 = SWT.getMessage("SWT_Charset_Korean");
        }
        string2 = bl && string2 != null ? String.valueOf(string) + " (" + string2 + ')' : string;
        return string2;
    }

    String getTranslatedFaceName(FontData fontData) {
        StringBuffer stringBuffer;
        if (fontData.foundry != null && fontData.foundry.length() > 0) {
            stringBuffer = new StringBuffer(fontData.fontFamily);
            stringBuffer.append(" (");
            stringBuffer.append(fontData.foundry);
            stringBuffer.append(')');
        } else {
            stringBuffer = new StringBuffer(fontData.getName());
        }
        return stringBuffer.toString();
    }

    void handleEvent(Event event) {
        if (this.ignoreEvents) {
            return;
        }
        if (event.widget instanceof List) {
            int n;
            List list = (List)event.widget;
            String string = this.getListSelection(list);
            int n2 = (Integer)list.getData();
            if (n2 != (n = list.indexOf(string)) || n == -1) {
                this.ignoreEvents = true;
                if (list == this.charSetList) {
                    this.initFaceNameList();
                } else if (list == this.faceNameList) {
                    this.initExtStyleList();
                } else if (list == this.extStyleList) {
                    this.initSizeList();
                } else if (list == this.fontSizeList) {
                    this.initStyleList();
                } else if (event.widget == this.fontSetList) {
                    this.currentFontData = this.fontData[this.fontSetList.getSelectionIndex()];
                    this.setFontControls(this.currentFontData);
                    this.updateButtonEnablements();
                }
                this.updateSampleFont();
                this.updateFontList();
                list.setData(new Integer(n));
                if (n != -1) {
                    list.select(n);
                }
                this.ignoreEvents = false;
            }
            return;
        }
        if (event.widget instanceof Button) {
            if (event.widget == this.okButton) {
                this.okSelected = true;
                this.shell.close();
            } else if (event.widget == this.cancelButton) {
                this.okSelected = false;
                this.shell.close();
            } else if (event.widget == this.colorButton) {
                ColorDialog colorDialog = new ColorDialog(this.shell, 0);
                colorDialog.setRGB(this.rgb);
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    this.rgb = rGB;
                    this.updateSampleColor();
                }
            } else if (event.widget == this.newButton) {
                FontData fontData;
                FontData[] fontDataArray = new FontData[this.fontData.length + 1];
                System.arraycopy(this.fontData, 0, fontDataArray, 0, this.fontData.length);
                FontData fontData2 = this.fontData[this.fontSetList.getSelectionIndex()];
                fontDataArray[fontDataArray.length - 1] = fontData = this.copyFontData(fontData2);
                this.fontData = fontDataArray;
                this.updateFontList();
                this.fontSetList.select(fontDataArray.length - 1);
                this.fontSetList.setData(new Integer(fontDataArray.length - 1));
                this.fontSetList.showSelection();
                this.updateButtonEnablements();
            } else if (event.widget == this.removeButton) {
                int n = this.fontSetList.getSelectionIndex();
                FontData[] fontDataArray = new FontData[this.fontData.length - 1];
                System.arraycopy(this.fontData, 0, fontDataArray, 0, n);
                System.arraycopy(this.fontData, n + 1, fontDataArray, n, fontDataArray.length - n);
                this.fontData = fontDataArray;
                this.updateFontList();
                this.updateButtonEnablements();
                this.setFontControls(this.fontData[this.fontSetList.getSelectionIndex()]);
            } else if (event.widget == this.upButton) {
                int n = this.fontSetList.getSelectionIndex();
                FontData fontData = this.fontData[n];
                this.fontData[n] = this.fontData[n - 1];
                this.fontData[n - 1] = fontData;
                this.fontSetList.select(n - 1);
                this.fontSetList.setData(new Integer(n - 1));
                this.updateFontList();
                this.updateButtonEnablements();
            } else if (event.widget == this.downButton) {
                int n = this.fontSetList.getSelectionIndex();
                FontData fontData = this.fontData[n];
                this.fontData[n] = this.fontData[n + 1];
                this.fontData[n + 1] = fontData;
                this.fontSetList.select(n + 1);
                this.fontSetList.setData(new Integer(n + 1));
                this.updateFontList();
                this.updateButtonEnablements();
            }
        }
    }

    void hookListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                FontDialog.this.handleEvent(event);
            }
        };
        this.okButton.addListener(13, listener);
        this.cancelButton.addListener(13, listener);
        this.colorButton.addListener(13, listener);
        this.charSetList.addListener(13, listener);
        this.faceNameList.addListener(13, listener);
        this.fontStyleList.addListener(13, listener);
        this.extStyleList.addListener(13, listener);
        this.fontSizeList.addListener(13, listener);
        this.newButton.addListener(13, listener);
        this.removeButton.addListener(13, listener);
        this.upButton.addListener(13, listener);
        this.downButton.addListener(13, listener);
        this.fontSetList.addListener(13, listener);
    }

    void initExtStyleList() {
        String string = this.getListSelection(this.extStyleList);
        this.extStyleList.removeAll();
        String string2 = this.getListSelection(this.charSetList);
        String string3 = this.getListSelection(this.faceNameList);
        Hashtable hashtable = this.getExtStyles(string2, string3);
        this.setItemsSorted(this.extStyleList, hashtable);
        int n = this.extStyleList.indexOf(string);
        this.extStyleList.select(n);
        this.extStyleList.setData(new Integer(n));
        this.centerListIndex(this.extStyleList, n);
        this.initSizeList();
    }

    void initFaceNameList() {
        String string = this.getListSelection(this.faceNameList);
        this.faceNameList.removeAll();
        String string2 = this.getListSelection(this.charSetList);
        if (string2.length() == 0) {
            return;
        }
        Hashtable hashtable = this.getFaces(string2);
        this.setItemsSorted(this.faceNameList, hashtable);
        int n = this.faceNameList.indexOf(string);
        n = Math.max(0, n);
        this.faceNameList.select(n);
        this.faceNameList.setData(new Integer(n));
        this.centerListIndex(this.faceNameList, n);
        this.initExtStyleList();
    }

    void initFonts() {
        Display display = this.shell.display;
        this.addFonts(display.getFontList(null, false));
        this.addFonts(display.getFontList(null, true));
        this.setItemsSorted(this.charSetList, this.getFonts());
        if (this.fontData != null) {
            Font font = new Font((Device)display, this.fontData);
            this.fontData = font.getFontData();
            this.currentFontData = this.fontData[0];
            font.dispose();
        } else {
            this.fontData = display.textFont.getFontData();
            this.currentFontData = this.fontData[0];
        }
    }

    void initSizeList() {
        int n;
        String string = this.getListSelection(this.fontSizeList);
        this.fontSizeList.removeAll();
        String string2 = this.getListSelection(this.charSetList);
        String string3 = this.getListSelection(this.faceNameList);
        String string4 = this.getListSelection(this.extStyleList);
        Hashtable hashtable = this.getSizes(string2, string3, string4);
        if (hashtable != null) {
            if (hashtable.get(SCALABLE_KEY) == null) {
                this.setSizeItemsSorted(hashtable.keys());
            } else {
                Vector<Integer> vector = new Vector<Integer>();
                int n2 = 0;
                while (n2 < SCALABLE_SIZES.length) {
                    vector.addElement(Integer.valueOf(SCALABLE_SIZES[n2]));
                    ++n2;
                }
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Integer n3 = (Integer)enumeration.nextElement();
                    if (n3.equals(SCALABLE_KEY) || vector.contains(n3)) continue;
                    vector.addElement(n3);
                }
                this.setSizeItemsSorted(vector.elements());
            }
        }
        if ((n = this.fontSizeList.indexOf(string)) == -1) {
            n = this.fontSizeList.indexOf(String.valueOf(14));
        }
        n = Math.max(0, n);
        this.fontSizeList.select(n);
        this.fontSizeList.setData(new Integer(n));
        this.centerListIndex(this.fontSizeList, n);
        this.initStyleList();
    }

    void initStyleList() {
        int n;
        String string = this.getListSelection(this.fontStyleList);
        this.fontStyleList.removeAll();
        String string2 = this.getListSelection(this.charSetList);
        String string3 = this.getListSelection(this.faceNameList);
        String string4 = this.getListSelection(this.extStyleList);
        try {
            n = Integer.valueOf(this.getListSelection(this.fontSizeList));
            if (n > 0) {
                Hashtable hashtable = this.getStyles(string2, string3, string4, n);
                this.setItemsSorted(this.fontStyleList, hashtable);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if ((n = this.fontStyleList.indexOf(string)) == -1) {
            n = this.fontStyleList.indexOf(String.valueOf(DEFAULT_STYLE));
        }
        n = Math.max(0, n);
        this.fontStyleList.select(n);
        this.fontStyleList.setData(new Integer(n));
        this.centerListIndex(this.fontStyleList, n);
    }

    public FontData open() {
        this.shell = new Shell(this.getParent(), this.getStyle() | 0x20 | 0x800 | 0x10000);
        this.shell.setLayout(new GridLayout());
        this.createControls(this.shell);
        FontData[] fontDataArray = this.fontData;
        RGB rGB = this.rgb;
        this.initFonts();
        this.openDialog();
        this.setFontControls(this.currentFontData);
        this.updateSampleFont();
        this.updateSampleColor();
        this.updateFontList();
        this.fontSetList.select(0);
        this.fontSetList.setData(new Integer(0));
        this.updateButtonEnablements();
        this.hookListeners();
        Display display = this.shell.display;
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        FontData fontData = null;
        if (this.okSelected) {
            fontData = this.fontData[0];
        } else {
            this.fontData = fontDataArray;
            this.rgb = rGB;
        }
        if (this.sampleFont != null) {
            this.sampleFont.dispose();
        }
        this.sampleFont = null;
        if (this.sampleColor != null) {
            this.sampleColor.dispose();
        }
        this.sampleColor = null;
        return fontData;
    }

    void openDialog() {
        Point point = this.shell.computeSize(-1, -1, false);
        Display display = this.shell.display;
        Rectangle rectangle = display.getBounds();
        int n = rectangle.width * 7 / 8;
        int n2 = rectangle.height * 7 / 8;
        if (point.x > n) {
            point = this.shell.computeSize(n, -1, false);
        }
        Rectangle rectangle2 = null;
        rectangle2 = this.parent.isVisible() ? this.getParent().getBounds() : this.parent.getMonitor().getBounds();
        int n3 = (rectangle2.width - point.x) / 2 + rectangle2.x;
        n3 = Math.max(n3, 0);
        n3 = Math.min(n3, n - point.x);
        int n4 = (rectangle2.height - point.y) / 2 + rectangle2.y;
        n4 = Math.max(n4, 0);
        n4 = Math.min(n4, n2 - point.y);
        this.shell.setBounds(n3, n4, point.x, point.y);
        String string = this.getText();
        if (string.length() == 0) {
            string = SWT.getMessage("SWT_FontDialog_Title");
        }
        this.shell.setText(string);
        this.shell.open();
    }

    void setFontControls(FontData fontData) {
        this.ignoreEvents = true;
        String string = this.getTranslatedCharSet(fontData, true);
        String string2 = this.getTranslatedFaceName(fontData);
        this.charSetList.select(new String[]{string});
        int n = this.charSetList.indexOf(string);
        this.charSetList.setData(new Integer(n));
        if (n != -1) {
            this.centerListIndex(this.charSetList, n);
        }
        this.initFaceNameList();
        this.faceNameList.select(new String[]{string2});
        n = this.faceNameList.indexOf(string2);
        this.faceNameList.setData(new Integer(n));
        if (n != -1) {
            this.centerListIndex(this.faceNameList, n);
        }
        this.initExtStyleList();
        this.extStyleList.select(new String[]{fontData.addStyle});
        n = this.extStyleList.indexOf(fontData.addStyle);
        this.extStyleList.setData(new Integer(n));
        if (n != -1) {
            this.centerListIndex(this.extStyleList, n);
        }
        this.initSizeList();
        String string3 = String.valueOf(fontData.getHeight());
        this.fontSizeList.select(new String[]{string3});
        n = this.fontSizeList.indexOf(string3);
        this.fontSizeList.setData(new Integer(n));
        if (n != -1) {
            this.centerListIndex(this.fontSizeList, n);
        }
        this.initStyleList();
        this.fontStyleList.select(new String[]{fontData.weight});
        n = this.fontStyleList.indexOf(fontData.weight);
        this.fontStyleList.setData(new Integer(n));
        if (n != -1) {
            this.centerListIndex(this.fontStyleList, n);
        }
        this.ignoreEvents = false;
    }

    public void setFontData(FontData fontData) {
        if (fontData == null) {
            this.fontData = null;
        } else {
            this.fontData = new FontData[1];
            this.fontData[0] = fontData;
        }
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray;
    }

    void setItemsSorted(List list, Hashtable hashtable) {
        String[] stringArray;
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        String[] stringArray2 = new String[hashtable.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            if (stringArray.length() == 0) continue;
            stringArray2[n++] = stringArray;
        }
        if (n != stringArray2.length) {
            stringArray = new String[n];
            System.arraycopy(stringArray2, 0, stringArray, 0, n);
            stringArray2 = stringArray;
        }
        this.sort(stringArray2);
        list.setItems(stringArray2);
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }

    void setSizeItemsSorted(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new Integer[vector.size()];
        vector.copyInto(objectArray);
        this.sort((Integer[])objectArray);
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf((Integer)objectArray[n]);
            ++n;
        }
        this.fontSizeList.setItems(stringArray);
    }

    void sort(Integer[] integerArray) {
        int n = integerArray.length;
        int n2 = n / 2;
        while (n2 > 0) {
            int n3 = n2;
            while (n3 < n) {
                int n4 = n3 - n2;
                while (n4 >= 0) {
                    if (integerArray[n4] > integerArray[n4 + n2]) {
                        Integer n5 = integerArray[n4];
                        integerArray[n4] = integerArray[n4 + n2];
                        integerArray[n4 + n2] = n5;
                    }
                    n4 -= n2;
                }
                ++n3;
            }
            n2 /= 2;
        }
    }

    void sort(String[] stringArray) {
        int n = stringArray.length;
        int n2 = n / 2;
        while (n2 > 0) {
            int n3 = n2;
            while (n3 < n) {
                int n4 = n3 - n2;
                while (n4 >= 0) {
                    if (stringArray[n4].compareTo(stringArray[n4 + n2]) > 0) {
                        String string = stringArray[n4];
                        stringArray[n4] = stringArray[n4 + n2];
                        stringArray[n4 + n2] = string;
                    }
                    n4 -= n2;
                }
                ++n3;
            }
            n2 /= 2;
        }
    }

    void updateButtonEnablements() {
        this.removeButton.setEnabled(this.fontSetList.getItemCount() > 1);
        this.upButton.setEnabled(this.fontSetList.getSelectionIndex() > 0);
        this.downButton.setEnabled(this.fontSetList.getSelectionIndex() < this.fontSetList.getItemCount() - 1);
    }

    void updateFontList() {
        int n = this.fontSetList.getSelectionIndex();
        int n2 = Math.max(0, this.fontSetList.getTopIndex());
        String[] stringArray = new String[this.fontData.length];
        int n3 = 0;
        while (n3 < this.fontData.length) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(n3);
            stringBuffer.append(": ");
            stringBuffer.append(this.getTranslatedCharSet(this.fontData[n3], false));
            stringBuffer.append("-");
            stringBuffer.append(this.getTranslatedFaceName(this.fontData[n3]));
            stringBuffer.append("-");
            if (!this.fontData[n3].addStyle.equals("")) {
                stringBuffer.append(this.fontData[n3].addStyle);
                stringBuffer.append("-");
            }
            stringBuffer.append(this.fontData[n3].getHeight());
            stringBuffer.append("-");
            stringBuffer.append(this.fontData[n3].weight);
            stringArray[n3] = stringBuffer.toString();
            ++n3;
        }
        this.fontSetList.setItems(stringArray);
        if (n >= stringArray.length) {
            --n;
        }
        this.fontSetList.select(n);
        this.fontSetList.setData(new Integer(n));
        this.fontSetList.setTopIndex(n2);
        this.fontSetList.showSelection();
    }

    void updateSampleColor() {
        if (this.rgb == null) {
            this.rgb = new RGB(0, 0, 0);
        }
        if (this.sampleColor != null) {
            if (this.sampleColor.getRGB().equals(this.rgb)) {
                return;
            }
            this.sampleColor.dispose();
        }
        this.sampleColor = new Color(this.parent.display, this.rgb);
        this.sampleLabel.setForeground(this.sampleColor);
    }

    void updateSampleFont() {
        FontData fontData = this.getSelectionFontData();
        if (this.sampleFont != null) {
            this.sampleFont.dispose();
        }
        int n = Math.max(0, this.fontSetList.getSelectionIndex());
        this.fontData[n] = fontData;
        this.sampleFont = new Font((Device)this.shell.display, fontData);
        this.sampleLabel.setFont(this.sampleFont);
    }
}

