/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XtWidgetGeometry;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    int labelHandle;
    String text = "";

    public Group(Composite composite, int n) {
        super(composite, Group.checkStyle(n));
    }

    static int checkStyle(int n) {
        return (n |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Point point = super.computeSize(n, n2, bl);
        if (OS.XtIsManaged(this.labelHandle)) {
            int[] nArray = new int[4];
            nArray[0] = OS.XmNshadowThickness;
            nArray[2] = OS.XmNmarginWidth;
            int[] nArray2 = nArray;
            OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
            int n3 = nArray2[1];
            int n4 = nArray2[3];
            int n5 = this.getBorderWidth();
            int[] nArray3 = new int[2];
            nArray3[0] = OS.XmNchildHorizontalSpacing;
            int[] nArray4 = nArray3;
            OS.XtGetValues(this.labelHandle, nArray4, nArray4.length / 2);
            XtWidgetGeometry xtWidgetGeometry = new XtWidgetGeometry();
            OS.XtQueryGeometry(this.labelHandle, null, xtWidgetGeometry);
            int n6 = xtWidgetGeometry.width + 2 * (nArray4[1] + n4 + n3 + n5);
            point.x = Math.max(point.x, n6);
        }
        return point;
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int[] nArray = new int[6];
        nArray[0] = OS.XmNshadowThickness;
        nArray[2] = OS.XmNmarginWidth;
        nArray[4] = OS.XmNmarginHeight;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n5 = nArray2[1];
        int n6 = nArray2[3];
        int n7 = nArray2[5];
        int n8 = this.getBorderWidth();
        int n9 = n - n6 + n5 - n8;
        int n10 = n2 - n7 + n5 - n8;
        int n11 = n3 + (n6 + n5 + n8) * 2;
        int n12 = n4 + (n7 + n5 + n8) * 2;
        if (OS.XtIsManaged(this.labelHandle)) {
            int[] nArray3 = new int[6];
            nArray3[0] = OS.XmNy;
            nArray3[2] = OS.XmNheight;
            nArray3[4] = OS.XmNchildHorizontalSpacing;
            int[] nArray4 = nArray3;
            OS.XtGetValues(this.labelHandle, nArray4, nArray4.length / 2);
            int n13 = (short)nArray4[1] + nArray4[3];
            n10 = n2 - n13;
            n12 = n4 + n13 + (n7 + n5 + n8);
        }
        return new Rectangle(n9, n10, n11, n12);
    }

    void createHandle(int n) {
        this.state |= 0x80;
        int n2 = (this.style & 0x800) != 0 ? 1 : 0;
        int[] nArray = new int[]{OS.XmNancestorSensitive, 1, OS.XmNborderWidth, n2};
        int n3 = this.parent.handle;
        this.formHandle = OS.XmCreateForm(n3, null, nArray, nArray.length / 2);
        if (this.formHandle == 0) {
            this.error(2);
        }
        int[] nArray2 = new int[12];
        nArray2[0] = OS.XmNshadowType;
        nArray2[1] = this.shadowType();
        nArray2[2] = OS.XmNtopAttachment;
        nArray2[3] = 1;
        nArray2[4] = OS.XmNbottomAttachment;
        nArray2[5] = 1;
        nArray2[6] = OS.XmNleftAttachment;
        nArray2[7] = 1;
        nArray2[8] = OS.XmNrightAttachment;
        nArray2[9] = 1;
        nArray2[10] = OS.XmNresizable;
        int[] nArray3 = nArray2;
        this.handle = OS.XmCreateFrame(this.formHandle, null, nArray3, nArray3.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
        int[] nArray4 = new int[]{OS.XmNframeChildType, 2};
        this.labelHandle = OS.XmCreateLabel(this.handle, null, nArray4, nArray4.length / 2);
        if (this.labelHandle == 0) {
            this.error(2);
        }
        int[] nArray5 = new int[4];
        nArray5[0] = OS.XmNforeground;
        nArray5[2] = OS.XmNbackground;
        int[] nArray6 = nArray5;
        OS.XtGetValues(this.handle, nArray6, nArray6.length / 2);
        OS.XtSetValues(this.labelHandle, nArray6, nArray6.length / 2);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.labelHandle);
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        this.enableHandle(bl, this.labelHandle);
    }

    int fontHandle() {
        return this.labelHandle;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (!OS.XtIsRealized(this.handle)) {
            this.getShell().realizeWidget();
        }
        int[] nArray = new int[10];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        nArray[4] = OS.XmNshadowThickness;
        nArray[6] = OS.XmNmarginWidth;
        nArray[8] = OS.XmNmarginHeight;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = nArray2[5];
        int n2 = nArray2[7];
        int n3 = nArray2[9];
        int n4 = n2 + n;
        int n5 = n3 + n;
        int n6 = nArray2[1] - (n2 + n) * 2 - 1;
        int n7 = nArray2[3] - (n3 + n) * 2 - 1;
        if (OS.XtIsManaged(this.labelHandle)) {
            int[] nArray3 = new int[4];
            nArray3[0] = OS.XmNy;
            nArray3[2] = OS.XmNheight;
            int[] nArray4 = nArray3;
            OS.XtGetValues(this.labelHandle, nArray4, nArray4.length / 2);
            n5 = (short)nArray4[1] + nArray4[3];
            n7 = nArray2[3] - n5 - (n3 + n) - 1;
        }
        return new Rectangle(n4, n5, n6, n7);
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    void hookEvents() {
        super.hookEvents();
        int n = this.display.windowProc;
        OS.XtAddEventHandler(this.labelHandle, 4, false, n, 1);
        OS.XtAddEventHandler(this.labelHandle, 8, false, n, 2);
        OS.XtAddEventHandler(this.labelHandle, 64, false, n, 26);
    }

    boolean mnemonicHit(char c) {
        return this.setFocus();
    }

    boolean mnemonicMatch(char c) {
        char c2 = this.findMnemonic(this.getText());
        if (c2 == '\u0000') {
            return false;
        }
        return Character.toUpperCase(c) == Character.toUpperCase(c2);
    }

    void propagateWidget(boolean bl) {
        super.propagateWidget(bl);
        this.propagateHandle(bl, this.labelHandle, 0);
    }

    void redrawWidget(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        super.redrawWidget(n, n2, n3, n4, bl, bl2, bl3);
        short[] sArray = new short[1];
        short[] sArray2 = new short[1];
        OS.XtTranslateCoords(this.handle, (short)n, (short)n2, sArray, sArray2);
        short[] sArray3 = new short[1];
        short[] sArray4 = new short[1];
        OS.XtTranslateCoords(this.labelHandle, (short)0, (short)0, sArray3, sArray4);
        this.redrawHandle(sArray[0] - sArray3[0], sArray2[0] - sArray4[0], n3, n4, bl, this.labelHandle);
    }

    void register() {
        super.register();
        this.display.addWidget(this.labelHandle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.labelHandle = 0;
    }

    void setBackgroundPixel(int n) {
        super.setBackgroundPixel(n);
        int[] nArray = new int[2];
        nArray[0] = OS.XmNforeground;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.labelHandle, nArray2, nArray2.length / 2);
        OS.XmChangeColor(this.labelHandle, n);
        OS.XtSetValues(this.labelHandle, nArray2, nArray2.length / 2);
    }

    void setForegroundPixel(int n) {
        int[] nArray = new int[]{OS.XmNforeground, n};
        OS.XtSetValues(this.labelHandle, nArray, nArray.length / 2);
        super.setForegroundPixel(n);
    }

    void setParentBackground() {
        super.setParentBackground();
        if (this.labelHandle != 0) {
            this.setParentBackground(this.labelHandle);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n = this.fixMnemonic(cArray);
        byte[] byArray = Converter.wcsToMbcs(this.getCodePage(), cArray, true);
        int n2 = OS.XmStringParseText(byArray, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        if (n2 == 0) {
            this.error(13);
        }
        if (n == 0) {
            n = 0xFFFFFF;
        }
        int[] nArray = new int[]{OS.XmNlabelType, 2, OS.XmNlabelString, n2, OS.XmNmnemonic, n};
        OS.XtSetValues(this.labelHandle, nArray, nArray.length / 2);
        if (n2 != 0) {
            OS.XmStringFree(n2);
        }
        if (string.length() == 0) {
            OS.XtUnmanageChild(this.labelHandle);
        } else {
            OS.XtManageChild(this.labelHandle);
        }
    }

    int shadowType() {
        if ((this.style & 4) != 0) {
            return 7;
        }
        if ((this.style & 8) != 0) {
            return 8;
        }
        if ((this.style & 0x10) != 0) {
            return 5;
        }
        if ((this.style & 0x40) != 0) {
            return 6;
        }
        return 5;
    }
}

