/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    int scrolledHandle;
    int formHandle;
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite composite, int n) {
        super(composite, n);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int n5 = this.getBorderWidth();
        int n6 = n - n5;
        int n7 = n2 - n5;
        int n8 = n3 + n5 * 2;
        int n9 = n4 + n5 * 2;
        if (this.horizontalBar != null) {
            n7 -= this.display.scrolledInsetY;
            n9 += this.display.scrolledInsetY + this.display.scrolledMarginY;
            if (this.verticalBar == null) {
                n6 -= this.display.scrolledInsetX;
                n8 += this.display.scrolledInsetX * 2;
                n9 -= this.display.scrolledInsetY * 2;
            }
        }
        if (this.verticalBar != null) {
            n6 -= this.display.scrolledInsetX;
            n8 += this.display.scrolledInsetX + this.display.scrolledMarginX;
            if (this.horizontalBar == null) {
                n7 -= this.display.scrolledInsetY;
                n9 += this.display.scrolledInsetY * 2;
                n8 -= this.display.scrolledInsetX * 2;
            }
        }
        return new Rectangle(n6, n7, n8, n9);
    }

    ScrollBar createScrollBar(int n) {
        return new ScrollBar(this, n);
    }

    ScrollBar createStandardBar(int n) {
        if (this.scrolledHandle == 0) {
            return null;
        }
        ScrollBar scrollBar = new ScrollBar();
        scrollBar.parent = this;
        scrollBar.style = n;
        scrollBar.display = this.display;
        int[] nArray = new int[4];
        nArray[0] = OS.XmNhorizontalScrollBar;
        nArray[2] = OS.XmNverticalScrollBar;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.scrolledHandle, nArray2, nArray2.length / 2);
        if (n == 256) {
            scrollBar.handle = nArray2[1];
        }
        if (n == 512) {
            scrollBar.handle = nArray2[3];
        }
        scrollBar.hookEvents();
        scrollBar.register();
        return scrollBar;
    }

    void createWidget(int n) {
        super.createWidget(n);
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    void deregister() {
        super.deregister();
        if (this.formHandle != 0) {
            this.display.removeWidget(this.formHandle);
        }
        if (this.scrolledHandle != 0) {
            this.display.removeWidget(this.scrolledHandle);
        }
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        if (this.formHandle != 0) {
            this.enableHandle(bl, this.formHandle);
        }
        if (this.scrolledHandle != 0) {
            this.enableHandle(bl, this.scrolledHandle);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return new Rectangle(0, 0, nArray2[1], nArray2[3]);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    void manageChildren() {
        int[] nArray;
        if (this.scrolledHandle != 0) {
            OS.XtSetMappedWhenManaged(this.scrolledHandle, false);
            OS.XtManageChild(this.scrolledHandle);
        }
        if (this.formHandle != 0) {
            OS.XtSetMappedWhenManaged(this.formHandle, false);
            OS.XtManageChild(this.formHandle);
        }
        super.manageChildren();
        if (this.formHandle != 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = OS.XmNborderWidth;
            nArray = nArray2;
            OS.XtGetValues(this.formHandle, nArray, nArray.length / 2);
            OS.XtResizeWidget(this.formHandle, 1, 1, nArray[1]);
            OS.XtSetMappedWhenManaged(this.formHandle, true);
        }
        if (this.scrolledHandle != 0) {
            int[] nArray3 = new int[2];
            nArray3[0] = OS.XmNborderWidth;
            nArray = nArray3;
            OS.XtGetValues(this.scrolledHandle, nArray, nArray.length / 2);
            OS.XtResizeWidget(this.scrolledHandle, 1, 1, nArray[1]);
            OS.XtSetMappedWhenManaged(this.scrolledHandle, true);
        }
    }

    void propagateWidget(boolean bl) {
        super.propagateWidget(bl);
        if (this.formHandle != 0) {
            this.propagateHandle(bl, this.formHandle, 0);
        }
        if (this.scrolledHandle != 0) {
            this.propagateHandle(bl, this.scrolledHandle, 0);
            if (this.horizontalBar != null) {
                this.horizontalBar.propagateWidget(bl);
            }
            if (this.verticalBar != null) {
                this.verticalBar.propagateWidget(bl);
            }
        }
    }

    void register() {
        super.register();
        if (this.formHandle != 0) {
            this.display.addWidget(this.formHandle, this);
        }
        if (this.scrolledHandle != 0) {
            this.display.addWidget(this.scrolledHandle, this);
        }
    }

    void releaseChildren(boolean bl) {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.formHandle = 0;
        this.scrolledHandle = 0;
    }

    void setBackgroundPixel(int n) {
        super.setBackgroundPixel(n);
    }

    void redrawWidget(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        short[] sArray;
        short[] sArray2;
        super.redrawWidget(n, n2, n3, n4, bl, bl2, bl3);
        if (!bl3) {
            return;
        }
        if (this.formHandle == 0 && this.scrolledHandle == 0) {
            return;
        }
        short[] sArray3 = new short[1];
        short[] sArray4 = new short[1];
        OS.XtTranslateCoords(this.handle, (short)n, (short)n2, sArray3, sArray4);
        if (this.formHandle != 0) {
            sArray2 = new short[1];
            sArray = new short[1];
            OS.XtTranslateCoords(this.formHandle, (short)0, (short)0, sArray2, sArray);
            this.redrawHandle(sArray3[0] - sArray2[0], sArray4[0] - sArray[0], n3, n4, bl, this.formHandle);
        }
        if (this.scrolledHandle != 0) {
            short[] sArray5;
            short[] sArray6;
            int n5;
            sArray2 = new short[1];
            sArray = new short[1];
            OS.XtTranslateCoords(this.scrolledHandle, (short)0, (short)0, sArray2, sArray);
            this.redrawHandle(sArray3[0] - sArray2[0], sArray4[0] - sArray[0], n3, n4, bl, this.scrolledHandle);
            if (this.horizontalBar != null && this.horizontalBar.getVisible()) {
                n5 = this.horizontalBar.handle;
                sArray6 = new short[1];
                sArray5 = new short[1];
                OS.XtTranslateCoords(n5, (short)0, (short)0, sArray6, sArray5);
                this.redrawHandle(sArray3[0] - sArray6[0], sArray4[0] - sArray5[0], n3, n4, bl, n5);
            }
            if (this.verticalBar != null && this.verticalBar.getVisible()) {
                n5 = this.verticalBar.handle;
                sArray6 = new short[1];
                sArray5 = new short[1];
                OS.XtTranslateCoords(n5, (short)0, (short)0, sArray6, sArray5);
                this.redrawHandle(sArray3[0] - sArray6[0], sArray4[0] - sArray5[0], n3, n4, bl, n5);
            }
        }
    }

    boolean setScrollBarVisible(ScrollBar scrollBar, boolean bl) {
        if (this.scrolledHandle == 0) {
            return false;
        }
        int n = scrollBar.handle;
        boolean bl2 = OS.XtIsManaged(n);
        if (bl2 == bl) {
            return false;
        }
        int[] nArray = new int[6];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        nArray[4] = OS.XmNborderWidth;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.scrolledHandle, nArray2, nArray2.length / 2);
        int[] nArray3 = new int[4];
        nArray3[0] = OS.XmNwidth;
        nArray3[2] = OS.XmNheight;
        int[] nArray4 = nArray3;
        OS.XtGetValues(this.handle, nArray4, nArray4.length / 2);
        if (bl) {
            OS.XtManageChild(n);
        } else {
            OS.XtUnmanageChild(n);
        }
        if ((this.state & 2) != 0 && this.formHandle != 0) {
            int[] nArray5;
            int n2;
            boolean bl3 = (this.style & 0x800) != 0;
            int n3 = n2 = bl3 || bl ? 3 : 0;
            if ((scrollBar.style & 0x200) != 0) {
                nArray5 = new int[]{OS.XmNmarginWidth, n2};
                OS.XtSetValues(this.formHandle, nArray5, nArray5.length / 2);
            }
            if ((scrollBar.style & 0x100) != 0) {
                nArray5 = new int[]{OS.XmNmarginHeight, n2};
                OS.XtSetValues(this.formHandle, nArray5, nArray5.length / 2);
            }
        }
        OS.XtResizeWidget(this.scrolledHandle, nArray2[1], nArray2[3], nArray2[5]);
        scrollBar.sendEvent(bl ? 22 : 23);
        int[] nArray6 = new int[4];
        nArray6[0] = OS.XmNwidth;
        nArray6[2] = OS.XmNheight;
        int[] nArray7 = nArray6;
        OS.XtGetValues(this.handle, nArray7, nArray7.length / 2);
        if (nArray4[1] != nArray7[1] || nArray4[3] != nArray7[3]) {
            this.sendEvent(11);
            return true;
        }
        return false;
    }

    int topHandle() {
        if (this.scrolledHandle != 0) {
            return this.scrolledHandle;
        }
        if (this.formHandle != 0) {
            return this.formHandle;
        }
        return this.handle;
    }
}

