/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    TabFolder parent;
    int x;
    int y;
    int width;
    int height = 0;
    String toolTipText;
    Control control;
    static final int LEFT_HORIZONTAL_MARGIN = 8;
    static final int RIGHT_HORIZONTAL_MARGIN = 2;
    static final int VERTICAL_MARGIN = 1;
    static final int ICON_MARGIN = 6;
    static final int SHADOW_WIDTH = 2;
    static final int DEFAULT_TEXT_WIDTH = 36;

    public TabItem(TabFolder tabFolder, int n) {
        super(tabFolder, n);
        tabFolder.createChild(this, tabFolder.getItemCount());
    }

    public TabItem(TabFolder tabFolder, int n, int n2) {
        super(tabFolder, n);
        tabFolder.createChild(this, n2);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        super.dispose();
        this.parent.destroyChild(this);
        this.parent = null;
        this.control = null;
        this.toolTipText = null;
    }

    void expand(int n, int n2, int n3, int n4) {
        if (this.hasLocation()) {
            this.x -= n;
            this.y -= n2;
            this.width = this.width + n + n3;
            this.height = this.height + n2 + n4;
        }
    }

    Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    boolean hasLocation() {
        return this.width != 0 || this.height != 0 || this.x != 0 || this.y != 0;
    }

    private int imageHeight() {
        Image image = this.getImage();
        if (this.parent.getImageHeight() != -1) {
            return this.parent.getImageHeight();
        }
        if (image != null && !image.isDisposed()) {
            return image.getBounds().height;
        }
        return 0;
    }

    private int imageWidth() {
        Image image = this.getImage();
        if (image != null && !image.isDisposed()) {
            return image.getBounds().width;
        }
        return 0;
    }

    void paint(GC gC, boolean bl) {
        int n;
        gC.setForeground(this.display.getSystemColor(20));
        gC.drawLine(this.x, this.y + this.height - 2, this.x, this.y + 2);
        gC.drawLine(this.x, this.y + 2, this.x + 2, this.y);
        gC.drawLine(this.x + 2, this.y, this.x + this.width - 3, this.y);
        gC.setForeground(this.display.getSystemColor(19));
        gC.drawLine(this.x + 1, this.y + this.height - 2, this.x + 1, this.y + 2);
        gC.drawLine(this.x + 2, this.y + 1, this.x + this.width - 3, this.y + 1);
        gC.setForeground(this.display.getSystemColor(21));
        gC.drawLine(this.x + this.width - 1, this.y + 2, this.x + this.width - 1, this.y + this.height - 1);
        gC.drawLine(this.x + this.width - 2, this.y + 1, this.x + this.width - 2, this.y + 1);
        gC.setForeground(this.display.getSystemColor(18));
        gC.drawLine(this.x + this.width - 2, this.y + 2, this.x + this.width - 2, this.y + this.height - 1);
        if (this.parent.isFocusControl() && bl) {
            gC.drawFocus(this.x + 3, this.y + 3, this.width - 6, this.height - 3);
        }
        gC.setForeground(this.parent.getForeground());
        int n2 = this.x + 8;
        int n3 = 6;
        Image image = this.getImage();
        Rectangle rectangle = null;
        if (image != null) {
            rectangle = image.getBounds();
            n = this.y + 2 + 1 + (this.height - n3 - this.imageHeight()) / 2;
            gC.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2, n, rectangle.width, this.parent.getImageHeight());
        }
        n2 += 6;
        if (rectangle != null) {
            n2 += rectangle.width;
        }
        n = this.y + 2 + 1 + (this.height - n3 - this.textHeight(gC)) / 2;
        int n4 = 9;
        gC.drawText(this.getText(), n2, n, n4);
    }

    int preferredHeight(GC gC) {
        int n = this.textHeight(gC);
        if (this.imageHeight() > n) {
            n = this.imageHeight();
        }
        return n += 6;
    }

    int preferredWidth(GC gC) {
        return this.imageWidth() + this.textWidth(gC) + 8 + 2 + 6 + 4;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control control2 = this.control;
        Control control3 = control;
        this.control = control;
        int n = this.parent.indexOf(this);
        if (n != this.parent.getSelectionIndex()) {
            if (control3 != null) {
                control3.setVisible(false);
            }
            return;
        }
        if (control3 != null) {
            control3.setBounds(this.parent.getClientArea());
            control3.setVisible(true);
        }
        if (control2 != null) {
            control2.setVisible(false);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        Image image2 = this.image;
        super.setImage(image);
        if (image == null || !image.equals(image2)) {
            this.parent.itemChanged(this);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        String string2 = this.text;
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        if (!string.equals(string2)) {
            this.parent.itemChanged(this);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    private int textHeight(GC gC) {
        String string = this.getText();
        if (string == null) {
            return 0;
        }
        int n = 8;
        return gC.textExtent((String)string, (int)n).y;
    }

    private int textWidth(GC gC) {
        String string = this.getText();
        int n = 0;
        if (string != null) {
            int n2 = 8;
            n = gC.textExtent((String)string, (int)n2).x;
        }
        if (n == 0) {
            n = 36;
        }
        return n;
    }
}

