/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.TypedListener;

public class Table
extends Composite {
    Canvas header;
    TableColumn[] columns = new TableColumn[0];
    TableColumn[] orderedColumns;
    TableItem[] items = new TableItem[0];
    TableItem[] selectedItems = new TableItem[0];
    TableItem focusItem;
    TableItem anchorItem;
    TableItem lastClickedItem;
    Event lastSelectionEvent;
    boolean linesVisible;
    boolean ignoreKey;
    boolean ignoreDispose;
    boolean customHeightSet;
    int itemsCount = 0;
    int topIndex = 0;
    int horizontalOffset = 0;
    int fontHeight = 0;
    int imageHeight = 0;
    int itemHeight = 0;
    int col0ImageWidth = 0;
    int headerImageHeight = 0;
    TableColumn resizeColumn;
    int resizeColumnX = -1;
    int drawCount = 0;
    TableColumn sortColumn;
    int sortDirection = 0;
    Listener toolTipListener;
    Shell toolTipShell;
    Label toolTipLabel;
    Rectangle arrowBounds;
    Rectangle checkboxBounds;
    Rectangle clientArea;
    static final int MARGIN_IMAGE = 3;
    static final int MARGIN_CELL = 1;
    static final int SIZE_HORIZONTALSCROLL = 5;
    static final int TOLLERANCE_COLUMNRESIZE = 2;
    static final int WIDTH_HEADER_SHADOW = 2;
    static final int WIDTH_CELL_HIGHLIGHT = 1;
    static final int[] toolTipEvents = new int[]{7, 32, 5, 3};
    static final String ELLIPSIS = "...";
    static final String ID_UNCHECKED = "UNCHECKED";
    static final String ID_GRAYUNCHECKED = "GRAYUNCHECKED";
    static final String ID_CHECKMARK = "CHECKMARK";
    static final String ID_ARROWUP = "ARROWUP";
    static final String ID_ARROWDOWN = "ARROWDOWN";
    boolean hasFocus;

    public boolean isFocusControl() {
        return this.hasFocus;
    }

    public Table(Composite composite, int n) {
        super(composite, Table.checkStyle(n | 0x100 | 0x200 | 0x100000 | 0x40000 | 0x20000000));
        this.setForeground(null);
        this.setBackground(null);
        GC gC = new GC(this);
        this.fontHeight = gC.getFontMetrics().getHeight();
        gC.dispose();
        this.itemHeight = this.fontHeight + 2 * this.getCellPadding();
        Table.initImages(this.display);
        this.checkboxBounds = this.getUncheckedImage().getBounds();
        this.arrowBounds = this.getArrowDownImage().getBounds();
        this.clientArea = this.getClientArea();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                Table.this.handleEvents(event);
            }
        };
        this.addListener(9, listener);
        this.addListener(3, listener);
        this.addListener(4, listener);
        this.addListener(8, listener);
        this.addListener(12, listener);
        this.addListener(11, listener);
        this.addListener(1, listener);
        this.addListener(16, listener);
        this.addListener(15, listener);
        this.addListener(31, listener);
        this.header = new Canvas(this, 0x180000);
        this.header.setVisible(false);
        this.header.setBounds(0, 0, 0, this.fontHeight + 2 * this.getHeaderPadding());
        this.header.addListener(9, listener);
        this.header.addListener(3, listener);
        this.header.addListener(4, listener);
        this.header.addListener(32, listener);
        this.header.addListener(8, listener);
        this.header.addListener(5, listener);
        this.header.addListener(7, listener);
        this.toolTipListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: 
                    case 32: {
                        if (Table.this.headerUpdateToolTip(event.x)) break;
                    }
                    case 3: 
                    case 7: {
                        Table.this.headerHideToolTip();
                    }
                }
            }
        };
        ScrollBar scrollBar = this.getVerticalBar();
        ScrollBar scrollBar2 = this.getHorizontalBar();
        scrollBar.setValues(0, 0, 1, 1, 1, 1);
        scrollBar2.setValues(0, 0, 1, 1, 1, 1);
        scrollBar.setVisible(false);
        scrollBar2.setVisible(false);
        scrollBar.addListener(13, listener);
        scrollBar2.addListener(13, listener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    boolean checkData(TableItem tableItem, boolean bl) {
        if (tableItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            tableItem.cached = true;
            Event event = new Event();
            event.item = tableItem;
            event.index = this.indexOf(tableItem);
            this.sendEvent(36, event);
            if (this.isDisposed() || tableItem.isDisposed()) {
                return false;
            }
            if (bl) {
                this.redrawItem(tableItem.index, false);
            }
        }
        return true;
    }

    static int checkStyle(int n) {
        return Table.checkBits(n, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemsCount) {
            this.error(6);
        }
        Rectangle rectangle = this.items[n].getBounds(false);
        int n2 = rectangle.x + rectangle.width;
        this.items[n].clear();
        if (this.columns.length == 0) {
            this.updateHorizontalBar(0, -n2);
        }
        this.redrawItem(n, false);
    }

    public void clear(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (n < 0 || n > n2 || n2 >= this.itemsCount) {
            this.error(6);
        }
        int n3 = n;
        while (n3 <= n2) {
            this.items[n3].clear();
            ++n3;
        }
        this.updateHorizontalBar();
        this.redrawItems(n, n2, false);
    }

    public void clear(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < 0 || nArray[n] >= this.itemsCount) {
                this.error(6);
            }
            ++n;
        }
        n = 0;
        while (n < nArray.length) {
            this.items[nArray[n]].clear();
            ++n;
        }
        this.updateHorizontalBar();
        n = 0;
        while (n < nArray.length) {
            this.redrawItem(nArray[n], false);
            ++n;
        }
    }

    public void clearAll() {
        this.checkWidget();
        this.clear(0, this.itemsCount - 1);
    }

    int computeColumnIntersect(int n, int n2) {
        TableColumn[] tableColumnArray = this.getOrderedColumns();
        if (tableColumnArray.length - 1 < n2) {
            return -1;
        }
        int n3 = tableColumnArray[n2].getX();
        int n4 = n2;
        while (n4 < tableColumnArray.length) {
            if (n < (n3 += tableColumnArray[n4].width)) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if (n != -1) {
            n3 = n;
        } else if (this.columns.length == 0) {
            int n5 = 0;
            while (n5 < this.itemsCount) {
                Rectangle rectangle = this.items[n5].getBounds(false);
                n3 = Math.max(n3, rectangle.x + rectangle.width);
                ++n5;
            }
        } else {
            TableColumn[] tableColumnArray = this.getOrderedColumns();
            TableColumn tableColumn = tableColumnArray[tableColumnArray.length - 1];
            n3 = tableColumn.getX() + tableColumn.width;
        }
        n4 = n2 != -1 ? n2 : this.getHeaderHeight() + this.itemsCount * this.itemHeight;
        Rectangle rectangle = this.computeTrim(0, 0, n3, n4);
        return new Point(rectangle.width, rectangle.height);
    }

    void createItem(TableColumn tableColumn, int n) {
        int n2;
        TableColumn[] tableColumnArray = new TableColumn[this.columns.length + 1];
        System.arraycopy(this.columns, 0, tableColumnArray, 0, n);
        tableColumnArray[n] = tableColumn;
        System.arraycopy(this.columns, n, tableColumnArray, n + 1, this.columns.length - n);
        this.columns = tableColumnArray;
        if (this.orderedColumns != null) {
            n2 = 0;
            if (n > 0) {
                n2 = this.columns[n - 1].getOrderIndex() + 1;
            }
            TableColumn[] tableColumnArray2 = new TableColumn[this.orderedColumns.length + 1];
            System.arraycopy(this.orderedColumns, 0, tableColumnArray2, 0, n2);
            tableColumnArray2[n2] = tableColumn;
            System.arraycopy(this.orderedColumns, n2, tableColumnArray2, n2 + 1, this.orderedColumns.length - n2);
            this.orderedColumns = tableColumnArray2;
        }
        n2 = 0;
        while (n2 < this.itemsCount) {
            this.items[n2].addColumn(tableColumn);
            ++n2;
        }
        if (this.columns.length == 1 && this.itemsCount > 0) {
            this.redrawFromItemDownwards(this.topIndex);
        } else if (this.itemsCount > 0 && (this.style & 0x20) != 0 && n == 0 && tableColumn.getOrderIndex() == 0) {
            this.redrawFromItemDownwards(this.topIndex);
        }
    }

    void createItem(TableItem tableItem) {
        int n;
        int n2 = tableItem.index;
        if (this.itemsCount == this.items.length) {
            n = this.drawCount <= 0 ? 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] tableItemArray = new TableItem[this.items.length + n];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.items.length);
            this.items = tableItemArray;
        }
        if (n2 != this.itemsCount) {
            System.arraycopy(this.items, n2, this.items, n2 + 1, this.itemsCount - n2);
        }
        this.items[n2] = tableItem;
        ++this.itemsCount;
        n = n2 + 1;
        while (n < this.itemsCount) {
            this.items[n].index = n;
            ++n;
        }
        this.updateVerticalBar();
        Rectangle rectangle = tableItem.getBounds(false);
        int n3 = rectangle.x + rectangle.width;
        this.updateHorizontalBar(n3, n3);
        if (tableItem.index < this.topIndex) {
            ++this.topIndex;
            this.getVerticalBar().setSelection(this.topIndex);
            return;
        }
        if (this.itemsCount == 1 && this.isFocusControl()) {
            this.focusItem = tableItem;
            this.redraw();
            return;
        }
        if (tableItem.isInViewport()) {
            this.redrawFromItemDownwards(n2);
        }
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemsCount) {
            return;
        }
        TableItem tableItem = this.items[n];
        int n2 = this.getSelectionIndex(tableItem);
        if (n2 == -1) {
            return;
        }
        TableItem[] tableItemArray = new TableItem[this.selectedItems.length - 1];
        System.arraycopy(this.selectedItems, 0, tableItemArray, 0, n2);
        System.arraycopy(this.selectedItems, n2 + 1, tableItemArray, n2, tableItemArray.length - n2);
        this.selectedItems = tableItemArray;
        if (this.hasFocus() || (this.style & 0x8000) == 0) {
            this.redrawItem(tableItem.index, false);
        }
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        if (n == 0 && n2 == this.itemsCount - 1) {
            this.deselectAll();
        } else {
            n = Math.max(n, 0);
            n2 = Math.min(n2, this.itemsCount - 1);
            int n3 = n;
            while (n3 <= n2) {
                this.deselect(n3);
                ++n3;
            }
        }
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            this.deselect(nArray[n]);
            ++n;
        }
    }

    public void deselectAll() {
        this.checkWidget();
        TableItem[] tableItemArray = this.selectedItems;
        this.selectedItems = new TableItem[0];
        if (this.hasFocus() || (this.style & 0x8000) == 0) {
            int n = 0;
            while (n < tableItemArray.length) {
                this.redrawItem(tableItemArray[n].index, true);
                ++n;
            }
        }
    }

    void deselectItem(TableItem tableItem) {
        int n = this.getSelectionIndex(tableItem);
        if (n == -1) {
            return;
        }
        TableItem[] tableItemArray = new TableItem[this.selectedItems.length - 1];
        System.arraycopy(this.selectedItems, 0, tableItemArray, 0, n);
        System.arraycopy(this.selectedItems, n + 1, tableItemArray, n, tableItemArray.length - n);
        this.selectedItems = tableItemArray;
    }

    void destroyItem(TableColumn tableColumn) {
        TableColumn[] tableColumnArray;
        int n;
        this.headerHideToolTip();
        int n2 = tableColumn.getIndex();
        int n3 = tableColumn.getOrderIndex();
        TableColumn[] tableColumnArray2 = new TableColumn[this.columns.length - 1];
        System.arraycopy(this.columns, 0, tableColumnArray2, 0, n2);
        System.arraycopy(this.columns, n2 + 1, tableColumnArray2, n2, tableColumnArray2.length - n2);
        this.columns = tableColumnArray2;
        if (this.orderedColumns != null) {
            if (this.columns.length < 2) {
                this.orderedColumns = null;
            } else {
                n = tableColumn.getOrderIndex();
                tableColumnArray = new TableColumn[this.orderedColumns.length - 1];
                System.arraycopy(this.orderedColumns, 0, tableColumnArray, 0, n);
                System.arraycopy(this.orderedColumns, n + 1, tableColumnArray, n, tableColumnArray.length - n);
                this.orderedColumns = tableColumnArray;
            }
        }
        if (n2 == 0 && this.columns.length > 0) {
            this.columns[0].style |= 0x4000;
            this.columns[0].style &= 0xFEFDFFFF;
        }
        n = 0;
        while (n < this.itemsCount) {
            this.items[n].removeColumn(tableColumn, n2);
            ++n;
        }
        n = this.columns.length - 1;
        if (n < 0) {
            this.updateHorizontalBar();
        } else {
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.columns.length) {
                n4 += this.columns[n5].width;
                ++n5;
            }
            ScrollBar scrollBar = this.getHorizontalBar();
            scrollBar.setMaximum(n4);
            scrollBar.setVisible(this.clientArea.width < n4);
            int n6 = scrollBar.getSelection();
            if (n6 != this.horizontalOffset) {
                this.horizontalOffset = n6;
                this.redraw();
                if (this.header.isVisible() && this.drawCount <= 0) {
                    this.header.redraw();
                }
            }
        }
        tableColumnArray = this.getOrderedColumns();
        int n7 = n3;
        while (n7 < tableColumnArray.length) {
            if (!tableColumnArray[n7].isDisposed()) {
                tableColumnArray[n7].sendEvent(10);
            }
            ++n7;
        }
        if (this.sortColumn == tableColumn) {
            this.sortColumn = null;
        }
    }

    void destroyItem(TableItem tableItem) {
        if (tableItem == this.focusItem) {
            this.reassignFocus();
        }
        int n = tableItem.index;
        Rectangle rectangle = tableItem.getBounds(false);
        int n2 = rectangle.x + rectangle.width;
        if (n != this.itemsCount - 1) {
            System.arraycopy(this.items, n + 1, this.items, n, this.itemsCount - n - 1);
            this.items[this.itemsCount - 1] = null;
        } else {
            this.items[n] = null;
        }
        --this.itemsCount;
        if (this.drawCount <= 0 && this.items.length - this.itemsCount == 4) {
            TableItem[] tableItemArray = new TableItem[this.itemsCount];
            System.arraycopy(this.items, 0, tableItemArray, 0, tableItemArray.length);
            this.items = tableItemArray;
        }
        int n3 = n;
        while (n3 < this.itemsCount) {
            this.items[n3].index = n3;
            ++n3;
        }
        tableItem.index = -1;
        n3 = this.topIndex;
        this.updateVerticalBar();
        this.updateHorizontalBar(0, -n2);
        if (n < this.topIndex) {
            this.topIndex = n3 - 1;
            this.getVerticalBar().setSelection(this.topIndex);
        }
        if (tableItem.isSelected()) {
            int n4 = this.getSelectionIndex(tableItem);
            TableItem[] tableItemArray = new TableItem[this.selectedItems.length - 1];
            System.arraycopy(this.selectedItems, 0, tableItemArray, 0, n4);
            System.arraycopy(this.selectedItems, n4 + 1, tableItemArray, n4, tableItemArray.length - n4);
            this.selectedItems = tableItemArray;
        }
        if (tableItem == this.anchorItem) {
            this.anchorItem = null;
        }
        if (tableItem == this.lastClickedItem) {
            this.lastClickedItem = null;
        }
        if (this.itemsCount == 0 && this.isFocusControl()) {
            this.redraw();
            return;
        }
    }

    Image getArrowDownImage() {
        return (Image)this.display.getData(ID_ARROWDOWN);
    }

    Image getArrowUpImage() {
        return (Image)this.display.getData(ID_ARROWUP);
    }

    int getCellPadding() {
        return 2;
    }

    Image getCheckmarkImage() {
        return (Image)this.display.getData(ID_CHECKMARK);
    }

    public Control[] getChildren() {
        this.checkWidget();
        Control[] controlArray = this._getChildren();
        if (this.header == null) {
            return controlArray;
        }
        Control[] controlArray2 = new Control[controlArray.length - 1];
        int n = 0;
        int n2 = 0;
        while (n2 < controlArray.length) {
            if (controlArray[n2] != this.header) {
                controlArray2[n++] = controlArray[n2];
            }
            ++n2;
        }
        return controlArray2;
    }

    public TableColumn getColumn(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.columns.length) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columns.length;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] nArray = new int[this.columns.length];
        if (this.orderedColumns != null) {
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = this.orderedColumns[n].getIndex();
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.columns.length) {
                nArray[n] = n;
                ++n;
            }
        }
        return nArray;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] tableColumnArray = new TableColumn[this.columns.length];
        System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columns.length);
        return tableColumnArray;
    }

    Image getGrayUncheckedImage() {
        return (Image)this.display.getData(ID_GRAYUNCHECKED);
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!this.header.getVisible()) {
            return 0;
        }
        return this.header.getSize().y;
    }

    int getHeaderPadding() {
        return 3;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return this.header.getVisible();
    }

    public TableItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemsCount) {
            this.error(6);
        }
        return this.items[n];
    }

    public TableItem getItem(Point point) {
        int n;
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((n = (point.y - this.getHeaderHeight()) / this.itemHeight + this.topIndex) < 0 || n >= this.itemsCount) {
            return null;
        }
        TableItem tableItem = this.items[n];
        if (!tableItem.getHitBounds().contains(point)) {
            return null;
        }
        return tableItem;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemsCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.itemHeight;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] tableItemArray = new TableItem[this.itemsCount];
        System.arraycopy(this.items, 0, tableItemArray, 0, this.itemsCount);
        return tableItemArray;
    }

    int getItemY(TableItem tableItem) {
        return (tableItem.index - this.topIndex) * this.itemHeight + this.getHeaderHeight();
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this.linesVisible;
    }

    TableColumn[] getOrderedColumns() {
        if (this.orderedColumns != null) {
            return this.orderedColumns;
        }
        return this.columns;
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        TableItem[] tableItemArray = new TableItem[this.selectedItems.length];
        System.arraycopy(this.selectedItems, 0, tableItemArray, 0, this.selectedItems.length);
        this.sortAscent(tableItemArray);
        return tableItemArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.selectedItems.length;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if (this.selectedItems.length == 0) {
            return -1;
        }
        return this.selectedItems[0].index;
    }

    int getSelectionIndex(TableItem tableItem) {
        int n = 0;
        while (n < this.selectedItems.length) {
            if (this.selectedItems[n] == tableItem) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int[] nArray = new int[this.selectedItems.length];
        int n = 0;
        while (n < this.selectedItems.length) {
            nArray[n] = this.selectedItems[n].index;
            ++n;
        }
        this.sortAscent(nArray);
        return nArray;
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int getTopIndex() {
        this.checkWidget();
        return this.topIndex;
    }

    Image getUncheckedImage() {
        return (Image)this.display.getData(ID_UNCHECKED);
    }

    void handleEvents(Event event) {
        switch (event.type) {
            case 9: {
                if (event.widget == this.header) {
                    this.headerOnPaint(event);
                    break;
                }
                this.onPaint(event);
                break;
            }
            case 3: {
                if (event.widget == this.header) {
                    this.headerOnMouseDown(event);
                    break;
                }
                this.onMouseDown(event);
                break;
            }
            case 4: {
                if (event.widget == this.header) {
                    this.headerOnMouseUp(event);
                    break;
                }
                this.onMouseUp(event);
                break;
            }
            case 32: {
                this.headerOnMouseHover(event);
                break;
            }
            case 5: {
                this.headerOnMouseMove(event);
                break;
            }
            case 8: {
                if (event.widget == this.header) {
                    this.headerOnMouseDoubleClick(event);
                    break;
                }
                this.onMouseDoubleClick(event);
                break;
            }
            case 7: {
                this.headerOnMouseExit();
                break;
            }
            case 12: {
                this.onDispose(event);
                break;
            }
            case 1: {
                this.onKeyDown(event);
                break;
            }
            case 11: {
                this.onResize(event);
                break;
            }
            case 13: {
                if (event.widget == this.getVerticalBar()) {
                    this.onScrollVertical(event);
                    break;
                }
                this.onScrollHorizontal(event);
                break;
            }
            case 16: {
                this.onFocusOut();
                break;
            }
            case 15: {
                this.onFocusIn();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 256: 
                    case 512: {
                        event.doit = true;
                    }
                }
            }
        }
    }

    String headerGetToolTip(int n) {
        int n2;
        if (this.resizeColumn != null) {
            return null;
        }
        int n3 = this.computeColumnIntersect(n, 0);
        if (n3 == -1) {
            return null;
        }
        TableColumn[] tableColumnArray = this.getOrderedColumns();
        TableColumn tableColumn = tableColumnArray[n3];
        if (tableColumn.toolTipText == null) {
            return null;
        }
        int n4 = tableColumn.getX();
        if (n3 > 0 && tableColumnArray[n3 - 1].resizable && n - n4 <= 2) {
            return null;
        }
        if (tableColumn.resizable && (n2 = n4 + tableColumn.width) - n <= 2) {
            return null;
        }
        return tableColumn.toolTipText;
    }

    void headerHideToolTip() {
        if (this.toolTipShell == null) {
            return;
        }
        int n = 0;
        while (n < toolTipEvents.length) {
            this.header.removeListener(toolTipEvents[n], this.toolTipListener);
            ++n;
        }
        this.toolTipShell.dispose();
        this.toolTipShell = null;
        this.toolTipLabel = null;
    }

    void headerOnMouseDoubleClick(Event event) {
        if (!this.isFocusControl()) {
            this.setFocus();
        }
        if (this.columns.length == 0) {
            return;
        }
        TableColumn[] tableColumnArray = this.getOrderedColumns();
        int n = -this.horizontalOffset;
        int n2 = 0;
        while (n2 < tableColumnArray.length) {
            TableColumn tableColumn = tableColumnArray[n2];
            if (event.x < (n += tableColumn.width)) {
                TableColumn tableColumn2 = null;
                if (n - event.x <= 2) {
                    tableColumn2 = tableColumn;
                } else if (n2 > 0 && event.x - tableColumn.getX() <= 2) {
                    tableColumn2 = tableColumnArray[n2 - 1];
                }
                if (tableColumn2 != null) {
                    tableColumn2.pack();
                    this.resizeColumn = null;
                    if (Math.abs(tableColumn2.getX() + tableColumn2.width - event.x) > 2) {
                        this.setCursor(null);
                    }
                    return;
                }
                Event event2 = new Event();
                event2.widget = tableColumn;
                tableColumn.postEvent(14, event2);
                return;
            }
            ++n2;
        }
    }

    void headerOnMouseDown(Event event) {
        if (event.button != 1) {
            return;
        }
        TableColumn[] tableColumnArray = this.getOrderedColumns();
        int n = -this.horizontalOffset;
        int n2 = 0;
        while (n2 < tableColumnArray.length) {
            TableColumn tableColumn = tableColumnArray[n2];
            if (tableColumn.resizable && Math.abs((n += tableColumn.width) - event.x) <= 2) {
                this.resizeColumn = tableColumn;
                this.resizeColumnX = n;
                return;
            }
            if (event.x < n) {
                if (tableColumn.moveable) {
                    int n3 = tableColumn.getX();
                    int n4 = event.x - n3;
                    this.headerHideToolTip();
                    Tracker tracker = new Tracker(this, 0);
                    tracker.setRectangles(new Rectangle[]{new Rectangle(n3, 0, tableColumn.width, this.getHeaderHeight())});
                    if (!tracker.open()) {
                        return;
                    }
                    Rectangle rectangle = tracker.getRectangles()[0];
                    int n5 = rectangle.x + n4;
                    if (n5 < 0) {
                        return;
                    }
                    n = -this.horizontalOffset;
                    int n6 = 0;
                    while (n6 < tableColumnArray.length) {
                        TableColumn tableColumn2 = tableColumnArray[n6];
                        if (n5 < (n += tableColumn2.width)) {
                            int n7 = tableColumn.getOrderIndex();
                            if (n6 == n7) {
                                Event event2 = new Event();
                                event2.widget = tableColumn;
                                tableColumn.postEvent(13, event2);
                                return;
                            }
                            int n8 = Math.min(n6, n7);
                            int[] nArray = this.getColumnOrder();
                            int[] nArray2 = new int[nArray.length];
                            System.arraycopy(nArray, 0, nArray2, 0, n8);
                            if (n8 == n7) {
                                System.arraycopy(nArray, n7 + 1, nArray2, n7, n6 - n7);
                            } else {
                                System.arraycopy(nArray, n6, nArray2, n6 + 1, n7 - n6);
                            }
                            nArray2[n6] = nArray[n7];
                            int n9 = Math.max(n6, n7);
                            System.arraycopy(nArray, n9 + 1, nArray2, n9 + 1, nArray2.length - n9 - 1);
                            this.setColumnOrder(nArray2);
                            return;
                        }
                        ++n6;
                    }
                    return;
                }
                Event event3 = new Event();
                event3.widget = tableColumn;
                tableColumn.postEvent(13, event3);
                return;
            }
            ++n2;
        }
    }

    void headerOnMouseExit() {
        if (this.resizeColumn != null) {
            return;
        }
        this.setCursor(null);
    }

    void headerOnMouseHover(Event event) {
        this.headerShowToolTip(event.x);
    }

    void headerOnMouseMove(Event event) {
        if (this.resizeColumn == null) {
            int n = 0;
            while (n < this.columns.length) {
                TableColumn tableColumn = this.columns[n];
                int n2 = tableColumn.getX() + tableColumn.width;
                if (Math.abs(n2 - event.x) <= 2) {
                    if (tableColumn.resizable) {
                        this.setCursor(this.display.getSystemCursor(9));
                    } else {
                        this.setCursor(null);
                    }
                    return;
                }
                ++n;
            }
            this.setCursor(null);
            return;
        }
        if (event.x <= this.resizeColumn.getX()) {
            return;
        }
        GC gC = new GC(this);
        gC.setForeground(this.display.getSystemColor(2));
        int n = this.clientArea.height;
        this.redraw(this.resizeColumnX - 1, 0, 1, n, false);
        this.resizeColumnX = event.x;
        gC.drawLine(this.resizeColumnX - 1, 0, this.resizeColumnX - 1, n);
        gC.dispose();
    }

    void headerOnMouseUp(Event event) {
        if (this.resizeColumn == null) {
            return;
        }
        GC gC = new GC(this);
        this.redraw(this.resizeColumnX - 1, 0, 1, this.clientArea.height, false);
        gC.dispose();
        int n = this.resizeColumnX - this.resizeColumn.getX();
        if (n != this.resizeColumn.width) {
            this.setCursor(null);
            this.updateColumnWidth(this.resizeColumn, n);
        }
        this.resizeColumnX = -1;
        this.resizeColumn = null;
    }

    void headerOnPaint(Event event) {
        TableColumn[] tableColumnArray = this.getOrderedColumns();
        int n = tableColumnArray.length;
        GC gC = event.gc;
        Rectangle rectangle = gC.getClipping();
        int n2 = -1;
        int n3 = -1;
        if (n > 0) {
            n2 = this.computeColumnIntersect(rectangle.x, 0);
            if (n2 != -1 && (n3 = this.computeColumnIntersect(rectangle.x + rectangle.width, n2)) == -1) {
                n3 = n - 1;
            }
        } else {
            n3 = 0;
            n2 = 0;
        }
        Point point = this.header.getSize();
        this.headerPaintHShadows(gC, 0, 0, point.x, point.y);
        if (n2 == -1) {
            return;
        }
        if (n == 0) {
            return;
        }
        int n4 = n2;
        while (n4 <= n3) {
            this.headerPaintVShadows(gC, tableColumnArray[n4].getX(), 0, tableColumnArray[n4].width, point.y);
            tableColumnArray[n4].paint(gC);
            ++n4;
        }
    }

    void headerPaintHShadows(GC gC, int n, int n2, int n3, int n4) {
        gC.setClipping(n, n2, n3, n4);
        int n5 = n + n3;
        gC.setForeground(this.display.getSystemColor(20));
        gC.drawLine(n, n2, n5, n2);
        gC.setForeground(this.display.getSystemColor(18));
        gC.drawLine(n, n4 - 2, n5, n4 - 2);
        gC.setForeground(this.display.getSystemColor(17));
        gC.drawLine(n, n4 - 1, n5, n4 - 1);
    }

    void headerPaintVShadows(GC gC, int n, int n2, int n3, int n4) {
        gC.setClipping(n, n2, n3, n4);
        int n5 = n + n3;
        gC.setForeground(this.display.getSystemColor(20));
        gC.drawLine(n, n2, n, n2 + n4 - 1);
        gC.setForeground(this.display.getSystemColor(18));
        gC.drawLine(n5 - 2, n2 + 1, n5 - 2, n4 - 2);
        gC.setForeground(this.display.getSystemColor(17));
        gC.drawLine(n5 - 1, n2, n5 - 1, n4 - 1);
    }

    void headerShowToolTip(int n) {
        String string = this.headerGetToolTip(n);
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.toolTipShell == null) {
            this.toolTipShell = new Shell(this.getShell(), 16388);
            this.toolTipLabel = new Label(this.toolTipShell, 0x1000000);
            Display display = this.toolTipShell.getDisplay();
            this.toolTipLabel.setForeground(display.getSystemColor(28));
            this.toolTipLabel.setBackground(display.getSystemColor(29));
            int n2 = 0;
            while (n2 < toolTipEvents.length) {
                this.header.addListener(toolTipEvents[n2], this.toolTipListener);
                ++n2;
            }
        }
        if (this.headerUpdateToolTip(n)) {
            this.toolTipShell.setVisible(true);
        } else {
            this.headerHideToolTip();
        }
    }

    boolean headerUpdateToolTip(int n) {
        String string = this.headerGetToolTip(n);
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.equals(this.toolTipLabel.getText())) {
            return true;
        }
        this.toolTipLabel.setText(string);
        TableColumn tableColumn = this.getOrderedColumns()[this.computeColumnIntersect(n, 0)];
        this.toolTipShell.setData(new Integer(tableColumn.getIndex()));
        Point point = this.toolTipLabel.computeSize(-1, -1, true);
        point.x += 2;
        point.y += 2;
        this.toolTipLabel.setSize(point);
        this.toolTipShell.pack();
        Rectangle rectangle = this.toolTipShell.getClientArea();
        this.toolTipLabel.setSize(rectangle.width, rectangle.height);
        Point point2 = this.getDisplay().getCursorLocation();
        int n2 = 21;
        Point point3 = this.toolTipShell.getSize();
        Rectangle rectangle2 = this.getMonitor().getBounds();
        Point point4 = new Point(point2.x, point2.y + n2 + 2);
        point4.x = Math.max(point4.x, rectangle2.x);
        if (point4.x + point3.x > rectangle2.x + rectangle2.width) {
            point4.x = rectangle2.x + rectangle2.width - point3.x;
        }
        if (point4.y + point3.y > rectangle2.y + rectangle2.height) {
            point4.y = point2.y - 2 - point3.y;
        }
        this.toolTipShell.setLocation(point4);
        return true;
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.parent != this) {
            return -1;
        }
        return tableColumn.getIndex();
    }

    public int indexOf(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (tableItem.parent != this) {
            return -1;
        }
        return tableItem.index;
    }

    static void initImages(final Display display) {
        ImageData imageData;
        PaletteData paletteData;
        Object object;
        PaletteData paletteData2 = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
        if (display.getData(ID_ARROWDOWN) == null) {
            byte[] byArray = new byte[4];
            byArray[1] = -125;
            byArray[2] = -57;
            byArray[3] = -17;
            object = new ImageData(7, 4, 1, paletteData2, 1, byArray);
            ((ImageData)object).transparentPixel = 1;
            display.setData(ID_ARROWDOWN, new Image((Device)display, (ImageData)object));
        }
        if (display.getData(ID_ARROWUP) == null) {
            byte[] byArray = new byte[4];
            byArray[0] = -17;
            byArray[1] = -57;
            byArray[2] = -125;
            object = new ImageData(7, 4, 1, paletteData2, 1, byArray);
            ((ImageData)object).transparentPixel = 1;
            display.setData(ID_ARROWUP, new Image((Device)display, (ImageData)object));
        }
        object = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(252, 3, 251)});
        byte[] byArray = new byte[22];
        byArray[2] = 127;
        byArray[3] = -64;
        byArray[4] = 127;
        byArray[5] = -64;
        byArray[6] = 127;
        byArray[7] = -64;
        byArray[8] = 127;
        byArray[9] = -64;
        byArray[10] = 127;
        byArray[11] = -64;
        byArray[12] = 127;
        byArray[13] = -64;
        byArray[14] = 127;
        byArray[15] = -64;
        byArray[16] = 127;
        byArray[17] = -64;
        byArray[18] = 127;
        byArray[19] = -64;
        byte[] byArray2 = byArray;
        ImageData imageData2 = new ImageData(7, 7, 1, (PaletteData)object, 1, new byte[]{-4, -8, 112, 34, 6, -114, -34});
        imageData2.transparentPixel = 1;
        if (display.getData(ID_CHECKMARK) == null) {
            display.setData(ID_CHECKMARK, new Image((Device)display, imageData2));
        }
        if (display.getData(ID_UNCHECKED) == null) {
            paletteData = new PaletteData(new RGB[]{new RGB(128, 128, 128), new RGB(255, 255, 255)});
            imageData = new ImageData(11, 11, 1, paletteData, 2, byArray2);
            display.setData(ID_UNCHECKED, new Image((Device)display, imageData));
        }
        if (display.getData(ID_GRAYUNCHECKED) == null) {
            paletteData = new PaletteData(new RGB[]{new RGB(128, 128, 128), new RGB(192, 192, 192)});
            imageData = new ImageData(11, 11, 1, paletteData, 2, byArray2);
            display.setData(ID_GRAYUNCHECKED, new Image((Device)display, imageData));
        }
        display.disposeExec(new Runnable(){

            public void run() {
                Image image;
                Image image2;
                Image image3;
                Image image4;
                Image image5 = (Image)display.getData(Table.ID_UNCHECKED);
                if (image5 != null) {
                    image5.dispose();
                }
                if ((image4 = (Image)display.getData(Table.ID_GRAYUNCHECKED)) != null) {
                    image4.dispose();
                }
                if ((image3 = (Image)display.getData(Table.ID_CHECKMARK)) != null) {
                    image3.dispose();
                }
                if ((image2 = (Image)display.getData(Table.ID_ARROWDOWN)) != null) {
                    image2.dispose();
                }
                if ((image = (Image)display.getData(Table.ID_ARROWUP)) != null) {
                    image.dispose();
                }
                display.setData(Table.ID_UNCHECKED, null);
                display.setData(Table.ID_GRAYUNCHECKED, null);
                display.setData(Table.ID_CHECKMARK, null);
                display.setData(Table.ID_ARROWDOWN, null);
                display.setData(Table.ID_ARROWUP, null);
            }
        });
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemsCount) {
            return false;
        }
        return this.items[n].isSelected();
    }

    void onArrowDown(int n) {
        if ((n & 0x60000) == 0) {
            int n2 = this.focusItem.index + 1;
            if (n2 == this.itemsCount) {
                return;
            }
            this.selectItem(this.items[n2], false);
            this.setFocusItem(this.items[n2], true);
            this.redrawItem(n2, true);
            this.showItem(this.items[n2]);
            Event event = new Event();
            event.item = this.items[n2];
            this.postEvent(13, event);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((n & 0x40000) != 0) {
                int n3 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
                if (this.itemsCount <= this.topIndex + n3) {
                    return;
                }
                this.update();
                ++this.topIndex;
                this.getVerticalBar().setSelection(this.topIndex);
                GC gC = new GC(this);
                gC.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, -this.itemHeight);
                gC.dispose();
                return;
            }
            int n4 = this.focusItem.index + 1;
            if (n4 == this.itemsCount) {
                return;
            }
            this.selectItem(this.items[n4], false);
            this.setFocusItem(this.items[n4], true);
            this.redrawItem(n4, true);
            this.showItem(this.items[n4]);
            Event event = new Event();
            event.item = this.items[n4];
            this.postEvent(13, event);
            return;
        }
        if ((n & 0x40000) != 0) {
            if ((n & 0x20000) != 0) {
                int n5 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
                if (this.itemsCount <= this.topIndex + n5) {
                    return;
                }
                this.update();
                ++this.topIndex;
                this.getVerticalBar().setSelection(this.topIndex);
                GC gC = new GC(this);
                gC.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, -this.itemHeight);
                gC.dispose();
                return;
            }
            int n6 = this.focusItem.index;
            if (n6 == this.itemsCount - 1) {
                return;
            }
            TableItem tableItem = this.items[n6 + 1];
            this.setFocusItem(tableItem, true);
            this.redrawItem(tableItem.index, true);
            this.showItem(tableItem);
            return;
        }
        int n7 = this.focusItem.index + 1;
        if (n7 == this.itemsCount) {
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        if (this.focusItem.index < this.anchorItem.index) {
            this.deselectItem(this.focusItem);
            this.redrawItem(this.focusItem.index, true);
        }
        this.selectItem(this.items[n7], true);
        this.setFocusItem(this.items[n7], true);
        this.redrawItem(n7, true);
        this.showItem(this.items[n7]);
        Event event = new Event();
        event.item = this.items[n7];
        this.postEvent(13, event);
    }

    void onArrowLeft(int n) {
        if (this.horizontalOffset == 0) {
            return;
        }
        int n2 = Math.max(0, this.horizontalOffset - 5);
        this.update();
        GC gC = new GC(this);
        gC.copyArea(0, 0, this.clientArea.width, this.clientArea.height, this.horizontalOffset - n2, 0);
        gC.dispose();
        if (this.header.getVisible()) {
            this.header.update();
            Rectangle rectangle = this.header.getClientArea();
            gC = new GC(this.header);
            gC.copyArea(0, 0, rectangle.width, rectangle.height, this.horizontalOffset - n2, 0);
            gC.dispose();
        }
        this.horizontalOffset = n2;
        this.getHorizontalBar().setSelection(this.horizontalOffset);
    }

    void onArrowRight(int n) {
        ScrollBar scrollBar = this.getHorizontalBar();
        int n2 = scrollBar.getMaximum();
        int n3 = this.clientArea.width;
        if (this.horizontalOffset + this.clientArea.width == n2) {
            return;
        }
        if (n2 <= n3) {
            return;
        }
        int n4 = Math.min(this.horizontalOffset + 5, n2 - n3);
        this.update();
        GC gC = new GC(this);
        gC.copyArea(0, 0, this.clientArea.width, this.clientArea.height, this.horizontalOffset - n4, 0);
        gC.dispose();
        if (this.header.getVisible()) {
            Rectangle rectangle = this.header.getClientArea();
            this.header.update();
            gC = new GC(this.header);
            gC.copyArea(0, 0, rectangle.width, rectangle.height, this.horizontalOffset - n4, 0);
            gC.dispose();
        }
        this.horizontalOffset = n4;
        scrollBar.setSelection(this.horizontalOffset);
    }

    void onArrowUp(int n) {
        if ((n & 0x60000) == 0) {
            int n2 = this.focusItem.index - 1;
            if (n2 < 0) {
                return;
            }
            TableItem tableItem = this.items[n2];
            this.selectItem(tableItem, false);
            this.setFocusItem(tableItem, true);
            this.redrawItem(n2, true);
            this.showItem(tableItem);
            Event event = new Event();
            event.item = tableItem;
            this.postEvent(13, event);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((n & 0x40000) != 0) {
                if (this.topIndex == 0) {
                    return;
                }
                this.update();
                --this.topIndex;
                this.getVerticalBar().setSelection(this.topIndex);
                GC gC = new GC(this);
                gC.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, this.itemHeight);
                gC.dispose();
                return;
            }
            int n3 = this.focusItem.index - 1;
            if (n3 < 0) {
                return;
            }
            TableItem tableItem = this.items[n3];
            this.selectItem(tableItem, false);
            this.setFocusItem(tableItem, true);
            this.redrawItem(n3, true);
            this.showItem(tableItem);
            Event event = new Event();
            event.item = tableItem;
            this.postEvent(13, event);
            return;
        }
        if ((n & 0x40000) != 0) {
            if ((n & 0x20000) != 0) {
                if (this.topIndex == 0) {
                    return;
                }
                this.update();
                --this.topIndex;
                this.getVerticalBar().setSelection(this.topIndex);
                GC gC = new GC(this);
                gC.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, this.itemHeight);
                gC.dispose();
                return;
            }
            int n4 = this.focusItem.index;
            if (n4 == 0) {
                return;
            }
            TableItem tableItem = this.items[n4 - 1];
            this.setFocusItem(tableItem, true);
            this.showItem(tableItem);
            this.redrawItem(tableItem.index, true);
            return;
        }
        int n5 = this.focusItem.index - 1;
        if (n5 < 0) {
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        if (this.anchorItem.index < this.focusItem.index) {
            this.deselectItem(this.focusItem);
            this.redrawItem(this.focusItem.index, true);
        }
        TableItem tableItem = this.items[n5];
        this.selectItem(tableItem, true);
        this.setFocusItem(tableItem, true);
        this.redrawItem(n5, true);
        this.showItem(tableItem);
        Event event = new Event();
        event.item = tableItem;
        this.postEvent(13, event);
    }

    void onCR() {
        if (this.focusItem == null) {
            return;
        }
        Event event = new Event();
        event.item = this.focusItem;
        this.postEvent(14, event);
    }

    void onDispose(Event event) {
        if (this.isDisposed()) {
            return;
        }
        if (this.ignoreDispose) {
            return;
        }
        this.ignoreDispose = true;
        this.notifyListeners(12, event);
        event.type = 0;
        int n = 0;
        while (n < this.itemsCount) {
            this.items[n].dispose(false);
            ++n;
        }
        n = 0;
        while (n < this.columns.length) {
            this.columns[n].dispose(false);
            ++n;
        }
        if (this.toolTipShell != null) {
            this.toolTipShell.dispose();
            this.toolTipShell = null;
            this.toolTipLabel = null;
        }
        this.toolTipListener = null;
        this.horizontalOffset = 0;
        this.topIndex = 0;
        this.itemsCount = 0;
        this.selectedItems = null;
        this.items = null;
        this.orderedColumns = null;
        this.columns = null;
        this.lastClickedItem = null;
        this.anchorItem = null;
        this.focusItem = null;
        this.lastSelectionEvent = null;
        this.header = null;
        this.sortColumn = null;
        this.resizeColumn = null;
    }

    void onEnd(int n) {
        TableItem tableItem;
        int n2 = this.itemsCount - 1;
        if ((n & 0x60000) == 0) {
            if (this.focusItem.index == n2) {
                return;
            }
            TableItem tableItem2 = this.items[n2];
            this.selectItem(tableItem2, false);
            this.setFocusItem(tableItem2, true);
            this.redrawItem(n2, true);
            this.showItem(tableItem2);
            Event event = new Event();
            event.item = tableItem2;
            this.postEvent(13, event);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((n & 0x40000) != 0) {
                int n3 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
                this.setTopIndex(this.itemsCount - n3);
                return;
            }
            if (this.focusItem.index == n2) {
                return;
            }
            TableItem tableItem3 = this.items[n2];
            this.selectItem(tableItem3, false);
            this.setFocusItem(tableItem3, true);
            this.redrawItem(n2, true);
            this.showItem(tableItem3);
            Event event = new Event();
            event.item = tableItem3;
            this.postEvent(13, event);
            return;
        }
        if ((n & 0x40000) != 0) {
            if ((n & 0x20000) != 0) {
                this.showItem(this.items[n2]);
                return;
            }
            if (this.focusItem.index == n2) {
                return;
            }
            TableItem tableItem4 = this.items[n2];
            this.setFocusItem(tableItem4, true);
            this.showItem(tableItem4);
            this.redrawItem(tableItem4.index, true);
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        if ((tableItem = this.items[n2]) == this.focusItem && tableItem.isSelected()) {
            return;
        }
        int n4 = this.anchorItem.index;
        int n5 = tableItem.index;
        TableItem[] tableItemArray = new TableItem[n5 - n4 + 1];
        int n6 = 0;
        int n7 = n4;
        while (n7 <= n5) {
            tableItemArray[n6++] = this.items[n7];
            ++n7;
        }
        this.setSelection(tableItemArray);
        this.setFocusItem(tableItem, true);
        this.redrawItems(n4, n5, true);
        this.showItem(tableItem);
        Event event = new Event();
        event.item = tableItem;
        this.postEvent(13, event);
    }

    void onFocusIn() {
        this.hasFocus = true;
        if (this.itemsCount == 0) {
            this.redraw();
            return;
        }
        if ((this.style & 0x8002) == 32770) {
            int n = 0;
            while (n < this.selectedItems.length) {
                this.redrawItem(this.selectedItems[n].index, true);
                ++n;
            }
        }
        if (this.focusItem != null) {
            this.redrawItem(this.focusItem.index, true);
            return;
        }
        TableItem tableItem = this.selectedItems.length > 0 ? this.selectedItems[0] : this.items[this.topIndex];
        this.setFocusItem(tableItem, false);
        this.redrawItem(tableItem.index, true);
    }

    void onFocusOut() {
        this.hasFocus = false;
        if (this.itemsCount == 0) {
            this.redraw();
            return;
        }
        if (this.focusItem != null) {
            this.redrawItem(this.focusItem.index, true);
        }
        if ((this.style & 0x8002) == 32770) {
            int n = 0;
            while (n < this.selectedItems.length) {
                this.redrawItem(this.selectedItems[n].index, true);
                ++n;
            }
        }
    }

    void onHome(int n) {
        TableItem tableItem;
        if ((n & 0x60000) == 0) {
            if (this.focusItem.index == 0) {
                return;
            }
            TableItem tableItem2 = this.items[0];
            this.selectItem(tableItem2, false);
            this.setFocusItem(tableItem2, true);
            this.redrawItem(0, true);
            this.showItem(tableItem2);
            Event event = new Event();
            event.item = tableItem2;
            this.postEvent(13, event);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((n & 0x40000) != 0) {
                this.setTopIndex(0);
                return;
            }
            if (this.focusItem.index == 0) {
                return;
            }
            TableItem tableItem3 = this.items[0];
            this.selectItem(tableItem3, false);
            this.setFocusItem(tableItem3, true);
            this.redrawItem(0, true);
            this.showItem(tableItem3);
            Event event = new Event();
            event.item = tableItem3;
            this.postEvent(13, event);
            return;
        }
        if ((n & 0x40000) != 0) {
            if ((n & 0x20000) != 0) {
                this.setTopIndex(0);
                return;
            }
            if (this.focusItem.index == 0) {
                return;
            }
            TableItem tableItem4 = this.items[0];
            this.setFocusItem(tableItem4, true);
            this.showItem(tableItem4);
            this.redrawItem(tableItem4.index, true);
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        if ((tableItem = this.items[0]) == this.focusItem && tableItem.isSelected()) {
            return;
        }
        int n2 = this.anchorItem.index;
        int n3 = tableItem.index;
        TableItem[] tableItemArray = new TableItem[n2 + 1];
        int n4 = 0;
        int n5 = n2;
        while (n5 >= 0) {
            tableItemArray[n4++] = this.items[n5];
            --n5;
        }
        this.setSelection(tableItemArray);
        this.setFocusItem(tableItem, true);
        this.redrawItems(n2, n3, true);
        this.showItem(tableItem);
        Event event = new Event();
        event.item = tableItem;
        this.postEvent(13, event);
    }

    void onKeyDown(Event event) {
        String string;
        TableItem tableItem;
        if (this.ignoreKey) {
            this.ignoreKey = false;
            return;
        }
        this.ignoreKey = true;
        this.notifyListeners(event.type, event);
        event.type = 0;
        if (!event.doit) {
            return;
        }
        if (this.focusItem == null) {
            return;
        }
        if ((event.stateMask & 0x20000) == 0 && event.keyCode != 131072) {
            this.anchorItem = null;
        }
        switch (event.keyCode) {
            case 0x1000001: {
                this.onArrowUp(event.stateMask);
                return;
            }
            case 0x1000002: {
                this.onArrowDown(event.stateMask);
                return;
            }
            case 0x1000003: {
                this.onArrowLeft(event.stateMask);
                return;
            }
            case 0x1000004: {
                this.onArrowRight(event.stateMask);
                return;
            }
            case 0x1000005: {
                this.onPageUp(event.stateMask);
                return;
            }
            case 0x1000006: {
                this.onPageDown(event.stateMask);
                return;
            }
            case 0x1000007: {
                this.onHome(event.stateMask);
                return;
            }
            case 0x1000008: {
                this.onEnd(event.stateMask);
                return;
            }
        }
        if (event.character == ' ') {
            this.onSpace();
            return;
        }
        if (event.character == '\r') {
            this.onCR();
            return;
        }
        if ((event.stateMask & 0x40000) != 0) {
            return;
        }
        int n = this.focusItem.index;
        char c = Character.toLowerCase(event.character);
        int n2 = n + 1;
        while (n2 < this.itemsCount) {
            tableItem = this.items[n2];
            string = tableItem.getText(0, false);
            if (string.length() > 0 && Character.toLowerCase(string.charAt(0)) == c) {
                this.selectItem(tableItem, false);
                this.setFocusItem(tableItem, true);
                this.redrawItem(n2, true);
                this.showItem(tableItem);
                Event event2 = new Event();
                event2.item = tableItem;
                this.postEvent(13, event2);
                return;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            tableItem = this.items[n2];
            string = tableItem.getText(0, false);
            if (string.length() > 0 && Character.toLowerCase(string.charAt(0)) == c) {
                this.selectItem(tableItem, false);
                this.setFocusItem(tableItem, true);
                this.redrawItem(n2, true);
                this.showItem(tableItem);
                Event event3 = new Event();
                event3.item = tableItem;
                this.postEvent(13, event3);
                return;
            }
            ++n2;
        }
    }

    void onMouseDoubleClick(Event event) {
        int n;
        if (!this.isFocusControl()) {
            this.setFocus();
        }
        if ((n = (event.y - this.getHeaderHeight()) / this.itemHeight + this.topIndex) < 0 || n >= this.itemsCount) {
            return;
        }
        TableItem tableItem = this.items[n];
        if (tableItem != this.lastClickedItem) {
            return;
        }
        if (!tableItem.getHitBounds().contains(event.x, event.y)) {
            return;
        }
        Event event2 = new Event();
        event2.item = tableItem;
        this.postEvent(14, event2);
    }

    void onMouseDown(Event event) {
        int n;
        if (!this.isFocusControl()) {
            this.forceFocus();
        }
        if ((n = (event.y - this.getHeaderHeight()) / this.itemHeight + this.topIndex) < 0 || n >= this.itemsCount) {
            return;
        }
        TableItem tableItem = this.items[n];
        if ((this.style & 0x20) != 0 && tableItem.getCheckboxBounds().contains(event.x, event.y)) {
            if (event.button != 1) {
                return;
            }
            tableItem.setChecked(!tableItem.checked);
            Event event2 = new Event();
            event2.item = tableItem;
            event2.detail = 32;
            this.postEvent(13, event2);
            return;
        }
        if (!tableItem.getHitBounds().contains(event.x, event.y)) {
            return;
        }
        if ((event.stateMask & 0x20000) == 0 && event.keyCode != 131072) {
            this.anchorItem = null;
        }
        boolean bl = true;
        if (this.lastSelectionEvent != null && this.lastSelectionEvent.item == tableItem) {
            if (event.time - this.lastSelectionEvent.time <= this.display.getDoubleClickTime()) {
                bl = false;
            } else {
                this.lastSelectionEvent = event;
                event.item = tableItem;
            }
        } else {
            this.lastSelectionEvent = event;
            event.item = tableItem;
        }
        if ((this.style & 4) != 0) {
            if (!tableItem.isSelected()) {
                if (event.button == 1) {
                    this.selectItem(tableItem, false);
                    this.setFocusItem(tableItem, true);
                    this.redrawItem(tableItem.index, true);
                    if (bl) {
                        Event event3 = new Event();
                        event3.item = tableItem;
                        this.postEvent(13, event3);
                    }
                    return;
                }
                if ((event.stateMask & 0x60000) == 0) {
                    this.selectItem(tableItem, false);
                    this.setFocusItem(tableItem, true);
                    this.redrawItem(tableItem.index, true);
                    if (bl) {
                        Event event4 = new Event();
                        event4.item = tableItem;
                        this.postEvent(13, event4);
                    }
                    return;
                }
            }
            if (event.button == 1) {
                if (bl) {
                    Event event5 = new Event();
                    event5.item = tableItem;
                    this.postEvent(13, event5);
                }
                return;
            }
        }
        if (!tableItem.isSelected()) {
            if (event.button == 1) {
                if ((event.stateMask & 0x60000) == 131072) {
                    if (this.anchorItem == null) {
                        this.anchorItem = this.focusItem;
                    }
                    int n2 = this.anchorItem.index;
                    int n3 = tableItem.index;
                    TableItem[] tableItemArray = new TableItem[Math.abs(n2 - n3) + 1];
                    int n4 = n2 < n3 ? 1 : -1;
                    int n5 = 0;
                    int n6 = n2;
                    while (n6 != n3) {
                        tableItemArray[n5++] = this.items[n6];
                        n6 += n4;
                    }
                    tableItemArray[n5] = this.items[n3];
                    this.setSelection(tableItemArray);
                    this.setFocusItem(tableItem, true);
                    this.redrawItems(Math.min(n2, n3), Math.max(n2, n3), true);
                    if (bl) {
                        Event event6 = new Event();
                        event6.item = tableItem;
                        this.postEvent(13, event6);
                    }
                    return;
                }
                this.selectItem(tableItem, (event.stateMask & 0x40000) != 0);
                this.setFocusItem(tableItem, true);
                this.redrawItem(tableItem.index, true);
                if (bl) {
                    Event event7 = new Event();
                    event7.item = tableItem;
                    this.postEvent(13, event7);
                }
                return;
            }
            if ((event.stateMask & 0x60000) == 0) {
                this.selectItem(tableItem, false);
                this.setFocusItem(tableItem, true);
                this.redrawItem(tableItem.index, true);
                if (bl) {
                    Event event8 = new Event();
                    event8.item = tableItem;
                    this.postEvent(13, event8);
                }
                return;
            }
        }
        if (event.button != 1) {
            return;
        }
        if ((event.stateMask & 0x40000) != 0) {
            this.removeSelectedItem(this.getSelectionIndex(tableItem));
            this.setFocusItem(tableItem, true);
            this.redrawItem(tableItem.index, true);
            if (bl) {
                Event event9 = new Event();
                event9.item = tableItem;
                this.postEvent(13, event9);
            }
            return;
        }
        if ((event.stateMask & 0x20000) != 0) {
            if (this.anchorItem == null) {
                this.anchorItem = this.focusItem;
            }
            int n7 = this.anchorItem.index;
            int n8 = tableItem.index;
            TableItem[] tableItemArray = new TableItem[Math.abs(n7 - n8) + 1];
            int n9 = n7 < n8 ? 1 : -1;
            int n10 = 0;
            int n11 = n7;
            while (n11 != n8) {
                tableItemArray[n10++] = this.items[n11];
                n11 += n9;
            }
            tableItemArray[n10] = this.items[n8];
            this.setSelection(tableItemArray);
            this.setFocusItem(tableItem, true);
            this.redrawItems(Math.min(n7, n8), Math.max(n7, n8), true);
            if (bl) {
                Event event10 = new Event();
                event10.item = tableItem;
                this.postEvent(13, event10);
            }
            return;
        }
        this.selectItem(tableItem, false);
        this.setFocusItem(tableItem, true);
        this.redrawItem(tableItem.index, true);
        if (bl) {
            Event event11 = new Event();
            event11.item = tableItem;
            this.postEvent(13, event11);
        }
    }

    void onMouseUp(Event event) {
        int n = (event.y - this.getHeaderHeight()) / this.itemHeight + this.topIndex;
        if (n < 0 || n >= this.itemsCount) {
            return;
        }
        this.lastClickedItem = this.items[n];
    }

    void onPageDown(int n) {
        int n2;
        int n3 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        if ((n & 0x60000) == 0) {
            int n4 = this.focusItem.index + n3 - 1;
            if ((n4 = Math.min(n4, this.itemsCount - 1)) == this.focusItem.index) {
                return;
            }
            TableItem tableItem = this.items[n4];
            this.selectItem(tableItem, false);
            this.setFocusItem(tableItem, true);
            this.showItem(tableItem);
            this.redrawItem(tableItem.index, true);
            return;
        }
        if ((n & 0x60000) == 393216) {
            int n5 = this.topIndex + n3;
            if ((n5 = Math.min(n5, this.itemsCount - n3)) == this.topIndex) {
                return;
            }
            this.setTopIndex(n5);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((n & 0x20000) != 0) {
                int n6 = this.focusItem.index + n3 - 1;
                if ((n6 = Math.min(n6, this.itemsCount - 1)) == this.focusItem.index) {
                    return;
                }
                TableItem tableItem = this.items[n6];
                this.selectItem(tableItem, false);
                this.setFocusItem(tableItem, true);
                this.showItem(tableItem);
                this.redrawItem(tableItem.index, true);
                return;
            }
            int n7 = this.topIndex + n3;
            if ((n7 = Math.min(n7, this.itemsCount - n3)) == this.topIndex) {
                return;
            }
            this.setTopIndex(n7);
            return;
        }
        if ((n & 0x40000) != 0) {
            int n8 = Math.min(this.topIndex + n3 - 1, this.itemsCount - 1);
            if (this.focusItem.index != n8) {
                this.setFocusItem(this.items[n8], true);
                this.redrawItem(n8, true);
            } else {
                int n9 = Math.min(this.itemsCount - 1, n8 + n3);
                if (n9 == this.focusItem.index) {
                    return;
                }
                this.setFocusItem(this.items[n9], true);
                this.showItem(this.items[n9]);
                this.redrawItem(n9, true);
            }
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        int n10 = this.anchorItem.index;
        int n11 = Math.min(this.topIndex + n3 - 1, this.itemsCount - 1);
        if (this.focusItem.index != n11) {
            n2 = n11;
        } else {
            n2 = Math.min(this.itemsCount - 1, n11 + n3);
            if (n2 == this.focusItem.index && this.focusItem.isSelected()) {
                return;
            }
        }
        TableItem tableItem = this.items[n2];
        TableItem[] tableItemArray = new TableItem[Math.abs(n10 - n2) + 1];
        int n12 = n10 < n2 ? 1 : -1;
        int n13 = 0;
        int n14 = n10;
        while (n14 != n2) {
            tableItemArray[n13++] = this.items[n14];
            n14 += n12;
        }
        tableItemArray[n13] = this.items[n2];
        this.setSelection(tableItemArray);
        this.setFocusItem(tableItem, true);
        this.showItem(tableItem);
        Event event = new Event();
        event.item = tableItem;
        this.postEvent(13, event);
    }

    void onPageUp(int n) {
        int n2;
        int n3 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        if ((n & 0x60000) == 0) {
            int n4 = Math.max(0, this.focusItem.index - n3 + 1);
            if (n4 == this.focusItem.index) {
                return;
            }
            TableItem tableItem = this.items[n4];
            this.selectItem(tableItem, false);
            this.setFocusItem(tableItem, true);
            this.showItem(tableItem);
            this.redrawItem(tableItem.index, true);
            return;
        }
        if ((n & 0x60000) == 393216) {
            int n5 = Math.max(0, this.topIndex - n3);
            if (n5 == this.topIndex) {
                return;
            }
            this.setTopIndex(n5);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((n & 0x20000) != 0) {
                int n6 = Math.max(0, this.focusItem.index - n3 + 1);
                if (n6 == this.focusItem.index) {
                    return;
                }
                TableItem tableItem = this.items[n6];
                this.selectItem(tableItem, false);
                this.setFocusItem(tableItem, true);
                this.showItem(tableItem);
                this.redrawItem(tableItem.index, true);
                return;
            }
            int n7 = Math.max(0, this.topIndex - n3);
            if (n7 == this.topIndex) {
                return;
            }
            this.setTopIndex(n7);
            return;
        }
        if ((n & 0x40000) != 0) {
            if (this.focusItem.index != this.topIndex) {
                this.setFocusItem(this.items[this.topIndex], true);
                this.redrawItem(this.topIndex, true);
            } else {
                int n8 = Math.max(0, this.focusItem.index - n3);
                if (n8 == this.focusItem.index) {
                    return;
                }
                this.setFocusItem(this.items[n8], true);
                this.showItem(this.items[n8]);
                this.redrawItem(n8, true);
            }
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        int n9 = this.anchorItem.index;
        if (this.focusItem.index != this.topIndex) {
            n2 = this.topIndex;
        } else {
            n2 = Math.max(0, this.topIndex - n3);
            if (n2 == this.focusItem.index && this.focusItem.isSelected()) {
                return;
            }
        }
        TableItem tableItem = this.items[n2];
        TableItem[] tableItemArray = new TableItem[Math.abs(n9 - n2) + 1];
        int n10 = n9 < n2 ? 1 : -1;
        int n11 = 0;
        int n12 = n9;
        while (n12 != n2) {
            tableItemArray[n11++] = this.items[n12];
            n12 += n10;
        }
        tableItemArray[n11] = this.items[n2];
        this.setSelection(tableItemArray);
        this.setFocusItem(tableItem, true);
        this.showItem(tableItem);
        Event event = new Event();
        event.item = tableItem;
        this.postEvent(13, event);
    }

    void onPaint(Event event) {
        int n;
        TableColumn tableColumn;
        int n2;
        TableColumn[] tableColumnArray = this.getOrderedColumns();
        GC gC = event.gc;
        Rectangle rectangle = gC.getClipping();
        int n3 = this.getHeaderHeight();
        int n4 = tableColumnArray.length;
        int n5 = -1;
        int n6 = -1;
        if (n4 > 0) {
            n5 = this.computeColumnIntersect(rectangle.x, 0);
            if (n5 != -1 && (n6 = this.computeColumnIntersect(rectangle.x + rectangle.width, n5)) == -1) {
                n6 = n4 - 1;
            }
        } else {
            n6 = 0;
            n5 = 0;
        }
        int n7 = (rectangle.y - n3) / this.itemHeight + this.topIndex;
        int n8 = -1;
        if (n7 < this.itemsCount) {
            n8 = n7 + Compatibility.ceil(rectangle.height, this.itemHeight);
        }
        n7 = Math.max(0, n7);
        n8 = Math.min(n8, this.itemsCount - 1);
        gC.setBackground(this.getBackground());
        gC.setClipping(rectangle);
        int n9 = n8 >= 0 ? this.getItemY(this.items[n8]) + this.itemHeight : 0;
        int n10 = Math.max(0, this.clientArea.height - n9);
        if (n10 > 0) {
            this.drawBackground(gC, 0, n9, this.clientArea.width, n10);
        }
        if (this.columns.length > 0 && (n2 = (tableColumn = tableColumnArray[tableColumnArray.length - 1]).getX() + tableColumn.width) < this.clientArea.width) {
            this.drawBackground(gC, n2, 0, this.clientArea.width - n2, this.clientArea.height - n10);
        }
        boolean bl = false;
        int[] nArray = gC.getLineDash();
        int n11 = gC.getLineWidth();
        int n12 = n7;
        while (n12 <= Math.min(n8, this.itemsCount - 1)) {
            TableItem tableItem = this.items[n12];
            if (!tableItem.isDisposed()) {
                if (n5 == -1) {
                    bl = tableItem.paint(gC, null, true) || bl;
                } else if (n4 == 0) {
                    bl = tableItem.paint(gC, null, false) || bl;
                } else {
                    n = n5;
                    while (n <= Math.min(n6, this.columns.length - 1)) {
                        if (!tableItem.isDisposed()) {
                            boolean bl2 = bl = tableItem.paint(gC, tableColumnArray[n], false) || bl;
                        }
                        if (this.isDisposed() || gC.isDisposed()) {
                            return;
                        }
                        ++n;
                    }
                }
            }
            if (this.isDisposed() || gC.isDisposed()) {
                return;
            }
            ++n12;
        }
        gC.setClipping(rectangle);
        gC.setLineWidth(n11);
        if (this.linesVisible) {
            gC.setForeground(this.display.getSystemColor(19));
            gC.setLineDash(nArray);
            if (n4 > 0 && n5 != -1) {
                n12 = n5;
                while (n12 <= n6) {
                    int n13 = tableColumnArray[n12].getX() + tableColumnArray[n12].width - 1;
                    gC.drawLine(n13, rectangle.y, n13, rectangle.y + rectangle.height);
                    ++n12;
                }
            }
            n9 = rectangle.y + rectangle.height;
            n12 = rectangle.x + rectangle.width;
            int n14 = (rectangle.y - n3) / this.itemHeight * this.itemHeight + n3;
            while (n14 <= n9) {
                gC.drawLine(rectangle.x, n14, n12, n14);
                n14 += this.itemHeight;
            }
        }
        if (!bl && this.isFocusControl()) {
            if (this.focusItem != null) {
                Rectangle rectangle2 = this.focusItem.getFocusBounds();
                if (rectangle2.width > 0) {
                    gC.setForeground(this.display.getSystemColor(2));
                    gC.setClipping(rectangle2);
                    if (this.focusItem.isSelected()) {
                        gC.setLineDash(new int[]{2, 2});
                    } else {
                        gC.setLineDash(new int[]{1, 1});
                    }
                    gC.drawFocus(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
            } else {
                n12 = n3 + 1;
                int n15 = Math.max(0, this.clientArea.width - 2);
                n = Math.max(0, this.clientArea.height - n3 - 2);
                gC.setForeground(this.display.getSystemColor(2));
                gC.setClipping(1, n12, n15, n);
                gC.setLineDash(new int[]{1, 1});
                gC.drawFocus(1, n12, n15, n);
            }
        }
    }

    void onResize(Event event) {
        boolean bl;
        this.clientArea = this.getClientArea();
        ScrollBar scrollBar = this.getVerticalBar();
        int n = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        int n2 = Math.min(n, this.itemsCount);
        scrollBar.setThumb(n2);
        scrollBar.setPageIncrement(n2);
        int n3 = scrollBar.getSelection();
        if (n3 != this.topIndex) {
            this.topIndex = n3;
            this.redraw();
        }
        boolean bl2 = bl = n < this.itemsCount;
        if (bl != scrollBar.getVisible()) {
            scrollBar.setVisible(bl);
            this.clientArea = this.getClientArea();
        }
        ScrollBar scrollBar2 = this.getHorizontalBar();
        int n4 = scrollBar2.getMaximum();
        n2 = Math.min(this.clientArea.width, n4);
        scrollBar2.setThumb(n2);
        scrollBar2.setPageIncrement(n2);
        this.horizontalOffset = scrollBar2.getSelection();
        boolean bl3 = bl = this.clientArea.width < n4;
        if (bl != scrollBar2.getVisible()) {
            scrollBar2.setVisible(bl);
            this.clientArea = this.getClientArea();
        }
        int n5 = Math.max(this.fontHeight, this.headerImageHeight) + 2 * this.getHeaderPadding();
        this.header.setSize(this.clientArea.width, n5);
        if (this.itemsCount == 0 && this.isFocusControl()) {
            this.redraw();
        }
    }

    void onScrollHorizontal(Event event) {
        Object object;
        int n = this.getHorizontalBar().getSelection();
        this.update();
        if (this.itemsCount > 0) {
            object = new GC(this);
            ((GC)object).copyArea(0, 0, this.clientArea.width, this.clientArea.height, this.horizontalOffset - n, 0);
            ((GC)object).dispose();
        } else {
            this.redraw();
        }
        if (this.drawCount <= 0 && this.header.isVisible()) {
            this.header.update();
            object = this.header.getClientArea();
            GC gC = new GC(this.header);
            gC.copyArea(0, 0, ((Rectangle)object).width, ((Rectangle)object).height, this.horizontalOffset - n, 0);
            gC.dispose();
        }
        this.horizontalOffset = n;
    }

    void onScrollVertical(Event event) {
        int n = this.getVerticalBar().getSelection();
        this.update();
        GC gC = new GC(this);
        gC.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, (this.topIndex - n) * this.itemHeight);
        gC.dispose();
        this.topIndex = n;
    }

    void onSpace() {
        if (this.focusItem == null) {
            return;
        }
        if (!this.focusItem.isSelected()) {
            this.selectItem(this.focusItem, (this.style & 2) != 0);
            this.redrawItem(this.focusItem.index, true);
        }
        if ((this.style & 0x20) != 0) {
            this.focusItem.setChecked(!this.focusItem.checked);
        }
        this.showItem(this.focusItem);
        Event event = new Event();
        event.item = this.focusItem;
        this.postEvent(13, event);
        if ((this.style & 0x20) == 0) {
            return;
        }
        event = new Event();
        event.item = this.focusItem;
        event.detail = 32;
        this.postEvent(13, event);
    }

    void reassignFocus() {
        if (this.focusItem == null) {
            return;
        }
        int n = this.focusItem.index;
        n = n != 0 ? --n : ++n;
        if (n < this.itemsCount) {
            TableItem tableItem = this.items[n];
            this.setFocusItem(tableItem, false);
            this.showItem(tableItem);
        } else {
            this.setFocusItem(null, false);
        }
    }

    public void redraw() {
        this.checkWidget();
        if (this.drawCount <= 0) {
            super.redraw();
        }
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        this.checkWidget();
        if (this.drawCount <= 0) {
            super.redraw(n, n2, n3, n4, bl);
        }
    }

    void redrawFromItemDownwards(int n) {
        this.redrawItems(n, this.itemsCount - 1, false);
    }

    void redrawItem(int n, boolean bl) {
        if (n < this.itemsCount && !this.items[n].isInViewport()) {
            return;
        }
        this.redrawItems(n, n, bl);
    }

    void redrawItems(int n, int n2, boolean bl) {
        if (this.drawCount > 0) {
            return;
        }
        int n3 = (n - this.topIndex) * this.itemHeight + this.getHeaderHeight();
        int n4 = (n2 - n + 1) * this.itemHeight;
        if (bl) {
            boolean bl2;
            boolean bl3 = bl2 = this.hooks(40) || this.hooks(42);
            if (!bl2 && this.columns.length > 0) {
                TableColumn tableColumn;
                if ((this.style & 0x10000) != 0) {
                    TableColumn[] tableColumnArray = this.getOrderedColumns();
                    tableColumn = tableColumnArray[tableColumnArray.length - 1];
                } else {
                    tableColumn = this.columns[0];
                }
                int n5 = tableColumn.getX() + tableColumn.getWidth();
                if (n5 <= 0) {
                    return;
                }
            }
            n2 = Math.min(n2, this.itemsCount - 1);
            int n6 = n;
            while (n6 <= n2) {
                TableItem tableItem = this.items[n6];
                if (tableItem.isInViewport()) {
                    if (bl2) {
                        this.redraw(0, this.getItemY(tableItem), this.clientArea.width, this.itemHeight, false);
                    } else {
                        Rectangle rectangle = tableItem.getFocusBounds();
                        this.redraw(rectangle.x, n3, rectangle.width, n4, false);
                    }
                }
                ++n6;
            }
        } else {
            this.redraw(0, n3, this.clientArea.width, n4, false);
        }
    }

    public void remove(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemsCount) {
            this.error(6);
        }
        this.items[n].dispose();
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (n < 0 || n > n2 || n2 >= this.itemsCount) {
            this.error(6);
        }
        if (n == 0 && n2 == this.itemsCount - 1) {
            this.removeAll();
        } else {
            int n3 = n2;
            while (n3 >= n) {
                this.items[n3].dispose();
                --n3;
            }
        }
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sortDescent(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        if (n < 0 || n > n2 || n2 >= this.itemsCount) {
            this.error(6);
        }
        int n3 = -1;
        int n4 = 0;
        while (n4 < nArray2.length) {
            if (nArray2[n4] != n3) {
                this.items[nArray2[n4]].dispose();
                n3 = nArray2[n4];
            }
            ++n4;
        }
    }

    public void removeAll() {
        this.checkWidget();
        if (this.itemsCount == 0) {
            return;
        }
        this.setRedraw(false);
        this.setFocusItem(null, false);
        int n = 0;
        while (n < this.itemsCount) {
            this.items[n].dispose(false);
            ++n;
        }
        this.items = new TableItem[0];
        this.selectedItems = new TableItem[0];
        this.topIndex = 0;
        this.itemsCount = 0;
        this.lastClickedItem = null;
        this.anchorItem = null;
        this.lastSelectionEvent = null;
        ScrollBar scrollBar = this.getVerticalBar();
        scrollBar.setMaximum(1);
        scrollBar.setVisible(false);
        if (this.columns.length == 0) {
            this.horizontalOffset = 0;
            ScrollBar scrollBar2 = this.getHorizontalBar();
            scrollBar2.setMaximum(1);
            scrollBar2.setVisible(false);
        }
        this.setRedraw(true);
    }

    void removeSelectedItem(int n) {
        TableItem[] tableItemArray = new TableItem[this.selectedItems.length - 1];
        System.arraycopy(this.selectedItems, 0, tableItemArray, 0, n);
        System.arraycopy(this.selectedItems, n + 1, tableItemArray, n, tableItemArray.length - n);
        this.selectedItems = tableItemArray;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    public void select(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemsCount) {
            return;
        }
        this.selectItem(this.items[n], (this.style & 2) != 0);
        if (this.hasFocus() || (this.style & 0x8000) == 0) {
            this.redrawItem(n, false);
        }
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemsCount == 0 || n >= this.itemsCount) {
            return;
        }
        n = Math.max(n, 0);
        n2 = Math.min(n2, this.itemsCount - 1);
        int n3 = n;
        while (n3 <= n2) {
            this.selectItem(this.items[n3], (this.style & 2) != 0);
            ++n3;
        }
        if (this.hasFocus() || (this.style & 0x8000) == 0) {
            this.redrawItems(n, n2, false);
        }
    }

    public void select(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0 || (this.style & 4) != 0 && nArray.length > 1) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] >= 0 && nArray[n] < this.itemsCount) {
                this.selectItem(this.items[nArray[n]], (this.style & 2) != 0);
            }
            ++n;
        }
        if (this.hasFocus() || (this.style & 0x8000) == 0) {
            n = 0;
            while (n < nArray.length) {
                if (nArray[n] >= 0 && nArray[n] < this.itemsCount) {
                    this.redrawItem(nArray[n], false);
                }
                ++n;
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.selectedItems = new TableItem[this.itemsCount];
        System.arraycopy(this.items, 0, this.selectedItems, 0, this.itemsCount);
        if (this.hasFocus() || (this.style & 0x8000) == 0) {
            this.redraw();
        }
    }

    void selectItem(TableItem tableItem, boolean bl) {
        TableItem[] tableItemArray = this.selectedItems;
        if (!bl || (this.style & 4) != 0) {
            this.selectedItems = new TableItem[]{tableItem};
            if (this.hasFocus() || (this.style & 0x8000) == 0) {
                int n = 0;
                while (n < tableItemArray.length) {
                    if (tableItemArray[n] != tableItem) {
                        this.redrawItem(tableItemArray[n].index, true);
                    }
                    ++n;
                }
            }
        } else {
            if (tableItem.isSelected()) {
                return;
            }
            this.selectedItems = new TableItem[this.selectedItems.length + 1];
            System.arraycopy(tableItemArray, 0, this.selectedItems, 0, tableItemArray.length);
            this.selectedItems[this.selectedItems.length - 1] = tableItem;
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color == null) {
            color = this.display.getSystemColor(25);
        }
        super.setBackground(color);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color == null) {
            color = this.display.getSystemColor(24);
        }
        super.setForeground(color);
    }

    public void setColumnOrder(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columns.length == 0) {
            if (nArray.length != 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columns.length) {
            this.error(5);
        }
        boolean bl = false;
        boolean[] blArray = new boolean[this.columns.length];
        int[] nArray2 = this.getColumnOrder();
        int n2 = 0;
        while (n2 < nArray.length) {
            n = nArray[n2];
            if (n < 0 || n >= this.columns.length) {
                this.error(6);
            }
            if (blArray[n]) {
                this.error(5);
            }
            blArray[n] = true;
            if (n != nArray2[n2]) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            return;
        }
        this.headerHideToolTip();
        int[] nArray3 = new int[this.columns.length];
        n = 0;
        while (n < this.columns.length) {
            nArray3[n] = this.columns[n].getX();
            ++n;
        }
        this.orderedColumns = new TableColumn[nArray.length];
        n = 0;
        while (n < nArray.length) {
            this.orderedColumns[n] = this.columns[nArray[n]];
            ++n;
        }
        n = 0;
        while (n < this.orderedColumns.length) {
            TableColumn tableColumn = this.orderedColumns[n];
            if (!tableColumn.isDisposed() && tableColumn.getX() != nArray3[tableColumn.getIndex()]) {
                tableColumn.sendEvent(10);
            }
            ++n;
        }
        this.redraw();
        if (this.drawCount <= 0 && this.header.isVisible()) {
            this.header.redraw();
        }
    }

    void setFocusItem(TableItem tableItem, boolean bl) {
        if (tableItem == this.focusItem) {
            return;
        }
        TableItem tableItem2 = this.focusItem;
        this.focusItem = tableItem;
        if (bl && tableItem2 != null) {
            this.redrawItem(tableItem2.index, true);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        Font font2 = this.getFont();
        super.setFont(font);
        Font font3 = this.getFont();
        if (font3.equals(font2)) {
            return;
        }
        GC gC = new GC(this);
        this.fontHeight = gC.getFontMetrics().getHeight();
        this.setItemHeight(Math.max(this.fontHeight, this.imageHeight) + 2 * this.getCellPadding());
        Point point = this.header.getSize();
        int n = Math.max(this.fontHeight, this.headerImageHeight) + 2 * this.getHeaderPadding();
        if (point.y != n) {
            this.header.setSize(point.x, n);
        }
        this.header.setFont(font3);
        int n2 = 0;
        while (n2 < this.columns.length) {
            this.columns[n2].updateFont(gC);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.itemsCount) {
            this.items[n2].updateFont(gC);
            ++n2;
        }
        gC.dispose();
        if (this.drawCount <= 0 && this.header.isVisible()) {
            this.header.redraw();
        }
        if (this.columns.length == 0) {
            this.updateHorizontalBar();
        }
        ScrollBar scrollBar = this.getVerticalBar();
        int n3 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        scrollBar.setThumb(n3);
        scrollBar.setPageIncrement(n3);
        this.topIndex = scrollBar.getSelection();
        scrollBar.setVisible(n3 < scrollBar.getMaximum());
        this.redraw();
    }

    void setHeaderImageHeight(int n) {
        this.headerImageHeight = n;
        Point point = this.header.getSize();
        int n2 = Math.max(this.fontHeight, this.headerImageHeight) + 2 * this.getHeaderPadding();
        if (point.y != n2) {
            this.header.setSize(point.x, n2);
        }
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        if (this.header.getVisible() == bl) {
            return;
        }
        this.headerHideToolTip();
        this.header.setVisible(bl);
        this.updateVerticalBar();
        this.redraw();
    }

    void setImageHeight(int n) {
        this.imageHeight = n;
        this.setItemHeight(Math.max(this.fontHeight, this.imageHeight) + 2 * this.getCellPadding());
    }

    public void setItemCount(int n) {
        int n2;
        int n3;
        this.checkWidget();
        n = Math.max(0, n);
        if (n == this.itemsCount) {
            return;
        }
        int n4 = this.itemsCount;
        if (n < this.itemsCount) {
            n3 = n;
            n2 = this.itemsCount - 1;
            int n5 = n;
            while (n5 < this.itemsCount) {
                this.items[n5].dispose(false);
                ++n5;
            }
            n5 = 0;
            int n6 = 0;
            while (n6 < this.selectedItems.length) {
                if (!this.selectedItems[n6].isDisposed()) {
                    ++n5;
                }
                ++n6;
            }
            if (n5 != this.selectedItems.length) {
                TableItem[] tableItemArray = new TableItem[n5];
                int n7 = 0;
                int n8 = 0;
                while (n8 < this.selectedItems.length) {
                    TableItem tableItem = this.selectedItems[n8];
                    if (!tableItem.isDisposed()) {
                        tableItemArray[n7++] = tableItem;
                    }
                    ++n8;
                }
                this.selectedItems = tableItemArray;
            }
            if (this.anchorItem != null && this.anchorItem.isDisposed()) {
                this.anchorItem = null;
            }
            if (this.lastClickedItem != null && this.lastClickedItem.isDisposed()) {
                this.lastClickedItem = null;
            }
            if (this.focusItem != null && this.focusItem.isDisposed()) {
                TableItem tableItem = n > 0 ? this.items[n - 1] : null;
                this.setFocusItem(tableItem, false);
            }
            this.itemsCount = n;
            if (this.columns.length == 0) {
                this.updateHorizontalBar();
            }
        } else {
            n3 = this.itemsCount;
            n2 = n - 1;
            TableItem[] tableItemArray = new TableItem[n];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.itemsCount);
            this.items = tableItemArray;
            int n9 = this.itemsCount;
            while (n9 < n) {
                this.items[n9] = new TableItem(this, 0, n9, false);
                ++this.itemsCount;
                ++n9;
            }
            if (n4 == 0) {
                this.focusItem = this.items[0];
            }
        }
        this.updateVerticalBar();
        if ((n4 == 0 || this.itemsCount == 0) && this.isFocusControl()) {
            this.redraw();
            return;
        }
        this.redrawItems(n3, n2, false);
    }

    boolean setItemHeight(int n) {
        boolean bl;
        boolean bl2 = bl = !this.customHeightSet || this.itemHeight < n;
        if (bl) {
            this.itemHeight = n;
        }
        return bl;
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        if (this.linesVisible == bl) {
            return;
        }
        this.linesVisible = bl;
        this.redraw();
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        if (bl) {
            if (--this.drawCount == 0) {
                if (this.items.length - this.itemsCount > 3) {
                    TableItem[] tableItemArray = new TableItem[this.itemsCount];
                    System.arraycopy(this.items, 0, tableItemArray, 0, this.itemsCount);
                    this.items = tableItemArray;
                }
                this.updateVerticalBar();
                this.updateHorizontalBar();
            }
        } else {
            ++this.drawCount;
        }
        super.setRedraw(bl);
        this.header.setRedraw(bl);
    }

    public void setSelection(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{tableItem});
    }

    public void setSelection(TableItem[] tableItemArray) {
        this.checkWidget();
        if (tableItemArray == null) {
            this.error(4);
        }
        if (tableItemArray.length == 0 || (this.style & 4) != 0 && tableItemArray.length > 1) {
            this.deselectAll();
            return;
        }
        TableItem[] tableItemArray2 = this.selectedItems;
        int n = 0;
        this.selectedItems = new TableItem[tableItemArray.length];
        int n2 = 0;
        while (n2 < tableItemArray.length) {
            TableItem tableItem = tableItemArray[n2];
            if (tableItem != null && tableItem.parent == this && !tableItem.isSelected()) {
                this.selectedItems[n++] = tableItem;
            }
            ++n2;
        }
        if (n != tableItemArray.length) {
            TableItem[] tableItemArray3 = new TableItem[n];
            System.arraycopy(this.selectedItems, 0, tableItemArray3, 0, n);
            this.selectedItems = tableItemArray3;
        }
        if (this.selectedItems.length == 0) {
            this.deselectAll();
            return;
        }
        if (this.hasFocus() || (this.style & 0x8000) == 0) {
            int n3 = 0;
            while (n3 < tableItemArray2.length) {
                if (!tableItemArray2[n3].isSelected()) {
                    this.redrawItem(tableItemArray2[n3].index, true);
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < this.selectedItems.length) {
                this.redrawItem(this.selectedItems[n3].index, true);
                ++n3;
            }
        }
        this.showItem(this.selectedItems[0]);
        this.setFocusItem(this.selectedItems[0], true);
    }

    public void setSortColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn != null && tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn == this.sortColumn) {
            return;
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(0);
        }
        this.sortColumn = tableColumn;
        if (this.sortColumn != null) {
            this.sortColumn.setSortDirection(this.sortDirection);
        }
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024 && n != 0) {
            return;
        }
        this.sortDirection = n;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        this.sortColumn.setSortDirection(this.sortDirection);
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.deselectAll();
        if (n < 0 || n >= this.itemsCount) {
            return;
        }
        this.selectItem(this.items[n], false);
        this.setFocusItem(this.items[n], true);
        this.redrawItem(n, true);
        this.showSelection();
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemsCount == 0 || n >= this.itemsCount) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemsCount - 1);
        this.select(n, n2);
        this.setFocusItem(this.items[n], true);
        this.showSelection();
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        this.select(nArray);
        int n2 = -1;
        int n3 = 0;
        while (n3 < nArray.length && n2 == -1) {
            if (nArray[n3] >= 0 && nArray[n3] < this.itemsCount) {
                n2 = nArray[n3];
            }
            ++n3;
        }
        if (n2 != -1) {
            this.setFocusItem(this.items[n2], true);
        }
        this.showSelection();
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemsCount) {
            return;
        }
        int n2 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        if (this.itemsCount <= n2) {
            return;
        }
        if ((n = Math.min(n, this.itemsCount - n2)) == this.topIndex) {
            return;
        }
        this.update();
        int n3 = this.topIndex - n;
        this.topIndex = n;
        this.getVerticalBar().setSelection(this.topIndex);
        if (this.drawCount <= 0) {
            GC gC = new GC(this);
            gC.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, n3 * this.itemHeight);
            gC.dispose();
        }
    }

    public void showColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn.parent != this) {
            return;
        }
        int n = tableColumn.getX();
        int n2 = n + tableColumn.width;
        if (n >= 0 && n2 <= this.clientArea.width) {
            return;
        }
        this.headerHideToolTip();
        int n3 = 0;
        TableColumn[] tableColumnArray = this.getOrderedColumns();
        int n4 = 0;
        while (n4 < tableColumn.getOrderIndex()) {
            n3 += tableColumnArray[n4].width;
            ++n4;
        }
        this.horizontalOffset = n < this.clientArea.x ? n3 : n3 + tableColumn.width - this.clientArea.width;
        this.getHorizontalBar().setSelection(this.horizontalOffset);
        this.redraw();
        if (this.drawCount <= 0 && this.header.isVisible()) {
            this.header.redraw();
        }
    }

    public void showItem(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (tableItem.isDisposed()) {
            this.error(5);
        }
        if (tableItem.parent != this) {
            return;
        }
        int n = tableItem.index;
        int n2 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        if (this.topIndex <= n && n < this.topIndex + n2) {
            return;
        }
        if (n <= this.topIndex) {
            this.setTopIndex(tableItem.index);
        } else {
            n2 = Math.max(n2, 1);
            this.setTopIndex(Math.min(n - n2 + 1, this.itemsCount - 1));
        }
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selectedItems.length == 0) {
            return;
        }
        this.showItem(this.selectedItems[0]);
    }

    void sortDescent(int[] nArray) {
        int n = nArray.length;
        int n2 = n / 2;
        while (n2 > 0) {
            int n3 = n2;
            while (n3 < n) {
                int n4 = n3 - n2;
                while (n4 >= 0) {
                    if (nArray[n4] <= nArray[n4 + n2]) {
                        int n5 = nArray[n4];
                        nArray[n4] = nArray[n4 + n2];
                        nArray[n4 + n2] = n5;
                    }
                    n4 -= n2;
                }
                ++n3;
            }
            n2 /= 2;
        }
    }

    void sortAscent(int[] nArray) {
        int n = nArray.length;
        int n2 = n / 2;
        while (n2 > 0) {
            int n3 = n2;
            while (n3 < n) {
                int n4 = n3 - n2;
                while (n4 >= 0) {
                    if (nArray[n4] >= nArray[n4 + n2]) {
                        int n5 = nArray[n4];
                        nArray[n4] = nArray[n4 + n2];
                        nArray[n4 + n2] = n5;
                    }
                    n4 -= n2;
                }
                ++n3;
            }
            n2 /= 2;
        }
    }

    void sortAscent(TableItem[] tableItemArray) {
        int n = tableItemArray.length;
        int n2 = n / 2;
        while (n2 > 0) {
            int n3 = n2;
            while (n3 < n) {
                int n4 = n3 - n2;
                while (n4 >= 0) {
                    if (tableItemArray[n4].index >= tableItemArray[n4 + n2].index) {
                        TableItem tableItem = tableItemArray[n4];
                        tableItemArray[n4] = tableItemArray[n4 + n2];
                        tableItemArray[n4 + n2] = tableItem;
                    }
                    n4 -= n2;
                }
                ++n3;
            }
            n2 /= 2;
        }
    }

    void updateColumnWidth(TableColumn tableColumn, int n) {
        int n2;
        int n3;
        this.headerHideToolTip();
        int n4 = tableColumn.width;
        int n5 = tableColumn.getX();
        int n6 = n5 + n4 - 1;
        this.update();
        GC gC = new GC(this);
        gC.copyArea(n6, 0, this.clientArea.width - n6, this.clientArea.height, n5 + n - 1, 0);
        if (n > n4) {
            n3 = n - n4 + 1;
            this.redraw(n6 - 1, 0, n3 + 1, this.clientArea.height, false);
        } else {
            n3 = n4 - n + 1;
            this.redraw(this.clientArea.width - n3, 0, n3, this.clientArea.height, false);
        }
        if (this.focusItem != null) {
            this.redrawItem(this.focusItem.index, true);
        }
        GC gC2 = new GC(this.header);
        if (this.drawCount <= 0 && this.header.getVisible()) {
            Rectangle rectangle = this.header.getClientArea();
            this.header.update();
            gC2.copyArea(--n6, 0, rectangle.width - n6, rectangle.height, n5 + n - 2, 0);
            if (n > n4) {
                n2 = n - n4 + 2;
                this.header.redraw(n6, 0, n2, rectangle.height, false);
            } else {
                n2 = n4 - n + 2;
                this.header.redraw(rectangle.width - n2, 0, n2, rectangle.height, false);
            }
        }
        tableColumn.width = n;
        tableColumn.updateWidth(gC2);
        gC2.dispose();
        int n7 = 0;
        while (n7 < this.itemsCount) {
            this.items[n7].updateColumnWidth(tableColumn, gC);
            ++n7;
        }
        gC.dispose();
        n7 = 0;
        n2 = 0;
        while (n2 < this.columns.length) {
            n7 += this.columns[n2].width;
            ++n2;
        }
        ScrollBar scrollBar = this.getHorizontalBar();
        scrollBar.setMaximum(Math.max(1, n7));
        if (scrollBar.getThumb() != this.clientArea.width) {
            scrollBar.setThumb(this.clientArea.width);
            scrollBar.setPageIncrement(this.clientArea.width);
        }
        int n8 = this.horizontalOffset;
        scrollBar.setVisible(this.clientArea.width < n7);
        int n9 = scrollBar.getSelection();
        if (n9 != n8) {
            this.horizontalOffset = n9;
            this.redraw();
            if (this.drawCount <= 0 && this.header.getVisible()) {
                this.header.redraw();
            }
        }
        tableColumn.sendEvent(11);
        TableColumn[] tableColumnArray = this.getOrderedColumns();
        int n10 = tableColumn.getOrderIndex() + 1;
        while (n10 < tableColumnArray.length) {
            if (!tableColumnArray[n10].isDisposed()) {
                tableColumnArray[n10].sendEvent(10);
            }
            ++n10;
        }
        if (this.itemsCount == 0) {
            this.redraw();
        }
    }

    void updateHorizontalBar() {
        int n;
        int n2;
        if (this.drawCount > 0) {
            return;
        }
        ScrollBar scrollBar = this.getHorizontalBar();
        int n3 = 0;
        if (this.columns.length > 0) {
            n2 = 0;
            while (n2 < this.columns.length) {
                n3 += this.columns[n2].width;
                ++n2;
            }
        } else {
            n2 = 0;
            while (n2 < this.itemsCount) {
                Rectangle rectangle = this.items[n2].getCellBounds(0);
                n3 = Math.max(n3, rectangle.x + rectangle.width + this.horizontalOffset);
                ++n2;
            }
        }
        n2 = this.clientArea.width;
        if (n3 != scrollBar.getMaximum()) {
            scrollBar.setMaximum(Math.max(1, n3));
        }
        if ((n = Math.min(n2, n3)) != scrollBar.getThumb()) {
            scrollBar.setThumb(n);
            scrollBar.setPageIncrement(n);
        }
        scrollBar.setVisible(n2 < n3);
        if (n3 < this.horizontalOffset + n) {
            this.horizontalOffset = n3 - n;
            scrollBar.setSelection(this.horizontalOffset);
            this.redraw();
        } else {
            int n4 = scrollBar.getSelection();
            if (n4 != this.horizontalOffset) {
                this.horizontalOffset = n4;
                this.redraw();
            }
        }
    }

    void updateHorizontalBar(int n, int n2) {
        if (this.drawCount > 0) {
            return;
        }
        ScrollBar scrollBar = this.getHorizontalBar();
        int n3 = scrollBar.getMaximum();
        if ((n += this.horizontalOffset) > n3) {
            scrollBar.setMaximum(n);
            int n4 = this.clientArea.width;
            int n5 = Math.min(n, n4);
            scrollBar.setThumb(n5);
            scrollBar.setPageIncrement(n5);
            scrollBar.setVisible(n4 <= n);
            return;
        }
        int n6 = n - n2;
        if (n6 != n3) {
            int n7 = this.clientArea.width;
            int n8 = Math.min(n3, n7);
            scrollBar.setThumb(n8);
            scrollBar.setPageIncrement(n8);
            scrollBar.setVisible(n7 <= n3);
            return;
        }
        this.updateHorizontalBar();
    }

    void updateVerticalBar() {
        int n;
        ScrollBar scrollBar;
        if (this.drawCount > 0) {
            return;
        }
        int n2 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        int n3 = Math.max(1, this.itemsCount);
        if (n3 != (scrollBar = this.getVerticalBar()).getMaximum()) {
            scrollBar.setMaximum(n3);
        }
        if ((n = Math.min(n2, n3)) != scrollBar.getThumb()) {
            scrollBar.setThumb(n);
            scrollBar.setPageIncrement(n);
        }
        scrollBar.setVisible(n2 < n3);
        if (n3 < this.topIndex + n) {
            this.topIndex = n3 - n;
            scrollBar.setSelection(this.topIndex);
            this.redraw();
        } else {
            int n4 = scrollBar.getSelection();
            if (n4 != this.topIndex) {
                this.topIndex = n4;
                this.redraw();
            }
        }
    }
}

