/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    Table parent;
    String displayText = "";
    int width;
    boolean moveable;
    boolean resizable = true;
    int sort = 0;
    String toolTipText;

    public TableColumn(Table table, int n) {
        this(table, n, TableColumn.checkNull((Table)table).columns.length);
    }

    public TableColumn(Table table, int n, int n2) {
        super(table, TableColumn.checkStyle(n), n2);
        if (n2 < 0 || n2 > table.columns.length) {
            this.error(6);
        }
        this.parent = table;
        table.createItem(this, n2);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static Table checkNull(Table table) {
        if (table == null) {
            SWT.error(4);
        }
        return table;
    }

    static int checkStyle(int n) {
        return TableColumn.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    /*
     * Unable to fully structure code
     */
    void computeDisplayText(GC var1_1) {
        var2_2 = this.width - 2 * this.parent.getHeaderPadding();
        if (this.image != null) {
            var2_2 -= this.image.getBounds().width;
            var2_2 -= 3;
        }
        if (this.sort != 0) {
            var2_2 -= this.parent.arrowBounds.width;
            var2_2 -= 3;
        }
        var3_3 = this.text;
        var4_4 = var1_1.textExtent((String)var3_3, (int)8).x;
        if (var4_4 <= var2_2) {
            this.displayText = var3_3;
            return;
        }
        var5_5 = var1_1.stringExtent((String)"...").x;
        if ((var2_2 -= var5_5) <= 0) {
            this.displayText = "...";
            return;
        }
        var6_6 = Math.min(var2_2 / var1_1.getFontMetrics().getAverageCharWidth(), var3_3.length());
        var4_4 = var1_1.textExtent((String)var3_3.substring((int)0, (int)var6_6), (int)8).x;
        if (var2_2 == var4_4) {
            this.displayText = String.valueOf(var3_3.substring(0, var6_6)) + "...";
            return;
        }
        if (var2_2 >= var4_4) ** GOTO lbl32
        do {
            if (--var6_6 < 0) {
                this.displayText = "...";
                return;
            }
            var3_3 = var3_3.substring(0, var6_6);
        } while (var2_2 < (var4_4 = var1_1.textExtent((String)var3_3, (int)8).x));
        this.displayText = String.valueOf(var3_3) + "...";
        return;
lbl-1000:
        // 1 sources

        {
            var4_4 = var1_1.textExtent((String)var3_3.substring((int)0, (int)(++var6_6)), (int)8).x;
lbl32:
            // 2 sources

            ** while (var4_4 < var2_2)
        }
lbl33:
        // 1 sources

        this.displayText = String.valueOf(var3_3.substring(0, var6_6 - 1)) + "...";
    }

    public void dispose() {
        TableColumn tableColumn;
        if (this.isDisposed()) {
            return;
        }
        Rectangle rectangle = this.parent.clientArea;
        int n = this.getX();
        int n2 = this.getIndex();
        int n3 = this.getOrderIndex();
        int n4 = this.parent.columns.length > 1 ? this.parent.columns[1].getAlignment() : 16384;
        Table table = this.parent;
        this.dispose(true);
        int n5 = rectangle.width - n;
        table.redraw(n, 0, n5, rectangle.height, false);
        if (n2 == 0 && ((table.style & 0x20) != 0 || n4 != 16384) && table.columns.length > 0 && (tableColumn = table.columns[0]).getOrderIndex() < n3) {
            int n6 = tableColumn.getX();
            table.redraw(n6, 0, tableColumn.width, rectangle.height, false);
            if (n4 != 16384 && table.getHeaderVisible() && table.drawCount <= 0) {
                table.header.redraw(n6, 0, tableColumn.width, table.header.getClientArea().height, false);
            }
        }
        if (table.drawCount <= 0 && table.getHeaderVisible()) {
            table.header.redraw(n, 0, n5, table.getHeaderHeight(), false);
        }
    }

    void dispose(boolean bl) {
        super.dispose();
        if (bl) {
            this.parent.destroyItem(this);
        }
        this.parent = null;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    int getContentWidth(GC gC, boolean bl) {
        String string;
        int n = 0;
        String string2 = string = bl ? this.displayText : this.text;
        if (string.length() > 0) {
            n += gC.textExtent((String)string, (int)8).x;
        }
        if (this.image != null) {
            n += this.image.getBounds().width;
            if (string.length() > 0) {
                n += 3;
            }
        }
        if (this.sort != 0) {
            n += this.parent.arrowBounds.width;
            if (string.length() > 0 || this.image != null) {
                n += 3;
            }
        }
        return n;
    }

    int getIndex() {
        TableColumn[] tableColumnArray = this.parent.columns;
        int n = 0;
        while (n < tableColumnArray.length) {
            if (tableColumnArray[n] == this) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    int getOrderIndex() {
        TableColumn[] tableColumnArray = this.parent.orderedColumns;
        if (tableColumnArray == null) {
            return this.getIndex();
        }
        int n = 0;
        while (n < tableColumnArray.length) {
            if (tableColumnArray[n] == this) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth() {
        if (!this.parent.getHeaderVisible()) {
            return 0;
        }
        GC gC = new GC(this.parent);
        int n = this.getContentWidth(gC, false);
        gC.dispose();
        return n + 2 * this.parent.getHeaderPadding();
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return this.width;
    }

    int getX() {
        TableColumn[] tableColumnArray = this.parent.getOrderedColumns();
        int n = this.getOrderIndex();
        int n2 = -this.parent.horizontalOffset;
        int n3 = 0;
        while (n3 < n) {
            n2 += tableColumnArray[n3].width;
            ++n3;
        }
        return n2;
    }

    public void pack() {
        this.checkWidget();
        TableItem[] tableItemArray = this.parent.items;
        int n = this.getIndex();
        int n2 = this.getPreferredWidth();
        int n3 = 0;
        while (n3 < this.parent.itemsCount) {
            int n4 = tableItemArray[n3].getPreferredWidth(n);
            if (this.parent.isDisposed() || this.isDisposed()) {
                return;
            }
            if (!tableItemArray[n3].isDisposed()) {
                n2 = Math.max(n2, n4);
            }
            ++n3;
        }
        if (n2 != this.width) {
            this.parent.updateColumnWidth(this, n2);
        }
    }

    void paint(GC gC) {
        int n;
        Object object;
        int n2;
        int n3 = this.parent.getHeaderPadding();
        int n4 = this.getX();
        int n5 = n4 + n3;
        if ((this.style & 0x4000) == 0) {
            n2 = this.getContentWidth(gC, true);
            n5 = (this.style & 0x20000) != 0 ? Math.max(n5, n4 + this.width - n3 - n2) : Math.max(n5, n4 + (this.width - n2) / 2);
        }
        n2 = this.parent.getHeaderHeight();
        gC.setClipping(n4 + n3, n3, this.width - 2 * n3, n2 - 2 * n3);
        if (this.image != null) {
            object = this.image.getBounds();
            n = Math.min(((Rectangle)object).height, n2 - 2 * n3);
            gC.drawImage(this.image, 0, 0, ((Rectangle)object).width, ((Rectangle)object).height, n5, (n2 - n) / 2, ((Rectangle)object).width, n);
            n5 += ((Rectangle)object).width + 3;
        }
        if (this.displayText.length() > 0) {
            gC.setForeground(this.display.getSystemColor(2));
            int n6 = this.parent.fontHeight;
            gC.drawText(this.displayText, n5, (n2 - n6) / 2, 8);
            n5 += gC.textExtent((String)this.displayText, (int)8).x + 3;
        }
        if (this.sort != 0) {
            object = this.sort == 1024 ? this.parent.getArrowDownImage() : this.parent.getArrowUpImage();
            n = (n2 - this.parent.arrowBounds.height) / 2;
            gC.drawImage((Image)object, n5, n);
        }
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((n & 0x1024000) == 0) {
            return;
        }
        int n2 = this.getIndex();
        if (n2 == -1 || n2 == 0) {
            return;
        }
        if ((this.style & (n = TableColumn.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0))) != 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n;
        int n3 = this.getX();
        this.parent.redraw(n3, 0, this.width, this.parent.clientArea.height, false);
        if (this.parent.drawCount <= 0 && this.parent.getHeaderVisible()) {
            this.parent.header.redraw(n3, 0, this.width, this.parent.getHeaderHeight(), false);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image == this.image) {
            return;
        }
        if (image != null && image.equals(this.image)) {
            return;
        }
        super.setImage(image);
        GC gC = new GC(this.parent);
        this.computeDisplayText(gC);
        gC.dispose();
        if (this.parent.headerImageHeight == 0) {
            int n = this.parent.getHeaderHeight();
            this.parent.setHeaderImageHeight(image.getBounds().height);
            if (n != this.parent.getHeaderHeight()) {
                if (this.parent.drawCount <= 0 && this.parent.getHeaderVisible()) {
                    this.parent.header.redraw();
                }
                this.parent.redraw();
                return;
            }
        }
        if (this.parent.drawCount <= 0 && this.parent.getHeaderVisible()) {
            this.parent.header.redraw(this.getX(), 0, this.width, this.parent.getHeaderHeight(), false);
        }
    }

    public void setMoveable(boolean bl) {
        this.checkWidget();
        this.moveable = bl;
    }

    public void setResizable(boolean bl) {
        this.checkWidget();
        this.resizable = bl;
    }

    void setSortDirection(int n) {
        if (n == this.sort) {
            return;
        }
        boolean bl = n == 0 || this.sort == 0;
        this.sort = n;
        if (bl) {
            GC gC = new GC(this.parent);
            this.computeDisplayText(gC);
            gC.dispose();
        }
        if (this.parent.drawCount <= 0 && this.parent.getHeaderVisible()) {
            this.parent.header.redraw(this.getX(), 0, this.width, this.parent.getHeaderHeight(), false);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        super.setText(string);
        GC gC = new GC(this.parent);
        this.computeDisplayText(gC);
        gC.dispose();
        if (this.parent.drawCount <= 0 && this.parent.getHeaderVisible()) {
            this.parent.header.redraw(this.getX(), 0, this.width, this.parent.getHeaderHeight(), false);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (this.toolTipText == string) {
            return;
        }
        if (this.toolTipText != null && this.toolTipText.equals(string)) {
            return;
        }
        this.toolTipText = string;
        if (this.parent.toolTipShell == null) {
            return;
        }
        if (((Integer)this.parent.toolTipShell.getData()).intValue() != this.getIndex()) {
            return;
        }
        this.parent.headerUpdateToolTip(this.getX() + this.width / 2);
    }

    public void setWidth(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (this.width == n) {
            return;
        }
        this.parent.updateColumnWidth(this, n);
    }

    void updateFont(GC gC) {
        this.computeDisplayText(gC);
    }

    void updateWidth(GC gC) {
        String string = this.displayText;
        this.computeDisplayText(gC);
        if (this.parent.getHeaderVisible() && ((this.style & 0x4000) == 0 || !string.equals(this.displayText))) {
            int n = this.parent.getHeaderPadding();
            this.parent.header.redraw(this.getX() + n, 0, this.width - n, this.parent.getHeaderHeight(), false);
        }
    }
}

