/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XAnyEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Composite parent;
    boolean tracking;
    boolean cancelled;
    boolean stippled;
    Rectangle[] rectangles = new Rectangle[0];
    Rectangle[] proportions = this.rectangles;
    Rectangle bounds;
    int cursorOrientation = 0;
    int cursor;
    int window;
    int oldX;
    int oldY;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite composite, int n) {
        super(composite, Tracker.checkStyle(n));
        this.parent = composite;
    }

    public Tracker(Display display, int n) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(n);
        this.display = display;
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    Point adjustMoveCursor() {
        if (this.bounds == null) {
            return null;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int n = this.bounds.x + this.bounds.width / 2;
        int n2 = this.bounds.y;
        int n3 = this.display.xDisplay;
        OS.XWarpPointer(n3, 0, this.window, 0, 0, 0, 0, n, n2);
        OS.XQueryPointer(n3, this.window, nArray, nArray, nArray2, nArray3, nArray, nArray, nArray);
        return new Point(nArray2[0], nArray3[0]);
    }

    Point adjustResizeCursor() {
        if (this.bounds == null) {
            return null;
        }
        int n = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int n2 = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int n3 = this.display.xDisplay;
        OS.XWarpPointer(n3, 0, this.window, 0, 0, 0, 0, n, n2);
        OS.XQueryPointer(n3, this.window, nArray, nArray, nArray2, nArray3, nArray, nArray, nArray);
        return new Point(nArray2[0], nArray3[0]);
    }

    static int checkStyle(int n) {
        if ((n & 0x24480) == 0) {
            n |= 0x24480;
        }
        return n;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int n = this.rectangles[0].x;
        int n2 = this.rectangles[0].y;
        int n3 = this.rectangles[0].x + this.rectangles[0].width;
        int n4 = this.rectangles[0].y + this.rectangles[0].height;
        int n5 = 1;
        while (n5 < this.rectangles.length) {
            int n6;
            int n7;
            if (this.rectangles[n5].x < n) {
                n = this.rectangles[n5].x;
            }
            if (this.rectangles[n5].y < n2) {
                n2 = this.rectangles[n5].y;
            }
            if ((n7 = this.rectangles[n5].x + this.rectangles[n5].width) > n3) {
                n3 = n7;
            }
            if ((n6 = this.rectangles[n5].y + this.rectangles[n5].height) > n4) {
                n4 = n6;
            }
            ++n5;
        }
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    Rectangle[] computeProportions(Rectangle[] rectangleArray) {
        Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            int n = 0;
            while (n < rectangleArray.length) {
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                if (this.bounds.width != 0) {
                    n2 = (rectangleArray[n].x - this.bounds.x) * 100 / this.bounds.width;
                    n4 = rectangleArray[n].width * 100 / this.bounds.width;
                } else {
                    n4 = 100;
                }
                if (this.bounds.height != 0) {
                    n3 = (rectangleArray[n].y - this.bounds.y) * 100 / this.bounds.height;
                    n5 = rectangleArray[n].height * 100 / this.bounds.height;
                } else {
                    n5 = 100;
                }
                rectangleArray2[n] = new Rectangle(n2, n3, n4, n5);
                ++n;
            }
        }
        return rectangleArray2;
    }

    void drawRectangles(Rectangle[] rectangleArray, boolean bl) {
        int n;
        int n2;
        int n3 = this.display.xDisplay;
        int n4 = OS.XWhitePixel(n3, 0);
        int n5 = OS.XDefaultRootWindow(n3);
        if (this.parent != null) {
            n5 = OS.XtWindow(this.parent.handle);
            if (n5 == 0) {
                return;
            }
            n2 = this.parent.getForegroundPixel();
            Control control = this.parent.findBackgroundControl();
            if (control == null) {
                control = this.parent;
            }
            n = control.getBackgroundPixel();
            n4 = n2 ^ n;
        }
        n2 = OS.XCreateGC(n3, n5, 0, null);
        OS.XSetForeground(n3, n2, n4);
        OS.XSetSubwindowMode(n3, n2, 1);
        OS.XSetFunction(n3, n2, 6);
        int n6 = 0;
        if (bl) {
            byte[] byArray = new byte[16];
            byArray[0] = -86;
            byArray[2] = 85;
            byArray[4] = -86;
            byArray[6] = 85;
            byArray[8] = -86;
            byArray[10] = 85;
            byArray[12] = -86;
            byArray[14] = 85;
            byte[] byArray2 = byArray;
            n6 = OS.XCreateBitmapFromData(n3, n5, byArray2, 8, 8);
            OS.XSetStipple(n3, n2, n6);
            OS.XSetFillStyle(n3, n2, 2);
            OS.XSetLineAttributes(n3, n2, 3, 0, 1, 0);
        }
        n = 0;
        while (n < rectangleArray.length) {
            Rectangle rectangle = rectangleArray[n];
            OS.XDrawRectangle(n3, n5, n2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++n;
        }
        if (bl) {
            OS.XFreePixmap(n3, n6);
        }
        OS.XFreeGC(n3, n2);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        int n = 0;
        while (n < this.rectangles.length) {
            Rectangle rectangle = this.rectangles[n];
            rectangleArray[n] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++n;
        }
        return rectangleArray;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void moveRectangles(int n, int n2) {
        if (this.bounds == null) {
            return;
        }
        if (n < 0 && (this.style & 0x4000) == 0) {
            n = 0;
        }
        if (n > 0 && (this.style & 0x20000) == 0) {
            n = 0;
        }
        if (n2 < 0 && (this.style & 0x80) == 0) {
            n2 = 0;
        }
        if (n2 > 0 && (this.style & 0x400) == 0) {
            n2 = 0;
        }
        if (n == 0 && n2 == 0) {
            return;
        }
        this.bounds.x += n;
        this.bounds.y += n2;
        int n3 = 0;
        while (n3 < this.rectangles.length) {
            this.rectangles[n3].x += n;
            this.rectangles[n3].y += n2;
            ++n3;
        }
    }

    public boolean open() {
        int n;
        boolean bl;
        int n2;
        this.checkWidget();
        int n3 = this.display.xDisplay;
        this.window = OS.XDefaultRootWindow(n3);
        if (this.parent != null) {
            this.window = OS.XtWindow(this.parent.handle);
            if (this.window == 0) {
                return false;
            }
        }
        this.cancelled = false;
        this.tracking = true;
        this.update();
        this.drawRectangles(this.rectangles, this.stippled);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        OS.XQueryPointer(n3, this.window, nArray3, nArray3, nArray, nArray2, nArray3, nArray3, nArray4);
        int n4 = this.style & 0x480;
        if (n4 == 128 || n4 == 1024) {
            this.cursorOrientation |= n4;
        }
        if ((n2 = this.style & 0x24000) == 16384 || n2 == 131072) {
            this.cursorOrientation |= n2;
        }
        boolean bl2 = bl = (nArray4[0] & (n = 1792)) != 0;
        if (!bl) {
            Point point = null;
            point = (this.style & 0x10) != 0 ? this.adjustResizeCursor() : this.adjustMoveCursor();
            if (point != null) {
                nArray[0] = point.x;
                nArray2[0] = point.y;
            }
        }
        this.oldX = nArray[0];
        this.oldY = nArray2[0];
        int n5 = OS.XGrabPointer(n3, this.window, 0, 76, 1, 1, 0, 0, 0);
        int n6 = OS.XGrabKeyboard(n3, this.window, 0, 1, 1, 0);
        XAnyEvent xAnyEvent = new XAnyEvent();
        int n7 = OS.XtMalloc(96);
        int n8 = OS.XtMalloc(4);
        int n9 = OS.XtDisplayToApplicationContext(n3);
        while (this.tracking) {
            if (this.parent != null && this.parent.isDisposed()) break;
            OS.XtAppNextEvent(n9, n7);
            OS.memmove(xAnyEvent, n7, 20);
            int n10 = OS.XtWindowToWidget(xAnyEvent.display, xAnyEvent.window);
            switch (xAnyEvent.type) {
                case 6: {
                    this.XPointerMotion(n10, 0, n7, n8);
                    break;
                }
                case 5: {
                    this.XButtonRelease(n10, 0, n7, n8);
                    break;
                }
                case 2: {
                    this.XKeyPress(n10, 0, n7, n8);
                    break;
                }
                case 3: {
                    this.XKeyRelease(n10, 0, n7, n8);
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    break;
                }
                case 12: {
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                    OS.XtDispatchEvent(n7);
                    this.drawRectangles(this.rectangles, this.stippled);
                    break;
                }
                default: {
                    OS.XtDispatchEvent(n7);
                }
            }
        }
        if (n7 != 0) {
            OS.XtFree(n7);
        }
        if (n8 != 0) {
            OS.XtFree(n8);
        }
        if (!this.isDisposed()) {
            this.update();
            this.drawRectangles(this.rectangles, this.stippled);
        }
        if (n5 == 0) {
            OS.XUngrabPointer(n3, 0);
        }
        if (n6 == 0) {
            OS.XUngrabKeyboard(n3, 0);
        }
        this.window = 0;
        return !this.cancelled;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, controlListener);
        this.eventTable.unhook(10, controlListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.proportions = null;
        this.rectangles = null;
        this.bounds = null;
    }

    void resizeRectangles(int n, int n2) {
        Rectangle rectangle;
        int n3;
        if (this.bounds == null) {
            return;
        }
        if (n < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        }
        if (n > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        }
        if (n2 < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        }
        if (n2 > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (n > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                n -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    n3 = 0;
                    while (n3 < this.proportions.length) {
                        rectangle = this.proportions[n3];
                        rectangle.x = 100 - rectangle.x - rectangle.width;
                        ++n3;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -n) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            n += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                n3 = 0;
                while (n3 < this.proportions.length) {
                    rectangle = this.proportions[n3];
                    rectangle.x = 100 - rectangle.x - rectangle.width;
                    ++n3;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (n2 > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                n2 -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    n3 = 0;
                    while (n3 < this.proportions.length) {
                        rectangle = this.proportions[n3];
                        rectangle.y = 100 - rectangle.y - rectangle.height;
                        ++n3;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -n2) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            n2 += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                n3 = 0;
                while (n3 < this.proportions.length) {
                    rectangle = this.proportions[n3];
                    rectangle.y = 100 - rectangle.y - rectangle.height;
                    ++n3;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += n;
            this.bounds.width -= n;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += n;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += n2;
            this.bounds.height -= n2;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += n2;
        }
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        int n4 = 0;
        while (n4 < this.rectangles.length) {
            Rectangle rectangle2 = this.proportions[n4];
            rectangleArray[n4] = new Rectangle(rectangle2.x * this.bounds.width / 100 + this.bounds.x, rectangle2.y * this.bounds.height / 100 + this.bounds.y, rectangle2.width * this.bounds.width / 100, rectangle2.height * this.bounds.height / 100);
            ++n4;
        }
        this.rectangles = rectangleArray;
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        this.cursor = 0;
        if (cursor != null) {
            this.cursor = cursor.handle;
        }
    }

    public void setRectangles(Rectangle[] rectangleArray) {
        this.checkWidget();
        if (rectangleArray == null) {
            this.error(4);
        }
        this.rectangles = new Rectangle[rectangleArray.length];
        int n = 0;
        while (n < rectangleArray.length) {
            Rectangle rectangle = rectangleArray[n];
            if (rectangle == null) {
                this.error(4);
            }
            this.rectangles[n] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++n;
        }
        this.proportions = this.computeProportions(rectangleArray);
    }

    public void setStippled(boolean bl) {
        this.checkWidget();
        this.stippled = bl;
    }

    void update() {
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            this.parent.getShell().update();
        } else {
            this.display.update();
        }
    }

    int XButtonRelease(int n, int n2, int n3, int n4) {
        return this.xMouse(5, n, n2, n3, n4);
    }

    int XKeyPress(int n, int n2, int n3, int n4) {
        int n5 = super.XKeyPress(n, n2, n3, n4);
        if (n5 != 0) {
            return n5;
        }
        XKeyEvent xKeyEvent = new XKeyEvent();
        OS.memmove(xKeyEvent, n3, 60);
        if (xKeyEvent.keycode != 0) {
            int[] nArray = new int[1];
            OS.XLookupString(xKeyEvent, null, 0, nArray, null);
            nArray[0] = nArray[0] & 0xFFFF;
            int n6 = 0;
            int n7 = 0;
            int n8 = (xKeyEvent.state & 4) != 0 ? 1 : 9;
            switch (nArray[0]) {
                case 65293: 
                case 65421: {
                    this.tracking = false;
                    OS.XtAppNextEvent(OS.XtDisplayToApplicationContext(xKeyEvent.display), n3);
                    break;
                }
                case 65307: {
                    this.tracking = false;
                    this.cancelled = true;
                    OS.XtAppNextEvent(OS.XtDisplayToApplicationContext(xKeyEvent.display), n3);
                    break;
                }
                case 65361: {
                    n6 = -n8;
                    break;
                }
                case 65363: {
                    n6 = n8;
                    break;
                }
                case 65362: {
                    n7 = -n8;
                    break;
                }
                case 65364: {
                    n7 = n8;
                }
            }
            if (n6 != 0 || n7 != 0) {
                SerializableCompatibility serializableCompatibility;
                Rectangle[] rectangleArray = this.rectangles;
                boolean bl = this.stippled;
                Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
                int n9 = 0;
                while (n9 < this.rectangles.length) {
                    serializableCompatibility = this.rectangles[n9];
                    rectangleArray2[n9] = new Rectangle(serializableCompatibility.x, serializableCompatibility.y, serializableCompatibility.width, serializableCompatibility.height);
                    ++n9;
                }
                Event event = new Event();
                event.x = this.oldX + n6;
                event.y = this.oldY + n7;
                if ((this.style & 0x10) != 0) {
                    this.resizeRectangles(n6, n7);
                    this.sendEvent(11, event);
                    if (this.isDisposed()) {
                        this.cancelled = true;
                        return 1;
                    }
                    boolean bl2 = false;
                    if (this.rectangles != rectangleArray) {
                        int n10 = this.rectangles.length;
                        if (n10 != rectangleArray2.length) {
                            bl2 = true;
                        } else {
                            int n11 = 0;
                            while (n11 < n10) {
                                if (!this.rectangles[n11].equals(rectangleArray2[n11])) {
                                    bl2 = true;
                                    break;
                                }
                                ++n11;
                            }
                        }
                    } else {
                        bl2 = true;
                    }
                    if (bl2) {
                        this.drawRectangles(rectangleArray2, bl);
                        this.update();
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    serializableCompatibility = this.adjustResizeCursor();
                } else {
                    this.moveRectangles(n6, n7);
                    this.sendEvent(10, event);
                    if (this.isDisposed()) {
                        this.cancelled = true;
                        return 1;
                    }
                    boolean bl3 = false;
                    if (this.rectangles != rectangleArray) {
                        int n12 = this.rectangles.length;
                        if (n12 != rectangleArray2.length) {
                            bl3 = true;
                        } else {
                            int n13 = 0;
                            while (n13 < n12) {
                                if (!this.rectangles[n13].equals(rectangleArray2[n13])) {
                                    bl3 = true;
                                    break;
                                }
                                ++n13;
                            }
                        }
                    } else {
                        bl3 = true;
                    }
                    if (bl3) {
                        this.drawRectangles(rectangleArray2, bl);
                        this.update();
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    serializableCompatibility = this.adjustMoveCursor();
                }
                if (serializableCompatibility != null) {
                    this.oldX = ((Point)serializableCompatibility).x;
                    this.oldY = ((Point)serializableCompatibility).y;
                }
            }
        }
        return n5;
    }

    int XPointerMotion(int n, int n2, int n3, int n4) {
        if (this.cursor != 0) {
            int n5 = this.display.xDisplay;
            OS.XChangeActivePointerGrab(n5, 76, this.cursor, 0);
        }
        return this.xMouse(6, n, n2, n3, n4);
    }

    int xMouse(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.display.xDisplay;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.XQueryPointer(n6, this.window, nArray3, nArray3, nArray, nArray2, nArray3, nArray3, nArray3);
        if (this.oldX != nArray[0] || this.oldY != nArray2[0]) {
            Rectangle[] rectangleArray = this.rectangles;
            boolean bl = this.stippled;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            int n7 = 0;
            while (n7 < this.rectangles.length) {
                Rectangle rectangle = this.rectangles[n7];
                rectangleArray2[n7] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                ++n7;
            }
            Event event = new Event();
            event.x = nArray[0];
            event.y = nArray2[0];
            if ((this.style & 0x10) != 0) {
                Point point;
                this.resizeRectangles(nArray[0] - this.oldX, nArray2[0] - this.oldY);
                this.sendEvent(11, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1;
                }
                boolean bl2 = false;
                if (this.rectangles != rectangleArray) {
                    int n8 = this.rectangles.length;
                    if (n8 != rectangleArray2.length) {
                        bl2 = true;
                    } else {
                        int n9 = 0;
                        while (n9 < n8) {
                            if (!this.rectangles[n9].equals(rectangleArray2[n9])) {
                                bl2 = true;
                                break;
                            }
                            ++n9;
                        }
                    }
                } else {
                    bl2 = true;
                }
                if (bl2) {
                    this.drawRectangles(rectangleArray2, bl);
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
                if ((point = this.adjustResizeCursor()) != null) {
                    nArray[0] = point.x;
                    nArray2[0] = point.y;
                }
            } else {
                this.moveRectangles(nArray[0] - this.oldX, nArray2[0] - this.oldY);
                this.sendEvent(10, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1;
                }
                boolean bl3 = false;
                if (this.rectangles != rectangleArray) {
                    int n10 = this.rectangles.length;
                    if (n10 != rectangleArray2.length) {
                        bl3 = true;
                    } else {
                        int n11 = 0;
                        while (n11 < n10) {
                            if (!this.rectangles[n11].equals(rectangleArray2[n11])) {
                                bl3 = true;
                                break;
                            }
                            ++n11;
                        }
                    }
                } else {
                    bl3 = true;
                }
                if (bl3) {
                    this.drawRectangles(rectangleArray2, bl);
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
            }
            this.oldX = nArray[0];
            this.oldY = nArray2[0];
        }
        this.tracking = n != 5;
        return 0;
    }
}

