/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.mapreduce;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapRunnable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.CentralLogStore;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.hadoop.mapreduce.InKeyValueOrdinals;
import org.pentaho.hadoop.mapreduce.MRUtil;
import org.pentaho.hadoop.mapreduce.OutputCollectorRowListener;
import org.pentaho.hadoop.mapreduce.converter.TypeConverterFactory;
import org.pentaho.hadoop.mapreduce.converter.spi.ITypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PentahoMapRunnable<K1, V1, K2, V2>
implements MapRunnable<K1, V1, K2, V2> {
    protected String transMapXml;
    protected String transReduceXml;
    protected String mapInputStepName;
    protected String reduceInputStepName;
    protected String mapOutputStepName;
    protected String reduceOutputStepName;
    protected Class<K2> outClassK;
    protected Class<V2> outClassV;
    protected String id = UUID.randomUUID().toString();
    protected boolean debug = false;
    protected Trans trans;
    protected VariableSpace variableSpace = null;
    protected LogLevel logLevel;
    protected OutputCollectorRowListener<K2, V2> rowCollector;

    public void configure(JobConf job) {
        int lastUnderscoreIndex;
        this.debug = "true".equalsIgnoreCase(job.get("debug"));
        this.transMapXml = job.get("transformation-map-xml");
        this.transReduceXml = job.get("transformation-reduce-xml");
        this.mapInputStepName = job.get("transformation-map-input-stepname");
        this.mapOutputStepName = job.get("transformation-map-output-stepname");
        this.reduceInputStepName = job.get("transformation-reduce-input-stepname");
        this.reduceOutputStepName = job.get("transformation-reduce-output-stepname");
        String xmlVariableSpace = job.get("variableSpace");
        this.outClassK = job.getMapOutputKeyClass();
        this.outClassV = job.getMapOutputValueClass();
        if (!Const.isEmpty((String)xmlVariableSpace)) {
            this.setDebugStatus("PentahoMapRunnable(): variableSpace was retrieved from the job.  The contents: ");
            this.setDebugStatus(xmlVariableSpace);
            XStream xStream = new XStream();
            this.setDebugStatus("PentahoMapRunnable(): Setting classes variableSpace property.: ");
            this.variableSpace = (VariableSpace)xStream.fromXML(xmlVariableSpace);
        } else {
            this.setDebugStatus("PentahoMapRunnable(): The PDI Job's variable space was not sent.");
            this.variableSpace = new Variables();
        }
        this.variableSpace.setVariable("Internal.Hadoop.NumMapTasks", Integer.toString(job.getNumMapTasks()));
        this.variableSpace.setVariable("Internal.Hadoop.NumReduceTasks", Integer.toString(job.getNumReduceTasks()));
        String taskId = job.get("mapred.task.id");
        this.variableSpace.setVariable("Internal.Hadoop.TaskId", taskId);
        String nodeNumber = Const.isEmpty((String)taskId) ? "0" : ((lastUnderscoreIndex = taskId.lastIndexOf("_")) >= 0 ? taskId.substring(lastUnderscoreIndex + 1) : "0");
        this.variableSpace.setVariable("Internal.Hadoop.NodeNumber", Integer.toString(Integer.valueOf(nodeNumber)));
        this.setDebugStatus("Job configuration");
        this.setDebugStatus("Output key class: " + this.outClassK.getName());
        this.setDebugStatus("Output value class: " + this.outClassV.getName());
        String stringLogLevel = job.get("logLevel");
        if (!Const.isEmpty((String)stringLogLevel)) {
            this.logLevel = LogLevel.valueOf((String)stringLogLevel);
            this.setDebugStatus("Log level set to " + stringLogLevel);
        } else {
            System.out.println("Could not retrieve the log level from the job configuration.  logLevel will not be set.");
        }
        this.createTrans((Configuration)job);
    }

    public void injectValue(Object key, ITypeConverter inConverterK, Object value, ITypeConverter inConverterV, RowMeta injectorRowMeta, RowProducer rowProducer, Reporter reporter) throws Exception {
        this.injectValue(key, 0, inConverterK, value, 1, inConverterV, injectorRowMeta, rowProducer, reporter);
    }

    public void injectValue(Object key, int keyOrdinal, ITypeConverter inConverterK, Object value, int valueOrdinal, ITypeConverter inConverterV, RowMeta injectorRowMeta, RowProducer rowProducer, Reporter reporter) throws Exception {
        Object[] row = new Object[injectorRowMeta.size()];
        row[keyOrdinal] = inConverterK != null ? inConverterK.convert(injectorRowMeta.getValueMeta(keyOrdinal), key) : key;
        Object object = row[valueOrdinal] = inConverterV != null ? inConverterV.convert(injectorRowMeta.getValueMeta(valueOrdinal), value) : value;
        if (this.debug) {
            this.setDebugStatus(reporter, "Injecting input record [" + row[keyOrdinal] + "] - [" + row[valueOrdinal] + "]");
        }
        rowProducer.putRow((RowMetaInterface)injectorRowMeta, row);
    }

    protected void createTrans(Configuration conf) {
        try {
            this.setDebugStatus("Creating a transformation for a map.");
            this.trans = MRUtil.getTrans(conf, this.transMapXml, false);
        }
        catch (KettleException ke) {
            throw new RuntimeException("Error loading transformation", ke);
        }
    }

    public String getTransMapXml() {
        return this.transMapXml;
    }

    public void setTransMapXml(String transMapXml) {
        this.transMapXml = transMapXml;
    }

    public String getTransReduceXml() {
        return this.transReduceXml;
    }

    public void setTransReduceXml(String transReduceXml) {
        this.transReduceXml = transReduceXml;
    }

    public String getMapInputStepName() {
        return this.mapInputStepName;
    }

    public void setMapInputStepName(String mapInputStepName) {
        this.mapInputStepName = mapInputStepName;
    }

    public String getMapOutputStepName() {
        return this.mapOutputStepName;
    }

    public void setMapOutputStepName(String mapOutputStepName) {
        this.mapOutputStepName = mapOutputStepName;
    }

    public String getReduceInputStepName() {
        return this.reduceInputStepName;
    }

    public void setReduceInputStepName(String reduceInputStepName) {
        this.reduceInputStepName = reduceInputStepName;
    }

    public String getReduceOutputStepName() {
        return this.reduceOutputStepName;
    }

    public void setReduceOutputStepName(String reduceOutputStepName) {
        this.reduceOutputStepName = reduceOutputStepName;
    }

    public Class<?> getOutClassK() {
        return this.outClassK;
    }

    public void setOutClassK(Class<K2> outClassK) {
        this.outClassK = outClassK;
    }

    public Class<?> getOutClassV() {
        return this.outClassV;
    }

    public void setOutClassV(Class<V2> outClassV) {
        this.outClassV = outClassV;
    }

    public Trans getTrans() {
        return this.trans;
    }

    public void setTrans(Trans trans) {
        this.trans = trans;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Exception getException() {
        return this.rowCollector != null ? this.rowCollector.getException() : null;
    }

    public void setDebugStatus(Reporter reporter, String message) {
        if (this.debug) {
            System.out.println(message);
            reporter.setStatus(message);
        }
    }

    private void setDebugStatus(String message) {
        if (this.debug) {
            System.out.println(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RecordReader<K1, V1> input, OutputCollector<K2, V2> output, Reporter reporter) throws IOException {
        try {
            if (this.trans == null) {
                throw new RuntimeException("Error initializing transformation.  See error log.");
            }
            CentralLogStore.discardLines((String)this.trans.getLogChannelId(), (boolean)true);
            this.trans = MRUtil.recreateTrans(this.trans);
            String logLinePrefix = this.getClass().getName() + ".run: ";
            this.setDebugStatus(logLinePrefix + " The transformation was just recreated.");
            if (this.variableSpace != null) {
                this.setDebugStatus("Sharing the VariableSpace from the PDI job.");
                this.trans.shareVariablesWith(this.variableSpace);
                if (this.debug) {
                    List<String> variables = Arrays.asList(this.trans.listVariables());
                    Collections.sort(variables);
                    if (variables != null) {
                        this.setDebugStatus("Variables: ");
                        for (String variable : variables) {
                            this.setDebugStatus("     " + variable + " = " + this.trans.getVariable(variable));
                        }
                    }
                }
            } else {
                this.setDebugStatus(reporter, "variableSpace is null.  We are not going to share it with the trans.");
            }
            if (this.logLevel != null) {
                this.setDebugStatus("Setting the trans.logLevel to " + this.logLevel.toString());
                this.trans.setLogLevel(this.logLevel);
            } else {
                this.setDebugStatus("logLevel is null.  The trans log level will not be set.");
            }
            Object key = input.createKey();
            Object value = input.createValue();
            this.setDebugStatus(reporter, "Preparing transformation for execution");
            this.trans.prepareExecution(null);
            try {
                this.setDebugStatus(reporter, "Locating output step: " + this.mapOutputStepName);
                StepInterface outputStep = this.trans.findRunThread(this.mapOutputStepName);
                if (outputStep != null) {
                    this.rowCollector = new OutputCollectorRowListener<K2, V2>(output, this.outClassK, this.outClassV, reporter, this.debug);
                    outputStep.addRowListener(this.rowCollector);
                    RowMeta injectorRowMeta = new RowMeta();
                    RowProducer rowProducer = null;
                    TypeConverterFactory typeConverterFactory = new TypeConverterFactory();
                    ITypeConverter<?, ?> inConverterK = null;
                    ITypeConverter<?, ?> inConverterV = null;
                    this.setDebugStatus(reporter, "Locating input step: " + this.mapInputStepName);
                    if (this.mapInputStepName != null) {
                        rowProducer = this.trans.addRowProducer(this.mapInputStepName, 0);
                        StepInterface inputStep = rowProducer.getStepInterface();
                        StepMetaInterface inputStepMeta = inputStep.getStepMeta().getStepMetaInterface();
                        InKeyValueOrdinals inOrdinals = null;
                        if (inputStepMeta instanceof BaseStepMeta) {
                            this.setDebugStatus(reporter, "Generating converters from RowMeta for injection into the mapper transformation");
                            inputStepMeta.getFields((RowMetaInterface)injectorRowMeta, null, null, null, null);
                            inOrdinals = new InKeyValueOrdinals((RowMetaInterface)injectorRowMeta);
                            if (inOrdinals.getKeyOrdinal() < 0 || inOrdinals.getValueOrdinal() < 0) {
                                throw new KettleException("key or value is not defined in transformation injector step");
                            }
                            if (injectorRowMeta.getValueMeta(inOrdinals.getKeyOrdinal()) != null) {
                                inConverterK = typeConverterFactory.getConverter(key.getClass(), injectorRowMeta.getValueMeta(inOrdinals.getKeyOrdinal()));
                            }
                            if (injectorRowMeta.getValueMeta(inOrdinals.getValueOrdinal()) != null) {
                                inConverterV = typeConverterFactory.getConverter(value.getClass(), injectorRowMeta.getValueMeta(inOrdinals.getValueOrdinal()));
                            }
                        }
                        this.trans.startThreads();
                        if (rowProducer != null) {
                            while (input.next(key, value)) {
                                if (inOrdinals != null) {
                                    this.injectValue(key, inOrdinals.getKeyOrdinal(), inConverterK, value, inOrdinals.getValueOrdinal(), inConverterV, injectorRowMeta, rowProducer, reporter);
                                    continue;
                                }
                                this.injectValue(key, inConverterK, value, inConverterV, injectorRowMeta, rowProducer, reporter);
                            }
                            rowProducer.finished();
                        }
                        this.trans.waitUntilFinished();
                        this.setDebugStatus(reporter, "Mapper transformation has finished");
                        if (this.trans.getErrors() > 0) {
                            this.setDebugStatus("Errors detected for mapper transformation");
                            List logList = CentralLogStore.getLogBufferFromTo((String)this.trans.getLogChannelId(), (boolean)false, (int)0, (int)CentralLogStore.getLastBufferLineNr());
                            StringBuffer buff = new StringBuffer();
                            for (LoggingEvent le : logList) {
                                if (le.getLevel() != Level.ERROR) continue;
                                buff.append(le.getMessage().toString()).append("\n");
                            }
                            throw new Exception("Errors were detected for mapper transformation:\n\n" + buff.toString());
                        }
                    } else {
                        this.setDebugStatus(reporter, "No input stepname was defined");
                    }
                    if (this.getException() != null) {
                        this.setDebugStatus(reporter, "An exception was generated by the mapper transformation");
                        throw this.getException();
                    }
                } else {
                    if (this.mapOutputStepName != null) {
                        this.setDebugStatus(reporter, "Output step [" + this.mapOutputStepName + "]could not be found");
                        throw new KettleException("Output step not defined in transformation");
                    }
                    this.setDebugStatus(reporter, "Output step name not specified");
                }
            }
            finally {
                try {
                    this.trans.stopAll();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                try {
                    this.trans.cleanup();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.setDebugStatus(reporter, "An exception was generated by the mapper task");
            throw new IOException(e);
        }
        reporter.setStatus("Completed processing record");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Counter {
        INPUT_RECORDS,
        OUTPUT_RECORDS,
        OUT_RECORD_WITH_NULL_KEY,
        OUT_RECORD_WITH_NULL_VALUE;

    }
}

