/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.pmd;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.reporting.engine.classic.core.wizard.ConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.types.AggregationConceptMapper;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.types.AlignmentConceptMapper;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.types.BooleanConceptMapper;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.types.ColorConceptMapper;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.types.ColumnWidthConceptMapper;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.types.DataTypeConceptMapper;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.types.DateConceptMapper;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.types.FieldTypeConceptMapper;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.types.FontSettingsConceptMapper;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.types.LocalizedStringConceptMapper;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.types.NumberConceptMapper;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.types.StringConceptMapper;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.types.TableTypeConceptMapper;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.types.URLConceptMapper;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class PentahoMetaDataAttributes
implements DataAttributes {
    private static final String[] NAMESPACES = new String[]{"http://reporting.pentaho.org/namespaces/engine/meta-attributes/pentaho-meta-data"};
    private DataAttributes backend;
    private IConcept concept;
    private ArrayList<ConceptQueryMapper> conceptMappers;
    private LinkedHashMap<String, Object> properties;

    public PentahoMetaDataAttributes(DataAttributes backend, IConcept concept) {
        if (concept == null) {
            throw new NullPointerException();
        }
        if (backend == null) {
            throw new NullPointerException();
        }
        this.concept = concept;
        this.properties = new LinkedHashMap(concept.getProperties());
        this.backend = backend;
        this.conceptMappers = new ArrayList();
        this.conceptMappers.add(new AggregationConceptMapper());
        this.conceptMappers.add(new AlignmentConceptMapper());
        this.conceptMappers.add(new BooleanConceptMapper());
        this.conceptMappers.add(new ColorConceptMapper());
        this.conceptMappers.add(new ColumnWidthConceptMapper());
        this.conceptMappers.add(new DataTypeConceptMapper());
        this.conceptMappers.add(new DateConceptMapper());
        this.conceptMappers.add(new FieldTypeConceptMapper());
        this.conceptMappers.add(new FontSettingsConceptMapper());
        this.conceptMappers.add(new NumberConceptMapper());
        this.conceptMappers.add(new LocalizedStringConceptMapper());
        this.conceptMappers.add(new TableTypeConceptMapper());
        this.conceptMappers.add(new URLConceptMapper());
        this.conceptMappers.add(new StringConceptMapper());
    }

    public String[] getMetaAttributeDomains() {
        String[] backendDomains = this.backend.getMetaAttributeDomains();
        return StringUtils.merge((String[])NAMESPACES, (String[])backendDomains);
    }

    public String[] getMetaAttributeNames(String domainName) {
        if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/pentaho-meta-data".equals(domainName)) {
            return this.properties.keySet().toArray(new String[this.properties.size()]);
        }
        return this.backend.getMetaAttributeNames(domainName);
    }

    public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context) {
        return this.getMetaAttribute(domain, name, type, context, null);
    }

    public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context, Object defaultValue) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/pentaho-meta-data".equals(domain)) {
            Object value = this.concept.getProperty(name);
            if (value == null) {
                return defaultValue;
            }
            return this.convertFromPmd(value, type, defaultValue, context);
        }
        return this.backend.getMetaAttribute(domain, name, type, context, defaultValue);
    }

    private Object convertFromPmd(Object attribute, Class type, Object defaultValue, DataAttributeContext context) {
        if (attribute == null) {
            return defaultValue;
        }
        if (type == null) {
            return attribute;
        }
        if (type.isInstance(attribute)) {
            return attribute;
        }
        for (int i = 0; i < this.conceptMappers.size(); ++i) {
            ConceptQueryMapper conceptMapper = this.conceptMappers.get(i);
            Object value = conceptMapper.getValue(attribute, type, context);
            if (value == null) continue;
            return value;
        }
        return defaultValue;
    }

    public ConceptQueryMapper getMetaAttributeMapper(String domain, String name) {
        if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/pentaho-meta-data".equals(domain)) {
            Object value = this.properties.get(name);
            if (value == null) {
                return DefaultConceptQueryMapper.INSTANCE;
            }
            DefaultDataAttributeContext context = new DefaultDataAttributeContext();
            for (int i = 0; i < this.conceptMappers.size(); ++i) {
                ConceptQueryMapper conceptMapper = this.conceptMappers.get(i);
                Object ivalue = conceptMapper.getValue(value, null, (DataAttributeContext)context);
                if (ivalue == null) continue;
                return conceptMapper;
            }
        }
        return DefaultConceptQueryMapper.INSTANCE;
    }

    public Object clone() throws CloneNotSupportedException {
        PentahoMetaDataAttributes attributes = (PentahoMetaDataAttributes)super.clone();
        attributes.backend = (DataAttributes)this.backend.clone();
        attributes.concept = (IConcept)this.concept.clone();
        attributes.properties = (LinkedHashMap)this.properties.clone();
        attributes.conceptMappers = (ArrayList)this.conceptMappers.clone();
        return attributes;
    }
}

