/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.pmd;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import javax.swing.table.TableModel;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.metadata.repository.InMemoryMetadataDomainRepository;
import org.pentaho.metadata.util.XmiParser;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.DriverConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.JndiConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.IPmdConnectionProvider;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class PmdConnectionProvider
implements IPmdConnectionProvider {
    protected InputStream createStream(ResourceManager manager, ResourceKey contextKey, String xmiFile) throws ResourceException {
        if (contextKey != null) {
            try {
                ResourceKey resourceKey = manager.deriveKey(contextKey, xmiFile);
                ResourceData data = manager.load(resourceKey);
                return data.getResourceAsStream(manager);
            }
            catch (ResourceException re) {
                // empty catch block
            }
        }
        ResourceKey resourceKey = manager.createKey((Object)new File(xmiFile));
        ResourceData data = manager.load(resourceKey);
        return data.getResourceAsStream(manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMetadataDomainRepository getMetadataDomainRepository(String domainId, ResourceManager resourceManager, ResourceKey contextKey, String xmiFile) throws ReportDataFactoryException {
        InMemoryMetadataDomainRepository inMemoryMetadataDomainRepository;
        InputStream stream = this.createStream(resourceManager, contextKey, xmiFile);
        try {
            InMemoryMetadataDomainRepository repo = new InMemoryMetadataDomainRepository();
            XmiParser parser = new XmiParser();
            Domain domain = parser.parseXmi(stream);
            domain.setId(domainId);
            repo.storeDomain(domain, true);
            inMemoryMetadataDomainRepository = repo;
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new ReportDataFactoryException("The Specified XMI File is invalid: " + xmiFile, (Throwable)e);
            }
        }
        stream.close();
        return inMemoryMetadataDomainRepository;
    }

    public Connection createConnection(DatabaseMeta databaseMeta, String username, String password) throws ReportDataFactoryException {
        String jndiName;
        String realPassword;
        String realUser = StringUtils.isEmpty((String)databaseMeta.getUsername()) ? username : databaseMeta.getUsername();
        String string = realPassword = StringUtils.isEmpty((String)databaseMeta.getPassword()) ? password : databaseMeta.getPassword();
        if (databaseMeta.getAccessType() == 4 && (jndiName = databaseMeta.getDatabaseName()) != null) {
            JndiConnectionProvider connectionProvider = new JndiConnectionProvider();
            connectionProvider.setConnectionPath(jndiName);
            try {
                return connectionProvider.createConnection(realUser, realPassword);
            }
            catch (SQLException e) {
                throw new ReportDataFactoryException("JNDI dataconnection was requested, but no connection could be established", (Throwable)e);
            }
        }
        try {
            String connectionInfo = databaseMeta.getURL();
            if (connectionInfo == null) {
                throw new ReportDataFactoryException("Unable to create a connection: DatabaseMeta does not contain any driver or connection info");
            }
            String code = databaseMeta.getPluginId();
            Map map = databaseMeta.getExtraOptions();
            Iterator entryIterator = map.entrySet().iterator();
            DriverConnectionProvider driverProvider = new DriverConnectionProvider();
            driverProvider.setDriver(databaseMeta.getDriverClass());
            driverProvider.setUrl(connectionInfo);
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                String key = (String)entry.getKey();
                String realKey = key.substring(code.length() + 1);
                String value = (String)entry.getValue();
                if ("><EMPTY><".equals(value)) {
                    driverProvider.setProperty(realKey, "");
                    continue;
                }
                driverProvider.setProperty(realKey, value);
            }
            return driverProvider.createConnection(realUser, realPassword);
        }
        catch (Exception e) {
            throw new ReportDataFactoryException("Unable to create a connection", (Throwable)e);
        }
    }

    public TableModel executeQuery(Query query, DataRow parameters) throws ReportDataFactoryException {
        throw new UnsupportedOperationException("The default PmdConnectionProvider does not yet implement alternative physical model execution engines.");
    }
}

