/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.pmd;

import java.util.List;
import java.util.TreeSet;
import javax.swing.event.TableModelListener;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.query.model.Selection;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PentahoMetaDataAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdMetaTableModel
implements MetaTableModel,
CloseableTableModel {
    private MetaTableModel parentTableModel;
    private Selection[] selections;
    private String[] columnNames;

    public PmdMetaTableModel(MetaTableModel parentTableModel, List<Selection> selections) {
        if (parentTableModel == null) {
            throw new NullPointerException();
        }
        if (selections == null) {
            throw new NullPointerException();
        }
        this.parentTableModel = parentTableModel;
        this.selections = new Selection[selections.size()];
        this.columnNames = new String[selections.size()];
        TreeSet<String> uniqueIds = new TreeSet<String>();
        for (int i = 0; i < this.selections.length; ++i) {
            this.selections[i] = selections.get(i);
            String columnName = this.selections[i].getLogicalColumn().getId();
            if (uniqueIds.contains(columnName)) {
                columnName = columnName + (this.selections[i].getAggregationType() != null ? ":" + this.selections[i].getAggregationType().toString() : "");
            }
            uniqueIds.add(columnName);
            this.columnNames[i] = columnName;
        }
    }

    public DataAttributes getCellDataAttributes(int row, int column) {
        return new PentahoMetaDataAttributes(this.parentTableModel.getCellDataAttributes(row, column), (IConcept)this.selections[column].getLogicalColumn());
    }

    public boolean isCellDataAttributesSupported() {
        return this.parentTableModel.isCellDataAttributesSupported();
    }

    public DataAttributes getColumnAttributes(int column) {
        return new PentahoMetaDataAttributes(this.parentTableModel.getColumnAttributes(column), (IConcept)this.selections[column].getLogicalColumn());
    }

    public DataAttributes getTableAttributes() {
        return this.parentTableModel.getTableAttributes();
    }

    public int getRowCount() {
        return this.parentTableModel.getRowCount();
    }

    public int getColumnCount() {
        return this.parentTableModel.getColumnCount();
    }

    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        return this.parentTableModel.getColumnClass(columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.parentTableModel.getValueAt(rowIndex, columnIndex);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void addTableModelListener(TableModelListener l) {
        this.parentTableModel.addTableModelListener(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.parentTableModel.removeTableModelListener(l);
    }

    public void close() {
        if (this.parentTableModel instanceof CloseableTableModel) {
            CloseableTableModel closeableTableModel = (CloseableTableModel)this.parentTableModel;
            closeableTableModel.close();
        }
    }
}

