/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.pmd.parser;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.DataFactoryReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.QueryDefinitionReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.QueryDefinitionsReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PmdDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.parser.IPmdConfigReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.parser.PmdConfigReadHandlerFactory;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.PropertyReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PmdDataSourceReadHandler
extends AbstractXmlReadHandler
implements DataFactoryReadHandler {
    private IPmdConfigReadHandler configReadHandler;
    private ArrayList<PropertyReadHandler> queries = new ArrayList();
    private QueryDefinitionsReadHandler queryDefinitionsReadHandler;
    private PmdDataFactory dataFactory;
    private PropertyReadHandler globalScriptReadHandler;

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        PmdConfigReadHandlerFactory configfactory = PmdConfigReadHandlerFactory.getInstance();
        XmlReadHandler confighandler = configfactory.getHandler(uri, tagName);
        if (confighandler instanceof IPmdConfigReadHandler) {
            this.configReadHandler = (IPmdConfigReadHandler)confighandler;
            return confighandler;
        }
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("global-script".equals(tagName)) {
            this.globalScriptReadHandler = new PropertyReadHandler("language", true);
            return this.globalScriptReadHandler;
        }
        if ("query".equals(tagName)) {
            PropertyReadHandler queryReadHandler = new PropertyReadHandler();
            this.queries.add(queryReadHandler);
            return queryReadHandler;
        }
        if ("query-definitions".equals(tagName)) {
            this.queryDefinitionsReadHandler = new QueryDefinitionsReadHandler();
            return this.queryDefinitionsReadHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        PmdDataFactory pmddf = new PmdDataFactory();
        pmddf.setConnectionProvider(this.configReadHandler.getConnectionProvider());
        pmddf.setDomainId(this.configReadHandler.getDomain());
        pmddf.setXmiFile(this.configReadHandler.getXmiFile());
        if (this.configReadHandler != null) {
            pmddf.setLabelMapping(this.configReadHandler.isLabelMapping());
        }
        if (this.globalScriptReadHandler != null) {
            pmddf.setGlobalScript(this.globalScriptReadHandler.getResult());
            pmddf.setGlobalScriptLanguage(this.globalScriptReadHandler.getName());
        }
        for (int i = 0; i < this.queries.size(); ++i) {
            PropertyReadHandler handler = this.queries.get(i);
            pmddf.setQuery(handler.getName(), handler.getResult(), null, null);
        }
        if (this.queryDefinitionsReadHandler != null) {
            ArrayList scriptedQueries = this.queryDefinitionsReadHandler.getScriptedQueries();
            for (QueryDefinitionReadHandler scriptedQuery : scriptedQueries) {
                pmddf.setQuery(scriptedQuery.getName(), scriptedQuery.getQuery(), scriptedQuery.getScriptLanguage(), scriptedQuery.getScript());
            }
        }
        this.dataFactory = pmddf;
    }

    public Object getObject() throws SAXException {
        return this.dataFactory;
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }
}

