/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.pmd.writer;

import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.DataFactoryWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PmdDataFactory;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class PmdDataFactoryWriteHandler
implements DataFactoryWriteHandler {
    public void write(ReportWriterContext reportWriter, XmlWriter xmlWriter, DataFactory dataFactory) throws IOException, ReportWriterException {
        PmdDataFactory df = (PmdDataFactory)dataFactory;
        AttributeList rootAttrs = new AttributeList();
        rootAttrs.addNamespaceDeclaration("data", "http://reporting.pentaho.org/namespaces/datasources/pmd");
        xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/pmd", "pmd-datasource", rootAttrs, false);
        AttributeList configAttrs = new AttributeList();
        configAttrs.setAttribute("http://reporting.pentaho.org/namespaces/datasources/pmd", "label-mapping", String.valueOf(df.isLabelMapping()));
        configAttrs.setAttribute("http://reporting.pentaho.org/namespaces/datasources/pmd", "domain", String.valueOf(df.getDomainId()));
        configAttrs.setAttribute("http://reporting.pentaho.org/namespaces/datasources/pmd", "xmi-file", String.valueOf(df.getXmiFile()));
        xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/pmd", "config", configAttrs, true);
        String globalScript = df.getGlobalScript();
        String globalScriptLanguage = df.getGlobalScriptLanguage();
        if (!StringUtils.isEmpty((String)globalScript) && !StringUtils.isEmpty((String)globalScriptLanguage)) {
            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/pmd", "global-script", "language", globalScriptLanguage, false);
            xmlWriter.writeTextNormalized(globalScript, false);
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/pmd", "query-definitions", false);
        String[] queryNames = df.getQueryNames();
        for (int i = 0; i < queryNames.length; ++i) {
            String queryName = queryNames[i];
            String query = df.getQuery(queryName);
            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/pmd", "query", "name", queryName, false);
            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/pmd", "static-query", false);
            xmlWriter.writeTextNormalized(query, false);
            xmlWriter.writeCloseTag();
            String queryScriptLanguage = df.getScriptingLanguage(queryName);
            String queryScript = df.getScript(queryName);
            if (!(StringUtils.isEmpty((String)queryScript) || StringUtils.isEmpty((String)queryScriptLanguage) && StringUtils.isEmpty((String)globalScriptLanguage))) {
                if (StringUtils.isEmpty((String)queryScriptLanguage)) {
                    xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/pmd", "script", false);
                } else {
                    xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/pmd", "script", "language", queryScriptLanguage, false);
                }
                xmlWriter.writeTextNormalized(queryScript, false);
                xmlWriter.writeCloseTag();
            }
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeCloseTag();
        xmlWriter.writeCloseTag();
    }
}

