/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom;

import org.dom4j.Document;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionSequenceDocument;
import org.pentaho.actionsequence.dom.IAbstractIOElement;
import org.pentaho.actionsequence.dom.IActionSequenceDocument;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;
import org.pentaho.actionsequence.dom.messages.Messages;

public abstract class AbstractIOElement
implements IAbstractIOElement {
    Element ioElement;
    IActionParameterMgr actionInputProvider;

    protected AbstractIOElement(Element ioElement, IActionParameterMgr actionInputProvider) {
        this.ioElement = ioElement;
        this.actionInputProvider = actionInputProvider;
    }

    public String getName() {
        return this.ioElement.getName();
    }

    public void setName(String ioName) {
        if ((ioName = ioName.trim()).split("\\s+").length > 1) {
            throw new IllegalArgumentException(Messages.getString("ActionSequenceIO.NO_SPACES_IN_NAME"));
        }
        if (!this.ioElement.getName().equals(ioName)) {
            this.ioElement.setName(ioName);
            ActionSequenceDocument.fireIoRenamed(this);
        }
    }

    public String getType() {
        return this.ioElement.attributeValue("type");
    }

    public void setType(String ioType) {
        if (!ioType.equals(this.ioElement.attributeValue("type"))) {
            this.ioElement.addAttribute("type", ioType);
            ActionSequenceDocument.fireIoChanged(this);
        }
    }

    public void delete() {
        Document doc = this.ioElement.getDocument();
        if (doc != null) {
            this.ioElement.detach();
            ActionSequenceDocument.fireIoRemoved(new ActionSequenceDocument(doc, this.actionInputProvider), this);
        }
    }

    public Element getElement() {
        return this.ioElement;
    }

    public boolean equals(Object arg0) {
        boolean result = false;
        if (arg0 != null && arg0.getClass() == this.getClass()) {
            AbstractIOElement io = (AbstractIOElement)arg0;
            result = io.ioElement != null ? io.ioElement.equals(this.ioElement) : io == this;
        }
        return result;
    }

    public IActionSequenceDocument getDocument() {
        ActionSequenceDocument doc = null;
        if (this.ioElement != null && this.ioElement.getDocument() != null) {
            doc = new ActionSequenceDocument(this.ioElement.getDocument(), this.actionInputProvider);
        }
        return doc;
    }

    public IActionParameterMgr getParameterMgr() {
        return this.actionInputProvider;
    }
}

