/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.pentaho.actionsequence.dom.ActionIfStatement;
import org.pentaho.actionsequence.dom.ActionLoop;
import org.pentaho.actionsequence.dom.ActionSequenceDocument;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionControlStatement;
import org.pentaho.actionsequence.dom.IActionDefinition;
import org.pentaho.actionsequence.dom.IActionIfStatement;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionLoop;
import org.pentaho.actionsequence.dom.IActionSequenceDocument;
import org.pentaho.actionsequence.dom.IActionSequenceExecutableStatement;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.ActionFactory;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public abstract class ActionControlStatement
implements IActionControlStatement {
    Element controlElement;
    IActionParameterMgr actionInputProvider;

    public ActionControlStatement(Element controlElement, IActionParameterMgr actionInputProvider) {
        this.controlElement = controlElement;
        this.actionInputProvider = actionInputProvider;
    }

    public Element getElement() {
        return this.controlElement;
    }

    public Element getControlElement() {
        return this.controlElement;
    }

    public IActionDefinition addAction(Class actionDefinitionClass) {
        ActionDefinition action = null;
        try {
            action = (ActionDefinition)actionDefinitionClass.newInstance();
            this.controlElement.elements().add(action.getElement());
            ActionSequenceDocument.fireActionAdded(action);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return action;
    }

    public IActionDefinition addAction(Class actionDefClass, int index) {
        IActionDefinition actionDef = null;
        try {
            IActionSequenceExecutableStatement[] children = this.getChildren();
            if (index >= children.length) {
                actionDef = this.addAction(actionDefClass);
            } else {
                IActionSequenceExecutableStatement childAtIndex = children[index];
                Element childElement = childAtIndex instanceof ActionControlStatement ? ((ActionControlStatement)childAtIndex).controlElement : ((ActionDefinition)childAtIndex).getElement();
                List childElements = this.controlElement.elements();
                index = childElements.indexOf(childElement);
                if (index >= 0) {
                    actionDef = (ActionDefinition)actionDefClass.newInstance();
                    childElements.add(index, actionDef.getElement());
                    ActionSequenceDocument.fireActionAdded(actionDef);
                } else {
                    actionDef = this.addAction(actionDefClass);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actionDef;
    }

    public IActionSequenceExecutableStatement[] getChildren() {
        List allChildren = this.controlElement.elements();
        ArrayList<IActionSequenceExecutableStatement> filteredChildren = new ArrayList<IActionSequenceExecutableStatement>();
        for (Element element : allChildren) {
            String elementName = element.getName();
            if (elementName.equals("action-definition")) {
                filteredChildren.add(ActionFactory.getActionDefinition(element, this.actionInputProvider));
                continue;
            }
            if (!elementName.equals("actions")) continue;
            if (element.element("condition") == null) {
                filteredChildren.add(new ActionLoop(element, this.actionInputProvider));
                continue;
            }
            filteredChildren.add(new ActionIfStatement(element, this.actionInputProvider));
        }
        return filteredChildren.toArray(new IActionSequenceExecutableStatement[0]);
    }

    public IActionSequenceDocument getDocument() {
        ActionSequenceDocument doc = null;
        if (this.controlElement != null && this.controlElement.getDocument() != null) {
            doc = new ActionSequenceDocument(this.controlElement.getDocument(), this.actionInputProvider);
        }
        return doc;
    }

    public void delete() {
        Document doc = this.controlElement.getDocument();
        if (doc != null) {
            this.controlElement.detach();
            ActionSequenceDocument.fireControlStatementRemoved(new ActionSequenceDocument(doc, this.actionInputProvider), this);
        }
    }

    public IActionControlStatement getParent() {
        Element ancestorElement;
        ActionControlStatement controlStatement = null;
        if (this.controlElement != null && (ancestorElement = this.controlElement.getParent()) != null && ancestorElement.getName().equals("actions") && !ancestorElement.getPath().equals("/action-sequence/actions")) {
            controlStatement = ancestorElement.element("condition") == null ? new ActionLoop(ancestorElement, this.actionInputProvider) : new ActionIfStatement(ancestorElement, this.actionInputProvider);
        }
        return controlStatement;
    }

    public void add(IActionDefinition actionDef) {
        actionDef.delete();
        this.controlElement.elements().add(actionDef.getElement());
        ActionSequenceDocument.fireActionAdded(actionDef);
    }

    public void add(IActionDefinition actionDef, int index) {
        IActionSequenceExecutableStatement[] children = this.getChildren();
        if (index >= children.length) {
            this.add(actionDef);
        } else {
            Element childElement = children[index].getElement();
            List childElements = this.controlElement.elements();
            index = childElements.indexOf(childElement);
            int actionDefIndex = childElements.indexOf(actionDef.getElement());
            if (index >= 0) {
                actionDef.delete();
                if (actionDefIndex >= 0 && actionDefIndex < index) {
                    --index;
                }
                this.controlElement.elements().add(index, actionDef.getElement());
                ActionSequenceDocument.fireActionAdded(actionDef);
            } else {
                this.add(actionDef);
            }
        }
    }

    public void add(IActionControlStatement controlStatement) {
        controlStatement.delete();
        this.controlElement.elements().add(controlStatement.getControlElement());
        ActionSequenceDocument.fireControlStatementAdded(controlStatement);
    }

    public void add(IActionControlStatement controlStatement, int index) {
        IActionSequenceExecutableStatement[] children = this.getChildren();
        if (index >= children.length) {
            this.add(controlStatement);
        } else {
            Element childElement = children[index].getElement();
            List childElements = this.controlElement.elements();
            index = childElements.indexOf(childElement);
            int actionLoopIndex = childElements.indexOf(controlStatement.getElement());
            if (index >= 0) {
                controlStatement.delete();
                if (actionLoopIndex >= 0 && actionLoopIndex < index) {
                    --index;
                }
                this.controlElement.elements().add(index, controlStatement.getControlElement());
                ActionSequenceDocument.fireControlStatementAdded(controlStatement);
            } else {
                this.add(controlStatement);
            }
        }
    }

    public IActionLoop addLoop(String loopOn) {
        Element child = this.createLoopElement();
        this.controlElement.elements().add(child);
        ActionLoop loop = new ActionLoop(child, this.actionInputProvider);
        ActionSequenceDocument.fireControlStatementAdded(loop);
        return loop;
    }

    public IActionLoop addLoop(String loopOn, int index) {
        IActionSequenceExecutableStatement[] children = this.getChildren();
        IActionLoop actionLoop = null;
        if (index >= children.length) {
            actionLoop = this.addLoop(loopOn);
        } else {
            IActionSequenceExecutableStatement childAtIndex = children[index];
            Element childElement = childAtIndex instanceof ActionControlStatement ? ((ActionControlStatement)childAtIndex).controlElement : ((ActionDefinition)childAtIndex).getElement();
            List childElements = this.controlElement.elements();
            index = childElements.indexOf(childElement);
            if (index >= 0) {
                Element child = this.createLoopElement();
                childElements.add(index, child);
                actionLoop = new ActionLoop(child, this.actionInputProvider);
                ActionSequenceDocument.fireControlStatementAdded(actionLoop);
            } else {
                actionLoop = this.addLoop(loopOn);
            }
        }
        return actionLoop;
    }

    public IActionIfStatement addIf(String condition) {
        Element child = this.createIfElement();
        this.controlElement.elements().add(child);
        ActionIfStatement actionIf = new ActionIfStatement(child, this.actionInputProvider);
        ActionSequenceDocument.fireControlStatementAdded(actionIf);
        return actionIf;
    }

    public IActionIfStatement addIf(String condition, int index) {
        IActionSequenceExecutableStatement[] children = this.getChildren();
        IActionIfStatement actionIf = null;
        if (index >= children.length) {
            actionIf = this.addIf(condition);
        } else {
            IActionSequenceExecutableStatement childAtIndex = children[index];
            Element childElement = childAtIndex instanceof ActionControlStatement ? ((ActionControlStatement)childAtIndex).controlElement : ((ActionDefinition)childAtIndex).getElement();
            List childElements = this.controlElement.elements();
            index = childElements.indexOf(childElement);
            if (index >= 0) {
                Element child = this.createIfElement();
                childElements.add(index, child);
                actionIf = new ActionIfStatement(child, this.actionInputProvider);
                ActionSequenceDocument.fireControlStatementAdded(actionIf);
            } else {
                actionIf = this.addIf(condition);
            }
        }
        return actionIf;
    }

    private Element createLoopElement() {
        DefaultElement element = null;
        element = new DefaultElement("actions");
        return element;
    }

    private Element createIfElement() {
        DefaultElement element = null;
        element = new DefaultElement("actions");
        element.addElement("condition");
        return element;
    }

    public IActionInputVariable[] getAvailInputVariables() {
        return this.getDocument().getAvailInputVariables(this);
    }

    public boolean equals(Object arg0) {
        boolean result = false;
        if (arg0 != null && arg0.getClass() == this.getClass()) {
            ActionControlStatement controlStatement = (ActionControlStatement)arg0;
            result = controlStatement.controlElement != null ? controlStatement.controlElement.equals(this.controlElement) : controlStatement == this;
        }
        return result;
    }

    public IActionDefinition[] getPrecedingActionDefinitions() {
        return this.getDocument().getPrecedingActionDefinitions(this);
    }

    public IActionSequenceExecutableStatement[] getPrecedingExecutableStatements() {
        return this.getDocument().getPrecedingExecutables(this);
    }

    protected abstract IActionSequenceValidationError[] validateThis();

    public IActionSequenceValidationError[] validate() {
        return this.validate(false);
    }

    public IActionSequenceValidationError[] validate(boolean validateDescendants) {
        ArrayList<Object> errors = new ArrayList<Object>();
        errors.add(this.validateThis());
        if (validateDescendants) {
            IActionSequenceExecutableStatement[] children = this.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (children[i] instanceof ActionDefinition) {
                    ActionDefinition actionDefinition = (ActionDefinition)children[i];
                    errors.addAll(Arrays.asList(actionDefinition.validate()));
                    continue;
                }
                if (!(children[i] instanceof ActionControlStatement)) continue;
                ActionControlStatement actionControlStatement = (ActionControlStatement)children[i];
                errors.addAll(Arrays.asList(actionControlStatement.validate(true)));
            }
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }
}

