/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.AbstractActionIOElement;
import org.pentaho.actionsequence.dom.ActionSequenceDocument;
import org.pentaho.actionsequence.dom.IActionDefinition;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.IActionSequenceDocument;
import org.pentaho.actionsequence.dom.IActionSequenceResource;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.ActionFactory;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;
import org.pentaho.commons.connection.IPentahoStreamSource;

public class ActionResource
extends AbstractActionIOElement
implements IActionResource {
    public ActionResource(Element resourceElement, IActionParameterMgr actionInputProvider) {
        super(resourceElement, actionInputProvider);
        this.ioElement = resourceElement;
    }

    public String getName() {
        return this.ioElement.getName();
    }

    public void setName(String resourceName) {
        if (!this.ioElement.getName().equals(resourceName)) {
            this.ioElement.setName(resourceName);
            ActionSequenceDocument.fireResourceRenamed(this);
        }
    }

    public String getMapping() {
        String name = "";
        Attribute attr = this.ioElement.attribute("mapping");
        if (attr != null && (name = attr.getValue().trim()).equals(this.getName())) {
            name = "";
        }
        return name;
    }

    public void setMapping(String mapping) {
        if (mapping == null || mapping.trim().length() == 0 || mapping.trim().equals(this.getName())) {
            if (this.ioElement.attribute("mapping") != null) {
                this.ioElement.addAttribute("mapping", null);
                ActionSequenceDocument.fireResourceChanged(this);
            }
        } else if (!(mapping = mapping.trim()).equals(this.ioElement.attributeValue("mapping"))) {
            this.ioElement.addAttribute("mapping", mapping);
            ActionSequenceDocument.fireResourceChanged(this);
        }
    }

    public void delete() {
        Document doc = this.ioElement.getDocument();
        if (doc != null) {
            this.ioElement.detach();
            ActionSequenceDocument.fireResourceRemoved(new ActionSequenceDocument(doc, this.actionInputProvider), this);
        }
    }

    public boolean equals(Object arg0) {
        boolean result = false;
        if (arg0 != null && arg0.getClass() == this.getClass()) {
            ActionResource resource = (ActionResource)arg0;
            result = resource.ioElement != null ? resource.ioElement.equals(this.ioElement) : resource == this;
        }
        return result;
    }

    public Element getElement() {
        return this.ioElement;
    }

    public IActionSequenceDocument getDocument() {
        ActionSequenceDocument doc = null;
        if (this.ioElement != null && this.ioElement.getDocument() != null) {
            doc = new ActionSequenceDocument(this.ioElement.getDocument(), this.actionInputProvider);
        }
        return doc;
    }

    public String getPublicName() {
        String mapping = this.ioElement.attributeValue("mapping");
        return mapping != null && mapping.trim().length() > 0 ? mapping.trim() : this.ioElement.getName();
    }

    public IActionDefinition getActionDefinition() {
        Element ancestorElement;
        ActionDefinition actionDefinition = null;
        if (this.ioElement != null && (ancestorElement = this.ioElement.getParent()) != null && (ancestorElement = ancestorElement.getParent()) != null && ancestorElement.getName().equals("action-definition")) {
            actionDefinition = ActionFactory.getActionDefinition(ancestorElement, this.actionInputProvider);
        }
        return actionDefinition;
    }

    public String getType() {
        return null;
    }

    public void setType(String ioType) {
        throw new UnsupportedOperationException();
    }

    public URI getUri() {
        URI uri = null;
        IActionSequenceResource actionSequenceResource = this.getDocument().getResource(this.getPublicName());
        if (actionSequenceResource != null) {
            uri = actionSequenceResource.getUri();
        }
        return uri;
    }

    public String getMimeType() {
        String mimeType = null;
        IActionSequenceResource actionSequenceResource = this.getDocument().getResource(this.getPublicName());
        if (actionSequenceResource != null) {
            mimeType = actionSequenceResource.getMimeType();
        }
        return mimeType;
    }

    public void setURI(URI uri) {
        String logicalName = this.getPublicName();
        IActionSequenceResource actionSequenceResource = this.getDocument().getResource(logicalName);
        if (uri == null) {
            IActionSequenceDocument document = this.getDocument();
            this.delete();
            if (actionSequenceResource != null && document.getReferencesTo(actionSequenceResource).length == 0) {
                document.setResourceUri(logicalName, null, null);
            }
        } else if (actionSequenceResource == null) {
            this.getDocument().setResourceUri(logicalName, uri, "text/plain");
        } else {
            String mimeType = actionSequenceResource.getMimeType();
            IActionResource[] actionResources = this.getDocument().getReferencesTo(actionSequenceResource);
            if (actionResources.length == 1 && actionResources[0].equals(this)) {
                this.getDocument().setResourceUri(logicalName, uri, mimeType);
            } else {
                logicalName = this.createLogicalName(this.getName());
                this.setMapping(logicalName);
                this.getDocument().setResourceUri(logicalName, uri, mimeType);
            }
        }
    }

    public void setMimeType(String mimeType) {
        String logicalName = this.getPublicName();
        IActionSequenceResource actionSequenceResource = this.getDocument().getResource(logicalName);
        if (actionSequenceResource != null) {
            IActionResource[] actionResources = this.getDocument().getReferencesTo(actionSequenceResource);
            if (actionResources.length == 1 && actionResources[0].equals(this)) {
                this.getDocument().setResourceUri(logicalName, actionSequenceResource.getUri(), mimeType);
            } else {
                logicalName = this.createLogicalName(this.getName());
                this.setMapping(logicalName);
                this.getDocument().setResourceUri(logicalName, actionSequenceResource.getUri(), mimeType);
            }
        }
    }

    private String createLogicalName(String resourceName) {
        String logicalName = resourceName;
        int index = 1;
        while (this.getDocument().getResource(logicalName) != null) {
            logicalName = resourceName + index;
            ++index;
        }
        return logicalName;
    }

    public IPentahoStreamSource getDataSource() throws FileNotFoundException {
        IPentahoStreamSource dataSource = null;
        if (this.actionInputProvider != null) {
            dataSource = this.actionInputProvider.getDataSource(this);
        }
        return dataSource;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        InputStream inputStream = null;
        if (this.actionInputProvider != null) {
            inputStream = this.actionInputProvider.getInputStream(this);
        }
        return inputStream;
    }

    public String getStringValue() throws IOException {
        String stringValue = null;
        if (this.actionInputProvider != null) {
            stringValue = this.actionInputProvider.getString(this);
        }
        return stringValue;
    }
}

