/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.pentaho.actionsequence.dom.ActionControlStatement;
import org.pentaho.actionsequence.dom.ActionIfStatement;
import org.pentaho.actionsequence.dom.ActionInput;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.ActionLoop;
import org.pentaho.actionsequence.dom.ActionOutput;
import org.pentaho.actionsequence.dom.ActionResource;
import org.pentaho.actionsequence.dom.ActionSequenceInput;
import org.pentaho.actionsequence.dom.ActionSequenceOutput;
import org.pentaho.actionsequence.dom.ActionSequenceResource;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IAbstractIOElement;
import org.pentaho.actionsequence.dom.IActionControlStatement;
import org.pentaho.actionsequence.dom.IActionDefinition;
import org.pentaho.actionsequence.dom.IActionIfStatement;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionLoop;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.IActionSequenceDocument;
import org.pentaho.actionsequence.dom.IActionSequenceDocumentListener;
import org.pentaho.actionsequence.dom.IActionSequenceElement;
import org.pentaho.actionsequence.dom.IActionSequenceExecutableStatement;
import org.pentaho.actionsequence.dom.IActionSequenceInput;
import org.pentaho.actionsequence.dom.IActionSequenceOutput;
import org.pentaho.actionsequence.dom.IActionSequenceResource;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.ActionFactory;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;
import org.pentaho.actionsequence.dom.actions.SqlQueryAction;

public class ActionSequenceDocument
implements IActionSequenceDocument {
    Document document;
    IActionParameterMgr actionInputProvider;
    Metadata metadata = new Metadata();
    static HashMap listenersMap = new HashMap();

    public ActionSequenceDocument() {
        this.document = DocumentHelper.createDocument();
        Element rootElement = this.document.addElement("action-sequence");
        rootElement.addElement("inputs");
        rootElement.addElement("outputs");
        rootElement.addElement("resources");
        rootElement.addElement("actions");
    }

    public ActionSequenceDocument(Document doc) {
        this(doc, null);
    }

    public ActionSequenceDocument(Document doc, IActionParameterMgr actionInputProvider) {
        this.document = doc;
        this.actionInputProvider = actionInputProvider;
        List actions = this.document.selectNodes("/action-sequence/actions");
        Element masterAction = null;
        if (actions.size() == 1 && (masterAction = (Element)actions.get(0)).valueOf("loop-on") != null && masterAction.valueOf("loop-on").trim().length() > 0) {
            masterAction = null;
        }
        if (masterAction == null) {
            masterAction = this.document.addElement("actions");
            Iterator iter = actions.iterator();
            while (iter.hasNext()) {
                masterAction.add(((Element)iter.next()).detach());
            }
        }
    }

    public IActionSequenceElement getElement(String xPath) {
        IActionSequenceElement actionSequenceElement = null;
        Node node = this.getDocument().selectSingleNode(xPath);
        if (node instanceof Element) {
            Element element = (Element)node;
            if (element.getName().equals("action-definition")) {
                actionSequenceElement = ActionFactory.getActionDefinition(element, this.actionInputProvider);
            } else if (element.getName().equals("actions")) {
                actionSequenceElement = element.element("condition") == null ? new ActionLoop(element, this.actionInputProvider) : new ActionIfStatement(element, this.actionInputProvider);
            } else if (element.getParent().getPath().equals("/action-sequence/inputs")) {
                actionSequenceElement = new ActionSequenceInput(element, this.actionInputProvider);
            } else if (element.getParent().getPath().equals("/action-sequence/outputs")) {
                actionSequenceElement = new ActionSequenceOutput(element, this.actionInputProvider);
            } else if (element.getParent().getPath().equals("/action-sequence/resources")) {
                actionSequenceElement = new ActionSequenceResource(element, this.actionInputProvider);
            } else if (element.getParent().getName().equals("action-inputs")) {
                actionSequenceElement = new ActionInput(element, this.actionInputProvider);
            } else if (element.getParent().getName().equals("action-outputs")) {
                actionSequenceElement = new ActionOutput(element, this.actionInputProvider);
            } else if (element.getParent().getName().equals("action-resources")) {
                actionSequenceElement = new ActionResource(element, this.actionInputProvider);
            }
        }
        return actionSequenceElement;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getDescription() {
        Element subElement;
        String result = "";
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        if (actSeq != null && (subElement = (Element)actSeq.selectSingleNode("documentation/description")) != null) {
            result = subElement.getText();
        }
        return result;
    }

    public String getHelp() {
        Element subElement;
        String result = "";
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        if (actSeq != null && (subElement = (Element)actSeq.selectSingleNode("documentation/help")) != null) {
            result = subElement.getText();
        }
        return result;
    }

    public String getVersion() {
        Element subElement;
        String result = "";
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        if (actSeq != null && (subElement = (Element)actSeq.selectSingleNode("version")) != null) {
            result = subElement.getText();
        }
        return result;
    }

    public String getLoggingLevel() {
        Element subElement;
        String result = "";
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        if (actSeq != null && (subElement = (Element)actSeq.selectSingleNode("logging-level")) != null) {
            result = subElement.getText();
        }
        return result;
    }

    public String getAuthor() {
        Element subElement;
        String result = "";
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        if (actSeq != null && (subElement = (Element)actSeq.selectSingleNode("documentation/author")) != null) {
            result = subElement.getText();
        }
        return result;
    }

    public String getResultType() {
        Element subElement;
        String result = null;
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        if (actSeq != null && (subElement = (Element)actSeq.selectSingleNode("documentation/result-type")) != null) {
            result = subElement.getText();
        }
        return result;
    }

    public String getIconLocation() {
        int index;
        Element subElement;
        String result = "";
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        if (actSeq != null && (subElement = (Element)actSeq.selectSingleNode("documentation/icon")) != null && (index = (result = subElement.getText().trim()).indexOf("|")) > 0) {
            result = result.substring(0, index);
        }
        return result;
    }

    public String getFlyoverIconLocation() {
        Element subElement;
        String result = "";
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        if (actSeq != null && (subElement = (Element)actSeq.selectSingleNode("documentation/icon")) != null) {
            result = subElement.getText();
            int index = result.indexOf("|");
            result = index >= 0 && index < result.length() - 1 ? result.substring(index + 1) : "";
        }
        return result;
    }

    public String getTitle() {
        Element subElement;
        String result = "";
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        if (actSeq != null && (subElement = (Element)actSeq.selectSingleNode("title")) != null) {
            result = subElement.getText();
        }
        return result;
    }

    public void setDescription(String value) {
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        Element subElement = DocumentHelper.makeElement((Branch)actSeq, (String)"documentation/description");
        subElement.setText(value == null ? "" : value);
        ActionSequenceDocument.fireHeaderChanged(this);
    }

    public void setHelp(String value) {
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        Element subElement = DocumentHelper.makeElement((Branch)actSeq, (String)"documentation/help");
        subElement.setText(value == null ? "" : value);
        ActionSequenceDocument.fireHeaderChanged(this);
    }

    public void setVersion(String value) {
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        Element subElement = DocumentHelper.makeElement((Branch)actSeq, (String)"version");
        subElement.setText(value == null ? "" : value);
        ActionSequenceDocument.fireHeaderChanged(this);
    }

    public void setLoggingLevel(String value) {
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        Element subElement = DocumentHelper.makeElement((Branch)actSeq, (String)"logging-level");
        subElement.setText(value == null ? "" : value);
        ActionSequenceDocument.fireHeaderChanged(this);
    }

    public void setAuthor(String value) {
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        Element subElement = DocumentHelper.makeElement((Branch)actSeq, (String)"documentation/author");
        subElement.setText(value == null ? "" : value);
        ActionSequenceDocument.fireHeaderChanged(this);
    }

    public void setResultType(String value) {
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        if (value == null) {
            Node subElement = actSeq.selectSingleNode("documentation/result-type");
            if (subElement != null) {
                subElement.detach();
                ActionSequenceDocument.fireHeaderChanged(this);
            }
        } else {
            Element subElement = DocumentHelper.makeElement((Branch)actSeq, (String)"documentation/result-type");
            subElement.setText(value == null ? "" : value);
            ActionSequenceDocument.fireHeaderChanged(this);
        }
    }

    public void setIconLocation(String value) {
        String flyOverIcon;
        String location = "";
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        Element subElement = DocumentHelper.makeElement((Branch)actSeq, (String)"documentation/icon");
        if (value != null) {
            location = value;
        }
        if ((flyOverIcon = this.getFlyoverIconLocation()).length() > 0) {
            location = location + "|" + flyOverIcon;
        }
        subElement.setText(location);
        ActionSequenceDocument.fireHeaderChanged(this);
    }

    public void setFlyoverIconLocation(String value) {
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        Element subElement = DocumentHelper.makeElement((Branch)actSeq, (String)"documentation/icon");
        String location = this.getIconLocation();
        if (value != null && value.trim().length() > 0) {
            location = location + "|" + value;
        }
        subElement.setText(location);
        ActionSequenceDocument.fireHeaderChanged(this);
    }

    public void setTitle(String value) {
        Element actSeq = (Element)this.document.selectSingleNode("action-sequence");
        Element subElement = DocumentHelper.makeElement((Branch)actSeq, (String)"title");
        subElement.setText(value == null ? "" : value);
        ActionSequenceDocument.fireHeaderChanged(this);
    }

    public void deleteInput(String inputName) {
        IActionSequenceInput input = this.getInput(inputName);
        if (input != null) {
            input.getElement().detach();
            ActionSequenceDocument.fireIoRemoved(this, input);
        }
    }

    public IActionSequenceInput[] getInputs(String[] types) {
        IActionSequenceInput[] allInputs = this.getInputs();
        ArrayList<IActionSequenceInput> matchingInputs = new ArrayList<IActionSequenceInput>();
        if (types == null) {
            matchingInputs.addAll(Arrays.asList(allInputs));
        } else {
            ArrayList<String> typesList = new ArrayList<String>(Arrays.asList(types));
            for (int i = 0; i < allInputs.length; ++i) {
                if (!typesList.contains(allInputs[i].getType())) continue;
                matchingInputs.add(allInputs[i]);
            }
        }
        return matchingInputs.toArray(new ActionSequenceInput[0]);
    }

    public IActionSequenceInput[] getInputs() {
        List inputsList = this.document.getRootElement().selectNodes("inputs/*");
        IActionSequenceInput[] inputs = new ActionSequenceInput[inputsList.size()];
        int index = 0;
        Iterator iter = inputsList.iterator();
        while (iter.hasNext()) {
            inputs[index++] = new ActionSequenceInput((Element)iter.next(), this.actionInputProvider);
        }
        return inputs;
    }

    public IActionSequenceInput getInput(String inputName) {
        Element element = (Element)this.document.getRootElement().selectSingleNode("inputs/" + inputName);
        return element != null ? new ActionSequenceInput(element, this.actionInputProvider) : null;
    }

    public IActionSequenceInput createInput(String inputName, String inputType) {
        IActionSequenceInput input = this.getInput(inputName);
        if (input == null) {
            Element inputElement = DocumentHelper.makeElement((Branch)this.document.getRootElement(), (String)("inputs/" + inputName));
            inputElement.addAttribute("type", inputType);
            input = new ActionSequenceInput(inputElement, this.actionInputProvider);
            ActionSequenceDocument.fireIoAdded(input);
            if (inputType.equals("string")) {
                input.addSource("request", inputName);
            }
        } else {
            input.setType(inputType);
        }
        return input;
    }

    public void deleteOutput(String outputName) {
        IActionSequenceOutput output = this.getOutput(outputName);
        if (output != null) {
            output.getElement().detach();
            ActionSequenceDocument.fireIoRemoved(this, output);
        }
    }

    public IActionSequenceOutput[] getOutputs() {
        List outputsList = this.document.getRootElement().selectNodes("outputs/*");
        IActionSequenceOutput[] outputs = new ActionSequenceOutput[outputsList.size()];
        int index = 0;
        Iterator iter = outputsList.iterator();
        while (iter.hasNext()) {
            outputs[index++] = new ActionSequenceOutput((Element)iter.next(), this.actionInputProvider);
        }
        return outputs;
    }

    public IActionSequenceOutput getOutput(String outputName) {
        Element element = (Element)this.document.getRootElement().selectSingleNode("outputs/" + outputName);
        return element != null ? new ActionSequenceOutput(element, this.actionInputProvider) : null;
    }

    public IActionSequenceOutput createOutput(String outputName, String outputType) {
        IActionSequenceOutput output = this.getOutput(outputName);
        if (output == null) {
            Element outputElement = DocumentHelper.makeElement((Branch)this.document.getRootElement(), (String)("outputs/" + outputName));
            outputElement.addAttribute("type", outputType);
            output = new ActionSequenceOutput(outputElement, this.actionInputProvider);
            ActionSequenceDocument.fireIoAdded(output);
        } else {
            output.setType(outputType);
        }
        return output;
    }

    public IActionSequenceOutput createOutput(IActionOutput actionOutput, String outputType) {
        return this.createOutput(actionOutput.getName(), outputType);
    }

    public void deleteResource(String resourceName) {
        IActionSequenceResource resource = this.getResource(resourceName);
        if (resource != null) {
            resource.getElement().detach();
            ActionSequenceDocument.fireResourceRemoved(this, resource);
        }
    }

    public IActionSequenceResource[] getResources() {
        List resourcesList = this.document.getRootElement().selectNodes("resources/*");
        IActionSequenceResource[] resources = new ActionSequenceResource[resourcesList.size()];
        int index = 0;
        Iterator iter = resourcesList.iterator();
        while (iter.hasNext()) {
            resources[index++] = new ActionSequenceResource((Element)iter.next(), this.actionInputProvider);
        }
        return resources;
    }

    public IActionSequenceResource getResource(String resourceName) {
        Element element = (Element)this.document.getRootElement().selectSingleNode("resources/" + resourceName);
        return element != null ? new ActionSequenceResource(element, this.actionInputProvider) : null;
    }

    public IActionSequenceResource setResourceUri(String resourceName, URI uri, String mimeType) {
        IActionSequenceResource docResource = this.getResource(resourceName);
        if (uri == null) {
            if (docResource != null) {
                docResource.delete();
                ActionSequenceDocument.fireResourceRemoved(this.getDocument(), docResource);
            }
        } else {
            if (docResource == null) {
                Element resourceElement = DocumentHelper.makeElement((Branch)this.document.getRootElement(), (String)("resources/" + resourceName));
                docResource = new ActionSequenceResource(resourceElement, this.actionInputProvider);
                ActionSequenceDocument.fireResourceAdded(docResource);
            }
            docResource.setUri(uri);
            docResource.setMimeType(mimeType);
        }
        return docResource;
    }

    public IActionLoop getRootLoop() {
        return new ActionLoop((Element)this.document.selectSingleNode("/action-sequence/actions"), this.actionInputProvider);
    }

    public IActionLoop addLoop(String loopOn, int index) {
        return this.getRootLoop().addLoop(loopOn, index);
    }

    public IActionLoop addLoop(String loopOn) {
        return this.getRootLoop().addLoop(loopOn);
    }

    public IActionIfStatement addIf(String condition) {
        return this.getRootLoop().addIf(condition);
    }

    public IActionIfStatement addIf(String condition, int index) {
        return this.getRootLoop().addIf(condition, index);
    }

    public IActionSequenceExecutableStatement[] getExecutableChildren() {
        return this.getRootLoop().getChildren();
    }

    public IActionDefinition addAction(Class actionDefinitionClass) {
        return this.getRootLoop().addAction(actionDefinitionClass);
    }

    public IActionDefinition addAction(Class actionDefinitionClass, int index) {
        return this.getRootLoop().addAction(actionDefinitionClass, index);
    }

    public void addListener(IActionSequenceDocumentListener listener) {
        ArrayList<IActionSequenceDocumentListener> listenerList = (ArrayList<IActionSequenceDocumentListener>)listenersMap.get(this.document);
        if (listenerList == null) {
            listenerList = new ArrayList<IActionSequenceDocumentListener>();
            listenersMap.put(this.document, listenerList);
        }
        listenerList.add(listener);
    }

    public void removeListener(IActionSequenceDocumentListener listener) {
        ArrayList listenerList = (ArrayList)listenersMap.get(this.document);
        if (listenerList != null) {
            listenerList.remove(listener);
        }
    }

    public static void fireIoAdded(IAbstractIOElement io) {
        ArrayList listenerList = (ArrayList)listenersMap.get(io.getElement().getDocument());
        if (listenerList != null) {
            Object[] listeners = listenerList.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                IActionSequenceDocumentListener l = (IActionSequenceDocumentListener)listeners[i];
                l.ioAdded(io);
            }
        }
    }

    protected static void fireIoRemoved(Object parent, IAbstractIOElement io) {
        ArrayList listenerList;
        Document doc = null;
        if (parent instanceof ActionDefinition) {
            doc = ((ActionDefinition)parent).getElement().getDocument();
        } else if (parent instanceof ActionSequenceDocument) {
            doc = ((ActionSequenceDocument)parent).document;
        }
        if (doc != null && (listenerList = (ArrayList)listenersMap.get(doc)) != null) {
            Object[] listeners = listenerList.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                IActionSequenceDocumentListener l = (IActionSequenceDocumentListener)listeners[i];
                l.ioRemoved(parent, io);
            }
        }
    }

    protected static void fireIoRenamed(IAbstractIOElement io) {
        ArrayList listenerList = (ArrayList)listenersMap.get(io.getElement().getDocument());
        if (listenerList != null) {
            Object[] listeners = listenerList.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                IActionSequenceDocumentListener l = (IActionSequenceDocumentListener)listeners[i];
                l.ioRenamed(io);
            }
        }
    }

    public static void fireIoChanged(IAbstractIOElement io) {
        ArrayList listenerList = (ArrayList)listenersMap.get(io.getElement().getDocument());
        if (listenerList != null) {
            Object[] listeners = listenerList.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                IActionSequenceDocumentListener l = (IActionSequenceDocumentListener)listeners[i];
                l.ioChanged(io);
            }
        }
    }

    public static void fireResourceAdded(Object resource) {
        Document doc = null;
        if (resource instanceof ActionResource) {
            doc = ((ActionResource)resource).ioElement.getDocument();
        } else if (resource instanceof ActionSequenceResource) {
            doc = ((ActionSequenceResource)resource).ioElement.getDocument();
        }
        ArrayList listenerList = (ArrayList)listenersMap.get(doc);
        if (listenerList != null) {
            Object[] listeners = listenerList.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                IActionSequenceDocumentListener l = (IActionSequenceDocumentListener)listeners[i];
                l.resourceAdded(resource);
            }
        }
    }

    protected static void fireResourceRemoved(Object parent, Object resource) {
        Document doc = null;
        if (parent instanceof ActionDefinition) {
            doc = ((ActionDefinition)parent).getElement().getDocument();
        } else if (parent instanceof ActionSequenceDocument) {
            doc = ((ActionSequenceDocument)parent).document;
        }
        ArrayList listenerList = (ArrayList)listenersMap.get(doc);
        if (listenerList != null) {
            Object[] listeners = listenerList.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                IActionSequenceDocumentListener l = (IActionSequenceDocumentListener)listeners[i];
                l.resourceRemoved(parent, resource);
            }
        }
    }

    protected static void fireResourceRenamed(Object resource) {
        Document doc = null;
        if (resource instanceof ActionResource) {
            doc = ((ActionResource)resource).ioElement.getDocument();
        } else if (resource instanceof ActionSequenceResource) {
            doc = ((ActionSequenceResource)resource).ioElement.getDocument();
        }
        ArrayList listenerList = (ArrayList)listenersMap.get(doc);
        if (listenerList != null) {
            Object[] listeners = listenerList.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                IActionSequenceDocumentListener l = (IActionSequenceDocumentListener)listeners[i];
                l.resourceRenamed(resource);
            }
        }
    }

    public static void fireResourceChanged(Object resource) {
        Document doc = null;
        if (resource instanceof ActionResource) {
            doc = ((ActionResource)resource).ioElement.getDocument();
        } else if (resource instanceof ActionSequenceResource) {
            doc = ((ActionSequenceResource)resource).ioElement.getDocument();
        }
        ArrayList listenerList = (ArrayList)listenersMap.get(doc);
        if (listenerList != null) {
            Object[] listeners = listenerList.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                IActionSequenceDocumentListener l = (IActionSequenceDocumentListener)listeners[i];
                l.resourceChanged(resource);
            }
        }
    }

    protected static void fireActionAdded(IActionDefinition action) {
        ArrayList listenerList = (ArrayList)listenersMap.get(action.getElement().getDocument());
        if (listenerList != null) {
            Object[] listeners = listenerList.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                IActionSequenceDocumentListener l = (IActionSequenceDocumentListener)listeners[i];
                l.actionAdded(action);
            }
        }
    }

    public static void fireActionRemoved(Object parent, ActionDefinition action) {
        ArrayList listenerList;
        Document doc = null;
        if (parent instanceof ActionLoop) {
            doc = ((ActionLoop)parent).controlElement.getDocument();
        } else if (parent instanceof ActionSequenceDocument) {
            doc = ((ActionSequenceDocument)parent).document;
        }
        if (doc != null && (listenerList = (ArrayList)listenersMap.get(doc)) != null) {
            Object[] listeners = listenerList.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                IActionSequenceDocumentListener l = (IActionSequenceDocumentListener)listeners[i];
                l.actionRemoved(parent, action);
            }
        }
    }

    public static void fireActionRenamed(ActionDefinition action) {
        ArrayList listenerList = (ArrayList)listenersMap.get(action.getElement().getDocument());
        if (listenerList != null) {
            Object[] listeners = listenerList.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                IActionSequenceDocumentListener l = (IActionSequenceDocumentListener)listeners[i];
                l.actionRenamed(action);
            }
        }
    }

    public static void fireHeaderChanged(ActionSequenceDocument actionSequenceDocument) {
        ArrayList listenerList = (ArrayList)listenersMap.get(actionSequenceDocument.getDocument());
        if (listenerList != null) {
            Object[] listeners = listenerList.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                IActionSequenceDocumentListener l = (IActionSequenceDocumentListener)listeners[i];
                l.headerChanged(actionSequenceDocument);
            }
        }
    }

    public static void fireActionChanged(IActionDefinition action) {
        ArrayList listenerList = (ArrayList)listenersMap.get(action.getElement().getDocument());
        if (listenerList != null) {
            Object[] listeners = listenerList.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                IActionSequenceDocumentListener l = (IActionSequenceDocumentListener)listeners[i];
                l.actionChanged(action);
            }
        }
    }

    protected static void fireControlStatementAdded(IActionControlStatement controlStatement) {
        ArrayList listenerList = (ArrayList)listenersMap.get(controlStatement.getControlElement().getDocument());
        if (listenerList != null) {
            Object[] listeners = listenerList.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                IActionSequenceDocumentListener l = (IActionSequenceDocumentListener)listeners[i];
                l.controlStatementAdded(controlStatement);
            }
        }
    }

    protected static void fireControlStatementRemoved(Object parent, ActionControlStatement controlStatement) {
        ArrayList listenerList;
        Document doc = null;
        if (parent instanceof ActionControlStatement) {
            doc = ((ActionLoop)parent).controlElement.getDocument();
        } else if (parent instanceof ActionSequenceDocument) {
            doc = ((ActionSequenceDocument)parent).document;
        }
        if (doc != null && (listenerList = (ArrayList)listenersMap.get(doc)) != null) {
            Object[] listeners = listenerList.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                IActionSequenceDocumentListener l = (IActionSequenceDocumentListener)listeners[i];
                l.controlStatementRemoved(parent, controlStatement);
            }
        }
    }

    protected static void fireControlStatementChanged(ActionControlStatement controlStatement) {
        ArrayList listenerList = (ArrayList)listenersMap.get(controlStatement.controlElement.getDocument());
        if (listenerList != null) {
            Object[] listeners = listenerList.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                IActionSequenceDocumentListener l = (IActionSequenceDocumentListener)listeners[i];
                l.controlStatementChanged(controlStatement);
            }
        }
    }

    public boolean equals(Object arg0) {
        boolean result = false;
        if (arg0 != null && arg0.getClass() == this.getClass()) {
            ActionSequenceDocument doc = (ActionSequenceDocument)arg0;
            result = doc.document != null ? doc.document.equals(this.document) : doc == this;
        }
        return result;
    }

    private List getAncestorExecutables(IActionSequenceElement actionDefOrControlStatement, boolean includeAncestorConrolStatements) {
        ArrayList<IActionSequenceExecutableStatement> prevDefs = new ArrayList<IActionSequenceExecutableStatement>();
        IActionControlStatement parentControlStatement = null;
        parentControlStatement = actionDefOrControlStatement instanceof ActionDefinition ? ((ActionDefinition)actionDefOrControlStatement).getParent() : ((IActionControlStatement)actionDefOrControlStatement).getParent();
        if (parentControlStatement != null) {
            prevDefs.addAll(this.getAncestorExecutables(parentControlStatement, includeAncestorConrolStatements));
            IActionSequenceExecutableStatement[] siblings = parentControlStatement.getChildren();
            for (int i = 0; i < siblings.length && !siblings[i].equals(actionDefOrControlStatement); ++i) {
                if (!includeAncestorConrolStatements && !(siblings[i] instanceof ActionDefinition)) continue;
                prevDefs.add(siblings[i]);
            }
        } else {
            IActionSequenceExecutableStatement[] siblings = actionDefOrControlStatement.getDocument().getExecutableChildren();
            for (int i = 0; i < siblings.length && !siblings[i].equals(actionDefOrControlStatement); ++i) {
                if (!includeAncestorConrolStatements && !(siblings[i] instanceof ActionDefinition)) continue;
                prevDefs.add(siblings[i]);
            }
        }
        return prevDefs;
    }

    public IActionSequenceExecutableStatement[] getPrecedingExecutables(IActionDefinition actionDefinition) {
        return this.getAncestorExecutables(actionDefinition, true).toArray(new IActionSequenceExecutableStatement[0]);
    }

    public IActionSequenceExecutableStatement[] getPrecedingExecutables(IActionControlStatement actionControlStatement) {
        return this.getAncestorExecutables(actionControlStatement, true).toArray(new IActionSequenceExecutableStatement[0]);
    }

    public IActionDefinition[] getPrecedingActionDefinitions(IActionDefinition actionDefinition) {
        return this.getAncestorExecutables(actionDefinition, false).toArray(new ActionDefinition[0]);
    }

    public IActionDefinition[] getPrecedingActionDefinitions(IActionControlStatement controlStatement) {
        return this.getAncestorExecutables(controlStatement, false).toArray(new ActionDefinition[0]);
    }

    public IActionInputVariable[] getAvailInputVariables(IActionDefinition actionDefinition, String[] types) {
        ArrayList<IAbstractIOElement> availParams = new ArrayList<IAbstractIOElement>();
        availParams.addAll(Arrays.asList(this.getInputs(types)));
        IActionDefinition[] precedingActionDefs = this.getPrecedingActionDefinitions(actionDefinition);
        for (int i = 0; i < precedingActionDefs.length; ++i) {
            availParams.addAll(Arrays.asList(precedingActionDefs[i].getOutputs(types)));
        }
        return availParams.toArray(new IActionInputVariable[0]);
    }

    public IActionInputVariable[] getAvailInputVariables(IActionDefinition actionDefinition, String type) {
        return this.getAvailInputVariables(actionDefinition, new String[]{type});
    }

    public IActionInputVariable[] getAvailInputVariables(IActionControlStatement controlStatement) {
        ArrayList<IAbstractIOElement> availParams = new ArrayList<IAbstractIOElement>();
        if (controlStatement instanceof ActionLoop) {
            String[] types = new String[]{"property-map-list", "string-list", "result-set"};
            availParams.addAll(Arrays.asList(this.getInputs(types)));
            IActionDefinition[] precedingActionDefs = this.getPrecedingActionDefinitions(controlStatement);
            for (int i = 0; i < precedingActionDefs.length; ++i) {
                availParams.addAll(Arrays.asList(precedingActionDefs[i].getOutputs(types)));
            }
        } else {
            IActionSequenceInput[] actionSequenceInputs = this.getInputs();
            for (int i = 0; i < actionSequenceInputs.length; ++i) {
                if (actionSequenceInputs[i].getName().indexOf(45) != -1) continue;
                availParams.add(actionSequenceInputs[i]);
            }
            IActionDefinition[] precedingActionDefs = this.getPrecedingActionDefinitions(controlStatement);
            for (int i = 0; i < precedingActionDefs.length; ++i) {
                IActionOutput[] actionOutputs = precedingActionDefs[i].getOutputs();
                for (int j = 0; j < actionOutputs.length; ++j) {
                    if (actionOutputs[j].getPublicName().indexOf(45) != -1) continue;
                    availParams.add(actionOutputs[j]);
                }
            }
        }
        return availParams.toArray(new IActionInputVariable[0]);
    }

    public IActionSequenceElement[] getReferencesTo(IActionSequenceInput actionSequenceInput) {
        ArrayList<IActionSequenceElement> references = new ArrayList<IActionSequenceElement>();
        if (this.equals(actionSequenceInput.getDocument())) {
            String name = actionSequenceInput.getName();
            String xpath1 = "//action-definition/action-inputs/" + name + "[not(@" + "mapping" + ")]";
            String xpath2 = "//action-definition/action-inputs/*[@mapping='" + name + "']";
            String xpath3 = "//actions[@loop-on='" + name + "']";
            List referencingElements = this.document.selectNodes(xpath1 + "|" + xpath2 + "|" + xpath3);
            for (Element element : referencingElements) {
                if (element.getName().equals("actions")) {
                    references.add(new ActionLoop(element, this.actionInputProvider));
                    continue;
                }
                references.add(new ActionInput(element, this.actionInputProvider));
            }
        }
        return references.toArray(new IActionSequenceElement[0]);
    }

    public IActionSequenceElement[] getBrokenReferences() {
        String xPath1 = "//action-definition/action-inputs/*";
        String xPath2 = "//actions[@loop-on]";
        String xPath3 = "//action-definition/action-resources/*";
        List allActionInputElements = this.document.selectNodes(xPath1 + "|" + xPath2 + "|" + xPath3);
        ArrayList<IActionSequenceElement> brokenReferences = new ArrayList<IActionSequenceElement>();
        for (Element element : allActionInputElements) {
            if (element.getName().equals("actions")) {
                brokenReferences.add(new ActionLoop(element, this.actionInputProvider));
                continue;
            }
            if (element.getParent().getName().equals("action-inputs")) {
                brokenReferences.add(new ActionInput(element, this.actionInputProvider));
                continue;
            }
            if (!element.getParent().getName().equals("action-resources")) continue;
            brokenReferences.add(new ActionResource(element, this.actionInputProvider));
        }
        IActionSequenceInput[] actionSequenceInputs = this.getInputs();
        for (int i = 0; i < actionSequenceInputs.length; ++i) {
            brokenReferences.removeAll(Arrays.asList(this.getReferencesTo(actionSequenceInputs[i])));
        }
        List allActionOutputElements = this.document.selectNodes("//action-definition/action-outputs/*");
        ArrayList<ActionOutput> allActionOutputs = new ArrayList<ActionOutput>();
        Iterator iterator = allActionOutputElements.iterator();
        while (iterator.hasNext()) {
            allActionOutputs.add(new ActionOutput((Element)iterator.next(), this.actionInputProvider));
        }
        iterator = allActionOutputs.iterator();
        while (iterator.hasNext()) {
            brokenReferences.removeAll(Arrays.asList(this.getReferencesTo((ActionOutput)iterator.next())));
        }
        IActionSequenceResource[] actionSequenceResources = this.getResources();
        for (int i = 0; i < actionSequenceResources.length; ++i) {
            brokenReferences.removeAll(Arrays.asList(this.getReferencesTo(actionSequenceResources[i])));
        }
        return brokenReferences.toArray(new IActionSequenceElement[0]);
    }

    public IActionResource[] getReferencesTo(IActionSequenceResource actionSequenceResource) {
        ArrayList<ActionResource> actionInputs = new ArrayList<ActionResource>();
        if (this.equals(actionSequenceResource.getDocument())) {
            String name = actionSequenceResource.getName();
            String xpath1 = "//action-definition/action-resources/" + name + "[not(@" + "mapping" + ")]";
            String xpath2 = "//action-definition/action-resources/*[@mapping='" + name + "']";
            List references = this.document.selectNodes(xpath1 + "|" + xpath2);
            Iterator iter = references.iterator();
            while (iter.hasNext()) {
                actionInputs.add(new ActionResource((Element)iter.next(), this.actionInputProvider));
            }
        }
        return actionInputs.toArray(new ActionResource[0]);
    }

    public IActionSequenceElement[] getReferencesTo(IActionOutput actionOutput) {
        ArrayList<IActionSequenceElement> references = new ArrayList<IActionSequenceElement>();
        if (this.equals(actionOutput.getDocument())) {
            ArrayList<IActionSequenceExecutableStatement> excludedActionDefs = new ArrayList<IActionSequenceExecutableStatement>();
            excludedActionDefs.add(actionOutput.getActionDefinition());
            excludedActionDefs.addAll(Arrays.asList(this.getPrecedingExecutables(actionOutput.getActionDefinition())));
            String name = actionOutput.getPublicName();
            String xpath1 = "//action-definition/action-inputs/" + name + "[not(@" + "mapping" + ")]";
            String xpath2 = "//action-definition/action-inputs/*[@mapping='" + name + "']";
            String xpath3 = "//actions[@loop-on='" + name + "']";
            List referencingElements = this.document.selectNodes(xpath1 + "|" + xpath2 + "|" + xpath3);
            for (Element element : referencingElements) {
                IActionSequenceExecutableStatement executableStatement = null;
                if (element.getName().equals("actions")) {
                    executableStatement = new ActionLoop(element, this.actionInputProvider);
                    if (excludedActionDefs.contains(executableStatement)) continue;
                    references.add(executableStatement);
                    continue;
                }
                ActionInput actionInput = new ActionInput(element, this.actionInputProvider);
                executableStatement = actionInput.getActionDefinition();
                if (excludedActionDefs.contains(executableStatement)) continue;
                references.add(actionInput);
            }
        }
        return references.toArray(new IActionSequenceElement[0]);
    }

    public IActionSequenceValidationError[] validate() {
        ArrayList<IActionSequenceValidationError> errors = new ArrayList<IActionSequenceValidationError>();
        IActionSequenceExecutableStatement[] executableChildren = this.getExecutableChildren();
        for (int i = 0; i < executableChildren.length; ++i) {
            if (executableChildren[i] instanceof ActionDefinition) {
                ActionDefinition actionDefinition = (ActionDefinition)executableChildren[i];
                errors.addAll(Arrays.asList(actionDefinition.validate()));
                continue;
            }
            if (!(executableChildren[i] instanceof ActionControlStatement)) continue;
            ActionControlStatement actionControlStatement = (ActionControlStatement)executableChildren[i];
            errors.addAll(Arrays.asList(actionControlStatement.validate(true)));
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }

    public static Document prettyPrint(Document document) {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding(document.getXMLEncoding());
            StringWriter stringWriter = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)stringWriter, format);
            writer.write(DocumentHelper.parseText((String)document.asXML()));
            writer.close();
            document = DocumentHelper.parseText((String)stringWriter.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return document;
    }

    public String toString() {
        String string = null;
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding(this.document.getXMLEncoding());
            StringWriter stringWriter = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)stringWriter, format);
            writer.write(DocumentHelper.parseText((String)this.document.asXML()));
            writer.close();
            Document tempDocument = DocumentHelper.parseText((String)stringWriter.toString());
            string = tempDocument.getRootElement().asXML();
        }
        catch (Exception e) {
            string = super.toString();
        }
        return string;
    }

    public static void main(String[] args) throws Exception {
        ActionSequenceDocument actionSequenceDocument = new ActionSequenceDocument();
        SqlQueryAction sqlQueryAction = new SqlQueryAction();
        actionSequenceDocument.getRootLoop().add(sqlQueryAction);
        sqlQueryAction.setJndi(new ActionInputConstant("SampleData", null));
        sqlQueryAction.setQuery(new ActionInputConstant("select * from customers", null));
        sqlQueryAction.setOutputResultSet("queryResults");
        IActionSequenceOutput actionSequenceOutput = actionSequenceDocument.createOutput("queryResults", "result-set");
        actionSequenceOutput.addDestination("session", "theOutput");
        System.out.println(actionSequenceDocument.toString());
        actionSequenceDocument = new ActionSequenceDocument();
        IActionSequenceInput jndiInput = actionSequenceDocument.createInput("jndiName", "string");
        IActionSequenceInput queryInput = actionSequenceDocument.createInput("query", "string");
        sqlQueryAction = new SqlQueryAction();
        actionSequenceDocument.getRootLoop().add(sqlQueryAction);
        sqlQueryAction.setJndi(jndiInput);
        sqlQueryAction.setQuery(queryInput);
        sqlQueryAction.setOutputResultSet("queryResults");
        actionSequenceOutput = actionSequenceDocument.createOutput("queryResults", "result-set");
        actionSequenceOutput.addDestination("session", "theOutput");
        System.out.println(actionSequenceDocument.toString());
    }

    public void moveStatement(IActionSequenceExecutableStatement statementToMove, IActionControlStatement newParentControlStatement) {
        if (newParentControlStatement == null) {
            newParentControlStatement = this.getRootLoop();
        }
        if (statementToMove instanceof ActionControlStatement) {
            newParentControlStatement.add((ActionControlStatement)statementToMove);
        } else if (statementToMove instanceof ActionDefinition) {
            newParentControlStatement.add((ActionDefinition)statementToMove);
        }
    }

    public void moveStatement(IActionSequenceExecutableStatement statementToMove, IActionControlStatement newParentControlStatement, int index) {
        if (newParentControlStatement == null) {
            newParentControlStatement = this.getRootLoop();
        }
        if (statementToMove instanceof ActionControlStatement) {
            newParentControlStatement.add((ActionControlStatement)statementToMove, index);
        } else if (statementToMove instanceof ActionDefinition) {
            newParentControlStatement.add((ActionDefinition)statementToMove, index);
        }
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public class Metadata {
        String solutionName;
        String solutionPath;
        String documentName;

        public String getSolutionName() {
            return this.solutionName;
        }

        public void setSolutionName(String solutionName) {
            this.solutionName = solutionName;
        }

        public String getSolutionPath() {
            return this.solutionPath;
        }

        public void setSolutionPath(String solutionPath) {
            this.solutionPath = solutionPath;
        }

        public String getDocumentName() {
            return this.documentName;
        }

        public void setDocumentName(String documentName) {
            this.documentName = documentName;
        }
    }
}

