/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.pentaho.actionsequence.dom.AbstractIOElement;
import org.pentaho.actionsequence.dom.ActionSequenceDocument;
import org.pentaho.actionsequence.dom.ActionSequenceInputSource;
import org.pentaho.actionsequence.dom.IActionSequenceInput;
import org.pentaho.actionsequence.dom.IActionSequenceInputSource;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class ActionSequenceInput
extends AbstractIOElement
implements IActionSequenceInput {
    public static final int REQUEST_INPUT_SOURCE_ID = 1;
    public static final int SESSION_INPUT_SOURCE_ID = 2;
    public static final int RUNTIME_INPUT_SOURCE_ID = 3;
    public static final int GLOBAL_INPUT_SOURCE_ID = 4;

    public ActionSequenceInput(Element inputElement, IActionParameterMgr actionInputProvider) {
        super(inputElement, actionInputProvider);
    }

    public void setType(String ioType) {
        if (ioType != null && !ioType.equals(this.getType())) {
            this.ioElement.addAttribute("type", ioType);
            Element defValElement = this.ioElement.element("default-value");
            if (defValElement != null) {
                defValElement.clearContent();
            }
            ActionSequenceDocument.fireIoChanged(this);
        }
    }

    public void setDefaultValue(String defValue) {
        Element defValElement = this.ioElement.element("default-value");
        this.ioElement.elements("columns").clear();
        if (defValue == null) {
            if (defValElement != null) {
                defValElement.detach();
                ActionSequenceDocument.fireIoChanged(this);
            }
        } else {
            if (defValElement == null) {
                defValElement = this.ioElement.addElement("default-value");
            } else {
                defValElement.clearContent();
            }
            defValElement.addAttribute("type", null);
            if (defValue.length() > 0) {
                defValElement.addCDATA(defValue);
            }
            ActionSequenceDocument.fireIoChanged(this);
        }
    }

    public void setDefaultValue(String[] defValue) {
        Element defValElement = this.ioElement.element("default-value");
        this.ioElement.elements("columns").clear();
        if (defValue == null) {
            if (defValElement != null) {
                defValElement.detach();
                ActionSequenceDocument.fireIoChanged(this);
            }
        } else {
            if (defValElement == null) {
                defValElement = this.ioElement.addElement("default-value");
            } else {
                defValElement.clearContent();
            }
            if (defValue.length > 0) {
                defValElement.addAttribute("type", "string-list");
                for (int i = 0; i < defValue.length; ++i) {
                    defValElement.addElement("list-item").setText(defValue[i]);
                }
            }
            ActionSequenceDocument.fireIoChanged(this);
        }
    }

    public void setDefaultValue(HashMap paramMap) {
        Element defValElement = this.ioElement.element("default-value");
        this.ioElement.elements("columns").clear();
        if (paramMap == null) {
            if (defValElement != null) {
                defValElement.detach();
                ActionSequenceDocument.fireIoChanged(this);
            }
        } else {
            if (defValElement == null) {
                defValElement = this.ioElement.addElement("default-value");
            } else {
                defValElement.clearContent();
            }
            if (paramMap.size() > 0) {
                defValElement.addAttribute("type", "property-map");
                DefaultTableModel defaultTableModel = new DefaultTableModel();
                Iterator keyIter = paramMap.keySet().iterator();
                while (keyIter.hasNext()) {
                    defaultTableModel.addColumn(keyIter.next().toString());
                }
                defaultTableModel.addRow(paramMap.values().toArray(new String[0]));
                this.initPropertyMap(defValElement, defaultTableModel);
            }
            ActionSequenceDocument.fireIoChanged(this);
        }
    }

    public void setDefaultValue(TableModel defValue) {
        this.setDefaultValue(defValue, false);
    }

    private void initPropertyMap(Element defValElement, TableModel defValue) {
        for (int rowIdx = 0; rowIdx < defValue.getRowCount(); ++rowIdx) {
            Element propertyMapElement = defValElement.addElement("property-map");
            for (int colIdx = 0; colIdx < defValue.getColumnCount(); ++colIdx) {
                Element entryElement = propertyMapElement.addElement("entry");
                entryElement.addAttribute("key", defValue.getColumnName(colIdx));
                Object value = defValue.getValueAt(rowIdx, colIdx);
                entryElement.setText(value == null ? "" : value.toString());
            }
        }
    }

    private void setPropMapListDefVal(TableModel defValue) {
        Element defValElement = this.ioElement.element("default-value");
        this.ioElement.elements("columns").clear();
        if (defValue == null) {
            if (defValElement != null) {
                defValElement.detach();
                ActionSequenceDocument.fireIoChanged(this);
            }
        } else {
            if (defValElement == null) {
                defValElement = this.ioElement.addElement("default-value");
            } else {
                defValElement.clearContent();
            }
            if (defValue.getColumnCount() > 0) {
                defValElement.addAttribute("type", "property-map-list");
                this.initPropertyMap(defValElement, defValue);
            }
            ActionSequenceDocument.fireIoChanged(this);
        }
    }

    private void setResultSetDefVal(TableModel defValue) {
        Element defValElement = this.ioElement.element("default-value");
        this.ioElement.elements("columns").clear();
        if (defValue == null) {
            if (defValElement != null) {
                defValElement.detach();
                ActionSequenceDocument.fireIoChanged(this);
            }
        } else {
            if (defValElement == null) {
                defValElement = this.ioElement.addElement("default-value");
            } else {
                defValElement.clearContent();
            }
            if (defValue.getColumnCount() > 0) {
                defValElement.addAttribute("type", "result-set");
                Element columnsElement = this.ioElement.addElement("columns");
                for (int colIdx = 0; colIdx < defValue.getColumnCount(); ++colIdx) {
                    columnsElement.addElement(defValue.getColumnName(colIdx)).addAttribute("type", "string");
                }
                for (int rowIdx = 0; rowIdx < defValue.getRowCount(); ++rowIdx) {
                    Element rowElement = defValElement.addElement("row");
                    for (int colIdx = 0; colIdx < defValue.getColumnCount(); ++colIdx) {
                        Object value = defValue.getValueAt(rowIdx, colIdx);
                        Element cellElement = rowElement.addElement(defValue.getColumnName(colIdx));
                        cellElement.setText(value == null ? "" : value.toString());
                    }
                }
            }
            ActionSequenceDocument.fireIoChanged(this);
        }
    }

    public void setDefaultValue(TableModel defValue, boolean usePropertyMapList) {
        if (usePropertyMapList) {
            this.setPropMapListDefVal(defValue);
        } else {
            this.setResultSetDefVal(defValue);
        }
    }

    private String[] getDefaultStringList() {
        String[] defaultStringList = null;
        Element defValElement = this.ioElement.element("default-value");
        if (defValElement != null) {
            List listItems = defValElement.elements("list-item");
            defaultStringList = new String[listItems.size()];
            int index = 0;
            for (Element listItem : listItems) {
                defaultStringList[index++] = listItem.getText();
            }
        }
        return defaultStringList;
    }

    private String getDefaultString() {
        String defaultString = null;
        Element defValElement = this.ioElement.element("default-value");
        if (defValElement != null) {
            defaultString = defValElement.getText();
        }
        return defaultString;
    }

    private LinkedHashMap getDefaultPropertyMap() {
        LinkedHashMap<String, String> linkedHashMap = null;
        Element defValElement = this.ioElement.element("default-value");
        if (defValElement != null) {
            linkedHashMap = new LinkedHashMap<String, String>();
            Element propertyMapElement = defValElement.element("property-map");
            if (propertyMapElement != null) {
                List entries = propertyMapElement.elements("entry");
                for (Element entry : entries) {
                    linkedHashMap.put(entry.attributeValue("key"), entry.getText());
                }
            }
        }
        return linkedHashMap;
    }

    private TableModel getDefaultPropertyMapList() {
        DefaultTableModel defaultTableModel = null;
        Element defValElement = this.ioElement.element("default-value");
        if (defValElement != null) {
            defaultTableModel = new DefaultTableModel();
            List propertyMaps = defValElement.elements("property-map");
            HashSet<String> columnSet = new HashSet<String>();
            for (Element propertyMap : propertyMaps) {
                List propertyMapEntries = propertyMap.elements("entry");
                for (Element entry : propertyMapEntries) {
                    columnSet.add(entry.attributeValue("key"));
                }
            }
            defaultTableModel.setColumnIdentifiers(columnSet.toArray());
            for (Element propertyMap : propertyMaps) {
                ArrayList<String> row = new ArrayList<String>();
                for (String columnName : columnSet) {
                    String cellValue = "";
                    List propertyMapEntries = propertyMap.elements("entry");
                    for (Element entry : propertyMapEntries) {
                        if (!columnName.equals(entry.attributeValue("key"))) continue;
                        cellValue = entry.getText();
                        break;
                    }
                    row.add(cellValue);
                }
                defaultTableModel.addRow(row.toArray());
            }
        }
        return defaultTableModel;
    }

    private TableModel getDefaultResultSet() {
        DefaultTableModel defaultTableModel = null;
        Element defValElement = this.ioElement.element("default-value");
        if (defValElement != null) {
            defaultTableModel = new DefaultTableModel();
            ArrayList<String> columnList = new ArrayList<String>();
            Element columnsElement = this.ioElement.element("columns");
            if (columnsElement != null) {
                List columns = columnsElement.elements();
                for (Element columnElement : columns) {
                    columnList.add(columnElement.getName());
                }
            }
            defaultTableModel.setColumnIdentifiers(columnList.toArray());
            List rows = defValElement.elements("row");
            for (Element rowElement : rows) {
                ArrayList<String> rowValues = new ArrayList<String>();
                for (String columnName : columnList) {
                    String cellValue = "";
                    Element cellElement = rowElement.element(columnName);
                    if (cellElement != null) {
                        cellValue = cellElement.getText();
                    }
                    rowValues.add(cellValue);
                }
                defaultTableModel.addRow(rowValues.toArray());
            }
        }
        return defaultTableModel;
    }

    public Object getDefaultValue() {
        Object defVal = null;
        String type = this.getType();
        if ("string-list".equals(type)) {
            defVal = this.getDefaultStringList();
        } else if ("list".equals(type)) {
            defVal = this.getDefaultStringList();
        } else if ("result-set".equals(type)) {
            defVal = this.getDefaultResultSet();
        } else if ("property-map".equals(type)) {
            defVal = this.getDefaultPropertyMap();
        } else if ("property-map-list".equals(type)) {
            defVal = this.getDefaultPropertyMapList();
        } else if ("string".equals(type)) {
            defVal = this.getDefaultString();
        } else if ("long".equals(type)) {
            defVal = this.getDefaultString();
        } else if ("integer".equals(type)) {
            defVal = this.getDefaultString();
        } else if ("bigdecimal".equals(type)) {
            defVal = this.getDefaultString();
        }
        return defVal;
    }

    public IActionSequenceInputSource[] getSources() {
        ArrayList<ActionSequenceInputSource> inputSources = new ArrayList<ActionSequenceInputSource>();
        List sourceElements = this.ioElement.selectNodes("sources/*");
        Iterator iter = sourceElements.iterator();
        while (iter.hasNext()) {
            inputSources.add(new ActionSequenceInputSource((Element)iter.next(), this.actionInputProvider));
        }
        return inputSources.toArray(new ActionSequenceInputSource[0]);
    }

    public IActionSequenceInputSource addSource(String origin, String name) {
        Element sourceParent = DocumentHelper.makeElement((Branch)this.ioElement, (String)"sources");
        Element newSourceElement = sourceParent.addElement(origin);
        newSourceElement.setText(name);
        ActionSequenceInputSource actionSequenceInputSource = new ActionSequenceInputSource(newSourceElement, this.actionInputProvider);
        ActionSequenceDocument.fireIoChanged(this);
        return actionSequenceInputSource;
    }

    public IActionSequenceInputSource addSource(int index, String origin, String name) {
        if (index >= this.getSources().length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Element sourceParent = this.ioElement.element("sources");
        DefaultElement newSourceElement = new DefaultElement(origin);
        List sources = sourceParent.elements();
        sources.add(index, newSourceElement);
        return new ActionSequenceInputSource((Element)newSourceElement, this.actionInputProvider);
    }

    public String getVariableName() {
        return this.getName();
    }
}

