/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.AbstractIOElement;
import org.pentaho.actionsequence.dom.ActionSequenceDocument;
import org.pentaho.actionsequence.dom.ActionSequenceOutputDestination;
import org.pentaho.actionsequence.dom.IActionSequenceOutput;
import org.pentaho.actionsequence.dom.IActionSequenceOutputDestination;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class ActionSequenceOutput
extends AbstractIOElement
implements IActionSequenceOutput {
    protected ActionSequenceOutput(Element outputElement, IActionParameterMgr actionInputProvider) {
        super(outputElement, actionInputProvider);
    }

    public IActionSequenceOutputDestination[] getDestinations() {
        ArrayList<ActionSequenceOutputDestination> outputDestinations = new ArrayList<ActionSequenceOutputDestination>();
        List destinationElements = this.ioElement.selectNodes("destinations/*");
        Iterator iter = destinationElements.iterator();
        while (iter.hasNext()) {
            outputDestinations.add(new ActionSequenceOutputDestination((Element)iter.next(), this.actionInputProvider));
        }
        return outputDestinations.toArray(new ActionSequenceOutputDestination[0]);
    }

    public IActionSequenceOutputDestination addDestination(String destination, String name) {
        Element destinationParent = DocumentHelper.makeElement((Branch)this.ioElement, (String)"destinations");
        Element newDestinationElement = destinationParent.addElement(destination);
        newDestinationElement.setText(name);
        ActionSequenceOutputDestination actionSequenceOutputDestination = new ActionSequenceOutputDestination(newDestinationElement, this.actionInputProvider);
        ActionSequenceDocument.fireIoChanged(this);
        return actionSequenceOutputDestination;
    }

    public boolean isOutputParameter() {
        List attribs = this.ioElement.attributes();
        for (Attribute attrib : attribs) {
            if (!attrib.getName().equals("is-output-parameter")) continue;
            String outParamTxt = attrib.getValue();
            return Boolean.parseBoolean(outParamTxt);
        }
        return true;
    }

    public void setOutputParameter(boolean isOutputParameter) {
        List attribs = this.ioElement.attributes();
        for (Attribute attrib : attribs) {
            if (!attrib.getName().equals("is-output-parameter")) continue;
            attrib.setValue(Boolean.toString(isOutputParameter));
            ActionSequenceDocument.fireIoChanged(this);
            return;
        }
        this.ioElement.addAttribute("is-output-parameter", Boolean.toString(isOutputParameter));
        ActionSequenceDocument.fireIoChanged(this);
    }
}

