/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.AbstractIOElement;
import org.pentaho.actionsequence.dom.ActionSequenceDocument;
import org.pentaho.actionsequence.dom.IActionSequenceDocument;
import org.pentaho.actionsequence.dom.IActionSequenceResource;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class ActionSequenceResource
extends AbstractIOElement
implements IActionSequenceResource {
    public ActionSequenceResource(Element resourceElement, IActionParameterMgr actionInputProvider) {
        super(resourceElement, actionInputProvider);
    }

    public String getName() {
        return this.ioElement.getName();
    }

    public void setName(String resourceName) {
        if (!this.ioElement.getName().equals(resourceName)) {
            this.ioElement.setName(resourceName);
            ActionSequenceDocument.fireResourceRenamed(this);
        }
    }

    public void setMimeType(String mimeType) {
        String resType = this.getType();
        Element mimeElement = null;
        if ("solution-file".equals(resType)) {
            mimeElement = (Element)this.ioElement.selectSingleNode("solution-file/mime-type");
        } else if ("file".equals(resType)) {
            mimeElement = (Element)this.ioElement.selectSingleNode("file/mime-type");
        } else if ("url".equals(resType)) {
            mimeElement = (Element)this.ioElement.selectSingleNode("url/mime-type");
        }
        if (mimeElement == null) {
            if ("solution-file".equals(resType)) {
                mimeElement = DocumentHelper.makeElement((Branch)this.ioElement, (String)"solution-file/mime-type");
            } else if ("file".equals(resType)) {
                mimeElement = DocumentHelper.makeElement((Branch)this.ioElement, (String)"file/mime-type");
            } else if ("url".equals(resType)) {
                mimeElement = DocumentHelper.makeElement((Branch)this.ioElement, (String)"url/mime-type");
            }
            mimeElement.setText(mimeType);
            ActionSequenceDocument.fireResourceChanged(this);
        } else if (!mimeElement.getText().equals(mimeType)) {
            mimeElement.setText(mimeType);
            ActionSequenceDocument.fireResourceChanged(this);
        }
    }

    public String getMimeType() {
        String mimeType = "";
        String resType = this.getType();
        Element mimeElement = null;
        if ("solution-file".equals(resType)) {
            mimeElement = (Element)this.ioElement.selectSingleNode("solution-file/mime-type");
        } else if ("file".equals(resType)) {
            mimeElement = (Element)this.ioElement.selectSingleNode("file/mime-type");
        } else if ("url".equals(resType)) {
            mimeElement = (Element)this.ioElement.selectSingleNode("url/mime-type");
        }
        if (mimeElement != null) {
            mimeType = mimeElement.getText();
        }
        return mimeType;
    }

    public void setPath(String uri) {
        String resType = this.getType();
        Element pathElement = null;
        if ("solution-file".equals(resType)) {
            pathElement = (Element)this.ioElement.selectSingleNode("solution-file/location");
        } else if ("file".equals(resType)) {
            pathElement = (Element)this.ioElement.selectSingleNode("file/location");
        } else if ("url".equals(resType)) {
            pathElement = (Element)this.ioElement.selectSingleNode("url/location");
        }
        if (pathElement == null) {
            if ("solution-file".equals(resType)) {
                pathElement = DocumentHelper.makeElement((Branch)this.ioElement, (String)"solution-file/location");
            } else if ("file".equals(resType)) {
                pathElement = DocumentHelper.makeElement((Branch)this.ioElement, (String)"file/location");
            } else if ("url".equals(resType)) {
                pathElement = DocumentHelper.makeElement((Branch)this.ioElement, (String)"url/location");
            }
            pathElement.setText(uri);
            ActionSequenceDocument.fireResourceChanged(this);
        } else if (!pathElement.getText().equals(uri)) {
            pathElement.setText(uri);
            ActionSequenceDocument.fireResourceChanged(this);
        }
    }

    public String getPath() {
        String uri = "";
        String resType = this.getType();
        Element pathElement = null;
        if ("solution-file".equals(resType)) {
            pathElement = (Element)this.ioElement.selectSingleNode("solution-file/location");
        } else if ("file".equals(resType)) {
            pathElement = (Element)this.ioElement.selectSingleNode("file/location");
        } else if ("url".equals(resType)) {
            pathElement = (Element)this.ioElement.selectSingleNode("url/location");
        }
        if (pathElement != null) {
            uri = pathElement.getText();
        }
        return uri;
    }

    public String getType() {
        Element solutionFileElement = this.ioElement.element("solution-file");
        Element fileElement = this.ioElement.element("file");
        Element urlElement = this.ioElement.element("url");
        Element xmlElement = this.ioElement.element("xml");
        Element stringElement = this.ioElement.element("string");
        String resourceType = null;
        if (solutionFileElement != null && fileElement == null && urlElement == null && xmlElement == null && stringElement == null) {
            resourceType = "solution-file";
        } else if (solutionFileElement == null && fileElement != null && urlElement == null && xmlElement == null && stringElement == null) {
            resourceType = "file";
        } else if (solutionFileElement == null && fileElement == null && urlElement != null && xmlElement == null && stringElement == null) {
            resourceType = "url";
        } else if (solutionFileElement == null && fileElement == null && urlElement == null && xmlElement != null && stringElement == null) {
            resourceType = "xml";
        } else if (solutionFileElement == null && fileElement == null && urlElement == null && xmlElement == null && stringElement != null) {
            resourceType = "string";
        }
        return resourceType;
    }

    public void setType(String resourceType) {
        if ("solution-file".equals(resourceType) || "file".equals(resourceType) || "url".equals(resourceType) || "xml".equals(resourceType) || "string".equals(resourceType)) {
            Element existingElement;
            Element solutionFileElement = this.ioElement.element("solution-file");
            Element fileElement = this.ioElement.element("file");
            Element urlElement = this.ioElement.element("url");
            Element stringElement = this.ioElement.element("string");
            Element xmlElement = this.ioElement.element("xml");
            if (this.getType() == null) {
                if (solutionFileElement != null) {
                    solutionFileElement.detach();
                    solutionFileElement = null;
                }
                if (fileElement != null) {
                    fileElement.detach();
                    fileElement = null;
                }
                if (urlElement != null) {
                    urlElement.detach();
                    urlElement = null;
                }
                if (stringElement != null) {
                    stringElement.detach();
                    stringElement = null;
                }
                if (xmlElement != null) {
                    xmlElement.detach();
                    xmlElement = null;
                }
            }
            if ((existingElement = solutionFileElement) == null) {
                existingElement = fileElement;
            }
            if (existingElement == null) {
                existingElement = urlElement;
            }
            if (existingElement == null) {
                existingElement = stringElement;
            }
            if (existingElement == null) {
                existingElement = xmlElement;
            }
            if (existingElement == null) {
                existingElement = this.ioElement.addElement(resourceType);
                if (!"string".equals(resourceType)) {
                    existingElement.addElement("location");
                }
                existingElement.addElement("mime-type");
                ActionSequenceDocument.fireResourceChanged(this);
            } else {
                existingElement.setName(resourceType);
                Element locationElement = existingElement.element("location");
                if ("string".equals(resourceType) && locationElement != null) {
                    locationElement.detach();
                }
                if (!"xml".equals(resourceType)) {
                    List elements = locationElement.elements();
                    for (Object obj : elements) {
                        ((Element)obj).detach();
                    }
                }
                ActionSequenceDocument.fireResourceChanged(this);
            }
        }
    }

    public void delete() {
        Document doc = this.ioElement.getDocument();
        if (doc != null) {
            this.ioElement.detach();
            ActionSequenceDocument.fireResourceRemoved(new ActionSequenceDocument(doc, this.actionInputProvider), this);
        }
    }

    public Element getElement() {
        return this.ioElement;
    }

    public boolean equals(Object arg0) {
        boolean result = false;
        if (arg0 != null && arg0.getClass() == this.getClass()) {
            ActionSequenceResource resource = (ActionSequenceResource)arg0;
            result = resource.ioElement != null ? resource.ioElement.equals(this.ioElement) : resource == this;
        }
        return result;
    }

    public IActionSequenceDocument getDocument() {
        ActionSequenceDocument doc = null;
        if (this.ioElement != null && this.ioElement.getDocument() != null) {
            doc = new ActionSequenceDocument(this.ioElement.getDocument(), this.actionInputProvider);
        }
        return doc;
    }

    public URI getUri() {
        URI uri = null;
        try {
            String schemaSpecificPart = this.getPath();
            uri = this.getType().equals("solution-file") ? new URI("solution", schemaSpecificPart, null) : (this.getType().equals("file") ? new URI("file", schemaSpecificPart, null) : new URI(schemaSpecificPart));
        }
        catch (URISyntaxException e) {
            uri = null;
            e.printStackTrace();
        }
        return uri;
    }

    public void setUri(URI uri) {
        if (!uri.isAbsolute() || "file".equals(uri.getScheme())) {
            this.setType("file");
            this.setPath(uri.getSchemeSpecificPart());
        } else if ("solution".equals(uri.getScheme())) {
            this.setType("solution-file");
            this.setPath(uri.getSchemeSpecificPart());
        } else {
            try {
                URL url = uri.toURL();
                this.setType("url");
                this.setPath(url.toString());
            }
            catch (Exception ex) {
                this.setType("file");
                this.setPath(uri.toString());
            }
        }
    }

    public String getString() {
        String string = null;
        if ("string".equals(this.getType())) {
            string = this.ioElement.element("string").getText();
        }
        return string;
    }

    public void setString(String string) {
        this.setType("string");
        this.ioElement.element("string").setText(string);
    }

    public String getXml() {
        Element element;
        String xml = null;
        if ("xml".equals(this.getType()) && (element = (Element)this.ioElement.selectSingleNode("xml/location/*")) != null) {
            xml = element.asXML();
        }
        return xml;
    }

    public void setXml(String xml) throws DocumentException {
        this.setType("xml");
        Document document = DocumentHelper.parseText((String)xml);
        Element locationElement = (Element)this.ioElement.selectSingleNode("xml/location");
        List elements = locationElement.elements();
        for (Object obj : elements) {
            ((Element)obj).detach();
        }
        locationElement.add(document.getRootElement());
    }
}

