/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public abstract class AbstractChartAction
extends ActionDefinition {
    public static final String CHART_TYPE_XPATH = "chart-attributes/chart-type";
    public static final String COMPONENT_NAME = "org.pentaho.component.ChartComponent";
    public static final String CHART_ATTRIBUTES_ELEMENT = "chart-attributes";
    public static final String CHART_DATA_ELEMENT = "chart-data";
    public static final String CHART_WIDTH_ELEMENT = "width";
    public static final String CHART_HEIGHT_ELEMENT = "height";
    public static final String CHART_TITLE_ELEMENT = "title";
    public static final String CHART_SUBTITLE_ELEMENT = "subtitle";
    public static final String CHART_FONT_ELEMENT = "font-family";
    public static final String CHART_FONT_SIZE_ELEMENT = "size";
    public static final String CHART_BY_ROW_ELEMENT = "by-row";
    public static final String CHART_PAINT_BORDER_ELEMENT = "border-paint";
    public static final String CHART_SUBTITLE_XPATH = "chart-attributes/subtitle";
    public static final String CHART_BORDER_COLOR_XPATH = "chart-attributes/border-paint";
    public static final String CHART_TITLE_FONT_XPATH = "chart-attributes/title-font";
    public static final String CHART_TITLE_FONT_BOLD_ELEMENT = "is-bold";
    public static final String CHART_TITLE_FONT_ITALIC_ELEMENT = "is-italic";
    public static final String CHART_TITLE_FONT_BOLD_XPATH = "chart-attributes/title-font/is-bold";
    public static final String CHART_TITLE_FONT_ITALIC_XPATH = "chart-attributes/title-font/is-italic";
    public static final String CHART_TITLE_FONT_FAMILY_XPATH = "chart-attributes/title-font/font-family";
    public static final String CHART_TITLE_FONT_SIZE_XPATH = "chart-attributes/title-font/size";
    public static final String CHART_BORDER_VISIBLE_ELEMENT = "border-visible";
    public static final String CHART_BORDER_VISIBLE_XPATH = "chart-attributes/border-visible";
    public static final String CHART_FONT_SIZE = "font-size";
    public static final String CHART_TITLE_ITALIC = "title-italic";
    public static final String CHART_TITLE_BOLD = "title-bold";
    public static final String[] EXPECTED_INPUTS = new String[]{"chart-data", "width", "height", "title", "subtitle", "font-family", "size", "by-row", "border-paint"};

    public AbstractChartAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public AbstractChartAction(String componentName) {
        super(componentName);
    }

    public static boolean accepts(Element element) {
        return ActionDefinition.accepts(element) && AbstractChartAction.hasComponentName(element, COMPONENT_NAME);
    }

    public void setChartData(IActionInputVariable value) {
        this.setActionInputValue(CHART_DATA_ELEMENT, value);
    }

    public IActionInput getChartData() {
        return this.getInput(CHART_DATA_ELEMENT);
    }

    public void setWidth(IActionInputSource value) {
        this.setActionInputValue(CHART_WIDTH_ELEMENT, value);
    }

    public IActionInput getWidth() {
        return this.getInput(CHART_WIDTH_ELEMENT);
    }

    public void setHeight(IActionInputSource value) {
        this.setActionInputValue(CHART_HEIGHT_ELEMENT, value);
    }

    public IActionInput getHeight() {
        return this.getInput(CHART_HEIGHT_ELEMENT);
    }

    public void setTitle(IActionInputSource value) {
        this.setActionInputValue(CHART_TITLE_ELEMENT, value);
    }

    public IActionInput getTitle() {
        return this.getInput(CHART_TITLE_ELEMENT);
    }

    public void setTitleBold(ActionInputConstant value) {
        this.setComponentDefinition(CHART_TITLE_FONT_BOLD_XPATH, value != null ? Boolean.toString(value.getBooleanValue(false)) : "false");
    }

    public ActionInputConstant getTitleBold() {
        String value = this.getComponentDefinitionValue(CHART_TITLE_FONT_BOLD_XPATH);
        return value != null ? new ActionInputConstant(new Boolean(value), this.actionParameterMgr) : IActionInput.NULL_INPUT;
    }

    public void setTitleItalic(ActionInputConstant value) {
        this.setComponentDefinition(CHART_TITLE_FONT_ITALIC_XPATH, value != null ? Boolean.toString(value.getBooleanValue(false)) : "false");
    }

    public ActionInputConstant getTitleItalic() {
        String value = this.getComponentDefinitionValue(CHART_TITLE_FONT_ITALIC_XPATH);
        return value != null ? new ActionInputConstant(new Boolean(value), this.actionParameterMgr) : IActionInput.NULL_INPUT;
    }

    public void setByRow(IActionInputSource value) {
        this.setActionInputValue(CHART_BY_ROW_ELEMENT, value);
    }

    public IActionInput getByRow() {
        return this.getInput(CHART_BY_ROW_ELEMENT);
    }

    public void setBorderVisible(ActionInputConstant value) {
        this.setComponentDefinition(CHART_BORDER_VISIBLE_XPATH, value != null ? Boolean.toString(value.getBooleanValue(false)) : "false");
    }

    public ActionInputConstant getBorderVisible() {
        String value = this.getComponentDefinitionValue(CHART_BORDER_VISIBLE_XPATH);
        return value != null ? new ActionInputConstant(new Boolean(value), this.actionParameterMgr) : IActionInput.NULL_INPUT;
    }

    public void setFontFamily(ActionInputConstant value) {
        this.setComponentDefinition(CHART_TITLE_FONT_FAMILY_XPATH, value != null ? value.getStringValue() : null);
    }

    public ActionInputConstant getFontFamily() {
        String value = this.getComponentDefinitionValue(CHART_TITLE_FONT_FAMILY_XPATH);
        return value != null ? new ActionInputConstant(value, this.actionParameterMgr) : IActionInput.NULL_INPUT;
    }

    public void setSubtitle(ActionInputConstant value) {
        this.setComponentDefinition(CHART_SUBTITLE_XPATH, value != null ? value.getStringValue() : null);
    }

    public ActionInputConstant getSubtitle() {
        String value = this.getComponentDefinitionValue(CHART_SUBTITLE_XPATH);
        return value != null ? new ActionInputConstant(value, this.actionParameterMgr) : IActionInput.NULL_INPUT;
    }

    public void setFontSize(ActionInputConstant value) {
        this.setComponentDefinition(CHART_TITLE_FONT_SIZE_XPATH, value != null ? value.getStringValue() : null);
    }

    public ActionInputConstant getFontSize() {
        String value = this.getComponentDefinitionValue(CHART_SUBTITLE_XPATH);
        return value != null ? new ActionInputConstant(value, this.actionParameterMgr) : IActionInput.NULL_INPUT;
    }

    public void setBorderPaint(ActionInputConstant value) {
        this.setComponentDefinition(CHART_BORDER_COLOR_XPATH, value != null ? value.getStringValue() : null);
    }

    public ActionInputConstant getBorderPaint() {
        String value = this.getComponentDefinitionValue(CHART_SUBTITLE_XPATH);
        return value != null ? new ActionInputConstant(value, this.actionParameterMgr) : IActionInput.NULL_INPUT;
    }

    public void setChartType(String value) {
        this.setComponentDefinition(CHART_TYPE_XPATH, value);
    }

    public String getChartType() {
        return this.getComponentDefinitionValue(CHART_TYPE_XPATH);
    }

    public IActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateInput(CHART_DATA_ELEMENT);
        if (validationError != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing chart data input parameter.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Chart data input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Chart data is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        if ((validationError = this.validateResource(CHART_ATTRIBUTES_ELEMENT)) != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing chart attributes input parameter.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Chart attributes input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Chart attributes are uninitialized.";
                }
            }
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }
}

