/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public abstract class AbstractJobSchedulerAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "org.pentaho.component.JobSchedulerComponent";
    public static final String JOB_NAME_ELEMENT = "jobName";
    public static final String JOB_ACTION_ELEMENT = "jobAction";
    public static final String JOB_NAME = "job-name";
    private static final String DEFAULT_STR = "default";

    protected AbstractJobSchedulerAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    protected AbstractJobSchedulerAction(String componentName) {
        super(componentName);
    }

    public void setJobName(IActionInputSource value) {
        this.setActionInputValue(JOB_NAME_ELEMENT, value);
    }

    public IActionInput getJobName() {
        return this.getInput(JOB_NAME_ELEMENT);
    }

    public IActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateInput(JOB_ACTION_ELEMENT);
        if (validationError != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing job action input parameter.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Job action input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Job action input is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        if ((validationError = this.validateInput(JOB_NAME_ELEMENT)) != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing job name input parameter.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Job name input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Job name input is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }

    public static boolean accepts(Element element) {
        return ActionDefinition.accepts(element) && AbstractJobSchedulerAction.hasComponentName(element, COMPONENT_NAME);
    }
}

