/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInput;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public abstract class AbstractRelationalDbAction
extends ActionDefinition {
    public static final String QUERY_ELEMENT = "query";
    public static final String QUERY_NAME_ELEMENT = "query-name";
    public static final String PREPARED_COMPONENT_ELEMENT = "prepared_component";
    public static final String JNDI_ELEMENT = "jndi";
    public static final String DRIVER_ELEMENT = "driver";
    public static final String CONNECTION_ELEMENT = "connection";
    public static final String USER_ID_ELEMENT = "user-id";
    public static final String PASSWORD_ELEMENT = "password";
    public static final String TRANSFORM_ELEMENT = "transform";
    public static final String TRANSFORM_SORT_COLUMN_ELEMENT = "sort-by-col";
    public static final String TRANSFORM_PIVOT_COLUMN_ELEMENT = "pivot-column";
    public static final String TRANSFORM_MEASURES_COLUMN_ELEMENT = "measures-column";
    public static final String TRANSFORM_PIVOT_DATA_FORMAT_TYPE_ELEMENT = "format-type";
    public static final String TRANSFORM_PIVOT_DATA_FORMAT_STRING_ELEMENT = "format-string";
    public static final String TRANSFORM_SORT_FORMAT_TYPE_ELEMENT = "sort-format-type";
    public static final String TRANSFORM_SORT_FORMAT_STRING_ELEMENT = "sort-format-string";
    public static final String TRANSFORM_ORDERED_MAPS = "ordered-maps";
    public static final String DECIMAL_FORMAT_TYPE = "decimal";
    public static final String DATE_FORMAT_TYPE = "decimal";
    public static final String QUERY_RESULT_ELEMENT = "query-result";
    public static final String OUTPUT_NAME_ELEMENT = "output-name";
    public static final String MAX_ROWS_ELEMENT = "max_rows";
    public static final String LIVE_CONNECTION_ELEMENT = "live";
    public static final String DB_URL_NAME = "db-url";
    public static final String OUTPUT_RESULT_SET = "output-result-set";
    public static final String OUTPUT_PREPARED_STATEMENT = "output-prepared_statement";
    public static final String SHARED_CONNECTION = "shared-connection";
    public static final String RESULTSET_FORWARD_ONLY = "forward-only";
    public static final String TIMEOUT = "timeout";
    public static final String READ_ONLY_ELEMENT = "read_only";

    public AbstractRelationalDbAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public AbstractRelationalDbAction(String componentName) {
        super(componentName);
    }

    public IActionInput getQuery() {
        Object queryName;
        IActionInput actionInput = this.getInput(QUERY_ELEMENT);
        if (actionInput.getValue() == null && (queryName = this.getInput(QUERY_NAME_ELEMENT).getValue()) != null) {
            actionInput = this.getInput(queryName.toString());
        }
        return actionInput;
    }

    public void setQuery(IActionInputSource value) {
        this.setActionInputValue(QUERY_ELEMENT, value);
        this.setActionInputValue(QUERY_NAME_ELEMENT, (IActionInputSource)null);
    }

    public void setQueryTimeout(IActionInputSource value) {
        this.setActionInputValue(TIMEOUT, value);
    }

    public IActionInput getQueryTimeout() {
        return this.getInput(TIMEOUT);
    }

    public void setSharedConnection(IActionInputSource value) {
        if (value instanceof ActionInputConstant) {
            throw new IllegalArgumentException();
        }
        this.setActionInputValue(PREPARED_COMPONENT_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setDriver(null);
            this.setDbUrl(null);
            this.setUserId(null);
            this.setPassword(null);
            this.setJndi(null);
        }
    }

    public IActionInput getSharedConnection() {
        return this.getInput(PREPARED_COMPONENT_ELEMENT);
    }

    public void setJndi(IActionInputSource value) {
        this.setActionInputValue(JNDI_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setDriver(null);
            this.setDbUrl(null);
            this.setUserId(null);
            this.setPassword(null);
            this.setSharedConnection(null);
        }
    }

    public IActionInput getJndi() {
        return this.getInput(JNDI_ELEMENT);
    }

    public void setDriver(IActionInputSource value) {
        this.setActionInputValue(DRIVER_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
            this.setSharedConnection(null);
        }
    }

    public IActionInput getDriver() {
        return this.getInput(DRIVER_ELEMENT);
    }

    public void setDbUrl(IActionInputSource value) {
        this.setActionInputValue(CONNECTION_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
            this.setSharedConnection(null);
        }
    }

    public IActionInput getDbUrl() {
        return this.getInput(CONNECTION_ELEMENT);
    }

    public void setUserId(IActionInputSource value) {
        this.setActionInputValue(USER_ID_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
            this.setSharedConnection(null);
        }
    }

    public IActionInput getUserId() {
        return this.getInput(USER_ID_ELEMENT);
    }

    public void setPassword(IActionInputSource value) {
        this.setActionInputValue(PASSWORD_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
            this.setSharedConnection(null);
        }
    }

    public IActionInput getPassword() {
        return this.getInput(PASSWORD_ELEMENT);
    }

    public void setPerformTransform(IActionInputSource value) {
        this.setActionInputValue(TRANSFORM_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setTransformMeasuresColumn(null);
            this.setTransformPivotColumn(null);
            this.setTransformSortColumn(null);
            this.setTransformPivotDataFormat(null);
            this.setTransformSortDataFormat(null);
        }
    }

    public IActionInput getPerformTransform() {
        return this.getInput(TRANSFORM_ELEMENT);
    }

    public void setTransformPivotColumn(IActionInputSource value) {
        this.setActionInputValue(TRANSFORM_PIVOT_COLUMN_ELEMENT, value);
    }

    public IActionInput getTransformPivotColumn() {
        return this.getInput(TRANSFORM_PIVOT_COLUMN_ELEMENT);
    }

    public void setTransformMeasuresColumn(IActionInputSource value) {
        this.setActionInputValue(TRANSFORM_MEASURES_COLUMN_ELEMENT, value);
    }

    public IActionInput getTransformMeasuresColumn() {
        return this.getInput(TRANSFORM_MEASURES_COLUMN_ELEMENT);
    }

    public void setTransformPivotDataFormat(IActionInputSource value) {
        if (value == null || value instanceof ActionInputConstant && ((ActionInputConstant)value).getValue() == null) {
            this.setActionInputValue(TRANSFORM_PIVOT_DATA_FORMAT_STRING_ELEMENT, (IActionInputSource)null);
            this.setActionInputValue(TRANSFORM_PIVOT_DATA_FORMAT_TYPE_ELEMENT, (IActionInputSource)null);
        } else if (value instanceof ActionInputConstant) {
            Object object = ((ActionInputConstant)value).getValue();
            if (object instanceof DecimalFormat) {
                this.setActionInputValue(TRANSFORM_PIVOT_DATA_FORMAT_STRING_ELEMENT, new ActionInputConstant(((DecimalFormat)object).toPattern(), this.actionParameterMgr));
                this.setActionInputValue(TRANSFORM_PIVOT_DATA_FORMAT_TYPE_ELEMENT, new ActionInputConstant("decimal", this.actionParameterMgr));
            } else if (object instanceof SimpleDateFormat) {
                this.setActionInputValue(TRANSFORM_PIVOT_DATA_FORMAT_STRING_ELEMENT, new ActionInputConstant(((SimpleDateFormat)object).toPattern(), this.actionParameterMgr));
                this.setActionInputValue(TRANSFORM_PIVOT_DATA_FORMAT_TYPE_ELEMENT, new ActionInputConstant("decimal", this.actionParameterMgr));
            } else {
                this.setActionInputValue(TRANSFORM_PIVOT_DATA_FORMAT_STRING_ELEMENT, new ActionInputConstant(object, this.actionParameterMgr));
                this.setActionInputValue(TRANSFORM_PIVOT_DATA_FORMAT_TYPE_ELEMENT, (IActionInputSource)null);
            }
        } else {
            this.setActionInputValue(TRANSFORM_PIVOT_DATA_FORMAT_STRING_ELEMENT, value);
            this.setActionInputValue(TRANSFORM_PIVOT_DATA_FORMAT_TYPE_ELEMENT, (IActionInputSource)null);
        }
    }

    public IActionInput getTransformPivotDataFormat() {
        IActionInput actionInput = this.getInput(TRANSFORM_PIVOT_DATA_FORMAT_STRING_ELEMENT);
        if (actionInput instanceof ActionInput) {
            actionInput = new FormatInput(((ActionInput)actionInput).getElement(), ((ActionInput)actionInput).getParameterMgr());
        } else if (actionInput instanceof ActionInputConstant) {
            Format format = null;
            String formatPattern = actionInput.getStringValue();
            if (formatPattern != null) {
                format = this.getFormat(formatPattern);
            }
            if (format != null) {
                actionInput = new ActionInputConstant(format, this.actionParameterMgr);
            }
        }
        return actionInput;
    }

    public void setTransformSortDataFormat(IActionInputSource value) {
        if (value == null || value instanceof ActionInputConstant && ((ActionInputConstant)value).getValue() == null) {
            this.setActionInputValue(TRANSFORM_SORT_FORMAT_STRING_ELEMENT, (IActionInputSource)null);
            this.setActionInputValue(TRANSFORM_SORT_FORMAT_TYPE_ELEMENT, (IActionInputSource)null);
        } else if (value instanceof ActionInputConstant) {
            Object object = ((ActionInputConstant)value).getValue();
            if (object instanceof DecimalFormat) {
                this.setActionInputValue(TRANSFORM_SORT_FORMAT_STRING_ELEMENT, new ActionInputConstant(((DecimalFormat)object).toPattern(), this.actionParameterMgr));
                this.setActionInputValue(TRANSFORM_SORT_FORMAT_TYPE_ELEMENT, new ActionInputConstant("decimal", this.actionParameterMgr));
            } else if (object instanceof SimpleDateFormat) {
                this.setActionInputValue(TRANSFORM_SORT_FORMAT_STRING_ELEMENT, new ActionInputConstant(((SimpleDateFormat)object).toPattern(), this.actionParameterMgr));
                this.setActionInputValue(TRANSFORM_SORT_FORMAT_TYPE_ELEMENT, new ActionInputConstant("decimal", this.actionParameterMgr));
            } else {
                this.setActionInputValue(TRANSFORM_SORT_FORMAT_STRING_ELEMENT, new ActionInputConstant(object, this.actionParameterMgr));
                this.setActionInputValue(TRANSFORM_SORT_FORMAT_TYPE_ELEMENT, (IActionInputSource)null);
            }
        } else {
            this.setActionInputValue(TRANSFORM_SORT_FORMAT_STRING_ELEMENT, value);
            this.setActionInputValue(TRANSFORM_SORT_FORMAT_TYPE_ELEMENT, (IActionInputSource)null);
        }
    }

    public IActionInput getTransformSortDataFormat() {
        IActionInput actionInput = this.getInput(TRANSFORM_SORT_FORMAT_STRING_ELEMENT);
        if (actionInput instanceof ActionInput) {
            actionInput = new FormatInput(((ActionInput)actionInput).getElement(), ((ActionInput)actionInput).getParameterMgr());
        } else if (actionInput instanceof ActionInputConstant) {
            Format format = null;
            String formatPattern = actionInput.getStringValue();
            if (formatPattern != null) {
                format = this.getFormat(formatPattern);
            }
            if (format != null) {
                actionInput = new ActionInputConstant(format, this.actionParameterMgr);
            }
        }
        return actionInput;
    }

    public void setTransformSortColumn(IActionInputSource value) {
        this.setActionInputValue(TRANSFORM_SORT_COLUMN_ELEMENT, value);
    }

    public IActionInput getTransformSortColumn() {
        return this.getInput(TRANSFORM_SORT_COLUMN_ELEMENT);
    }

    public void setTransformOrderOutputColumns(IActionInputSource value) {
        this.setActionInputValue(TRANSFORM_ORDERED_MAPS, value);
    }

    public IActionInput getTransformOrderOutputColumns() {
        return this.getInput(TRANSFORM_ORDERED_MAPS);
    }

    public void setOutputResultSet(String publicOutputName) {
        this.setActionInputValue(OUTPUT_NAME_ELEMENT, (IActionInputSource)null);
        this.setOutput(QUERY_RESULT_ELEMENT, publicOutputName, "result-set");
        if (publicOutputName != null && publicOutputName.trim().length() > 0) {
            this.setOutputPreparedStatement(null);
        }
    }

    public IActionOutput getOutputResultSet() {
        IActionOutput[] actionOutputs;
        IActionOutput actionOutput;
        Object outputName = this.getInput(OUTPUT_NAME_ELEMENT).getValue();
        if (outputName == null) {
            outputName = QUERY_RESULT_ELEMENT;
        }
        if ((actionOutput = this.getOutput(outputName.toString())) == null && (actionOutputs = this.getOutputs()).length > 0) {
            actionOutput = actionOutputs[0];
        }
        return actionOutput;
    }

    public void setMaxRows(IActionInputSource value) {
        this.setActionInputValue(MAX_ROWS_ELEMENT, value);
    }

    public IActionInput getMaxRows() {
        return this.getInput(MAX_ROWS_ELEMENT);
    }

    public void setReadOnly(IActionInputSource value) {
        this.setActionInputValue(READ_ONLY_ELEMENT, value);
    }

    public IActionInput getReadOnly() {
        return this.getInput(READ_ONLY_ELEMENT);
    }

    public void setOutputPreparedStatement(String publicOutputName) {
        this.setOutput(PREPARED_COMPONENT_ELEMENT, publicOutputName, "sql-query");
        if (publicOutputName != null && publicOutputName.trim().length() > 0) {
            this.setOutputResultSet(null);
            IActionOutput[] actionOutputs = this.getOutputs();
            for (int i = 0; i < actionOutputs.length; ++i) {
                if (actionOutputs[i].getType().equals("sql-query")) continue;
                actionOutputs[i].delete();
            }
        }
    }

    public IActionOutput getOutputPreparedStatement() {
        return this.getOutput(PREPARED_COMPONENT_ELEMENT);
    }

    public void setLive(IActionInputSource value) {
        this.setActionInputValue(LIVE_CONNECTION_ELEMENT, value);
    }

    public IActionInput getLive() {
        return this.getInput(LIVE_CONNECTION_ELEMENT);
    }

    public void setUseForwardOnlyResultSet(IActionInputSource value) {
        this.setActionInputValue(RESULTSET_FORWARD_ONLY, value);
    }

    public IActionInput getUseForwardOnlyResultSet() {
        return this.getInput(RESULTSET_FORWARD_ONLY);
    }

    private Format getFormat(String formatPattern) {
        Format format = null;
        try {
            format = new DecimalFormat(formatPattern.toString());
        }
        catch (Exception ex) {
            try {
                format = new SimpleDateFormat(formatPattern.toString());
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        return format;
    }

    public class FormatInput
    extends ActionInput {
        FormatInput(Element element, IActionParameterMgr actionParameterMgr) {
            super(element, actionParameterMgr);
        }

        public Object getValue() {
            Format format = null;
            String formatPattern = this.getStringValue();
            if (formatPattern != null) {
                format = AbstractRelationalDbAction.this.getFormat(formatPattern);
            }
            return format;
        }
    }
}

