/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.actionsequence.dom.ActionInput;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.actions.IActionInputFilter;

public class ActionInputTypeFilter
implements IActionInputFilter {
    ArrayList types = new ArrayList();
    boolean includeConstants = false;

    public ActionInputTypeFilter(String[] types, boolean includeConstants) {
        if (types != null) {
            this.types.addAll(Arrays.asList(types));
        }
        this.includeConstants = includeConstants;
    }

    public ActionInputTypeFilter(String[] types) {
        this(types, false);
    }

    public ActionInputTypeFilter(String type) {
        this(new String[]{type}, false);
    }

    public boolean accepts(IActionInput actionInput) {
        boolean result = false;
        if (this.includeConstants && actionInput instanceof ActionInputConstant) {
            ActionInputConstant constant = (ActionInputConstant)actionInput;
            if (this.types.contains("string")) {
                result = constant.getValue() instanceof String;
            } else if ((this.types.contains("long") || this.types.contains("integer") || this.types.contains("bigdecimal")) && constant.getValue() instanceof String) {
                try {
                    Integer.parseInt(constant.getStringValue());
                    result = true;
                }
                catch (Exception ex) {}
            }
        } else {
            result = actionInput instanceof ActionInput && this.types.contains(((ActionInput)actionInput).getType());
        }
        return result;
    }
}

