/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.net.URI;
import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class BirtReportAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "org.pentaho.birt.BIRTReportComponent";
    public static final String OUTPUT_TYPE_ELEMENT = "output-type";
    public static final String REPORT_OUTPUT_ELEMENT = "report-output";
    public static final String REPORT_DEFINITION_ELEMENT = "report-definition";
    public static final String OUTPUT_REPORT = "output-report";
    protected static final String[] EXPECTED_INPUTS = new String[]{"output-type"};
    public static final String[] EXPECTED_RESOURCES = new String[]{"report-definition"};

    public BirtReportAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public BirtReportAction() {
        super(COMPONENT_NAME);
    }

    protected void initNewActionDefinition() {
        super.initNewActionDefinition();
        this.setComponentDefinition(OUTPUT_TYPE_ELEMENT, "html");
    }

    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    public String[] getReservedOutputNames() {
        IActionOutput[] actionOutputs;
        String privateOutputName = REPORT_OUTPUT_ELEMENT;
        if (this.getOutput(privateOutputName) == null && (actionOutputs = this.getOutputs("content")).length > 0) {
            privateOutputName = actionOutputs[0].getName();
        }
        return new String[]{privateOutputName};
    }

    public String[] getReservedResourceNames() {
        return EXPECTED_RESOURCES;
    }

    public void setOutputType(IActionInputSource value) {
        this.setActionInputValue(OUTPUT_TYPE_ELEMENT, value);
    }

    public IActionInput getOutputType() {
        return this.getInput(OUTPUT_TYPE_ELEMENT);
    }

    public void setOutputReport(String publicOutputName) {
        this.setOutput(REPORT_OUTPUT_ELEMENT, publicOutputName, "content");
        if (publicOutputName != null && publicOutputName.trim().length() > 0) {
            IActionOutput[] actionOutputs = this.getOutputs();
            for (int i = 0; i < actionOutputs.length; ++i) {
                if (!actionOutputs[i].getType().equals("content") || actionOutputs[i].getName().equals(REPORT_OUTPUT_ELEMENT)) continue;
                actionOutputs[i].delete();
            }
        }
    }

    public IActionOutput getOutputReport() {
        IActionOutput[] actionOutputs;
        IActionOutput actionOutput = this.getOutput(REPORT_OUTPUT_ELEMENT);
        if (actionOutput == null && (actionOutputs = this.getOutputs("content")).length > 0) {
            actionOutput = actionOutputs[0];
        }
        return actionOutput;
    }

    public IActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateResource(REPORT_DEFINITION_ELEMENT);
        if (validationError != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing report definition input parameter.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Report definition input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Report definition input parameter is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        if ((validationError = this.validateInput(OUTPUT_TYPE_ELEMENT)) != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing report format input parameter.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Report format input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Report format input parameter is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }

    public static boolean accepts(Element element) {
        return ActionDefinition.accepts(element) && BirtReportAction.hasComponentName(element, COMPONENT_NAME);
    }

    public IActionResource setReportDefinition(URI uri, String mimeType) {
        return this.setResourceUri(REPORT_DEFINITION_ELEMENT, uri, mimeType);
    }

    public IActionResource getReportDefinition() {
        return this.getResource(REPORT_DEFINITION_ELEMENT);
    }
}

